/*
 * Decompiled with CFR 0.152.
 */
package com.goide.comments;

import com.goide.GoParserDefinition;
import com.goide.comments.GoCommentListItemType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoCommentLine {
    private final PsiComment myComment;
    private final int myStartOffset;
    private final int myLineTextStartOffset;
    private final int myEndOffset;
    private final String myLineText;
    private final int myIndent;
    private final boolean myIsBlank;

    public GoCommentLine(@NotNull PsiComment comment, int startOffset, int endOffset) {
        if (comment == null) {
            GoCommentLine.$$$reportNull$$$0(0);
        }
        this.myComment = comment;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        String commentText = comment.getText();
        boolean isLineComment = this.myComment.getTokenType() == GoParserDefinition.Lazy.LINE_COMMENT;
        int lineTextStartOffset = startOffset;
        if (lineTextStartOffset < 2) {
            lineTextStartOffset = 2;
        }
        if (isLineComment && lineTextStartOffset < commentText.length() && commentText.charAt(lineTextStartOffset) == ' ') {
            ++lineTextStartOffset;
        }
        this.myLineTextStartOffset = lineTextStartOffset;
        int lineTextEndOffset = endOffset;
        if (endOffset == commentText.length() && !isLineComment && commentText.endsWith("*/")) {
            lineTextEndOffset -= 2;
        }
        this.myLineText = commentText.substring(lineTextStartOffset, lineTextEndOffset);
        this.myIsBlank = this.myLineText.isBlank();
        this.myIndent = StringUtil.skipWhitespaceForward((CharSequence)this.myLineText, (int)0);
    }

    @NotNull
    public PsiComment getComment() {
        PsiComment psiComment = this.myComment;
        if (psiComment == null) {
            GoCommentLine.$$$reportNull$$$0(1);
        }
        return psiComment;
    }

    @NotNull
    public TextRange getRangeInDocument() {
        TextRange textRange = TextRange.create((int)this.myStartOffset, (int)this.myEndOffset).shiftRight(this.myComment.getTextRange().getStartOffset());
        if (textRange == null) {
            GoCommentLine.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    public boolean isBlank() {
        return this.myIsBlank;
    }

    public int getLineTextStartOffset() {
        return this.myLineTextStartOffset;
    }

    public int getIndent() {
        return this.myIndent;
    }

    @NotNull
    public String getLineText() {
        String string = this.myLineText;
        if (string == null) {
            GoCommentLine.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getTrimmedLineText() {
        String string = this.myLineText.trim();
        if (string == null) {
            GoCommentLine.$$$reportNull$$$0(4);
        }
        return string;
    }

    boolean isIndentedWithTab() {
        return !this.myLineText.isEmpty() && this.myLineText.charAt(0) == '\t';
    }

    @Nullable
    public GoCommentListItemType getListItemType() {
        String text = StringUtil.trim((String)this.myLineText);
        if (text.isEmpty()) {
            return null;
        }
        char firstChar = text.charAt(0);
        if (firstChar == '*' || firstChar == '+' || firstChar == '-' || firstChar == '\u2022') {
            return new GoCommentListItemType(null);
        }
        if (StringUtil.isDecimalDigit((char)firstChar)) {
            char afterNumber;
            int i;
            for (i = 1; i < text.length() && StringUtil.isDecimalDigit((char)text.charAt(i)); ++i) {
            }
            if (i < text.length() - 1 && ((afterNumber = text.charAt(i)) == '.' || afterNumber == ')')) {
                return new GoCommentListItemType(text.substring(0, i));
            }
        }
        return null;
    }

    public String toString() {
        return "{'" + this.myLineText + "', indent: " + this.myIndent + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/comments/GoCommentLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/comments/GoCommentLine";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInDocument";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrimmedLineText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

