/*
 * Decompiled with CFR 0.152.
 */
package com.goide.codeInsight.imports;

import com.goide.codeInsight.imports.GoImport;
import com.goide.codeInsight.imports.GoImportsSettings;
import com.goide.psi.GoFile;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GoOptimizedImportsTracker
implements FileEditorManagerListener {
    private static final Key<Set<GoImport>> GO_OPTIMIZED_IMPORTS = Key.create((String)"GO_OPTIMIZED_IMPORTS");

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        Document document;
        PsiFile psiFile;
        if (source == null) {
            GoOptimizedImportsTracker.$$$reportNull$$$0(0);
        }
        if (file == null) {
            GoOptimizedImportsTracker.$$$reportNull$$$0(1);
        }
        PsiFile psiFile2 = psiFile = (document = FileDocumentManager.getInstance().getDocument(file)) != null ? PsiDocumentManager.getInstance((Project)source.getProject()).getPsiFile(document) : null;
        if (psiFile instanceof GoFile) {
            GoOptimizedImportsTracker.resetOptimizedImports(psiFile);
        }
    }

    @NotNull
    public static Set<GoImport> getOptimizedImports(@NotNull PsiFile file) {
        if (file == null) {
            GoOptimizedImportsTracker.$$$reportNull$$$0(2);
        }
        if (GoOptimizedImportsTracker.isEnabled(file.getProject())) {
            Set result = (Set)file.getUserData(GO_OPTIMIZED_IMPORTS);
            Set set = result != null ? ContainerUtil.unmodifiableOrEmptySet((Set)result) : Collections.emptySet();
            if (set == null) {
                GoOptimizedImportsTracker.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<GoImport> set = Collections.emptySet();
        if (set == null) {
            GoOptimizedImportsTracker.$$$reportNull$$$0(4);
        }
        return set;
    }

    public static void addOptimizedImports(@NotNull PsiFile file, @NotNull Set<GoImport> imports) {
        if (file == null) {
            GoOptimizedImportsTracker.$$$reportNull$$$0(5);
        }
        if (imports == null) {
            GoOptimizedImportsTracker.$$$reportNull$$$0(6);
        }
        if (imports.isEmpty()) {
            return;
        }
        GoFile goFile = (GoFile)((Object)ObjectUtils.tryCast((Object)file, GoFile.class));
        if (goFile != null && GoOptimizedImportsTracker.isEnabled(file.getProject())) {
            Set optimizedImports = (Set)goFile.putUserDataIfAbsent(GO_OPTIMIZED_IMPORTS, ConcurrentCollectionFactory.createConcurrentSet());
            optimizedImports.addAll(imports);
        }
    }

    public static void removeOptimizedImport(@NotNull PsiFile file, @NotNull GoImport goImport) {
        GoFile goFile;
        if (file == null) {
            GoOptimizedImportsTracker.$$$reportNull$$$0(7);
        }
        if (goImport == null) {
            GoOptimizedImportsTracker.$$$reportNull$$$0(8);
        }
        if ((goFile = (GoFile)((Object)ObjectUtils.tryCast((Object)file, GoFile.class))) != null && GoOptimizedImportsTracker.isEnabled(file.getProject())) {
            Set optimizedImports = (Set)goFile.putUserDataIfAbsent(GO_OPTIMIZED_IMPORTS, ConcurrentCollectionFactory.createConcurrentSet());
            optimizedImports.remove((Object)goImport);
        }
    }

    public static void resetOptimizedImports(@NotNull PsiFile file) {
        if (file == null) {
            GoOptimizedImportsTracker.$$$reportNull$$$0(9);
        }
        file.putUserData(GO_OPTIMIZED_IMPORTS, null);
    }

    private static boolean isEnabled(@NotNull Project project) {
        if (project == null) {
            GoOptimizedImportsTracker.$$$reportNull$$$0(10);
        }
        return Registry.is((String)"go.optimized.imports.tracker.enabled") && GoImportsSettings.getInstance(project).isOptimizeImportsOnTheFly();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/codeInsight/imports/GoOptimizedImportsTracker";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goImport";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/codeInsight/imports/GoOptimizedImportsTracker";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptimizedImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fileClosed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOptimizedImports";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addOptimizedImports";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeOptimizedImport";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resetOptimizedImports";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

