/*
 * Decompiled with CFR 0.152.
 */
package com.goide;

import com.goide.GoParserDefinition;
import com.goide.comments.GoCommentBlock;
import com.goide.comments.GoCommentLine;
import com.goide.comments.GoCommentListItemType;
import com.goide.comments.GoCommentParser;
import com.goide.comments.GoCommentSpan;
import com.goide.comments.GoCommentSpanType;
import com.goide.comments.GoCommentToken;
import com.goide.comments.GoCommentTokenType;
import com.goide.comments.GoDocLinkToken;
import com.goide.comments.GoLinkDefinition;
import com.goide.comments.GoTextLinkToken;
import com.goide.psi.presentation.GoPsiPresentationBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoCommentsConverter {
    private static final Pattern SPLIT_BY_LINES = Pattern.compile("(\r|\n|\r\n)");

    @NotNull
    public String toText(@NotNull List<PsiComment> comments) {
        if (comments == null) {
            GoCommentsConverter.$$$reportNull$$$0(0);
        }
        String string = StringUtil.join(GoCommentsConverter.toStringList(comments), (String)"\n");
        if (string == null) {
            GoCommentsConverter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String toHtml(@NotNull List<PsiComment> comments, @Nullable GoCommentLinkProvider linkProvider) {
        if (comments == null) {
            GoCommentsConverter.$$$reportNull$$$0(2);
        }
        if (linkProvider == null) {
            linkProvider = GoCommentLinkProvider.DEFAULT_PROVIDER;
        }
        GoCommentBlock block = GoCommentBlock.parse(comments);
        StringBuilder result = new StringBuilder();
        for (GoCommentSpan span : block.getSpans()) {
            GoCommentSpanType type2 = span.getType();
            switch (type2) {
                case HEADING: {
                    GoCommentsConverter.printHeading(result, span);
                    break;
                }
                case TEXT: {
                    GoCommentsConverter.printParagraph(result, linkProvider, block, span);
                    break;
                }
                case LIST: {
                    GoCommentsConverter.printList(result, linkProvider, block, span);
                    break;
                }
                case CODE: {
                    GoCommentsConverter.printCodeBlock(result, span);
                    break;
                }
            }
        }
        String string = result.toString();
        if (string == null) {
            GoCommentsConverter.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void printHeading(@NotNull StringBuilder result, @NotNull GoCommentSpan span) {
        GoCommentLine loneLine;
        if (result == null) {
            GoCommentsConverter.$$$reportNull$$$0(4);
        }
        if (span == null) {
            GoCommentsConverter.$$$reportNull$$$0(5);
        }
        if ((loneLine = (GoCommentLine)ContainerUtil.getFirstItem(span.getLines())) != null) {
            String header = StringUtil.trimStart((String)loneLine.getTrimmedLineText(), (String)"#");
            result.append("<h2>").append(header).append("</h2>\n");
        }
    }

    private static void printParagraph(@NotNull StringBuilder result, @NotNull GoCommentLinkProvider linkProvider, @NotNull GoCommentBlock block, @NotNull GoCommentSpan span) {
        if (result == null) {
            GoCommentsConverter.$$$reportNull$$$0(6);
        }
        if (linkProvider == null) {
            GoCommentsConverter.$$$reportNull$$$0(7);
        }
        if (block == null) {
            GoCommentsConverter.$$$reportNull$$$0(8);
        }
        if (span == null) {
            GoCommentsConverter.$$$reportNull$$$0(9);
        }
        result.append("<p>");
        for (GoCommentLine line : span.getLines()) {
            String lineText = line.getTrimmedLineText();
            result.append(GoCommentsConverter.emphasize(lineText, linkProvider, block.getLinks())).append("\n");
        }
        result.append("</p>\n");
    }

    private static void printCodeBlock(@NotNull StringBuilder result, @NotNull GoCommentSpan span) {
        if (result == null) {
            GoCommentsConverter.$$$reportNull$$$0(10);
        }
        if (span == null) {
            GoCommentsConverter.$$$reportNull$$$0(11);
        }
        result.append("<pre>");
        GoCommentLine last = (GoCommentLine)ContainerUtil.getLastItem(span.getLines());
        boolean prevBlank = false;
        for (GoCommentLine line : span.getLines()) {
            boolean addNewline = line != last;
            String lineText = line.getLineText();
            if (lineText.isBlank()) {
                if (prevBlank) {
                    addNewline = false;
                }
                prevBlank = true;
            } else {
                result.append(GoCommentsConverter.escapeCode(lineText.substring(span.getMinCommonIndent())));
                prevBlank = false;
            }
            if (!addNewline) continue;
            result.append("\n");
        }
        result.append("</pre>\n");
    }

    @NotNull
    private static String escapeCode(@NotNull String text) {
        GoCommentToken token;
        if (text == null) {
            GoCommentsConverter.$$$reportNull$$$0(12);
        }
        GoCommentParser parser = new GoCommentParser(text, Collections.emptyMap());
        StringBuilder result = new StringBuilder();
        while ((token = parser.getNext()) != null) {
            String tokenText = token.getRange().substring(text);
            if (token.getType() == GoCommentTokenType.PUNCTUATION && tokenText.length() == 1) {
                String escaped = switch (tokenText.charAt(0)) {
                    case '<' -> "&lt;";
                    case '&' -> "&amp;";
                    default -> tokenText;
                };
                result.append(escaped);
                continue;
            }
            result.append(tokenText);
        }
        String string = result.toString();
        if (string == null) {
            GoCommentsConverter.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static void printList(@NotNull StringBuilder result, @NotNull GoCommentLinkProvider linkProvider, @NotNull GoCommentBlock block, @NotNull GoCommentSpan span) {
        GoCommentLine firstLine;
        GoCommentListItemType listType;
        if (result == null) {
            GoCommentsConverter.$$$reportNull$$$0(14);
        }
        if (linkProvider == null) {
            GoCommentsConverter.$$$reportNull$$$0(15);
        }
        if (block == null) {
            GoCommentsConverter.$$$reportNull$$$0(16);
        }
        if (span == null) {
            GoCommentsConverter.$$$reportNull$$$0(17);
        }
        GoCommentListItemType goCommentListItemType = listType = (firstLine = (GoCommentLine)ContainerUtil.getFirstItem(span.getLines())) != null ? firstLine.getListItemType() : null;
        if (listType == null) {
            return;
        }
        result.append(listType.isNumbered() ? "<ol>\n" : "<ul>\n");
        boolean first = true;
        for (GoCommentLine line : span.getLines()) {
            String lineText = line.getTrimmedLineText();
            GoCommentListItemType itemType = line.getListItemType();
            if (itemType != null && itemType.isNumbered() == listType.isNumbered()) {
                String itemText;
                if (!first) {
                    result.append("</p></li>\n");
                }
                result.append("<li");
                String value = itemType.getNumericValue();
                if (value != null) {
                    result.append(" value=\"").append(value).append("\"");
                    itemText = lineText.substring(value.length() + 1);
                } else {
                    itemText = lineText.substring(1);
                }
                result.append(">");
                result.append("<p>").append(GoCommentsConverter.emphasize(itemText.trim(), linkProvider, block.getLinks()));
            } else if (lineText.isBlank()) {
                result.append("</p><p>");
            } else {
                result.append(lineText);
            }
            result.append("\n");
            first = false;
        }
        if (!first) {
            result.append("</p></li>\n");
        }
        result.append(listType.isNumbered() ? "</ol>\n" : "</ul>\n");
    }

    @NonNls
    @NotNull
    public String convertCodeToHtml(@NonNls @NotNull String code) {
        if (code == null) {
            GoCommentsConverter.$$$reportNull$$$0(18);
        }
        StringBuilder result = new StringBuilder();
        String tab = GoPsiPresentationBuilder.INDENT;
        for (String line : StringUtil.splitByLinesKeepSeparators((String)StringsKt.trimIndent((String)code))) {
            int tabsCount = StringUtil.countChars((CharSequence)line, (char)'\t', (int)0, (boolean)true);
            result.append(StringUtil.repeat((String)tab, (int)tabsCount)).append(line.substring(tabsCount));
        }
        String string = "<pre>" + StringUtil.escapeXmlEntities((String)result.toString()) + "</pre>";
        if (string == null) {
            GoCommentsConverter.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static List<String> toStringList(@NotNull List<PsiComment> comments) {
        if (comments == null) {
            GoCommentsConverter.$$$reportNull$$$0(20);
        }
        return GoCommentsConverter.toStringList(comments, true);
    }

    @NotNull
    public static List<String> toStringList(@NotNull List<PsiComment> comments, boolean trimMultilineComments) {
        if (comments == null) {
            GoCommentsConverter.$$$reportNull$$$0(21);
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (PsiComment comment : comments) {
            IElementType type2 = comment.getTokenType();
            strings.addAll(GoCommentsConverter.toStringList(comment.getText(), type2, trimMultilineComments));
        }
        ArrayList<String> arrayList = strings;
        if (arrayList == null) {
            GoCommentsConverter.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> toStringList(@NotNull String commentText, @NotNull IElementType type2, boolean trimMultilineComments) {
        if (commentText == null) {
            GoCommentsConverter.$$$reportNull$$$0(23);
        }
        if (type2 == null) {
            GoCommentsConverter.$$$reportNull$$$0(24);
        }
        ArrayList<String> strings = new ArrayList<String>();
        if (type2 == GoParserDefinition.Lazy.LINE_COMMENT) {
            strings.add(StringUtil.trimStart((String)StringUtil.trimStart((String)commentText, (String)"//"), (String)" "));
        } else if (type2 == GoParserDefinition.Lazy.MULTILINE_COMMENT) {
            String text = StringUtil.trimEnd((String)commentText, (String)"*/");
            text = StringUtil.trimStart((String)text, (String)"/*");
            if (trimMultilineComments) {
                text = StringsKt.trimIndent((String)text);
            }
            Collections.addAll(strings, SPLIT_BY_LINES.split(text));
        }
        ArrayList<String> arrayList = strings;
        if (arrayList == null) {
            GoCommentsConverter.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @Nullable
    public String getValidCommentText(@NotNull PsiComment comment) {
        IElementType type2;
        if (comment == null) {
            GoCommentsConverter.$$$reportNull$$$0(26);
        }
        if ((type2 = comment.getNode().getElementType()) == GoParserDefinition.Lazy.LINE_COMMENT) {
            return StringUtil.trimStart((String)comment.getText(), (String)"//").trim();
        }
        if (type2 == GoParserDefinition.Lazy.MULTILINE_COMMENT) {
            String commentText = StringUtil.trimStart((String)comment.getText(), (String)"/*");
            return commentText.endsWith("*/") ? StringUtil.trimEnd((String)commentText, (String)"*/").trim() : null;
        }
        return null;
    }

    @NonNls
    private static String emphasize(@NotNull String text, @NotNull GoCommentLinkProvider linkProvider, @NotNull Map<String, GoLinkDefinition> linkDefs) {
        GoCommentToken token;
        if (text == null) {
            GoCommentsConverter.$$$reportNull$$$0(27);
        }
        if (linkProvider == null) {
            GoCommentsConverter.$$$reportNull$$$0(28);
        }
        if (linkDefs == null) {
            GoCommentsConverter.$$$reportNull$$$0(29);
        }
        StringBuilder result = new StringBuilder();
        GoCommentParser parser = new GoCommentParser(text, linkDefs);
        GoCommentToken prevToken = null;
        while ((token = parser.getNext()) != null) {
            String tokenText = token.getRange().substring(text);
            GoCommentTokenType tokenType = token.getType();
            switch (tokenType) {
                case SPACE: {
                    result.append(tokenText);
                    break;
                }
                case WORD: {
                    String link;
                    String string = link = !parser.isLeftBracket(prevToken) && parser.isStrongWordBoundary(prevToken) ? linkProvider.getWordLink(tokenText) : null;
                    if (link != null) {
                        GoCommentsConverter.appendLink(result, link, tokenText);
                        break;
                    }
                    result.append(tokenText);
                    break;
                }
                case WORD_CHAIN: {
                    List links;
                    List words = StringUtil.split((String)tokenText, (String)".");
                    List<Object> list = links = !parser.isLeftBracket(prevToken) ? linkProvider.getWordChainLinks(words) : Collections.emptyList();
                    if (links.isEmpty()) {
                        result.append(tokenText);
                        break;
                    }
                    ArrayList<Pair<String, String>> textAndUrls = new ArrayList<Pair<String, String>>();
                    for (int i = 0; i < words.size(); ++i) {
                        String word = (String)words.get(i);
                        String url = i < links.size() ? (String)links.get(i) : null;
                        textAndUrls.add((Pair<String, String>)Pair.create((Object)word, (Object)url));
                    }
                    GoCommentsConverter.appendLinks(result, textAndUrls);
                    break;
                }
                case URL: {
                    GoCommentsConverter.appendLink(result, tokenText, tokenText);
                    break;
                }
                case PUNCTUATION: {
                    CharSequence textForHtml = GoCommentsConverter.getPunctuationTextForHTML(tokenText);
                    result.append(textForHtml);
                    break;
                }
                case TEXT_LINK: {
                    GoTextLinkToken textLink = (GoTextLinkToken)token;
                    GoLinkDefinition definition = textLink.getLinkDefinition();
                    GoCommentsConverter.appendLink(result, definition.getUrl(), definition.getLinkText());
                    break;
                }
                case DOC_LINK: {
                    List<Pair<String, String>> links = linkProvider.getDocLinkLinks((GoDocLinkToken)token, tokenText);
                    if (links.isEmpty()) {
                        result.append(tokenText);
                        break;
                    }
                    GoCommentsConverter.appendLinks(result, links);
                }
            }
            prevToken = token;
        }
        return result.toString();
    }

    private static void appendLinks(@NotNull StringBuilder result, @NotNull List<Pair<String, String>> textAndUrls) {
        if (result == null) {
            GoCommentsConverter.$$$reportNull$$$0(30);
        }
        if (textAndUrls == null) {
            GoCommentsConverter.$$$reportNull$$$0(31);
        }
        boolean first = true;
        for (Pair<String, String> textAndUrl : textAndUrls) {
            if (!first) {
                result.append(".");
            }
            String text = (String)textAndUrl.first;
            String url = (String)textAndUrl.second;
            if (url != null) {
                GoCommentsConverter.appendLink(result, url, text);
            } else {
                result.append(text);
            }
            first = false;
        }
    }

    private static void appendLink(@NotNull StringBuilder result, @NotNull String url, @NotNull String text) {
        if (result == null) {
            GoCommentsConverter.$$$reportNull$$$0(32);
        }
        if (url == null) {
            GoCommentsConverter.$$$reportNull$$$0(33);
        }
        if (text == null) {
            GoCommentsConverter.$$$reportNull$$$0(34);
        }
        result.append("<a href=\"").append(url).append("\">").append(text).append("</a>");
    }

    @NotNull
    private static CharSequence getPunctuationTextForHTML(@NotNull CharSequence punctuationTokenText) {
        int tokenLength;
        if (punctuationTokenText == null) {
            GoCommentsConverter.$$$reportNull$$$0(35);
        }
        if ((tokenLength = punctuationTokenText.length()) == 1) {
            CharSequence charSequence = switch (punctuationTokenText.charAt(0)) {
                case '\"' -> "&quot;";
                case '<' -> "&lt;";
                case '>' -> "&gt;";
                case '&' -> "&amp;";
                case '\u00a0' -> "&nbsp;";
                default -> punctuationTokenText;
            };
            if (charSequence == null) {
                GoCommentsConverter.$$$reportNull$$$0(36);
            }
            return charSequence;
        }
        if (tokenLength == 2) {
            if (StringUtil.equals((CharSequence)punctuationTokenText, (CharSequence)"``")) {
                return "&ldquo;";
            }
            if (StringUtil.equals((CharSequence)punctuationTokenText, (CharSequence)"''")) {
                return "&rdquo;";
            }
        }
        CharSequence charSequence = punctuationTokenText;
        if (charSequence == null) {
            GoCommentsConverter.$$$reportNull$$$0(37);
        }
        return charSequence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 13, 19, 22, 25, 36, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 1: 
            case 3: 
            case 13: 
            case 19: 
            case 22: 
            case 25: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/GoCommentsConverter";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 14: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "span";
                break;
            }
            case 7: 
            case 15: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkProvider";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 12: 
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkDefs";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAndUrls";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "punctuationTokenText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/GoCommentsConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtml";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCode";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "convertCodeToHtml";
                break;
            }
            case 22: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringList";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPunctuationTextForHTML";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toText";
                break;
            }
            case 1: 
            case 3: 
            case 13: 
            case 19: 
            case 22: 
            case 25: 
            case 36: 
            case 37: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toHtml";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "printHeading";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "printParagraph";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "printCodeBlock";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "escapeCode";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "printList";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "convertCodeToHtml";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "toStringList";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getValidCommentText";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "emphasize";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "appendLinks";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "appendLink";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPunctuationTextForHTML";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 13, 19, 22, 25, 36, 37 -> new IllegalStateException(string);
        };
    }

    public static interface GoCommentLinkProvider {
        public static final GoCommentLinkProvider DEFAULT_PROVIDER = new GoCommentLinkProvider(){};

        @Nullable
        default public String getWordLink(@NotNull String word) {
            if (word == null) {
                GoCommentLinkProvider.$$$reportNull$$$0(0);
            }
            return null;
        }

        @NotNull
        default public List<String> getWordChainLinks(@NotNull List<String> wordChainParts) {
            if (wordChainParts == null) {
                GoCommentLinkProvider.$$$reportNull$$$0(1);
            }
            List<String> list = Collections.emptyList();
            if (list == null) {
                GoCommentLinkProvider.$$$reportNull$$$0(2);
            }
            return list;
        }

        default public @NotNull List<Pair<String, @Nullable String>> getDocLinkLinks(@NotNull GoDocLinkToken docLink, @NotNull String docLinkText) {
            if (docLink == null) {
                GoCommentLinkProvider.$$$reportNull$$$0(3);
            }
            if (docLinkText == null) {
                GoCommentLinkProvider.$$$reportNull$$$0(4);
            }
            List<Pair<String, String>> list = Collections.emptyList();
            if (list == null) {
                GoCommentLinkProvider.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wordChainParts";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/GoCommentsConverter$GoCommentLinkProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docLink";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docLinkText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/GoCommentsConverter$GoCommentLinkProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWordChainLinks";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocLinkLinks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getWordLink";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getWordChainLinks";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDocLinkLinks";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5 -> new IllegalStateException(string);
            };
        }
    }
}

