/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grpc.restClient.execution;

import com.intellij.grpc.restClient.execution.GrpcRequestExecutionSupportKt;
import com.intellij.grpc.restClient.execution.GrpcRequestIdentity;
import com.intellij.httpClient.execution.common.CommonClientRequest;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001BK\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u001b\u001a\u00020\u001cR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000eR\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/grpc/restClient/execution/GrpcRequest;", "Lcom/intellij/httpClient/execution/common/CommonClientRequest;", "URL", "", "scheme", "host", "port", "", "methodFqn", "textToSend", "metadata", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "getURL", "()Ljava/lang/String;", "authority", "getAuthority", "getHost", "httpMethod", "getHttpMethod", "getMetadata", "()Ljava/util/Map;", "getMethodFqn", "getPort", "()I", "getScheme", "getTextToSend", "asIdentity", "Lcom/intellij/grpc/restClient/execution/GrpcRequestIdentity;", "intellij.grpc"})
public class GrpcRequest
implements CommonClientRequest {
    @Nullable
    private final String URL;
    @NotNull
    private final String scheme;
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final String methodFqn;
    @NotNull
    private final String textToSend;
    @NotNull
    private final Map<String, String> metadata;
    @NotNull
    private final String httpMethod;

    public GrpcRequest(@Nullable String URL2, @NotNull String scheme, @NotNull String host, int port, @NotNull String methodFqn, @NotNull String textToSend, @NotNull Map<String, String> metadata) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)methodFqn, (String)"methodFqn");
        Intrinsics.checkNotNullParameter((Object)textToSend, (String)"textToSend");
        Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
        this.URL = URL2;
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.methodFqn = methodFqn;
        this.textToSend = textToSend;
        this.metadata = metadata;
        this.httpMethod = "GRPC";
    }

    @Nullable
    public String getURL() {
        return this.URL;
    }

    @NotNull
    public String getScheme() {
        return this.scheme;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getMethodFqn() {
        return this.methodFqn;
    }

    @NotNull
    public String getTextToSend() {
        return this.textToSend;
    }

    @NotNull
    public final Map<String, String> getMetadata() {
        return this.metadata;
    }

    @NotNull
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @NotNull
    public final String getAuthority() {
        return this.host + ":" + this.port;
    }

    @NotNull
    public final GrpcRequestIdentity asIdentity() {
        boolean isSecure = GrpcRequestExecutionSupportKt.getSECURE_GRPC_SCHEMES_TRIMMED().contains(this.getScheme());
        return new GrpcRequestIdentity(isSecure, this.host, this.port);
    }
}

