/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grpc.restClient;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.grpc.GrpcBundle;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.suggested.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/grpc/restClient/GrpcChangeSchemeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "newScheme", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "intellij.grpc"})
@SourceDebugExtension(value={"SMAP\nGrpcChangeSchemeFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcChangeSchemeFix.kt\ncom/intellij/grpc/restClient/GrpcChangeSchemeFix\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,34:1\n14#2:35\n*S KotlinDebug\n*F\n+ 1 GrpcChangeSchemeFix.kt\ncom/intellij/grpc/restClient/GrpcChangeSchemeFix\n*L\n24#1:35\n*E\n"})
public final class GrpcChangeSchemeFix
implements LocalQuickFix {
    @NotNull
    private final String newScheme;

    public GrpcChangeSchemeFix(@NlsSafe @NotNull String newScheme) {
        Intrinsics.checkNotNullParameter((Object)newScheme, (String)"newScheme");
        this.newScheme = newScheme;
    }

    @NotNull
    public String getFamilyName() {
        String string;
        if (((CharSequence)this.newScheme).length() == 0) {
            string = GrpcBundle.INSTANCE.message("grpc.schemes.remove.fix.name", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{this.newScheme};
            string = GrpcBundle.INSTANCE.message("grpc.schemes.replace.fix.name", objectArray);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement $this$asSafely$iv = descriptor.getPsiElement();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof HttpRequestTarget)) {
            psiElement = null;
        }
        HttpRequestTarget httpRequestTarget = (HttpRequestTarget)psiElement;
        if (httpRequestTarget == null) {
            return;
        }
        HttpRequestTarget requestTarget = httpRequestTarget;
        Document document = requestTarget.getContainingFile().getViewProvider().getDocument();
        if (document == null) {
            return;
        }
        Document document2 = document;
        TextRange textRange = descriptor.getTextRangeInElement().shiftRight(UtilsKt.getStartOffset((PsiElement)((PsiElement)requestTarget)));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
        TextRange effectiveRange = textRange;
        String effectiveScheme = ((CharSequence)this.newScheme).length() == 0 || StringsKt.endsWith$default((String)this.newScheme, (String)"://", (boolean)false, (int)2, null) ? this.newScheme : this.newScheme + "://";
        document2.replaceString(effectiveRange.getStartOffset(), effectiveRange.getEndOffset(), (CharSequence)effectiveScheme);
    }
}

