/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grpc.requests.execution;

import com.intellij.grpc.requests.execution.GrpcSharedChannelPool;
import com.intellij.grpc.restClient.execution.GrpcRequestIdentity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ConcurrentFactoryMap;
import io.grpc.ManagedChannel;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0002J$\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005R/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/grpc/requests/execution/GrpcSharedChannelPool;", "Lcom/intellij/openapi/Disposable;", "()V", "channels", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/grpc/restClient/execution/GrpcRequestIdentity;", "kotlin.jvm.PlatformType", "Lio/grpc/ManagedChannel;", "Lorg/jetbrains/annotations/NotNull;", "createChannel", "grpcRequestIdentity", "createWithJdkSslProvider", "channelBuilder", "Lkotlin/Function1;", "dispose", "", "disposeChannel", "", "channel", "getOrCreateChannel", "intellij.grpc"})
@SourceDebugExtension(value={"SMAP\nGrpcSharedChannelPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcSharedChannelPool.kt\ncom/intellij/grpc/requests/execution/GrpcSharedChannelPool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1774#2,4:66\n9#3:70\n9#3:72\n1#4:71\n*S KotlinDebug\n*F\n+ 1 GrpcSharedChannelPool.kt\ncom/intellij/grpc/requests/execution/GrpcSharedChannelPool\n*L\n17#1:66,4\n18#1:70\n59#1:72\n*E\n"})
public final class GrpcSharedChannelPool
implements Disposable {
    @NotNull
    private final ConcurrentMap<GrpcRequestIdentity, ManagedChannel> channels;

    public GrpcSharedChannelPool() {
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> GrpcSharedChannelPool.channels$lambda$0((Function1)new Function1<GrpcRequestIdentity, ManagedChannel>((Object)this){

            @NotNull
            public final ManagedChannel invoke(@NotNull GrpcRequestIdentity p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GrpcSharedChannelPool.access$createChannel((GrpcSharedChannelPool)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
        this.channels = concurrentMap;
    }

    public void dispose() {
        int n;
        Iterable $this$count$iv = this.channels.values();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ManagedChannel p0 = (ManagedChannel)element$iv;
                boolean bl = false;
                if (!this.disposeChannel(p0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int count = n;
        GrpcSharedChannelPool $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GrpcSharedChannelPool.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn(count + " out of " + this.channels.size() + " channels were shutdown normally");
    }

    @NotNull
    public final ManagedChannel getOrCreateChannel(@NotNull GrpcRequestIdentity grpcRequestIdentity) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)grpcRequestIdentity, (String)"grpcRequestIdentity");
        ManagedChannel cachedChannel2 = (ManagedChannel)this.channels.get(grpcRequestIdentity);
        boolean bl2 = bl = cachedChannel2 != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Cached gRPC channel was 'null' but must be 'not null'";
            throw new AssertionError((Object)string);
        }
        ManagedChannel managedChannel = cachedChannel2;
        Intrinsics.checkNotNull((Object)managedChannel);
        return managedChannel;
    }

    private final ManagedChannel createChannel(GrpcRequestIdentity grpcRequestIdentity) {
        return this.createWithJdkSslProvider(grpcRequestIdentity, (Function1<? super GrpcRequestIdentity, ? extends ManagedChannel>)((Function1)createChannel.1.INSTANCE));
    }

    private final ManagedChannel createWithJdkSslProvider(GrpcRequestIdentity grpcRequestIdentity, Function1<? super GrpcRequestIdentity, ? extends ManagedChannel> channelBuilder) {
        ManagedChannel managedChannel;
        boolean openSslAlreadyDisabled;
        String string = System.getProperty("io.grpc.netty.shaded.io.netty.handler.ssl.noOpenSsl");
        boolean bl = openSslAlreadyDisabled = string != null ? Boolean.parseBoolean(string) : false;
        if (!openSslAlreadyDisabled) {
            System.setProperty("io.grpc.netty.shaded.io.netty.handler.ssl.noOpenSsl", "true");
            ManagedChannel channel = (ManagedChannel)channelBuilder.invoke((Object)grpcRequestIdentity);
            System.setProperty("io.grpc.netty.shaded.io.netty.handler.ssl.noOpenSsl", "false");
            managedChannel = channel;
        } else {
            managedChannel = (ManagedChannel)channelBuilder.invoke((Object)grpcRequestIdentity);
        }
        return managedChannel;
    }

    private final boolean disposeChannel(ManagedChannel channel) {
        if (!channel.isShutdown()) {
            channel.shutdown();
        }
        if (!channel.isTerminated()) {
            channel.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        if (!channel.isTerminated()) {
            channel.shutdownNow();
            GrpcSharedChannelPool $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GrpcSharedChannelPool.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Force gRPC channel '" + channel.authority() + "' shutdown");
        }
        return channel.isTerminated();
    }

    private static final ManagedChannel channels$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ManagedChannel)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ManagedChannel access$createChannel(GrpcSharedChannelPool $this, GrpcRequestIdentity grpcRequestIdentity) {
        return $this.createChannel(grpcRequestIdentity);
    }
}

