/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grpc.requests.execution;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import com.intellij.codeWithMe.ClientId;
import com.intellij.grpc.GrpcBundle;
import com.intellij.grpc.requests.RejectedRPCException;
import com.intellij.grpc.requests.execution.GrpcMetadataInterceptor;
import com.intellij.grpc.requests.execution.GrpcSharedChannelPool;
import com.intellij.grpc.restClient.execution.GrpcRequest;
import com.intellij.httpClient.execution.common.CommonClientResponse;
import com.intellij.openapi.application.ApplicationManager;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\b\u0010\u0012\u001a\u00020\u0005H\u0002J\b\u0010\u0013\u001a\u00020\u0014H&J\b\u0010\u0015\u001a\u00020\u0005H\u0004R\u001b\u0010\u0007\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/intellij/grpc/requests/execution/GrpcRequestExecutor;", "", "originalRequest", "Lcom/intellij/grpc/restClient/execution/GrpcRequest;", "givenChannel", "Lio/grpc/Channel;", "(Lcom/intellij/grpc/restClient/execution/GrpcRequest;Lio/grpc/Channel;)V", "cachedChannel", "getCachedChannel", "()Lio/grpc/Channel;", "cachedChannel$delegate", "Lkotlin/Lazy;", "getOriginalRequest", "()Lcom/intellij/grpc/restClient/execution/GrpcRequest;", "buildGenericMessage", "Lcom/google/protobuf/DynamicMessage;", "messageDescriptor", "Lcom/google/protobuf/Descriptors$Descriptor;", "createChannel", "executeUnsafe", "Lcom/intellij/httpClient/execution/common/CommonClientResponse;", "wrapChanelAndMetadata", "intellij.grpc"})
@SourceDebugExtension(value={"SMAP\nGrpcRequestExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcRequestExecutor.kt\ncom/intellij/grpc/requests/execution/GrpcRequestExecutor\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,49:1\n42#2,3:50\n*S KotlinDebug\n*F\n+ 1 GrpcRequestExecutor.kt\ncom/intellij/grpc/requests/execution/GrpcRequestExecutor\n*L\n32#1:50,3\n*E\n"})
public abstract class GrpcRequestExecutor {
    @NotNull
    private final GrpcRequest originalRequest;
    @Nullable
    private final Channel givenChannel;
    @NotNull
    private final Lazy cachedChannel$delegate;

    public GrpcRequestExecutor(@NotNull GrpcRequest originalRequest, @Nullable Channel givenChannel) {
        Intrinsics.checkNotNullParameter((Object)originalRequest, (String)"originalRequest");
        this.originalRequest = originalRequest;
        this.givenChannel = givenChannel;
        this.cachedChannel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Channel>(this){
            final /* synthetic */ GrpcRequestExecutor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Channel invoke() {
                Channel channel = GrpcRequestExecutor.access$getGivenChannel$p(this.this$0);
                if (channel == null) {
                    channel = GrpcRequestExecutor.access$createChannel(this.this$0);
                }
                return channel;
            }
        }));
    }

    public /* synthetic */ GrpcRequestExecutor(GrpcRequest grpcRequest, Channel channel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            channel = null;
        }
        this(grpcRequest, channel);
    }

    @NotNull
    protected final GrpcRequest getOriginalRequest() {
        return this.originalRequest;
    }

    @NotNull
    public abstract CommonClientResponse executeUnsafe() throws RejectedRPCException;

    private final Channel getCachedChannel() {
        Lazy lazy = this.cachedChannel$delegate;
        return (Channel)lazy.getValue();
    }

    @NotNull
    protected final Channel wrapChanelAndMetadata() {
        ClientInterceptor[] clientInterceptorArray = new ClientInterceptor[]{new GrpcMetadataInterceptor(this.originalRequest)};
        Channel channel = ClientInterceptors.intercept((Channel)this.getCachedChannel(), (ClientInterceptor[])clientInterceptorArray);
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"intercept(...)");
        return channel;
    }

    private final Channel createChannel() {
        boolean $i$f$service = false;
        Class<GrpcSharedChannelPool> serviceClass$iv = GrpcSharedChannelPool.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return (Channel)((GrpcSharedChannelPool)object).getOrCreateChannel(this.originalRequest.asIdentity());
    }

    @NotNull
    protected final DynamicMessage buildGenericMessage(@NotNull Descriptors.Descriptor messageDescriptor) {
        Intrinsics.checkNotNullParameter((Object)messageDescriptor, (String)"messageDescriptor");
        DynamicMessage.Builder builder = DynamicMessage.getDefaultInstance((Descriptors.Descriptor)messageDescriptor).toBuilder();
        try {
            if (!StringsKt.isBlank((CharSequence)this.originalRequest.getTextToSend())) {
                JsonFormat.parser().merge(this.originalRequest.getTextToSend(), (Message.Builder)builder);
            }
        }
        catch (InvalidProtocolBufferException exception) {
            throw new RejectedRPCException(GrpcBundle.INSTANCE.message("unable.to.build.message.from.provided.request.body", new Object[0]), exception);
        }
        DynamicMessage dynamicMessage = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)dynamicMessage, (String)"build(...)");
        return dynamicMessage;
    }

    public static final /* synthetic */ Channel access$getGivenChannel$p(GrpcRequestExecutor $this) {
        return $this.givenChannel;
    }

    public static final /* synthetic */ Channel access$createChannel(GrpcRequestExecutor $this) {
        return $this.createChannel();
    }
}

