/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grpc.requests.execution;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.intellij.grpc.GrpcBundle;
import com.intellij.grpc.requests.RejectedRPCException;
import com.intellij.grpc.requests.execution.FirstResponseCollector;
import com.intellij.grpc.requests.execution.GrpcMessageUtilsKt;
import com.intellij.grpc.requests.execution.GrpcReflectionResponse;
import com.intellij.grpc.requests.execution.GrpcTypedRequestExecutorBase;
import com.intellij.grpc.requests.execution.LazyParseableReflectionResponse;
import com.intellij.grpc.restClient.execution.GrpcRequest;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import io.grpc.reflection.v1alpha.ServerReflectionGrpc;
import io.grpc.reflection.v1alpha.ServerReflectionRequest;
import io.grpc.reflection.v1alpha.ServerReflectionResponse;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u0002H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/intellij/grpc/requests/execution/GrpcReflectionRequestExecutor;", "Lcom/intellij/grpc/requests/execution/GrpcTypedRequestExecutorBase;", "Lio/grpc/reflection/v1alpha/ServerReflectionRequest;", "Lio/grpc/reflection/v1alpha/ServerReflectionResponse;", "originalRequest", "Lcom/intellij/grpc/restClient/execution/GrpcRequest;", "givenChannel", "Lio/grpc/Channel;", "givenParsedRequest", "(Lcom/intellij/grpc/restClient/execution/GrpcRequest;Lio/grpc/Channel;Lio/grpc/reflection/v1alpha/ServerReflectionRequest;)V", "methodDescriptor", "Lio/grpc/MethodDescriptor;", "getMethodDescriptor", "()Lio/grpc/MethodDescriptor;", "assembleReflectionRequest", "executeBidiStreamingCall", "Lcom/intellij/grpc/requests/execution/GrpcReflectionResponse;", "intellij.grpc"})
public final class GrpcReflectionRequestExecutor
extends GrpcTypedRequestExecutorBase<ServerReflectionRequest, ServerReflectionResponse> {
    @Nullable
    private final ServerReflectionRequest givenParsedRequest;
    @NotNull
    private final MethodDescriptor<ServerReflectionRequest, ServerReflectionResponse> methodDescriptor;

    public GrpcReflectionRequestExecutor(@NotNull GrpcRequest originalRequest, @Nullable Channel givenChannel, @Nullable ServerReflectionRequest givenParsedRequest) {
        Intrinsics.checkNotNullParameter((Object)originalRequest, (String)"originalRequest");
        super(originalRequest, givenChannel);
        this.givenParsedRequest = givenParsedRequest;
        MethodDescriptor<ServerReflectionRequest, ServerReflectionResponse> methodDescriptor2 = ServerReflectionGrpc.getServerReflectionInfoMethod();
        Intrinsics.checkNotNullExpressionValue(methodDescriptor2, (String)"getServerReflectionInfoMethod(...)");
        this.methodDescriptor = methodDescriptor2;
    }

    public /* synthetic */ GrpcReflectionRequestExecutor(GrpcRequest grpcRequest, Channel channel, ServerReflectionRequest serverReflectionRequest, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            channel = null;
        }
        if ((n & 4) != 0) {
            serverReflectionRequest = null;
        }
        this(grpcRequest, channel, serverReflectionRequest);
    }

    @Override
    @NotNull
    protected MethodDescriptor<ServerReflectionRequest, ServerReflectionResponse> getMethodDescriptor() {
        return this.methodDescriptor;
    }

    @Override
    @NotNull
    protected GrpcReflectionResponse executeBidiStreamingCall() {
        Channel channel = this.wrapChanelAndMetadata();
        ServerReflectionRequest serverReflectionRequest = this.givenParsedRequest;
        if (serverReflectionRequest == null) {
            serverReflectionRequest = this.assembleReflectionRequest();
        }
        ServerReflectionRequest request = serverReflectionRequest;
        FirstResponseCollector responseCollector = new FirstResponseCollector();
        ServerReflectionGrpc.ServerReflectionStub newStub = ServerReflectionGrpc.newStub(channel);
        StreamObserver<ServerReflectionRequest> $this$executeBidiStreamingCall_u24lambda_u240 = newStub.serverReflectionInfo((StreamObserver<ServerReflectionResponse>)((StreamObserver)responseCollector));
        boolean bl = false;
        $this$executeBidiStreamingCall_u24lambda_u240.onNext((Object)request);
        $this$executeBidiStreamingCall_u24lambda_u240.onCompleted();
        ServerReflectionResponse reflectionResponse = responseCollector.waitForResponseOrNull(5L, TimeUnit.SECONDS);
        if (reflectionResponse == null) {
            Object[] objectArray = new Object[]{this.getOriginalRequest().getAuthority()};
            throw new RejectedRPCException(GrpcBundle.INSTANCE.message("request.execution.connection.timeout.for.address.0", objectArray), null, 2, null);
        }
        return new GrpcReflectionResponse(GrpcMessageUtilsKt.prettify(reflectionResponse), new LazyParseableReflectionResponse(reflectionResponse));
    }

    private final ServerReflectionRequest assembleReflectionRequest() {
        Descriptors.Descriptor descriptor = ServerReflectionRequest.getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)descriptor, (String)"getDescriptor(...)");
        DynamicMessage dynamicRequest = this.buildGenericMessage(descriptor);
        ServerReflectionRequest serverReflectionRequest = ServerReflectionRequest.newBuilder().mergeFrom((Message)dynamicRequest).build();
        Intrinsics.checkNotNullExpressionValue((Object)serverReflectionRequest, (String)"build(...)");
        return serverReflectionRequest;
    }
}

