/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grpc.requests.execution;

import com.intellij.grpc.requests.execution.GrpcInterceptedCall;
import com.intellij.grpc.restClient.execution.GrpcRequest;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002JH\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\b\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J*\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J*\u0010\u0018\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0013\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J0\u0010\u001d\u001a\u00020\u001b\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u001c\u001a\u00020\u00062\u0018\u0010\u001f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0\u0013\u0012\u0004\u0012\u0002H\u001e0\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/grpc/requests/execution/GrpcMetadataInterceptor;", "Lio/grpc/ClientInterceptor;", "grpcRequest", "Lcom/intellij/grpc/restClient/execution/GrpcRequest;", "(Lcom/intellij/grpc/restClient/execution/GrpcRequest;)V", "assembleUserDefinedMetadata", "Lio/grpc/Metadata;", "interceptCall", "Lio/grpc/ClientCall;", "DynamicRequest", "DynamicResponse", "method", "Lio/grpc/MethodDescriptor;", "callOptions", "Lio/grpc/CallOptions;", "next", "Lio/grpc/Channel;", "mapBinaryMetadata", "Lkotlin/Pair;", "Lio/grpc/Metadata$Key;", "", "key", "", "base64EncodedValue", "mapStringMetadata", "value", "updateMetadataEntry", "", "metadata", "updateWith", "T", "keyValue", "intellij.grpc"})
@SourceDebugExtension(value={"SMAP\nGrpcMetadataInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcMetadataInterceptor.kt\ncom/intellij/grpc/requests/execution/GrpcMetadataInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1855#2,2:54\n*S KotlinDebug\n*F\n+ 1 GrpcMetadataInterceptor.kt\ncom/intellij/grpc/requests/execution/GrpcMetadataInterceptor\n*L\n18#1:54,2\n*E\n"})
public final class GrpcMetadataInterceptor
implements ClientInterceptor {
    @NotNull
    private final GrpcRequest grpcRequest;

    public GrpcMetadataInterceptor(@NotNull GrpcRequest grpcRequest) {
        Intrinsics.checkNotNullParameter((Object)grpcRequest, (String)"grpcRequest");
        this.grpcRequest = grpcRequest;
    }

    @NotNull
    public <DynamicRequest, DynamicResponse> ClientCall<DynamicRequest, DynamicResponse> interceptCall(@Nullable MethodDescriptor<DynamicRequest, DynamicResponse> method, @Nullable CallOptions callOptions, @NotNull Channel next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        ClientCall interceptedCall = next.newCall(method, callOptions);
        io.grpc.Metadata metadata = this.assembleUserDefinedMetadata();
        Intrinsics.checkNotNull((Object)interceptedCall);
        return (ClientCall)new GrpcInterceptedCall(metadata, interceptedCall);
    }

    private final io.grpc.Metadata assembleUserDefinedMetadata() {
        io.grpc.Metadata metadata = new io.grpc.Metadata();
        Iterable $this$forEach$iv = this.grpcRequest.getMetadata().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            this.updateMetadataEntry(metadata, (String)it.getKey(), (String)it.getValue());
        }
        return metadata;
    }

    private final void updateMetadataEntry(io.grpc.Metadata metadata, String key, String value) {
        if (StringsKt.endsWith$default((String)key, (String)"-bin", (boolean)false, (int)2, null)) {
            this.updateWith(metadata, this.mapBinaryMetadata(key, value));
        } else {
            this.updateWith(metadata, this.mapStringMetadata(key, value));
        }
    }

    private final <T> void updateWith(io.grpc.Metadata metadata, Pair<? extends Metadata.Key<T>, ? extends T> keyValue) {
        metadata.put((Metadata.Key)keyValue.getFirst(), keyValue.getSecond());
    }

    private final Pair<Metadata.Key<byte[]>, byte[]> mapBinaryMetadata(String key, String base64EncodedValue) {
        byte[] byArray = Base64.getDecoder().decode(base64EncodedValue);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        byte[] decodedValue = byArray;
        return TuplesKt.to((Object)Metadata.Key.of((String)key, (Metadata.BinaryMarshaller)io.grpc.Metadata.BINARY_BYTE_MARSHALLER), (Object)decodedValue);
    }

    private final Pair<Metadata.Key<String>, String> mapStringMetadata(String key, String value) {
        return TuplesKt.to((Object)Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)io.grpc.Metadata.ASCII_STRING_MARSHALLER), (Object)value);
    }
}

