/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sqlite;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.sqlite.BaseBinder;
import org.jetbrains.sqlite.NativeDB;
import org.jetbrains.sqlite.SqliteConnectionKt;
import org.jetbrains.sqlite.SqliteDb;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\bJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ$\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\bJ.\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\bJ8\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\bJB\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\bJL\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\bJ#\u0010\u0014\u001a\u00020\u000b2\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0010\u00a2\u0006\u0002\b\u001cJ\r\u0010\u001d\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\u001eJ\u001d\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020 H\u0010\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020#H\u0016R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006$"}, d2={"Lorg/jetbrains/sqlite/ObjectBinder;", "Lorg/jetbrains/sqlite/BaseBinder;", "paramCount", "", "batchCountHint", "(II)V", "batch", "", "", "[Ljava/lang/Object;", "addBatch", "", "bind", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "bindMultiple", "values", "([Ljava/lang/Object;)V", "bindParams", "pointer", "", "db", "Lorg/jetbrains/sqlite/SqliteDb;", "bindParams$intellij_platform_sqlite", "clearBatch", "clearBatch$intellij_platform_sqlite", "executeBatch", "Lorg/jetbrains/sqlite/NativeDB;", "executeBatch$intellij_platform_sqlite", "toString", "", "intellij.platform.sqlite"})
public final class ObjectBinder
extends BaseBinder {
    @NotNull
    private Object[] batch;

    public ObjectBinder(int paramCount, int batchCountHint) {
        super(paramCount, null);
        this.batch = new Object[paramCount * batchCountHint];
    }

    public /* synthetic */ ObjectBinder(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        this(n, n2);
    }

    @Override
    public void bindParams$intellij_platform_sqlite(long pointer, @NotNull SqliteDb db) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        boolean bl2 = bl = this.getBatchQueryCount() == 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Object[] objectArray = this.batch;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            int position = i;
            Object value2 = objectArray[i];
            SqliteConnectionKt.sqlBind(pointer, position, value2, db);
        }
    }

    @NotNull
    public String toString() {
        String string2 = Arrays.toString(this.batch);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @Override
    public void addBatch() {
        this.batchPosition += this.getParamCount$intellij_platform_sqlite();
        int n = this.getBatchQueryCount();
        this.setBatchQueryCount(n + 1);
        if (this.batchPosition + this.getParamCount$intellij_platform_sqlite() > this.batch.length) {
            Object[] newBatch = new Object[this.batch.length * 2];
            ArraysKt.copyInto$default((Object[])this.batch, (Object[])newBatch, (int)0, (int)0, (int)0, (int)14, null);
            this.batch = newBatch;
        }
    }

    @Override
    public void executeBatch$intellij_platform_sqlite(long pointer, @NotNull NativeDB db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        int n = this.getBatchQueryCount();
        for (int batchIndex = 0; batchIndex < n; ++batchIndex) {
            db.reset(pointer);
            int n2 = this.getParamCount$intellij_platform_sqlite();
            for (int position = 0; position < n2; ++position) {
                SqliteConnectionKt.sqlBind(pointer, position, this.batch[batchIndex * this.getParamCount$intellij_platform_sqlite() + position], db);
            }
            SqliteConnectionKt.stepInBatch(pointer, db, batchIndex);
        }
        db.reset(pointer);
    }

    @Override
    public void clearBatch$intellij_platform_sqlite() {
        super.clearBatch$intellij_platform_sqlite();
        ArraysKt.fill$default((Object[])this.batch, null, (int)0, (int)0, (int)6, null);
    }

    public final void bind(@Nullable Object v1) {
        boolean bl;
        boolean bl2 = bl = this.getParamCount$intellij_platform_sqlite() == 1;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.batch[this.batchPosition] = v1;
    }

    public final void bind(@Nullable Object v1, @Nullable Object v2) {
        boolean bl;
        boolean bl2 = bl = this.getParamCount$intellij_platform_sqlite() == 2;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.batch[this.batchPosition] = v1;
        this.batch[this.batchPosition + 1] = v2;
    }

    public final void bind(@Nullable Object v1, @Nullable Object v2, @Nullable Object v3) {
        boolean bl;
        boolean bl2 = bl = this.getParamCount$intellij_platform_sqlite() == 3;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.batch[this.batchPosition] = v1;
        this.batch[this.batchPosition + 1] = v2;
        this.batch[this.batchPosition + 2] = v3;
    }

    public final void bind(@Nullable Object v1, @Nullable Object v2, @Nullable Object v3, @Nullable Object v4) {
        boolean bl;
        boolean bl2 = bl = this.getParamCount$intellij_platform_sqlite() == 4;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.batch[this.batchPosition] = v1;
        this.batch[this.batchPosition + 1] = v2;
        this.batch[this.batchPosition + 2] = v3;
        this.batch[this.batchPosition + 3] = v4;
    }

    public final void bind(@Nullable Object v1, @Nullable Object v2, @Nullable Object v3, @Nullable Object v4, @Nullable Object v5) {
        boolean bl;
        boolean bl2 = bl = this.getParamCount$intellij_platform_sqlite() == 5;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.batch[this.batchPosition] = v1;
        this.batch[this.batchPosition + 1] = v2;
        this.batch[this.batchPosition + 2] = v3;
        this.batch[this.batchPosition + 3] = v4;
        this.batch[this.batchPosition + 4] = v5;
    }

    public final void bind(@Nullable Object v1, @Nullable Object v2, @Nullable Object v3, @Nullable Object v4, @Nullable Object v5, @Nullable Object v6) {
        boolean bl;
        boolean bl2 = bl = this.getParamCount$intellij_platform_sqlite() == 6;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.batch[this.batchPosition] = v1;
        this.batch[this.batchPosition + 1] = v2;
        this.batch[this.batchPosition + 2] = v3;
        this.batch[this.batchPosition + 3] = v4;
        this.batch[this.batchPosition + 4] = v5;
        this.batch[this.batchPosition + 5] = v6;
    }

    public final void bindMultiple(Object ... values2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        boolean bl2 = bl = values2.length == this.getParamCount$intellij_platform_sqlite();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        System.arraycopy(values2, 0, this.batch, this.batchPosition, this.getParamCount$intellij_platform_sqlite());
    }

    public final void bind(@Nullable Object v1, @Nullable Object v2, @Nullable Object v3, @Nullable Object v4, @Nullable Object v5, @Nullable Object v6, @Nullable Object v7) {
        boolean bl;
        boolean bl2 = bl = this.getParamCount$intellij_platform_sqlite() == 7;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.batch[this.batchPosition] = v1;
        this.batch[this.batchPosition + 1] = v2;
        this.batch[this.batchPosition + 2] = v3;
        this.batch[this.batchPosition + 3] = v4;
        this.batch[this.batchPosition + 4] = v5;
        this.batch[this.batchPosition + 5] = v6;
        this.batch[this.batchPosition + 6] = v7;
    }
}

