/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.model.CommonElement;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.Div;
import org.intellij.plugins.relaxNG.model.Grammar;
import org.intellij.plugins.relaxNG.model.Include;
import org.intellij.plugins.relaxNG.model.Pattern;
import org.intellij.plugins.relaxNG.model.Ref;
import org.intellij.plugins.relaxNG.model.resolve.GrammarFactory;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.intellij.plugins.relaxNG.xml.dom.RngGrammar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefinitionResolver
extends CommonElement.Visitor
implements CachedValueProvider<Map<String, Set<Define>>> {
    private static final Key<CachedValue<Map<String, Set<Define>>>> KEY = Key.create((String)"CACHED_DEFINES");
    private static final ThreadLocal<Set<PsiFile>> myVisitedFiles = new ThreadLocal();
    private static final ThreadLocal<Map<String, Set<Define>>> myDefines = ThreadLocal.withInitial(() -> new HashMap());
    private final Grammar myScope;

    private DefinitionResolver(Grammar scope2) {
        this.myScope = scope2;
    }

    @Override
    public void visitInclude(Include include) {
        include.acceptChildren(this);
        PsiFile value2 = include.getInclude();
        if (myVisitedFiles.get() == null) {
            myVisitedFiles.set((Set<PsiFile>)new ReferenceOpenHashSet());
        }
        if (value2 != null && myVisitedFiles.get().add(value2)) {
            DefinitionResolver.doVisitRncOrRngFile(value2, this);
        }
    }

    private static void doVisitRncOrRngFile(PsiFile file, CommonElement.Visitor visitor2) {
        DomManager mgr;
        DomFileElement<RngGrammar> element;
        if (file instanceof RncFile) {
            RncGrammar grammar = ((RncFile)file).getGrammar();
            if (grammar != null) {
                grammar.acceptChildren(visitor2);
            }
        } else if (file instanceof XmlFile && (element = (mgr = DomManager.getDomManager(file.getProject())).getFileElement((XmlFile)file, RngGrammar.class)) != null) {
            element.getRootElement().acceptChildren(visitor2);
        }
    }

    @Override
    public void visitDiv(Div div) {
        div.acceptChildren(this);
    }

    public void visitDefine(Define def) {
        myDefines.get().computeIfAbsent(def.getName(), __ -> new HashSet()).add(def);
    }

    @Override
    public void visitPattern(Pattern pattern2) {
    }

    @Override
    public void visitGrammar(Grammar pattern2) {
    }

    @Override
    public void visitRef(Ref ref) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedValueProvider.Result<Map<String, Set<Define>>> compute() {
        try {
            this.myScope.acceptChildren(this);
            Object psiElement = this.myScope.getPsiElement();
            if (psiElement == null || !psiElement.isValid()) {
                CachedValueProvider.Result result2 = CachedValueProvider.Result.create(null, (Object[])new Object[]{ModificationTracker.EVER_CHANGED});
                return result2;
            }
            PsiFile file = psiElement.getContainingFile();
            if (myVisitedFiles.get() != null) {
                myVisitedFiles.get().add(file);
                CachedValueProvider.Result result3 = CachedValueProvider.Result.create(myDefines.get(), (Object[])myVisitedFiles.get().toArray());
                return result3;
            }
            CachedValueProvider.Result result4 = CachedValueProvider.Result.create(myDefines.get(), (Object[])new Object[]{file});
            return result4;
        }
        finally {
            myVisitedFiles.remove();
            myDefines.remove();
        }
    }

    @Nullable
    public static Set<Define> resolve(Grammar scope2, String value2) {
        PsiFile file;
        Object element;
        Map<String, Set<Define>> map2 = DefinitionResolver.getAllVariants(scope2);
        if (map2 == null) {
            return null;
        }
        Set<Define> set = map2.get(value2);
        if ((set == null || set.size() == 0) && (element = scope2.getPsiElement()) != null && (file = element.getContainingFile()) instanceof XmlFile) {
            BackwardDefinitionResolver resolver = new BackwardDefinitionResolver(value2);
            RelaxIncludeIndex.processBackwardDependencies((XmlFile)file, resolver);
            return resolver.getResult();
        }
        return set;
    }

    @Nullable
    public static Map<String, Set<Define>> getAllVariants(Grammar scope2) {
        Object psiElement = scope2.getPsiElement();
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)psiElement.getProject());
        CachedValue data2 = (CachedValue)psiElement.getUserData(KEY);
        if (data2 == null || !((DefinitionResolver)data2.getValueProvider()).isValid()) {
            DefinitionResolver resolver = new DefinitionResolver(scope2);
            data2 = manager.createCachedValue((CachedValueProvider)resolver, false);
            psiElement.putUserData(KEY, (Object)data2);
        }
        return (Map)data2.getValue();
    }

    private boolean isValid() {
        Object element = this.myScope.getPsiElement();
        return element != null && element.isValid();
    }

    private static class BackwardDefinitionResolver
    implements PsiElementProcessor<XmlFile> {
        private final String myValue;
        private Define myResult;
        private final Set<PsiFile> myVisitedPsiFiles = new HashSet<PsiFile>();

        BackwardDefinitionResolver(String value2) {
            this.myValue = value2;
        }

        public boolean execute(@NotNull XmlFile element) {
            Grammar g;
            if (element == null) {
                BackwardDefinitionResolver.$$$reportNull$$$0(0);
            }
            if ((g = GrammarFactory.getGrammar(element)) != null) {
                g.acceptChildren(new CommonElement.Visitor(){

                    @Override
                    public void visitElement(CommonElement pattern2) {
                        if (myResult == null) {
                            super.visitElement(pattern2);
                        }
                    }

                    public void visitDefine(Define define) {
                        if (myValue.equals(define.getName())) {
                            myResult = define;
                        }
                    }

                    @Override
                    public void visitInclude(Include include) {
                        PsiFile file = include.getInclude();
                        if (file != null && myVisitedPsiFiles.add(file)) {
                            DefinitionResolver.doVisitRncOrRngFile(file, this);
                        }
                    }
                });
            }
            return this.myResult == null;
        }

        @Nullable
        public Set<Define> getResult() {
            return this.myResult != null ? Collections.singleton(this.myResult) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/relaxNG/model/resolve/DefinitionResolver$BackwardDefinitionResolver", "execute"));
        }
    }
}

