/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.inspections;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.compact.psi.RncDefine;
import org.intellij.plugins.relaxNG.compact.psi.RncElement;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInspection
extends XmlSuppressableInspectionTool {
    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            BaseInspection.$$$reportNull$$$0(0);
        }
        if (element.getContainingFile() instanceof RncFile) {
            RncDefine define = (RncDefine)PsiTreeUtil.getParentOfType((PsiElement)element, RncDefine.class, (boolean)false);
            if (define != null && this.isSuppressedAt(define)) {
                return true;
            }
            RncGrammar grammar = (RncGrammar)PsiTreeUtil.getParentOfType((PsiElement)define, RncGrammar.class);
            return grammar != null && this.isSuppressedAt(grammar);
        }
        return super.isSuppressedFor(element);
    }

    private boolean isSuppressedAt(RncElement location) {
        PsiElement prev = location.getPrevSibling();
        while (prev instanceof PsiWhiteSpace || prev instanceof PsiComment) {
            String text2;
            if (prev instanceof PsiComment && (text2 = prev.getText()).matches("\n*#\\s*suppress\\s.+") && (text2.contains(this.getID()) || "ALL".equals(text2))) {
                return true;
            }
            prev = prev.getPrevSibling();
        }
        return false;
    }

    public SuppressQuickFix @NotNull [] getBatchSuppressActions(@Nullable PsiElement element) {
        if (element.getContainingFile() instanceof RncFile) {
            SuppressQuickFix[] suppressQuickFixArray = (SuppressQuickFix[])ArrayUtil.mergeArrays((Object[])new SuppressQuickFix[]{new SuppressAction("Define"){

                @Override
                protected PsiElement getTarget(PsiElement element) {
                    return PsiTreeUtil.getParentOfType((PsiElement)element, RncDefine.class, (boolean)false);
                }
            }, new SuppressAction("Grammar"){

                @Override
                protected PsiElement getTarget(PsiElement element) {
                    RncDefine define = (RncDefine)PsiTreeUtil.getParentOfType((PsiElement)element, RncDefine.class, (boolean)false);
                    RncGrammar target = define != null ? (RncGrammar)PsiTreeUtil.getParentOfType((PsiElement)define, RncGrammar.class, (boolean)false) : null;
                    return target != null && target.getText().startsWith("grammar ") ? target : null;
                }
            }}, (Object[])this.getXmlOnlySuppressions(element));
            if (suppressQuickFixArray == null) {
                BaseInspection.$$$reportNull$$$0(1);
            }
            return suppressQuickFixArray;
        }
        SuppressQuickFix[] suppressQuickFixArray = super.getBatchSuppressActions(element);
        if (suppressQuickFixArray == null) {
            BaseInspection.$$$reportNull$$$0(2);
        }
        return suppressQuickFixArray;
    }

    private SuppressQuickFix[] getXmlOnlySuppressions(PsiElement element) {
        return (SuppressQuickFix[])ContainerUtil.map((Object[])super.getBatchSuppressActions(element), action2 -> new SuppressQuickFix(){
            final /* synthetic */ SuppressQuickFix val$action;
            {
                this.val$action = suppressQuickFix;
            }

            @NotNull
            public String getName() {
                String string2 = this.val$action.getName();
                if (string2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string2;
            }

            public boolean isAvailable(@NotNull Project project2, @NotNull PsiElement context) {
                if (project2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(2);
                }
                return context.isValid();
            }

            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                PsiElement element1;
                PsiFile file;
                if (project2 == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (descriptor == null) {
                    3.$$$reportNull$$$0(4);
                }
                PsiFile psiFile2 = file = (element1 = descriptor.getPsiElement()) == null ? null : element1.getContainingFile();
                if (file == null || file.getFileType() != XmlFileType.INSTANCE) {
                    return;
                }
                this.val$action.applyFix(project2, (CommonProblemDescriptor)descriptor);
            }

            @NotNull
            public String getFamilyName() {
                String string2 = this.val$action.getFamilyName();
                if (string2 == null) {
                    3.$$$reportNull$$$0(5);
                }
                return string2;
            }

            public boolean isSuppressAll() {
                return this.val$action.isSuppressAll();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3, 4 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/plugins/relaxNG/inspections/BaseInspection$3";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/plugins/relaxNG/inspections/BaseInspection$3";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string2);
                    case 1, 2, 3, 4 -> new IllegalArgumentException(string2);
                };
            }
        }, (Object[])SuppressQuickFix.EMPTY_ARRAY);
    }

    private void suppress(PsiFile file, @NotNull PsiElement location) {
        if (location == null) {
            BaseInspection.$$$reportNull$$$0(3);
        }
        BaseInspection.suppress(file, location, "#suppress " + this.getID(), (Function<? super String, String>)((Function)text2 -> text2 + ", " + this.getID()));
    }

    private static void suppress(PsiFile file, @NotNull PsiElement location, String suppressComment, Function<? super String, String> replace) {
        if (location == null) {
            BaseInspection.$$$reportNull$$$0(4);
        }
        Project project2 = file.getProject();
        VirtualFile vfile = file.getVirtualFile();
        if (vfile == null || ReadonlyStatusHandler.getInstance((Project)project2).ensureFilesWritable(Collections.singletonList(vfile)).hasReadonlyFiles()) {
            return;
        }
        Document doc2 = PsiDocumentManager.getInstance((Project)project2).getDocument(file);
        assert (doc2 != null);
        PsiElement leaf = location.getPrevSibling();
        while (leaf instanceof PsiWhiteSpace) {
            leaf = leaf.getPrevSibling();
        }
        while (leaf instanceof PsiComment || leaf instanceof PsiWhiteSpace) {
            @NonNls String text2 = leaf.getText();
            if (text2.matches("\n*#\\s*suppress\\s.+")) {
                TextRange textRange = leaf.getTextRange();
                doc2.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)replace.fun((Object)text2));
                return;
            }
            leaf = leaf.getPrevSibling();
        }
        int offset = location.getTextRange().getStartOffset();
        doc2.insertString(offset, (CharSequence)(suppressComment + "\n"));
        CodeStyleManager.getInstance((Project)project2).adjustLineIndent(doc2, offset + suppressComment.length());
    }

    @NotNull
    public abstract RncElementVisitor buildVisitor(@NotNull ProblemsHolder var1, boolean var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/inspections/BaseInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/inspections/BaseInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suppress";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }

    private abstract class SuppressAction
    implements SuppressQuickFix {
        private final String myLocation;

        SuppressAction(String location) {
            this.myLocation = location;
        }

        @NotNull
        public String getName() {
            String string2 = RelaxngBundle.message("relaxng.suppress.action.name", this.myLocation);
            if (string2 == null) {
                SuppressAction.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @NotNull
        public String getFamilyName() {
            String string2 = BaseInspection.this.getDisplayName();
            if (string2 == null) {
                SuppressAction.$$$reportNull$$$0(1);
            }
            return string2;
        }

        public boolean isAvailable(@NotNull Project project2, @NotNull PsiElement context) {
            if (project2 == null) {
                SuppressAction.$$$reportNull$$$0(2);
            }
            if (context == null) {
                SuppressAction.$$$reportNull$$$0(3);
            }
            return context.isValid();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            PsiElement target;
            if (project2 == null) {
                SuppressAction.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                SuppressAction.$$$reportNull$$$0(5);
            }
            if ((target = this.getTarget(element = descriptor.getPsiElement())) == null) {
                return;
            }
            BaseInspection.this.suppress(element.getContainingFile(), target);
        }

        protected abstract PsiElement getTarget(PsiElement var1);

        public boolean isSuppressAll() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/relaxNG/inspections/BaseInspection$SuppressAction";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/relaxNG/inspections/BaseInspection$SuppressAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 2, 3, 4, 5 -> new IllegalArgumentException(string2);
            };
        }
    }
}

