/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.json.JsonBundle;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.EnumArrayValueWrapper;
import com.jetbrains.jsonSchema.impl.EnumObjectValueWrapper;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaObjectImpl;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.light.legacy.JsonSchemaObjectReadingUtils;
import com.jetbrains.jsonSchema.impl.light.nodes.JsonSchemaObjectStorage;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class JsonSchemaReader {
    private static final int MAX_SCHEMA_LENGTH = FileUtilRt.LARGE_FOR_CONTENT_LOADING;
    private static final ObjectMapper jsonObjectMapper = new ObjectMapper(new JsonFactory());
    public static final Logger LOG = Logger.getInstance(JsonSchemaReader.class);
    public static final NotificationGroup ERRORS_NOTIFICATION = NotificationGroupManager.getInstance().getNotificationGroup("JSON Schema");
    private final Map<String, JsonSchemaObjectImpl> myIds;
    private final ArrayDeque<Pair<JsonSchemaObjectImpl, JsonValueAdapter>> myQueue;
    private static final Map<String, MyReader> READERS_MAP = new HashMap<String, MyReader>();
    @NotNull
    private final VirtualFile myFile;

    public JsonSchemaReader(@NotNull VirtualFile file) {
        if (file == null) {
            JsonSchemaReader.$$$reportNull$$$0(0);
        }
        this.myIds = new HashMap<String, JsonSchemaObjectImpl>();
        this.myFile = file;
        this.myQueue = new ArrayDeque();
    }

    @NotNull
    public static JsonSchemaObject readFromFile(@NotNull Project project2, @NotNull VirtualFile file) throws Exception {
        JsonSchemaObject object;
        if (project2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(1);
        }
        if (file == null) {
            JsonSchemaReader.$$$reportNull$$$0(2);
        }
        if (!file.isValid()) {
            throw new Exception(JsonBundle.message("schema.reader.cant.load.file", file.getName()));
        }
        PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(file);
        JsonSchemaObject jsonSchemaObject = object = psiFile2 == null ? null : new JsonSchemaReader(file).read(psiFile2);
        if (object == null) {
            throw new Exception(JsonBundle.message("schema.reader.cant.load.model", file.getName()));
        }
        JsonSchemaObject jsonSchemaObject2 = object;
        if (jsonSchemaObject2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(3);
        }
        return jsonSchemaObject2;
    }

    @Nullable
    @NlsContexts.DialogMessage
    public static String checkIfValidJsonSchema(@NotNull Project project2, @NotNull VirtualFile file) {
        if (project2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(4);
        }
        if (file == null) {
            JsonSchemaReader.$$$reportNull$$$0(5);
        }
        long length = file.getLength();
        String fileName = file.getName();
        if (length > (long)MAX_SCHEMA_LENGTH) {
            return JsonBundle.message("schema.reader.file.too.large", fileName, length);
        }
        if (length == 0L) {
            return JsonBundle.message("schema.reader.file.empty", fileName);
        }
        try {
            JsonSchemaReader.readFromFile(project2, file);
        }
        catch (Exception e) {
            String message2 = JsonBundle.message("schema.reader.file.not.found.or.error", fileName, e.getMessage());
            LOG.info(message2);
            return message2;
        }
        return null;
    }

    private static JsonSchemaObjectImpl enqueue(@NotNull Collection<Pair<JsonSchemaObjectImpl, JsonValueAdapter>> queue2, @NotNull JsonSchemaObjectImpl schemaObject, @NotNull JsonValueAdapter container) {
        if (queue2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(6);
        }
        if (schemaObject == null) {
            JsonSchemaReader.$$$reportNull$$$0(7);
        }
        if (container == null) {
            JsonSchemaReader.$$$reportNull$$$0(8);
        }
        queue2.add((Pair<JsonSchemaObjectImpl, JsonValueAdapter>)Pair.create((Object)schemaObject, (Object)container));
        return schemaObject;
    }

    @Nullable
    public static JsonSchemaObject getOrComputeSchemaObjectForSchemaFile(@NotNull VirtualFile schemaFile, @NotNull Project project2) {
        if (schemaFile == null) {
            JsonSchemaReader.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(10);
        }
        return JsonSchemaObjectStorage.getInstance(project2).getOrComputeSchemaRootObject(schemaFile);
    }

    @Nullable
    public JsonSchemaObject read(@NotNull PsiFile file) {
        if (file == null) {
            JsonSchemaReader.$$$reportNull$$$0(11);
        }
        if (Registry.is((String)"json.schema.object.v2")) {
            return JsonSchemaReader.getOrComputeSchemaObjectForSchemaFile(file.getOriginalFile().getVirtualFile(), file.getProject());
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker((PsiElement)file, JsonSchemaObjectReadingUtils.NULL_OBJ);
        if (walker == null) {
            return null;
        }
        PsiElement root = (PsiElement)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file, () -> (PsiElement)ContainerUtil.getFirstItem(walker.getRoots(file)));
        if (root == null) {
            return null;
        }
        JsonValueAdapter rootAdapter = walker.createValueAdapter(root);
        return rootAdapter == null ? null : this.read(rootAdapter);
    }

    @NotNull
    private JsonSchemaObjectImpl read(@NotNull JsonValueAdapter rootAdapter) {
        if (rootAdapter == null) {
            JsonSchemaReader.$$$reportNull$$$0(12);
        }
        JsonSchemaObjectImpl root = new JsonSchemaObjectImpl(this.myFile, "/");
        JsonSchemaReader.enqueue(this.myQueue, root, rootAdapter);
        while (!this.myQueue.isEmpty()) {
            Pair<JsonSchemaObjectImpl, JsonValueAdapter> currentItem = this.myQueue.removeFirst();
            JsonSchemaObjectImpl currentSchema = (JsonSchemaObjectImpl)currentItem.first;
            String pointer = currentSchema.getPointer();
            JsonValueAdapter adapter = (JsonValueAdapter)currentItem.second;
            if (adapter instanceof JsonObjectValueAdapter) {
                List<JsonPropertyAdapter> list2 = ((JsonObjectValueAdapter)adapter).getPropertyList();
                for (JsonPropertyAdapter property2 : list2) {
                    String name;
                    Collection<JsonValueAdapter> values2 = property2.getValues();
                    if (values2.size() != 1 || (name = property2.getName()) == null) continue;
                    MyReader reader = READERS_MAP.get(name);
                    JsonValueAdapter value2 = values2.iterator().next();
                    if (reader != null) {
                        reader.read(value2, currentSchema, this.myQueue, this.myFile);
                        continue;
                    }
                    this.readSingleDefinition(name, value2, currentSchema, pointer);
                }
            } else if (adapter instanceof JsonArrayValueAdapter) {
                List<JsonValueAdapter> values3 = ((JsonArrayValueAdapter)adapter).getElements();
                for (int i = 0; i < values3.size(); ++i) {
                    this.readSingleDefinition(String.valueOf(i), values3.get(i), currentSchema, pointer);
                }
            }
            if (currentSchema.getId() != null) {
                this.myIds.put(currentSchema.getId(), currentSchema);
            }
            currentSchema.completeInitialization(adapter);
        }
        JsonSchemaObjectImpl jsonSchemaObjectImpl = root;
        if (jsonSchemaObjectImpl == null) {
            JsonSchemaReader.$$$reportNull$$$0(13);
        }
        return jsonSchemaObjectImpl;
    }

    public Map<String, JsonSchemaObjectImpl> getIds() {
        return this.myIds;
    }

    private void readSingleDefinition(@NotNull String name, @NotNull JsonValueAdapter value2, @NotNull JsonSchemaObjectImpl schema, String pointer) {
        if (name == null) {
            JsonSchemaReader.$$$reportNull$$$0(14);
        }
        if (value2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(15);
        }
        if (schema == null) {
            JsonSchemaReader.$$$reportNull$$$0(16);
        }
        String nextPointer = JsonSchemaReader.getNewPointer(name, pointer);
        JsonSchemaObjectImpl defined = JsonSchemaReader.enqueue(this.myQueue, new JsonSchemaObjectImpl(this.myFile, nextPointer), value2);
        Map<String, JsonSchemaObjectImpl> definitions = schema.getDefinitionsMap();
        if (definitions == null) {
            definitions = new HashMap<String, JsonSchemaObjectImpl>();
            schema.setDefinitionsMap(definitions);
        }
        definitions.put(name, defined);
    }

    @NotNull
    public static String getNewPointer(@NotNull String name, String oldPointer) {
        if (name == null) {
            JsonSchemaReader.$$$reportNull$$$0(17);
        }
        String string2 = oldPointer.equals("/") ? oldPointer + name : oldPointer + "/" + name;
        if (string2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(18);
        }
        return string2;
    }

    private static void fillMap() {
        READERS_MAP.put("$anchor", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObjectImpl, String>)((PairConsumer)(object, s) -> object.setId((String)s))));
        READERS_MAP.put("$id", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObjectImpl, String>)((PairConsumer)(object, s) -> object.setId((String)s))));
        READERS_MAP.put("id", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObjectImpl, String>)((PairConsumer)(object, s) -> object.setId((String)s))));
        READERS_MAP.put("$schema", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObjectImpl, String>)((PairConsumer)(object, s) -> object.setSchema((String)s))));
        READERS_MAP.put("description", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObjectImpl, String>)((PairConsumer)(object, s) -> object.setDescription((String)s))));
        READERS_MAP.put("deprecationMessage", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObjectImpl, String>)((PairConsumer)(object, s) -> object.setDeprecationMessage((String)s))));
        READERS_MAP.put("x-intellij-html-description", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObjectImpl, String>)((PairConsumer)(object, s) -> object.setHtmlDescription((String)s))));
        READERS_MAP.put("x-intellij-language-injection", (element, object, queue2, virtualFile) -> JsonSchemaReader.readInjectionMetadata(element, object));
        READERS_MAP.put("x-intellij-enum-metadata", (element, object, queue2, virtualFile) -> JsonSchemaReader.readEnumMetadata(element, object));
        READERS_MAP.put("x-intellij-case-insensitive", (element, object, queue2, virtualFile) -> {
            if (element.isBooleanLiteral()) {
                object.setForceCaseInsensitive(JsonSchemaReader.getBoolean(element));
            }
        });
        READERS_MAP.put("title", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObjectImpl, String>)((PairConsumer)(object, s) -> object.setTitle((String)s))));
        READERS_MAP.put("$ref", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObjectImpl, String>)((PairConsumer)(object, s) -> object.setRef((String)s))));
        READERS_MAP.put("$recursiveRef", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObjectImpl, String>)((PairConsumer)(object, s) -> {
            object.setRef((String)s);
            object.setRefRecursive(true);
        })));
        READERS_MAP.put("$recursiveAnchor", (element, object, queue2, virtualFile) -> {
            if (element.isBooleanLiteral()) {
                object.setRecursiveAnchor(true);
            }
        });
        READERS_MAP.put("default", JsonSchemaReader.createDefault());
        READERS_MAP.put("example", JsonSchemaReader.createExampleConsumer());
        READERS_MAP.put("format", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObjectImpl, String>)((PairConsumer)(object, s) -> object.setFormat((String)s))));
        READERS_MAP.put("definitions", JsonSchemaReader.createDefinitionsConsumer("definitions"));
        READERS_MAP.put("$defs", JsonSchemaReader.createDefinitionsConsumer("$defs"));
        READERS_MAP.put("properties", JsonSchemaReader.createPropertiesConsumer());
        READERS_MAP.put("multipleOf", JsonSchemaReader.createFromNumber((PairConsumer<JsonSchemaObjectImpl, Number>)((PairConsumer)(object, i) -> object.setMultipleOf((Number)i))));
        READERS_MAP.put("maximum", JsonSchemaReader.createFromNumber((PairConsumer<JsonSchemaObjectImpl, Number>)((PairConsumer)(object, i) -> object.setMaximum((Number)i))));
        READERS_MAP.put("minimum", JsonSchemaReader.createFromNumber((PairConsumer<JsonSchemaObjectImpl, Number>)((PairConsumer)(object, i) -> object.setMinimum((Number)i))));
        READERS_MAP.put("exclusiveMaximum", (element, object, queue2, virtualFile) -> {
            if (element.isBooleanLiteral()) {
                object.setExclusiveMaximum(JsonSchemaReader.getBoolean(element));
            } else if (element.isNumberLiteral()) {
                object.setExclusiveMaximumNumber(JsonSchemaReader.getNumber(element));
            }
        });
        READERS_MAP.put("exclusiveMinimum", (element, object, queue2, virtualFile) -> {
            if (element.isBooleanLiteral()) {
                object.setExclusiveMinimum(JsonSchemaReader.getBoolean(element));
            } else if (element.isNumberLiteral()) {
                object.setExclusiveMinimumNumber(JsonSchemaReader.getNumber(element));
            }
        });
        READERS_MAP.put("maxLength", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObjectImpl, Integer>)((PairConsumer)(object, i) -> object.setMaxLength((Integer)i))));
        READERS_MAP.put("minLength", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObjectImpl, Integer>)((PairConsumer)(object, i) -> object.setMinLength((Integer)i))));
        READERS_MAP.put("pattern", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObjectImpl, String>)((PairConsumer)(object, s) -> object.setPattern((String)s))));
        READERS_MAP.put("additionalItems", JsonSchemaReader.createAdditionalItems());
        READERS_MAP.put("items", JsonSchemaReader.createItems());
        READERS_MAP.put("contains", JsonSchemaReader.createContains());
        READERS_MAP.put("maxItems", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObjectImpl, Integer>)((PairConsumer)(object, i) -> object.setMaxItems((Integer)i))));
        READERS_MAP.put("minItems", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObjectImpl, Integer>)((PairConsumer)(object, i) -> object.setMinItems((Integer)i))));
        READERS_MAP.put("uniqueItems", (element, object, queue2, virtualFile) -> {
            if (element.isBooleanLiteral()) {
                object.setUniqueItems(JsonSchemaReader.getBoolean(element));
            }
        });
        READERS_MAP.put("maxProperties", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObjectImpl, Integer>)((PairConsumer)(object, i) -> object.setMaxProperties((Integer)i))));
        READERS_MAP.put("minProperties", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObjectImpl, Integer>)((PairConsumer)(object, i) -> object.setMinProperties((Integer)i))));
        READERS_MAP.put("required", JsonSchemaReader.createRequired());
        READERS_MAP.put("additionalProperties", JsonSchemaReader.createAdditionalProperties());
        READERS_MAP.put("propertyNames", JsonSchemaReader.createFromObject("propertyNames", (PairConsumer<JsonSchemaObjectImpl, JsonSchemaObjectImpl>)((PairConsumer)(object, schema) -> object.setPropertyNamesSchema((JsonSchemaObjectImpl)schema))));
        READERS_MAP.put("patternProperties", JsonSchemaReader.createPatternProperties());
        READERS_MAP.put("dependencies", JsonSchemaReader.createDependencies());
        READERS_MAP.put("enum", JsonSchemaReader.createEnum());
        READERS_MAP.put("const", (element, object, queue2, virtualFile) -> object.setEnum(ContainerUtil.createMaybeSingletonList((Object)JsonSchemaReader.readEnumValue(element))));
        READERS_MAP.put("type", JsonSchemaReader.createType());
        READERS_MAP.put("allOf", JsonSchemaReader.createContainer("allOf", (PairConsumer<JsonSchemaObjectImpl, List<JsonSchemaObjectImpl>>)((PairConsumer)(object, members) -> object.setAllOf((List<JsonSchemaObjectImpl>)members))));
        READERS_MAP.put("anyOf", JsonSchemaReader.createContainer("anyOf", (PairConsumer<JsonSchemaObjectImpl, List<JsonSchemaObjectImpl>>)((PairConsumer)(object, members) -> object.setAnyOf((List<JsonSchemaObjectImpl>)members))));
        READERS_MAP.put("oneOf", JsonSchemaReader.createContainer("oneOf", (PairConsumer<JsonSchemaObjectImpl, List<JsonSchemaObjectImpl>>)((PairConsumer)(object, members) -> object.setOneOf((List<JsonSchemaObjectImpl>)members))));
        READERS_MAP.put("not", JsonSchemaReader.createFromObject("not", (PairConsumer<JsonSchemaObjectImpl, JsonSchemaObjectImpl>)((PairConsumer)(object, schema1) -> object.setNot((JsonSchemaObjectImpl)schema1))));
        READERS_MAP.put("if", JsonSchemaReader.createFromObject("if", (PairConsumer<JsonSchemaObjectImpl, JsonSchemaObjectImpl>)((PairConsumer)(object, schema) -> object.setIf((JsonSchemaObjectImpl)schema))));
        READERS_MAP.put("then", JsonSchemaReader.createFromObject("then", (PairConsumer<JsonSchemaObjectImpl, JsonSchemaObjectImpl>)((PairConsumer)(object, schema) -> object.setThen((JsonSchemaObjectImpl)schema))));
        READERS_MAP.put("else", JsonSchemaReader.createFromObject("else", (PairConsumer<JsonSchemaObjectImpl, JsonSchemaObjectImpl>)((PairConsumer)(object, schema) -> object.setElse((JsonSchemaObjectImpl)schema))));
        READERS_MAP.put("instanceof", (element, object, queue2, virtualFile) -> object.setShouldValidateAgainstJSType(true));
        READERS_MAP.put("typeof", (element, object, queue2, virtualFile) -> object.setShouldValidateAgainstJSType(true));
    }

    private static void readEnumMetadata(JsonValueAdapter element, JsonSchemaObjectImpl object) {
        if (!(element instanceof JsonObjectValueAdapter)) {
            return;
        }
        HashMap<String, Map<String, String>> metadataMap = new HashMap<String, Map<String, String>>();
        for (JsonPropertyAdapter adapter : ((JsonObjectValueAdapter)element).getPropertyList()) {
            Collection<JsonValueAdapter> values2;
            String name = adapter.getName();
            if (name == null || (values2 = adapter.getValues()).size() != 1) continue;
            JsonValueAdapter valueAdapter = values2.iterator().next();
            if (valueAdapter.isStringLiteral()) {
                metadataMap.put(name, Collections.singletonMap("description", JsonSchemaReader.getString(valueAdapter)));
                continue;
            }
            if (!(valueAdapter instanceof JsonObjectValueAdapter)) continue;
            HashMap<String, String> valueMap = new HashMap<String, String>();
            for (JsonPropertyAdapter propertyAdapter : ((JsonObjectValueAdapter)valueAdapter).getPropertyList()) {
                JsonValueAdapter next;
                Collection<JsonValueAdapter> adapterValues;
                String adapterName = propertyAdapter.getName();
                if (adapterName == null || (adapterValues = propertyAdapter.getValues()).size() != 1 || !(next = adapterValues.iterator().next()).isStringLiteral()) continue;
                valueMap.put(adapterName, JsonSchemaReader.getString(next));
            }
            metadataMap.put(name, valueMap);
        }
        object.setEnumMetadata(metadataMap);
    }

    private static void readInjectionMetadata(JsonValueAdapter element, JsonSchemaObjectImpl object) {
        if (element.isStringLiteral()) {
            object.setLanguageInjection(JsonSchemaReader.getString(element));
        } else if (element instanceof JsonObjectValueAdapter) {
            for (JsonPropertyAdapter adapter : ((JsonObjectValueAdapter)element).getPropertyList()) {
                String postfix;
                String prefix;
                String lang = JsonSchemaReader.readSingleProp(adapter, "language", JsonSchemaReader::getString);
                if (lang != null) {
                    object.setLanguageInjection(lang);
                }
                if ((prefix = JsonSchemaReader.readSingleProp(adapter, "prefix", JsonSchemaReader::getString)) != null) {
                    object.setLanguageInjectionPrefix(prefix);
                }
                if ((postfix = JsonSchemaReader.readSingleProp(adapter, "suffix", JsonSchemaReader::getString)) == null) continue;
                object.setLanguageInjectionPostfix(postfix);
            }
        }
    }

    @Nullable
    private static <T> T readSingleProp(JsonPropertyAdapter adapter, String propName, Function<JsonValueAdapter, T> getterFunc) {
        Collection<JsonValueAdapter> values2;
        if (propName.equals(adapter.getName()) && (values2 = adapter.getValues()).size() == 1) {
            return getterFunc.apply(values2.iterator().next());
        }
        return null;
    }

    private static MyReader createFromStringValue(PairConsumer<JsonSchemaObjectImpl, String> propertySetter) {
        return (element, object, queue2, virtualFile) -> {
            if (element.isStringLiteral()) {
                propertySetter.consume((Object)object, (Object)JsonSchemaReader.getString(element));
            }
        };
    }

    private static MyReader createFromInteger(PairConsumer<JsonSchemaObjectImpl, Integer> propertySetter) {
        return (element, object, queue2, virtualFile) -> {
            if (element.isNumberLiteral()) {
                propertySetter.consume((Object)object, (Object)((Integer)JsonSchemaReader.getNumber(element)));
            }
        };
    }

    private static MyReader createFromNumber(PairConsumer<JsonSchemaObjectImpl, Number> propertySetter) {
        return (element, object, queue2, virtualFile) -> {
            if (element.isNumberLiteral()) {
                propertySetter.consume((Object)object, (Object)JsonSchemaReader.getNumber(element));
            }
        };
    }

    private static MyReader createFromObject(String prop, PairConsumer<JsonSchemaObjectImpl, JsonSchemaObjectImpl> propertySetter) {
        return (element, object, queue2, virtualFile) -> {
            if (element.isObject()) {
                propertySetter.consume((Object)object, (Object)JsonSchemaReader.enqueue(queue2, new JsonSchemaObjectImpl(virtualFile, JsonSchemaReader.getNewPointer(prop, object.getPointer())), element));
            }
        };
    }

    private static MyReader createContainer(@NotNull String containerName, @NotNull PairConsumer<JsonSchemaObjectImpl, List<JsonSchemaObjectImpl>> delegate) {
        if (containerName == null) {
            JsonSchemaReader.$$$reportNull$$$0(19);
        }
        if (delegate == null) {
            JsonSchemaReader.$$$reportNull$$$0(20);
        }
        return (element, object, queue2, virtualFile) -> {
            if (element instanceof JsonArrayValueAdapter) {
                List<JsonValueAdapter> list2 = ((JsonArrayValueAdapter)element).getElements();
                ArrayList<JsonSchemaObjectImpl> members = new ArrayList<JsonSchemaObjectImpl>(list2.size());
                for (int i = 0; i < list2.size(); ++i) {
                    JsonValueAdapter value2 = list2.get(i);
                    if (!value2.isObject()) continue;
                    members.add(JsonSchemaReader.enqueue(queue2, new JsonSchemaObjectImpl(virtualFile, JsonSchemaReader.getNewPointer(containerName + "/" + i, object.getPointer())), value2));
                }
                delegate.consume((Object)object, members);
            }
        };
    }

    private static MyReader createType() {
        return (element, object, queue2, virtualFile) -> {
            Set<JsonSchemaType> typeList;
            if (element.isStringLiteral()) {
                JsonSchemaType type2 = JsonSchemaReader.parseType(StringUtil.unquoteString((String)element.getDelegate().getText()));
                if (type2 != null) {
                    object.setType(type2);
                }
            } else if (element instanceof JsonArrayValueAdapter && !(typeList = ((JsonArrayValueAdapter)element).getElements().stream().filter(JsonSchemaReader.notEmptyString()).map(el -> JsonSchemaReader.parseType(StringUtil.unquoteString((String)el.getDelegate().getText()))).filter(el -> el != null).collect(Collectors.toSet())).isEmpty()) {
                object.setTypeVariants(typeList);
            }
        };
    }

    @Nullable
    public static JsonSchemaType parseType(@NotNull String typeString) {
        if (typeString == null) {
            JsonSchemaReader.$$$reportNull$$$0(21);
        }
        try {
            return JsonSchemaType.valueOf("_" + typeString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    private static Object readEnumValue(JsonValueAdapter value2) {
        if (value2.isStringLiteral()) {
            return "\"" + StringUtil.unquoteString((String)value2.getDelegate().getText()) + "\"";
        }
        if (value2.isNumberLiteral()) {
            return JsonSchemaReader.getNumber(value2);
        }
        if (value2.isBooleanLiteral()) {
            return JsonSchemaReader.getBoolean(value2);
        }
        if (value2.isNull()) {
            return "null";
        }
        if (value2 instanceof JsonArrayValueAdapter) {
            return new EnumArrayValueWrapper(((JsonArrayValueAdapter)value2).getElements().stream().map(v -> JsonSchemaReader.readEnumValue(v)).filter(v -> v != null).toArray());
        }
        if (value2 instanceof JsonObjectValueAdapter) {
            return new EnumObjectValueWrapper(((JsonObjectValueAdapter)value2).getPropertyList().stream().filter(p -> p.getValues().size() == 1).map(p -> Pair.create((Object)p.getName(), (Object)JsonSchemaReader.readEnumValue(p.getValues().iterator().next()))).filter(p -> p.second != null).collect(Collectors.toMap(p -> (String)p.first, p -> p.second)));
        }
        return null;
    }

    private static MyReader createEnum() {
        return (element, object, queue2, virtualFile) -> {
            if (element instanceof JsonArrayValueAdapter) {
                ArrayList<Object> objects = new ArrayList<Object>();
                List<JsonValueAdapter> list2 = ((JsonArrayValueAdapter)element).getElements();
                for (JsonValueAdapter value2 : list2) {
                    Object enumValue = JsonSchemaReader.readEnumValue(value2);
                    if (enumValue == null) {
                        return;
                    }
                    objects.add(enumValue);
                }
                object.setEnum(objects);
            }
        };
    }

    private static String getString(@NotNull JsonValueAdapter value2) {
        if (value2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(22);
        }
        return StringUtil.unquoteString((String)value2.getDelegate().getText());
    }

    private static boolean getBoolean(@NotNull JsonValueAdapter value2) {
        if (value2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(23);
        }
        return Boolean.parseBoolean(value2.getDelegate().getText());
    }

    @NotNull
    private static Number getNumber(@NotNull JsonValueAdapter value2) {
        Number numberValue;
        if (value2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(24);
        }
        try {
            numberValue = Integer.parseInt(value2.getDelegate().getText());
        }
        catch (NumberFormatException e) {
            try {
                numberValue = Double.parseDouble(value2.getDelegate().getText());
            }
            catch (NumberFormatException e2) {
                Integer n = -1;
                if (n == null) {
                    JsonSchemaReader.$$$reportNull$$$0(25);
                }
                return n;
            }
        }
        Integer n = numberValue;
        if (n == null) {
            JsonSchemaReader.$$$reportNull$$$0(26);
        }
        return n;
    }

    private static MyReader createDependencies() {
        return (element, object, queue2, virtualFile) -> {
            if (element instanceof JsonObjectValueAdapter) {
                HashMap<String, List<String>> propertyDependencies = new HashMap<String, List<String>>();
                HashMap<String, JsonSchemaObjectImpl> schemaDependencies = new HashMap<String, JsonSchemaObjectImpl>();
                List<JsonPropertyAdapter> list2 = ((JsonObjectValueAdapter)element).getPropertyList();
                for (JsonPropertyAdapter property2 : list2) {
                    JsonValueAdapter value2;
                    String escapedName = JsonPointerUtil.escapeForJsonPointer(StringUtil.notNullize((String)property2.getName()));
                    Collection<JsonValueAdapter> values2 = property2.getValues();
                    if (values2.size() != 1 || (value2 = values2.iterator().next()) == null) continue;
                    if (value2 instanceof JsonArrayValueAdapter) {
                        List dependencies = ((JsonArrayValueAdapter)value2).getElements().stream().filter(JsonSchemaReader.notEmptyString()).map(el -> StringUtil.unquoteString((String)el.getDelegate().getText())).collect(Collectors.toList());
                        if (dependencies.isEmpty()) continue;
                        propertyDependencies.put(property2.getName(), dependencies);
                        continue;
                    }
                    if (!value2.isObject()) continue;
                    String newPointer = JsonSchemaReader.getNewPointer("dependencies/" + escapedName, object.getPointer());
                    schemaDependencies.put(property2.getName(), JsonSchemaReader.enqueue(queue2, new JsonSchemaObjectImpl(virtualFile, newPointer), value2));
                }
                object.setPropertyDependencies(propertyDependencies);
                object.setSchemaDependencies(schemaDependencies);
            }
        };
    }

    @NotNull
    private static Predicate<JsonValueAdapter> notEmptyString() {
        Predicate<JsonValueAdapter> predicate = el -> el.isStringLiteral() && !StringUtil.isEmptyOrSpaces((String)el.getDelegate().getText());
        if (predicate == null) {
            JsonSchemaReader.$$$reportNull$$$0(27);
        }
        return predicate;
    }

    private static MyReader createPatternProperties() {
        return (element, object, queue2, virtualFile) -> {
            if (element.isObject()) {
                object.setPatternProperties(JsonSchemaReader.readInnerObject(JsonSchemaReader.getNewPointer("patternProperties", object.getPointer()), element, queue2, virtualFile));
            }
        };
    }

    private static MyReader createAdditionalProperties() {
        return (element, object, queue2, virtualFile) -> {
            if (element.isBooleanLiteral()) {
                object.setAdditionalPropertiesAllowed(JsonSchemaReader.getBoolean(element));
            } else if (element.isObject()) {
                object.setAdditionalPropertiesSchema(JsonSchemaReader.enqueue(queue2, new JsonSchemaObjectImpl(virtualFile, JsonSchemaReader.getNewPointer("additionalProperties", object.getPointer())), element));
            }
        };
    }

    private static MyReader createRequired() {
        return (element, object, queue2, virtualFile) -> {
            if (element instanceof JsonArrayValueAdapter) {
                object.setRequired(new LinkedHashSet<String>(((JsonArrayValueAdapter)element).getElements().stream().filter(JsonSchemaReader.notEmptyString()).map(el -> StringUtil.unquoteString((String)el.getDelegate().getText())).collect(Collectors.toList())));
            }
        };
    }

    private static MyReader createItems() {
        return (element, object, queue2, virtualFile) -> {
            if (element.isObject()) {
                object.setItemsSchema(JsonSchemaReader.enqueue(queue2, new JsonSchemaObjectImpl(virtualFile, JsonSchemaReader.getNewPointer("items", object.getPointer())), element));
            } else if (element instanceof JsonArrayValueAdapter) {
                ArrayList<JsonSchemaObjectImpl> list2 = new ArrayList<JsonSchemaObjectImpl>();
                List<JsonValueAdapter> values2 = ((JsonArrayValueAdapter)element).getElements();
                for (int i = 0; i < values2.size(); ++i) {
                    JsonValueAdapter value2 = values2.get(i);
                    if (!value2.isObject()) continue;
                    list2.add(JsonSchemaReader.enqueue(queue2, new JsonSchemaObjectImpl(virtualFile, JsonSchemaReader.getNewPointer("items/" + i, object.getPointer())), value2));
                }
                object.setItemsSchemaList(list2);
            }
        };
    }

    private static MyReader createDefinitionsConsumer(String defsOrDefinitions) {
        return (element, object, queue2, virtualFile) -> {
            if (element.isObject()) {
                object.setDefinitionsMap(JsonSchemaReader.readInnerObject(JsonSchemaReader.getNewPointer(defsOrDefinitions, object.getPointer()), element, queue2, virtualFile));
            }
        };
    }

    private static MyReader createContains() {
        return (element, object, queue2, virtualFile) -> {
            if (element.isObject()) {
                object.setContainsSchema(JsonSchemaReader.enqueue(queue2, new JsonSchemaObjectImpl(virtualFile, JsonSchemaReader.getNewPointer("contains", object.getPointer())), element));
            }
        };
    }

    private static MyReader createAdditionalItems() {
        return (element, object, queue2, virtualFile) -> {
            if (element.isBooleanLiteral()) {
                object.setAdditionalItemsAllowed(JsonSchemaReader.getBoolean(element));
            } else if (element.isObject()) {
                object.setAdditionalItemsSchema(JsonSchemaReader.enqueue(queue2, new JsonSchemaObjectImpl(virtualFile, JsonSchemaReader.getNewPointer("additionalItems", object.getPointer())), element));
            }
        };
    }

    private static MyReader createPropertiesConsumer() {
        return (element, object, queue2, virtualFile) -> {
            if (element.isObject()) {
                object.setProperties(JsonSchemaReader.readInnerObject(JsonSchemaReader.getNewPointer("properties", object.getPointer()), element, queue2, virtualFile));
            }
        };
    }

    private static MyReader createExampleConsumer() {
        return (element, object, queue2, virtualFile) -> {
            if (element.isObject()) {
                object.setExample(JsonSchemaReader.readExample(element));
            }
        };
    }

    @NotNull
    private static Map<String, JsonSchemaObjectImpl> readInnerObject(String parentPointer, @NotNull JsonValueAdapter element, @NotNull Collection<Pair<JsonSchemaObjectImpl, JsonValueAdapter>> queue2, VirtualFile virtualFile) {
        if (element == null) {
            JsonSchemaReader.$$$reportNull$$$0(28);
        }
        if (queue2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(29);
        }
        HashMap<String, JsonSchemaObjectImpl> map2 = new HashMap<String, JsonSchemaObjectImpl>();
        if (!(element instanceof JsonObjectValueAdapter)) {
            HashMap<String, JsonSchemaObjectImpl> hashMap = map2;
            if (hashMap == null) {
                JsonSchemaReader.$$$reportNull$$$0(30);
            }
            return hashMap;
        }
        List<JsonPropertyAdapter> properties2 = ((JsonObjectValueAdapter)element).getPropertyList();
        for (JsonPropertyAdapter property2 : properties2) {
            Collection<JsonValueAdapter> values2 = property2.getValues();
            if (values2.size() != 1) continue;
            JsonValueAdapter value2 = values2.iterator().next();
            String propertyName = property2.getName();
            if (propertyName == null) continue;
            String escapedName = JsonPointerUtil.escapeForJsonPointer(propertyName);
            if (value2.isBooleanLiteral()) {
                map2.put(propertyName, new JsonSchemaObjectImpl(virtualFile, JsonSchemaReader.getNewPointer(escapedName, parentPointer)));
                continue;
            }
            if (!value2.isObject()) continue;
            map2.put(propertyName, JsonSchemaReader.enqueue(queue2, new JsonSchemaObjectImpl(virtualFile, JsonSchemaReader.getNewPointer(escapedName, parentPointer)), value2));
        }
        HashMap<String, JsonSchemaObjectImpl> hashMap = map2;
        if (hashMap == null) {
            JsonSchemaReader.$$$reportNull$$$0(31);
        }
        return hashMap;
    }

    @NotNull
    private static Map<String, Object> readExample(@NotNull JsonValueAdapter element) {
        if (element == null) {
            JsonSchemaReader.$$$reportNull$$$0(32);
        }
        HashMap<String, Object> example = new HashMap<String, Object>();
        if (!(element instanceof JsonObjectValueAdapter)) {
            HashMap<String, Object> hashMap = example;
            if (hashMap == null) {
                JsonSchemaReader.$$$reportNull$$$0(33);
            }
            return hashMap;
        }
        JsonObjectValueAdapter objectAdapter = (JsonObjectValueAdapter)element;
        for (JsonPropertyAdapter property2 : objectAdapter.getPropertyList()) {
            JsonValueAdapter value2 = (JsonValueAdapter)ContainerUtil.getFirstItem(property2.getValues());
            String propertyName = property2.getName();
            if (propertyName == null) continue;
            example.put(propertyName, JsonSchemaReader.mapPrimitiveTypeOrEmptyObject(value2));
        }
        HashMap<String, Object> hashMap = example;
        if (hashMap == null) {
            JsonSchemaReader.$$$reportNull$$$0(34);
        }
        return hashMap;
    }

    private static MyReader createDefault() {
        return (element, object, queue2, virtualFile) -> {
            if (element.isObject()) {
                object.setDefault(JsonSchemaReader.enqueue(queue2, new JsonSchemaObjectImpl(virtualFile, JsonSchemaReader.getNewPointer("default", object.getPointer())), element));
            } else if (element.isStringLiteral()) {
                object.setDefault(StringUtil.unquoteString((String)element.getDelegate().getText()));
            } else if (element.isNumberLiteral()) {
                object.setDefault(JsonSchemaReader.getNumber(element));
            } else if (element.isBooleanLiteral()) {
                object.setDefault(JsonSchemaReader.getBoolean(element));
            }
        };
    }

    private static Object mapPrimitiveTypeOrEmptyObject(JsonValueAdapter element) {
        if (element.isObject()) {
            try {
                return jsonObjectMapper.readTree(element.getDelegate().getText());
            }
            catch (IOException exception) {
                return null;
            }
        }
        if (element.isStringLiteral()) {
            return StringUtil.unquoteString((String)element.getDelegate().getText());
        }
        if (element.isNumberLiteral()) {
            return JsonSchemaReader.getNumber(element);
        }
        if (element.isBooleanLiteral()) {
            return JsonSchemaReader.getBoolean(element);
        }
        return null;
    }

    static {
        JsonSchemaReader.fillMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 13, 18, 25, 26, 27, 30, 31, 33, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 13: 
            case 18: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaReader";
                break;
            }
            case 6: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaObject";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootAdapter";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaReader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readFromFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewPointer";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumber";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "notEmptyString";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "readInnerObject";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "readExample";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readFromFile";
                break;
            }
            case 3: 
            case 13: 
            case 18: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkIfValidJsonSchema";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "enqueue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrComputeSchemaObjectForSchemaFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readSingleDefinition";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNewPointer";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createContainer";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getNumber";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "readInnerObject";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "readExample";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 13, 18, 25, 26, 27, 30, 31, 33, 34 -> new IllegalStateException(string2);
        };
    }

    private static interface MyReader {
        public void read(@NotNull JsonValueAdapter var1, @NotNull JsonSchemaObjectImpl var2, @NotNull Collection<Pair<JsonSchemaObjectImpl, JsonValueAdapter>> var3, @NotNull VirtualFile var4);
    }
}

