/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.presentation;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.clones.structures.TextClone;
import com.jetbrains.clones.structures.TextFragment;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

class AggregateReport {
    private final SortedMap<Fragment, Duplicate> myMap;
    @NotNull
    private final PathMacroManager myMacroManager;

    AggregateReport(@NotNull Project project2) {
        if (project2 == null) {
            AggregateReport.$$$reportNull$$$0(0);
        }
        this.myMap = new TreeMap<Fragment, Duplicate>();
        this.myMacroManager = PathMacroManager.getInstance((ComponentManager)project2);
    }

    void add(@NotNull TextClone textClone) {
        if (textClone == null) {
            AggregateReport.$$$reportNull$$$0(1);
        }
        TreeSet<Fragment> newFragments = new TreeSet<Fragment>();
        newFragments.add(new Fragment(textClone.getMain(), this.myMacroManager));
        for (TextFragment textFragment : textClone.getDuplicates()) {
            newFragments.add(new Fragment(textFragment, this.myMacroManager));
        }
        ArrayList<Fragment> oldFragments = new ArrayList<Fragment>();
        for (Fragment fragment2 : newFragments) {
            Duplicate duplicate3 = (Duplicate)this.myMap.get(fragment2);
            if (duplicate3 == null) continue;
            oldFragments.addAll(duplicate3.myFragments);
        }
        newFragments.addAll(oldFragments);
        Duplicate duplicate = new Duplicate(newFragments);
        for (Fragment fragment3 : duplicate.myFragments) {
            this.myMap.put(fragment3, duplicate);
        }
    }

    void addContentTo(Consumer<? super Element> resultConsumer) {
        TreeSet<Duplicate> uniqueDuplicates = new TreeSet<Duplicate>(this.myMap.values());
        for (Duplicate duplicate : uniqueDuplicates) {
            resultConsumer.accept((Element)duplicate.createContent());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textClone";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/clones/presentation/AggregateReport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Fragment
    implements Comparable<Fragment> {
        @NotNull
        final String myCollapsedUrl;
        final int myLine;
        final int myStart;
        final int myEnd;

        Fragment(@NotNull TextFragment fragment2, @NotNull PathMacroManager macroManager) {
            if (fragment2 == null) {
                Fragment.$$$reportNull$$$0(0);
            }
            if (macroManager == null) {
                Fragment.$$$reportNull$$$0(1);
            }
            this.myCollapsedUrl = macroManager.collapsePath(fragment2.getFile().getUrl());
            this.myLine = Fragment.getStartLine(fragment2);
            this.myStart = fragment2.getRange().getStartOffset();
            this.myEnd = fragment2.getRange().getEndOffset();
        }

        private static int getStartLine(@NotNull TextFragment fragment2) {
            if (fragment2 == null) {
                Fragment.$$$reportNull$$$0(2);
            }
            try {
                return fragment2.getLines().getStart();
            }
            catch (Exception e) {
                return 0;
            }
        }

        @NotNull
        Element createContent() {
            Element element = new Element("fragment");
            element.setAttribute("file", this.myCollapsedUrl);
            element.setAttribute("line", String.valueOf(this.myLine));
            element.setAttribute("start", String.valueOf(this.myStart));
            element.setAttribute("end", String.valueOf(this.myEnd));
            Element element2 = element;
            if (element2 == null) {
                Fragment.$$$reportNull$$$0(3);
            }
            return element2;
        }

        @Override
        public int compareTo(@NotNull Fragment f) {
            int c;
            if (f == null) {
                Fragment.$$$reportNull$$$0(4);
            }
            if ((c = this.myCollapsedUrl.compareTo(f.myCollapsedUrl)) != 0) {
                return c;
            }
            c = Integer.compare(this.myStart, f.myStart);
            if (c != 0) {
                return c;
            }
            return Integer.compare(this.myEnd, f.myEnd);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Fragment)) {
                return false;
            }
            Fragment f = (Fragment)o;
            return this.myCollapsedUrl.equalsIgnoreCase(f.myCollapsedUrl) && this.myStart == f.myStart && this.myEnd == f.myEnd;
        }

        public int hashCode() {
            int result2 = this.myCollapsedUrl.hashCode();
            result2 = 31 * result2 + this.myStart;
            result2 = 31 * result2 + this.myEnd;
            return result2;
        }

        public String toString() {
            return this.myCollapsedUrl + ":" + this.myLine + " (" + this.myStart + "," + this.myEnd + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "macroManager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/clones/presentation/AggregateReport$Fragment";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "f";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/clones/presentation/AggregateReport$Fragment";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getStartLine";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }

    private static class Duplicate
    implements Comparable<Duplicate> {
        final List<Fragment> myFragments;
        @NotNull
        private final Fragment myFirstFragment;

        Duplicate(@NotNull SortedSet<Fragment> fragments) {
            if (fragments == null) {
                Duplicate.$$$reportNull$$$0(0);
            }
            if (fragments.isEmpty()) {
                throw new IllegalArgumentException("empty set of duplicates");
            }
            this.myFragments = new ArrayList<Fragment>(fragments);
            this.myFirstFragment = this.myFragments.get(0);
        }

        @NotNull
        Element createContent() {
            Element element = new Element("duplicate");
            element.setAttribute("cost", "1");
            element.setAttribute("hash", "0");
            for (Fragment fragment2 : this.myFragments) {
                element.addContent(fragment2.createContent());
            }
            Element element2 = element;
            if (element2 == null) {
                Duplicate.$$$reportNull$$$0(1);
            }
            return element2;
        }

        @Override
        public int compareTo(@NotNull Duplicate d) {
            if (d == null) {
                Duplicate.$$$reportNull$$$0(2);
            }
            return this.myFirstFragment.compareTo(d.myFirstFragment);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Duplicate && this.myFragments.equals(((Duplicate)o).myFragments);
        }

        public int hashCode() {
            return this.myFragments.hashCode();
        }

        public String toString() {
            return this.myFragments.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/clones/presentation/AggregateReport$Duplicate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "d";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/clones/presentation/AggregateReport$Duplicate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

