/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.languagescope.common;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.clones.configuration.DuplicatesBundle;
import com.jetbrains.clones.structures.TextClone;
import com.jetbrains.clones.toolwindow.DuplicateViewManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\f0\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u0011H\u0016J\u0012\u0010\u0012\u001a\f0\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/clones/languagescope/common/ShowDuplicatesLikeThisFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "textClone", "Lcom/jetbrains/clones/structures/TextClone;", "(Lcom/jetbrains/clones/structures/TextClone;)V", "version", "", "Ljava/lang/Long;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getName", "isValid", "", "startInWriteAction", "intellij.platform.duplicatesDetector"})
public final class ShowDuplicatesLikeThisFix
implements LocalQuickFix {
    @NotNull
    private final TextClone textClone;
    @Nullable
    private final Long version;

    public ShowDuplicatesLikeThisFix(@NotNull TextClone textClone) {
        Intrinsics.checkNotNullParameter((Object)textClone, (String)"textClone");
        this.textClone = textClone;
        Document document2 = FileDocumentManager.getInstance().getDocument(this.textClone.getMain().getFile());
        this.version = document2 != null ? Long.valueOf(document2.getModificationStamp()) : null;
    }

    private final boolean isValid() {
        Document document2 = FileDocumentManager.getInstance().getDocument(this.textClone.getMain().getFile());
        return Intrinsics.areEqual((Object)(document2 != null ? Long.valueOf(document2.getModificationStamp()) : null), (Object)this.version);
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.textClone.getDuplicates().size() + 1};
        String string2 = DuplicatesBundle.INSTANCE.getMessage("duplicate.inspection.fix.name", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMessage(...)");
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        String string2 = DuplicatesBundle.INSTANCE.getMessage("duplicate.inspection.fix.family", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMessage(...)");
        return string2;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.isValid()) {
            DuplicateViewManager.Companion.getInstance(project2).showClonesData(this.textClone);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

