/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.frame.VcsCommitExternalStatusProvider;
import com.intellij.vcs.log.ui.table.column.VcsLogColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnUtilKt;
import com.intellij.vcs.log.ui.table.column.VcsLogCustomColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumnKt;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleLogColumnsActionGroup
extends ActionGroup
implements DumbAware {
    public ToggleLogColumnsActionGroup() {
        super(VcsLogBundle.message("action.title.select.columns.to.see", new Object[0]), VcsLogBundle.message("action.description.select.columns.to.see", new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleLogColumnsActionGroup.$$$reportNull$$$0(0);
        }
        super.update(e);
        e.getPresentation().setPopupGroup(ToggleLogColumnsActionGroup.isPopup(e));
        e.getPresentation().setEnabledAndVisible(ToggleLogColumnsActionGroup.isEnabledAndVisible(e));
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        ArrayList<Object> actions2 = new ArrayList<Object>();
        if (e != null && !ToggleLogColumnsActionGroup.isPopup(e)) {
            actions2.add(Separator.create((String)VcsLogBundle.message("action.title.select.columns.to.see", new Object[0])));
        }
        ArrayList columns = new ArrayList();
        columns.addAll(VcsLogDefaultColumnKt.getDefaultDynamicColumns());
        columns.addAll(VcsLogCustomColumn.KEY.getExtensionList());
        columns.addAll(ContainerUtil.map(VcsCommitExternalStatusProvider.getExtensionsWithColumns(), ext -> ext.getLogColumn()));
        for (VcsLogColumn column : ContainerUtil.filter(columns, it -> it.isDynamic())) {
            actions2.add((Object)new ToggleColumnAction(column));
        }
        AnAction[] anActionArray = actions2.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            ToggleLogColumnsActionGroup.$$$reportNull$$$0(1);
        }
        return anActionArray;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ToggleLogColumnsActionGroup.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static boolean isPopup(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleLogColumnsActionGroup.$$$reportNull$$$0(3);
        }
        return e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI) == null;
    }

    private static boolean isEnabledAndVisible(@NotNull AnActionEvent e) {
        VcsLogUiProperties properties2;
        if (e == null) {
            ToggleLogColumnsActionGroup.$$$reportNull$$$0(4);
        }
        return (properties2 = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)) != null && VcsLogColumnUtilKt.supportsColumnsToggling(properties2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/actions/ToggleLogColumnsActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/actions/ToggleLogColumnsActionGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPopup";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledAndVisible";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }

    private static final class ToggleColumnAction
    extends ToggleAction
    implements DumbAware {
        private final VcsLogColumn<?> myColumn;

        private ToggleColumnAction(@NotNull VcsLogColumn<?> column) {
            if (column == null) {
                ToggleColumnAction.$$$reportNull$$$0(0);
            }
            super(() -> column.getLocalizedName());
            this.myColumn = column;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            VcsLogUiProperties properties2;
            if (e == null) {
                ToggleColumnAction.$$$reportNull$$$0(1);
            }
            if ((properties2 = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)) != null) {
                return VcsLogColumnUtilKt.isVisible(this.myColumn, properties2);
            }
            return false;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleColumnAction.$$$reportNull$$$0(2);
            }
            VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
            VcsLogUiProperties properties2 = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
            if (properties2 == null) {
                return;
            }
            assert (VcsLogColumnUtilKt.supportsColumnsToggling(properties2));
            if (state) {
                VcsLogColumnUtilKt.addColumn(properties2, this.myColumn);
            } else {
                VcsLogColumnUtilKt.removeColumn(properties2, this.myColumn);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleColumnAction.$$$reportNull$$$0(3);
            }
            super.update(e);
            e.getPresentation().setEnabledAndVisible(ToggleLogColumnsActionGroup.isEnabledAndVisible(e));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ToggleColumnAction.$$$reportNull$$$0(4);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/actions/ToggleLogColumnsActionGroup$ToggleColumnAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/actions/ToggleLogColumnsActionGroup$ToggleColumnAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 4 -> new IllegalStateException(string2);
            };
        }
    }
}

