/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.log.data.AbstractDataGetter;
import com.intellij.vcs.log.data.CommitDetailsGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexDiagnostic;
import com.intellij.vcs.log.data.index.IndexDiagnosticRunner;
import com.intellij.vcs.log.data.index.IndexDiagnosticRunnerKt;
import com.intellij.vcs.log.data.index.PhmVcsLogStorageBackend;
import com.intellij.vcs.log.data.index.VcsLogBigRepositoriesList;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.data.index.VcsLogStorageBackend;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001%BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\u00020 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0003J\u0006\u0010#\u001a\u00020 J\u0016\u0010$\u001a\u00020 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0015\u001a(\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u0014 \u0018*\u0012\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u00140\u0017\u00a2\u0006\u0002\b\u00140\u0016\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/vcs/log/data/index/IndexDiagnosticRunner;", "Lcom/intellij/openapi/Disposable;", "index", "Lcom/intellij/vcs/log/data/index/VcsLogModifiableIndex;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "dataPackGetter", "Lkotlin/Function0;", "Lcom/intellij/vcs/log/data/DataPack;", "commitDetailsGetter", "Lcom/intellij/vcs/log/data/CommitDetailsGetter;", "errorHandler", "Lcom/intellij/vcs/log/impl/VcsLogErrorHandler;", "parent", "(Lcom/intellij/vcs/log/data/index/VcsLogModifiableIndex;Lcom/intellij/vcs/log/data/VcsLogStorage;Ljava/util/Collection;Lkotlin/jvm/functions/Function0;Lcom/intellij/vcs/log/data/CommitDetailsGetter;Lcom/intellij/vcs/log/impl/VcsLogErrorHandler;Lcom/intellij/openapi/Disposable;)V", "bigRepositoriesList", "Lcom/intellij/vcs/log/data/index/VcsLogBigRepositoriesList;", "Lorg/jetbrains/annotations/NotNull;", "checkedRoots", "", "", "kotlin.jvm.PlatformType", "disposedFlag", "Lcom/intellij/openapi/util/CheckedDisposable;", "executor", "Ljava/util/concurrent/ExecutorService;", "indexingListener", "Lcom/intellij/vcs/log/data/index/VcsLogIndex$IndexingFinishedListener;", "dispose", "", "doRunDiagnostic", "rootsToCheck", "onDataPackChange", "runDiagnostic", "MyBigRepositoriesListListener", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nIndexDiagnosticRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexDiagnosticRunner.kt\ncom/intellij/vcs/log/data/index/IndexDiagnosticRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,127:1\n766#2:128\n857#2,2:129\n766#2:141\n857#2,2:142\n9#3:131\n9#3:132\n46#3,5:133\n9#3:138\n9#3:139\n9#3:140\n*S KotlinDebug\n*F\n+ 1 IndexDiagnosticRunner.kt\ncom/intellij/vcs/log/data/index/IndexDiagnosticRunner\n*L\n72#1:128\n72#1:129,2\n102#1:141\n102#1:142,2\n74#1:131\n80#1:132\n80#1:133,5\n85#1:138\n90#1:139\n94#1:140\n*E\n"})
public final class IndexDiagnosticRunner
implements Disposable {
    @NotNull
    private final VcsLogModifiableIndex index;
    @NotNull
    private final VcsLogStorage storage;
    @NotNull
    private final Collection<VirtualFile> roots;
    @NotNull
    private final Function0<DataPack> dataPackGetter;
    @NotNull
    private final CommitDetailsGetter commitDetailsGetter;
    @NotNull
    private final VcsLogErrorHandler errorHandler;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final VcsLogBigRepositoriesList bigRepositoriesList;
    @NotNull
    private final VcsLogIndex.IndexingFinishedListener indexingListener;
    @NotNull
    private final CheckedDisposable disposedFlag;
    @NotNull
    private final Set<VirtualFile> checkedRoots;

    public IndexDiagnosticRunner(@NotNull VcsLogModifiableIndex index, @NotNull VcsLogStorage storage, @NotNull Collection<? extends VirtualFile> roots, @NotNull Function0<? extends DataPack> dataPackGetter, @NotNull CommitDetailsGetter commitDetailsGetter, @NotNull VcsLogErrorHandler errorHandler2, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter(dataPackGetter, (String)"dataPackGetter");
        Intrinsics.checkNotNullParameter((Object)commitDetailsGetter, (String)"commitDetailsGetter");
        Intrinsics.checkNotNullParameter((Object)errorHandler2, (String)"errorHandler");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.index = index;
        this.storage = storage;
        this.roots = roots;
        this.dataPackGetter = dataPackGetter;
        this.commitDetailsGetter = commitDetailsGetter;
        this.errorHandler = errorHandler2;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Index Diagnostic Runner", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.executor = executorService;
        VcsLogBigRepositoriesList vcsLogBigRepositoriesList = VcsLogBigRepositoriesList.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogBigRepositoriesList, (String)"getInstance(...)");
        this.bigRepositoriesList = vcsLogBigRepositoriesList;
        this.indexingListener = arg_0 -> IndexDiagnosticRunner.indexingListener$lambda$0(this, arg_0);
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        this.disposedFlag = checkedDisposable;
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.checkedRoots = set;
        this.index.addListener(this.indexingListener);
        this.bigRepositoriesList.addListener(new MyBigRepositoriesListListener(), this);
        Disposer.register((Disposable)parent, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.disposedFlag));
    }

    private final void runDiagnostic(Collection<? extends VirtualFile> rootsToCheck) {
        if (this.disposedFlag.isDisposed()) {
            return;
        }
        BackgroundTaskUtil.BackgroundTask backgroundTask = BackgroundTaskUtil.submitTask((Executor)this.executor, (Disposable)this, () -> IndexDiagnosticRunner.runDiagnostic$lambda$1(this, rootsToCheck));
        Intrinsics.checkNotNullExpressionValue((Object)backgroundTask, (String)"submitTask(...)");
        BackgroundTaskUtil.BackgroundTask backgroundTask2 = backgroundTask;
        IndexDiagnosticRunnerKt.access$cancelAfter(backgroundTask2, 180L, (Function0)new Function0<Unit>(this, rootsToCheck){
            final /* synthetic */ IndexDiagnosticRunner this$0;
            final /* synthetic */ Collection<VirtualFile> $rootsToCheck;
            {
                this.this$0 = $receiver;
                this.$rootsToCheck = $rootsToCheck;
                super(0);
            }

            public final void invoke() {
                IndexDiagnosticRunner $this$thisLogger$iv = this.this$0;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(IndexDiagnosticRunner.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Index diagnostic for " + this.$rootsToCheck + " is cancelled by timeout");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    private final void doRunDiagnostic(Collection<? extends VirtualFile> rootsToCheck) {
        Object diffReport;
        void $this$filterTo$iv$iv;
        IndexDataGetter indexDataGetter = this.index.getDataGetter();
        if (indexDataGetter == null) {
            return;
        }
        IndexDataGetter dataGetter = indexDataGetter;
        DataPack dataPack = (DataPack)this.dataPackGetter.invoke();
        if (!dataPack.isFull()) {
            return;
        }
        List uncheckedRoots = CollectionsKt.minus((Iterable)rootsToCheck, (Iterable)this.checkedRoots);
        if (uncheckedRoots.isEmpty()) {
            return;
        }
        this.checkedRoots.addAll(uncheckedRoots);
        Set<Integer> oldCommits = IndexDiagnostic.INSTANCE.pickCommits(dataPack, this.storage, uncheckedRoots, true);
        Set<Integer> newCommits = IndexDiagnostic.INSTANCE.pickCommits(dataPack, this.storage, uncheckedRoots, false);
        Set<Integer> indexedCommits = IndexDiagnostic.INSTANCE.pickIndexedCommits(dataPack, dataGetter, uncheckedRoots);
        Iterable $this$filter$iv = SetsKt.plus(oldCommits, (Iterable)newCommits);
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(!indexedCommits.contains(it) && this.index.isIndexed(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List commits2 = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)indexedCommits);
        if (commits2.isEmpty()) {
            Attachment[] $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(IndexDiagnosticRunner.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Index diagnostic for " + uncheckedRoots + " is skipped as no commits were selected");
            return;
        }
        try {
            void $this$debug_u24default$iv;
            List commitDetails = AbstractDataGetter.Companion.getCommitDetails(this.commitDetailsGetter, commits2);
            Attachment[] $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(IndexDiagnosticRunner.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            $this$thisLogger$iv = logger;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                void var18_27 = $this$debug_u24default$iv;
                boolean bl = false;
                var18_27.debug("Running index diagnostic for commits [" + CollectionsKt.joinToString$default((Iterable)commitDetails, (CharSequence)" ", null, null, (int)0, null, (Function1)doRunDiagnostic.1.1.INSTANCE, (int)30, null) + "]", e$iv);
            }
            diffReport = IndexDiagnostic.INSTANCE.getDiffFor(dataGetter, commits2, commitDetails, false);
            if (!StringsKt.isBlank((CharSequence)((CharSequence)diffReport))) {
                RuntimeException exception = new RuntimeException("Index is corrupted");
                Attachment[] $this$thisLogger$iv2 = this;
                boolean $i$f$thisLogger2 = false;
                Logger logger2 = Logger.getInstance(IndexDiagnosticRunner.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                $this$thisLogger$iv2 = new Attachment[]{new Attachment("VcsLogIndexDiagnosticReport.txt", (String)diffReport)};
                logger2.error(exception.getMessage(), (Throwable)exception, $this$thisLogger$iv2);
                this.index.markCorrupted();
                this.errorHandler.handleError(VcsLogErrorHandler.Source.Index, exception);
            } else {
                Attachment[] $this$thisLogger$iv3 = this;
                boolean $i$f$thisLogger3 = false;
                Logger logger3 = Logger.getInstance(IndexDiagnosticRunner.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
                logger3.info("Index diagnostic for " + commits2.size() + " commits in " + uncheckedRoots + " is completed");
            }
            diffReport = dataGetter.getIndexStorageBackend();
        }
        catch (VcsException e) {
            VcsLogStorageBackend vcsLogStorageBackend;
            try {
                Attachment[] $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(IndexDiagnosticRunner.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error((Throwable)e);
                vcsLogStorageBackend = dataGetter.getIndexStorageBackend();
            }
            catch (Throwable throwable) {
                object = dataGetter.getIndexStorageBackend();
                PhmVcsLogStorageBackend phmVcsLogStorageBackend = object instanceof PhmVcsLogStorageBackend ? (PhmVcsLogStorageBackend)object : null;
                if (phmVcsLogStorageBackend != null) {
                    phmVcsLogStorageBackend.clearCaches$intellij_platform_vcs_log_impl();
                }
                throw throwable;
            }
            PhmVcsLogStorageBackend phmVcsLogStorageBackend = vcsLogStorageBackend instanceof PhmVcsLogStorageBackend ? (PhmVcsLogStorageBackend)vcsLogStorageBackend : null;
            if (phmVcsLogStorageBackend != null) {
                phmVcsLogStorageBackend.clearCaches$intellij_platform_vcs_log_impl();
            }
        }
        PhmVcsLogStorageBackend phmVcsLogStorageBackend = diffReport instanceof PhmVcsLogStorageBackend ? (PhmVcsLogStorageBackend)diffReport : null;
        if (phmVcsLogStorageBackend != null) {
            phmVcsLogStorageBackend.clearCaches$intellij_platform_vcs_log_impl();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void onDataPackChange() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = this.roots;
        IndexDiagnosticRunner indexDiagnosticRunner = this;
        boolean $i$f$filter = false;
        void var3_4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile root = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(this.index.isIndexed(root) || this.bigRepositoriesList.isBig(root))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        indexDiagnosticRunner.runDiagnostic((List)destination$iv$iv);
    }

    public void dispose() {
        this.index.removeListener(this.indexingListener);
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(10L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static final void indexingListener$lambda$0(IndexDiagnosticRunner this$0, VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this$0.runDiagnostic(CollectionsKt.listOf((Object)root));
    }

    private static final void runDiagnostic$lambda$1(IndexDiagnosticRunner this$0, Collection $rootsToCheck) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$rootsToCheck, (String)"$rootsToCheck");
        this$0.doRunDiagnostic($rootsToCheck);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/data/index/IndexDiagnosticRunner$MyBigRepositoriesListListener;", "Lcom/intellij/vcs/log/data/index/VcsLogBigRepositoriesList$Listener;", "(Lcom/intellij/vcs/log/data/index/IndexDiagnosticRunner;)V", "onRepositoryAdded", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.vcs.log.impl"})
    private final class MyBigRepositoriesListListener
    implements VcsLogBigRepositoriesList.Listener {
        @Override
        public void onRepositoryAdded(@NotNull VirtualFile root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            IndexDiagnosticRunner.this.runDiagnostic(CollectionsKt.listOf((Object)root));
        }
    }
}

