/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.console;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.ui.ConsoleViewPlace;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.vcs.console.VcsConsoleFolding;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/vcs/console/VcsConsoleView;", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getPlace", "Lcom/intellij/execution/ui/ConsoleViewPlace;", "updateFoldings", "", "startLine", "", "endLine", "Companion", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nVcsConsoleView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsConsoleView.kt\ncom/intellij/vcs/console/VcsConsoleView\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,57:1\n11#2:58\n*S KotlinDebug\n*F\n+ 1 VcsConsoleView.kt\ncom/intellij/vcs/console/VcsConsoleView\n*L\n14#1:58\n*E\n"})
public final class VcsConsoleView
extends ConsoleViewImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @JvmField
    @NotNull
    public static final ConsoleViewPlace CONSOLE_PLACE;

    public VcsConsoleView(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2, true);
    }

    @NotNull
    public ConsoleViewPlace getPlace() {
        return CONSOLE_PLACE;
    }

    protected void updateFoldings(int startLine, int endLine) {
        super.updateFoldings(startLine, endLine);
        this.getEditor().getFoldingModel().runBatchFoldingOperation(() -> VcsConsoleView.updateFoldings$lambda$0(this, startLine, endLine));
    }

    private static final void updateFoldings$lambda$0(VcsConsoleView this$0, int $startLine, int $endLine) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Document document2 = this$0.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document document3 = document2;
        int line = $startLine;
        if (line <= $endLine) {
            while (true) {
                int oStart = document3.getLineStartOffset(line);
                int oEnd = document3.getLineEndOffset(line);
                Intrinsics.checkNotNullExpressionValue((Object)EditorHyperlinkSupport.getLineText((Document)document3, (int)line, (boolean)false), (String)"getLineText(...)");
                for (VcsConsoleFolding provider2 : (VcsConsoleFolding[])VcsConsoleFolding.Companion.getEP_NAME().getExtensions()) {
                    String lineText;
                    Project project2 = this$0.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                    for (VcsConsoleFolding.Placeholder folding : provider2.getFoldingsForLine(project2, lineText)) {
                        FoldRegion region;
                        TextRange foldingRange;
                        Intrinsics.checkNotNullExpressionValue((Object)folding.getTextRange().shiftRight(oStart), (String)"shiftRight(...)");
                        if (foldingRange.getEndOffset() > oEnd) {
                            LOG.error("Folding exceeds line length: " + folding + ", provider: " + provider2);
                            continue;
                        }
                        FoldRegion foldRegion = region = this$0.getEditor().getFoldingModel().addFoldRegion(foldingRange.getStartOffset(), foldingRange.getEndOffset(), folding.getPlaceholder());
                        if (foldRegion == null) continue;
                        foldRegion.setExpanded(false);
                    }
                }
                if (line == $endLine) break;
                ++line;
            }
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VcsConsoleView.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        CONSOLE_PLACE = new ConsoleViewPlace("VCS Console");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/console/VcsConsoleView$Companion;", "", "()V", "CONSOLE_PLACE", "Lcom/intellij/execution/ui/ConsoleViewPlace;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

