/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class GenericValueUtil {
    public static NullableFunction<GenericValue, String> STRING_VALUE = genericValue -> genericValue.getStringValue();
    public static NullableFunction<GenericValue, Object> OBJECT_VALUE = genericValue -> genericValue.getValue();

    private GenericValueUtil() {
    }

    public static boolean containsString(Collection<? extends GenericValue<?>> collection, String value2) {
        for (GenericValue<?> o : collection) {
            if (!Objects.equals(value2, o.getStringValue())) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsValue(Collection<? extends GenericValue<? extends T>> collection, T value2) {
        for (GenericValue<T> o : collection) {
            if (!Comparing.equal(value2, o.getValue())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static <T> Collection<T> getValueCollection(Collection<? extends GenericValue<? extends T>> collection, Collection<T> result2) {
        for (GenericValue<T> o : collection) {
            ContainerUtil.addIfNotNull(result2, o.getValue());
        }
        Collection<T> collection2 = result2;
        if (collection2 == null) {
            GenericValueUtil.$$$reportNull$$$0(0);
        }
        return collection2;
    }

    @NotNull
    public static Collection<String> getStringCollection(Collection<? extends GenericValue> collection, Collection<String> result2) {
        for (GenericValue genericValue : collection) {
            ContainerUtil.addIfNotNull(result2, (Object)genericValue.getStringValue());
        }
        Collection<String> collection2 = result2;
        if (collection2 == null) {
            GenericValueUtil.$$$reportNull$$$0(1);
        }
        return collection2;
    }

    @NotNull
    public static Collection<String> getClassStringCollection(Collection<? extends GenericValue> collection, Collection<String> result2) {
        for (GenericValue genericValue : collection) {
            String value2 = genericValue.getStringValue();
            if (value2 == null) continue;
            result2.add(value2.replace('$', '.'));
        }
        Collection<String> collection2 = result2;
        if (collection2 == null) {
            GenericValueUtil.$$$reportNull$$$0(2);
        }
        return collection2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/xml/GenericValueUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueCollection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringCollection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassStringCollection";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

