/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.WordSplitter;
import com.intellij.util.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextSplitter
extends BaseSplitter {
    private static final TextSplitter INSTANCE = new TextSplitter();
    private static final String letter = "(\\p{L}\\p{Mn}*)";
    private static final String xmlEntity = "(&.+?;)";
    private static final Pattern EXTENDED_WORD_AND_SPECIAL = Pattern.compile("(&.+?;)|(#|0x\\d*)?(\\p{L}\\p{Mn}*)++('(\\p{L}\\p{Mn}*))?(_|(\\p{L}\\p{Mn}*))*+");

    public static TextSplitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void split(@Nullable String text2, @NotNull TextRange range, Consumer<TextRange> consumer) {
        if (range == null) {
            TextSplitter.$$$reportNull$$$0(0);
        }
        if (text2 == null || StringUtil.isEmpty((String)text2)) {
            return;
        }
        this.doSplit(text2, range, consumer);
    }

    protected void doSplit(@NotNull String text2, @NotNull TextRange range, Consumer<TextRange> consumer) {
        if (text2 == null) {
            TextSplitter.$$$reportNull$$$0(1);
        }
        if (range == null) {
            TextSplitter.$$$reportNull$$$0(2);
        }
        WordSplitter ws = WordSplitter.getInstance();
        try {
            Matcher matcher = this.getExtendedWordAndSpecial().matcher(TextSplitter.newBombedCharSequence(text2));
            matcher.region(range.getStartOffset(), range.getEndOffset());
            while (matcher.find()) {
                TextRange found = new TextRange(matcher.start(), matcher.end());
                ws.split(text2, found, consumer);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    @Contract(pure=true)
    @NotNull
    protected Pattern getExtendedWordAndSpecial() {
        Pattern pattern2 = EXTENDED_WORD_AND_SPECIAL;
        if (pattern2 == null) {
            TextSplitter.$$$reportNull$$$0(3);
        }
        return pattern2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/inspections/TextSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/inspections/TextSplitter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedWordAndSpecial";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doSplit";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }
}

