/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.impl.session;

import com.intellij.platform.ml.TierInstance;
import com.intellij.platform.ml.impl.session.DescribedTierData;
import com.intellij.platform.ml.impl.session.Level;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bw\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u00020\u0004:\t\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015J3\u0010\b\u001a\u0002H\t\"\u0004\b\u0003\u0010\t2\u001e\u0010\n\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u0002H\t0\u000bH&\u00a2\u0006\u0002\u0010\fR\u0012\u0010\u0005\u001a\u00028\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0005\u0016\u0017\u0018\u0019\u001a\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/ml/impl/session/SessionTree;", "RootT", "LevelT", "PredictionT", "", "level", "getLevel", "()Ljava/lang/Object;", "accept", "T", "visitor", "Lcom/intellij/platform/ml/impl/session/SessionTree$Visitor;", "(Lcom/intellij/platform/ml/impl/session/SessionTree$Visitor;)Ljava/lang/Object;", "Branching", "ChildrenContainer", "ComplexRoot", "Leaf", "LevelVisitor", "PredictionContainer", "RootContainer", "SolitaryLeaf", "Visitor", "Lcom/intellij/platform/ml/impl/session/SessionTree$Branching;", "Lcom/intellij/platform/ml/impl/session/SessionTree$ChildrenContainer;", "Lcom/intellij/platform/ml/impl/session/SessionTree$Leaf;", "Lcom/intellij/platform/ml/impl/session/SessionTree$PredictionContainer;", "Lcom/intellij/platform/ml/impl/session/SessionTree$RootContainer;", "intellij.platform.ml.impl"})
@ApiStatus.Internal
public interface SessionTree<RootT, LevelT, PredictionT> {
    public LevelT getLevel();

    public <T> T accept(@NotNull Visitor<RootT, LevelT, PredictionT, ? extends T> var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005B-\u0012\u0006\u0010\u0006\u001a\u00028\u0004\u0012\u001e\u0010\u0007\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00040\b\u00a2\u0006\u0002\u0010\tJ3\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0006\u0010\u00102\u001e\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u0002H\u00100\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00028\u0004H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ!\u0010\u0015\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00040\bH\u00c6\u0003JL\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00002\b\b\u0002\u0010\u0006\u001a\u00028\u00042 \b\u0002\u0010\u0007\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00040\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R,\u0010\u0007\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0006\u001a\u00028\u0004X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lcom/intellij/platform/ml/impl/session/SessionTree$Branching;", "RootT", "LevelT", "PredictionT", "Lcom/intellij/platform/ml/impl/session/SessionTree;", "Lcom/intellij/platform/ml/impl/session/SessionTree$ChildrenContainer;", "level", "children", "", "(Ljava/lang/Object;Ljava/util/List;)V", "getChildren", "()Ljava/util/List;", "getLevel", "()Ljava/lang/Object;", "Ljava/lang/Object;", "accept", "T", "visitor", "Lcom/intellij/platform/ml/impl/session/SessionTree$Visitor;", "(Lcom/intellij/platform/ml/impl/session/SessionTree$Visitor;)Ljava/lang/Object;", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/util/List;)Lcom/intellij/platform/ml/impl/session/SessionTree$Branching;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.ml.impl"})
    public static final class Branching<RootT, LevelT, PredictionT>
    implements SessionTree<RootT, LevelT, PredictionT>,
    ChildrenContainer<RootT, LevelT, PredictionT> {
        private final LevelT level;
        @NotNull
        private final List<SessionTree<RootT, LevelT, PredictionT>> children;

        public Branching(LevelT level, @NotNull List<? extends SessionTree<RootT, LevelT, PredictionT>> children) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.level = level;
            this.children = children;
        }

        @Override
        public LevelT getLevel() {
            return this.level;
        }

        @Override
        @NotNull
        public List<SessionTree<RootT, LevelT, PredictionT>> getChildren() {
            return this.children;
        }

        @Override
        public <T> T accept(@NotNull Visitor<RootT, LevelT, PredictionT, ? extends T> visitor2) {
            Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
            return visitor2.acceptBranching(this);
        }

        public final LevelT component1() {
            return this.level;
        }

        @NotNull
        public final List<SessionTree<RootT, LevelT, PredictionT>> component2() {
            return this.children;
        }

        @NotNull
        public final Branching<RootT, LevelT, PredictionT> copy(LevelT level, @NotNull List<? extends SessionTree<RootT, LevelT, PredictionT>> children) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            return new Branching<RootT, LevelT, PredictionT>(level, children);
        }

        public static /* synthetic */ Branching copy$default(Branching branching, Object object, List list2, int n, Object object2) {
            if ((n & 1) != 0) {
                object = branching.level;
            }
            if ((n & 2) != 0) {
                list2 = branching.children;
            }
            return branching.copy(object, list2);
        }

        @NotNull
        public String toString() {
            return "Branching(level=" + this.level + ", children=" + this.children + ")";
        }

        public int hashCode() {
            int result2 = this.level == null ? 0 : this.level.hashCode();
            result2 = result2 * 31 + ((Object)this.children).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Branching)) {
                return false;
            }
            Branching branching = (Branching)other;
            if (!Intrinsics.areEqual(this.level, branching.level)) {
                return false;
            }
            return Intrinsics.areEqual(this.children, branching.children);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004R*\u0010\u0005\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00040\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0002\t\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/ml/impl/session/SessionTree$ChildrenContainer;", "RootT", "LevelT", "PredictionT", "Lcom/intellij/platform/ml/impl/session/SessionTree;", "children", "", "getChildren", "()Ljava/util/List;", "Lcom/intellij/platform/ml/impl/session/SessionTree$Branching;", "Lcom/intellij/platform/ml/impl/session/SessionTree$ComplexRoot;", "intellij.platform.ml.impl"})
    public static interface ChildrenContainer<RootT, LevelT, PredictionT>
    extends SessionTree<RootT, LevelT, PredictionT> {
        @NotNull
        public List<SessionTree<RootT, LevelT, PredictionT>> getChildren();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005B5\u0012\u0006\u0010\u0006\u001a\u00028\u0003\u0012\u0006\u0010\u0007\u001a\u00028\u0004\u0012\u001e\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\n0\t\u00a2\u0006\u0002\u0010\u000bJ3\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0006\u0010\u00132\u001e\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u0002H\u00130\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00028\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0018\u001a\u00028\u0004H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ!\u0010\u0019\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\n0\tH\u00c6\u0003JV\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00002\b\b\u0002\u0010\u0006\u001a\u00028\u00032\b\b\u0002\u0010\u0007\u001a\u00028\u00042 \b\u0002\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\n0\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R,\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0007\u001a\u00028\u0004X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0006\u001a\u00028\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/intellij/platform/ml/impl/session/SessionTree$ComplexRoot;", "RootT", "LevelT", "PredictionT", "Lcom/intellij/platform/ml/impl/session/SessionTree$RootContainer;", "Lcom/intellij/platform/ml/impl/session/SessionTree$ChildrenContainer;", "root", "level", "children", "", "Lcom/intellij/platform/ml/impl/session/SessionTree;", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/List;)V", "getChildren", "()Ljava/util/List;", "getLevel", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getRoot", "accept", "T", "visitor", "Lcom/intellij/platform/ml/impl/session/SessionTree$Visitor;", "(Lcom/intellij/platform/ml/impl/session/SessionTree$Visitor;)Ljava/lang/Object;", "component1", "component2", "component3", "copy", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/List;)Lcom/intellij/platform/ml/impl/session/SessionTree$ComplexRoot;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.ml.impl"})
    public static final class ComplexRoot<RootT, LevelT, PredictionT>
    implements RootContainer<RootT, LevelT, PredictionT>,
    ChildrenContainer<RootT, LevelT, PredictionT> {
        private final RootT root;
        private final LevelT level;
        @NotNull
        private final List<SessionTree<RootT, LevelT, PredictionT>> children;

        public ComplexRoot(RootT root, LevelT level, @NotNull List<? extends SessionTree<RootT, LevelT, PredictionT>> children) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.root = root;
            this.level = level;
            this.children = children;
        }

        @Override
        public RootT getRoot() {
            return this.root;
        }

        @Override
        public LevelT getLevel() {
            return this.level;
        }

        @Override
        @NotNull
        public List<SessionTree<RootT, LevelT, PredictionT>> getChildren() {
            return this.children;
        }

        @Override
        public <T> T accept(@NotNull Visitor<RootT, LevelT, PredictionT, ? extends T> visitor2) {
            Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
            return visitor2.acceptRoot(this);
        }

        public final RootT component1() {
            return this.root;
        }

        public final LevelT component2() {
            return this.level;
        }

        @NotNull
        public final List<SessionTree<RootT, LevelT, PredictionT>> component3() {
            return this.children;
        }

        @NotNull
        public final ComplexRoot<RootT, LevelT, PredictionT> copy(RootT root, LevelT level, @NotNull List<? extends SessionTree<RootT, LevelT, PredictionT>> children) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            return new ComplexRoot<RootT, LevelT, PredictionT>(root, level, children);
        }

        public static /* synthetic */ ComplexRoot copy$default(ComplexRoot complexRoot, Object object, Object object2, List list2, int n, Object object3) {
            if ((n & 1) != 0) {
                object = complexRoot.root;
            }
            if ((n & 2) != 0) {
                object2 = complexRoot.level;
            }
            if ((n & 4) != 0) {
                list2 = complexRoot.children;
            }
            return complexRoot.copy(object, object2, list2);
        }

        @NotNull
        public String toString() {
            return "ComplexRoot(root=" + this.root + ", level=" + this.level + ", children=" + this.children + ")";
        }

        public int hashCode() {
            int result2 = this.root == null ? 0 : this.root.hashCode();
            result2 = result2 * 31 + (this.level == null ? 0 : this.level.hashCode());
            result2 = result2 * 31 + ((Object)this.children).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComplexRoot)) {
                return false;
            }
            ComplexRoot complexRoot = (ComplexRoot)other;
            if (!Intrinsics.areEqual(this.root, complexRoot.root)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.level, complexRoot.level)) {
                return false;
            }
            return Intrinsics.areEqual(this.children, complexRoot.children);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005B\u0017\u0012\u0006\u0010\u0006\u001a\u00028\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00018\u0005\u00a2\u0006\u0002\u0010\bJ3\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0006\u0010\u000e2\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u0002H\u000e0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00028\u0004H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\u0004\u0018\u00018\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ6\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00002\b\b\u0002\u0010\u0006\u001a\u00028\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00018\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0016\u0010\u0006\u001a\u00028\u0004X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0018\u0010\u0007\u001a\u0004\u0018\u00018\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/ml/impl/session/SessionTree$Leaf;", "RootT", "LevelT", "PredictionT", "Lcom/intellij/platform/ml/impl/session/SessionTree;", "Lcom/intellij/platform/ml/impl/session/SessionTree$PredictionContainer;", "level", "prediction", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getLevel", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getPrediction", "accept", "T", "visitor", "Lcom/intellij/platform/ml/impl/session/SessionTree$Visitor;", "(Lcom/intellij/platform/ml/impl/session/SessionTree$Visitor;)Ljava/lang/Object;", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/intellij/platform/ml/impl/session/SessionTree$Leaf;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.ml.impl"})
    public static final class Leaf<RootT, LevelT, PredictionT>
    implements SessionTree<RootT, LevelT, PredictionT>,
    PredictionContainer<RootT, LevelT, PredictionT> {
        private final LevelT level;
        @Nullable
        private final PredictionT prediction;

        public Leaf(LevelT level, @Nullable PredictionT prediction) {
            this.level = level;
            this.prediction = prediction;
        }

        @Override
        public LevelT getLevel() {
            return this.level;
        }

        @Override
        @Nullable
        public PredictionT getPrediction() {
            return this.prediction;
        }

        @Override
        public <T> T accept(@NotNull Visitor<RootT, LevelT, PredictionT, ? extends T> visitor2) {
            Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
            return visitor2.acceptLeaf(this);
        }

        public final LevelT component1() {
            return this.level;
        }

        @Nullable
        public final PredictionT component2() {
            return this.prediction;
        }

        @NotNull
        public final Leaf<RootT, LevelT, PredictionT> copy(LevelT level, @Nullable PredictionT prediction) {
            return new Leaf<RootT, LevelT, PredictionT>(level, prediction);
        }

        public static /* synthetic */ Leaf copy$default(Leaf leaf, Object object, Object object2, int n, Object object3) {
            if ((n & 1) != 0) {
                object = leaf.level;
            }
            if ((n & 2) != 0) {
                object2 = leaf.prediction;
            }
            return leaf.copy(object, object2);
        }

        @NotNull
        public String toString() {
            return "Leaf(level=" + this.level + ", prediction=" + this.prediction + ")";
        }

        public int hashCode() {
            int result2 = this.level == null ? 0 : this.level.hashCode();
            result2 = result2 * 31 + (this.prediction == null ? 0 : this.prediction.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Leaf)) {
                return false;
            }
            Leaf leaf = (Leaf)other;
            if (!Intrinsics.areEqual(this.level, leaf.level)) {
                return false;
            }
            return Intrinsics.areEqual(this.prediction, leaf.prediction);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0003\u0010\u0001*\b\b\u0004\u0010\u0002*\u00020\u00032^\u0012\u0004\u0012\u0002H\u0001\u0012H\u0012F\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t0\u0005j\u0002`\n\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u000b0\u0004:\u0001#B\u000f\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB\u0017\b\u0002\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010Jd\u0010\u0011\u001a\u00020\u000b2\\\u0010\u0012\u001aX\u0012\u0004\u0012\u00028\u0003\u0012H\u0012F\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t0\u0005j\u0002`\n\u0012\u0004\u0012\u00028\u00040\u0013Jd\u0010\u0014\u001a\u00020\u000b2\\\u0010\u0015\u001aX\u0012\u0004\u0012\u00028\u0003\u0012H\u0012F\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t0\u0005j\u0002`\n\u0012\u0004\u0012\u00028\u00040\u0016Jd\u0010\u0017\u001a\u00020\u000b2\\\u0010\u0018\u001aX\u0012\u0004\u0012\u00028\u0003\u0012H\u0012F\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t0\u0005j\u0002`\n\u0012\u0004\u0012\u00028\u00040\u0019Jd\u0010\u001a\u001a\u00020\u000b2\\\u0010\u001b\u001aX\u0012\u0004\u0012\u00028\u0003\u0012H\u0012F\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t0\u0005j\u0002`\n\u0012\u0004\u0012\u00028\u00040\u001cJ\u00b2\u0001\u0010\u001d\u001a\u00020\u001e2J\u0010\u001f\u001aF\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t0\u0005j\u0002`\n2\\\u0010 \u001aX\u0012\u0004\u0012\u00028\u0003\u0012H\u0012F\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t0\u0005j\u0002`\n\u0012\u0004\u0012\u00028\u00040!H\u0002J\u00b2\u0001\u0010\"\u001a\u00020\u000b2J\u0010\u001f\u001aF\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t0\u0005j\u0002`\n2\\\u0010 \u001aX\u0012\u0004\u0012\u00028\u0003\u0012H\u0012F\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006j\b\u0012\u0004\u0012\u00020\b`\t0\u0005j\u0002`\n\u0012\u0004\u0012\u00028\u00040!H&R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/platform/ml/impl/session/SessionTree$LevelVisitor;", "RootT", "PredictionT", "", "Lcom/intellij/platform/ml/impl/session/SessionTree$Visitor;", "Lcom/intellij/platform/ml/impl/session/Level;", "", "Lcom/intellij/platform/ml/TierInstance;", "Lcom/intellij/platform/ml/impl/session/DescribedTierData;", "Lcom/intellij/platform/ml/PerTierInstance;", "Lcom/intellij/platform/ml/impl/session/DescribedLevel;", "", "levelIndex", "", "(I)V", "thisVisitorLevel", "(II)V", "acceptBranching", "branching", "Lcom/intellij/platform/ml/impl/session/SessionTree$Branching;", "acceptLeaf", "leaf", "Lcom/intellij/platform/ml/impl/session/SessionTree$Leaf;", "acceptRoot", "root", "Lcom/intellij/platform/ml/impl/session/SessionTree$ComplexRoot;", "acceptSolitaryLeaf", "solitaryLeaf", "Lcom/intellij/platform/ml/impl/session/SessionTree$SolitaryLeaf;", "maybeVisitLevel", "", "level", "levelRoot", "Lcom/intellij/platform/ml/impl/session/SessionTree;", "visitLevel", "DeeperLevelVisitor", "intellij.platform.ml.impl"})
    public static abstract class LevelVisitor<RootT, PredictionT>
    implements Visitor<RootT, Level<Map<TierInstance<?>, ? extends DescribedTierData>, Map<TierInstance<?>, ? extends DescribedTierData>>, PredictionT, Unit> {
        private final int levelIndex;
        private final int thisVisitorLevel;

        private LevelVisitor(int levelIndex, int thisVisitorLevel) {
            this.levelIndex = levelIndex;
            this.thisVisitorLevel = thisVisitorLevel;
        }

        public LevelVisitor(int levelIndex) {
            this(levelIndex, 0);
        }

        private final boolean maybeVisitLevel(Level<Map<TierInstance<?>, DescribedTierData>, Map<TierInstance<?>, DescribedTierData>> level, SessionTree<RootT, Level<Map<TierInstance<?>, DescribedTierData>, Map<TierInstance<?>, DescribedTierData>>, PredictionT> levelRoot) {
            boolean bl;
            if (this.levelIndex == this.thisVisitorLevel) {
                this.visitLevel(level, levelRoot);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public final void acceptBranching(@NotNull Branching<RootT, Level<Map<TierInstance<?>, DescribedTierData>, Map<TierInstance<?>, DescribedTierData>>, PredictionT> branching) {
            Intrinsics.checkNotNullParameter(branching, (String)"branching");
            if (this.maybeVisitLevel(branching.getLevel(), (SessionTree)branching)) {
                return;
            }
            for (SessionTree<RootT, Level<Map<TierInstance<?>, DescribedTierData>, Map<TierInstance<?>, DescribedTierData>>, PredictionT> child : branching.getChildren()) {
                child.accept(new DeeperLevelVisitor());
            }
        }

        @Override
        public final void acceptLeaf(@NotNull Leaf<RootT, Level<Map<TierInstance<?>, DescribedTierData>, Map<TierInstance<?>, DescribedTierData>>, PredictionT> leaf) {
            Intrinsics.checkNotNullParameter(leaf, (String)"leaf");
            if (!this.maybeVisitLevel(leaf.getLevel(), (SessionTree)leaf)) {
                boolean bl = false;
                String string2 = "The deepest level in the session tree is " + this.thisVisitorLevel + ", given level " + this.levelIndex + " does not exist";
                throw new IllegalArgumentException(string2.toString());
            }
        }

        @Override
        public final void acceptRoot(@NotNull ComplexRoot<RootT, Level<Map<TierInstance<?>, DescribedTierData>, Map<TierInstance<?>, DescribedTierData>>, PredictionT> root) {
            Intrinsics.checkNotNullParameter(root, (String)"root");
            if (this.maybeVisitLevel(root.getLevel(), (SessionTree)root)) {
                return;
            }
            for (SessionTree<RootT, Level<Map<TierInstance<?>, DescribedTierData>, Map<TierInstance<?>, DescribedTierData>>, PredictionT> child : root.getChildren()) {
                child.accept(new DeeperLevelVisitor());
            }
        }

        @Override
        public final void acceptSolitaryLeaf(@NotNull SolitaryLeaf<RootT, Level<Map<TierInstance<?>, DescribedTierData>, Map<TierInstance<?>, DescribedTierData>>, PredictionT> solitaryLeaf) {
            Intrinsics.checkNotNullParameter(solitaryLeaf, (String)"solitaryLeaf");
            if (!this.maybeVisitLevel(solitaryLeaf.getLevel(), (SessionTree)solitaryLeaf)) {
                boolean bl = false;
                String string2 = "The only level in the session tree is " + this.thisVisitorLevel + ", given level " + this.levelIndex + " does not exist";
                throw new IllegalArgumentException(string2.toString());
            }
        }

        public abstract void visitLevel(@NotNull Level<Map<TierInstance<?>, DescribedTierData>, Map<TierInstance<?>, DescribedTierData>> var1, @NotNull SessionTree<RootT, Level<Map<TierInstance<?>, DescribedTierData>, Map<TierInstance<?>, DescribedTierData>>, PredictionT> var2);

        public /* synthetic */ LevelVisitor(int levelIndex, int thisVisitorLevel, DefaultConstructorMarker $constructor_marker) {
            this(levelIndex, thisVisitorLevel);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u00b2\u0001\u0010\u0003\u001a\u00020\u00042J\u0010\u0005\u001aF\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0007j\b\u0012\u0004\u0012\u00020\t`\n\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0007j\b\u0012\u0004\u0012\u00020\t`\n0\u0006j\u0002`\u000b2\\\u0010\f\u001aX\u0012\u0004\u0012\u00028\u0003\u0012H\u0012F\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0007j\b\u0012\u0004\u0012\u00020\t`\n\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0007j\b\u0012\u0004\u0012\u00020\t`\n0\u0006j\u0002`\u000b\u0012\u0004\u0012\u00028\u00040\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/ml/impl/session/SessionTree$LevelVisitor$DeeperLevelVisitor;", "Lcom/intellij/platform/ml/impl/session/SessionTree$LevelVisitor;", "(Lcom/intellij/platform/ml/impl/session/SessionTree$LevelVisitor;)V", "visitLevel", "", "level", "Lcom/intellij/platform/ml/impl/session/Level;", "", "Lcom/intellij/platform/ml/TierInstance;", "Lcom/intellij/platform/ml/impl/session/DescribedTierData;", "Lcom/intellij/platform/ml/PerTierInstance;", "Lcom/intellij/platform/ml/impl/session/DescribedLevel;", "levelRoot", "Lcom/intellij/platform/ml/impl/session/SessionTree;", "intellij.platform.ml.impl"})
        private final class DeeperLevelVisitor
        extends LevelVisitor<RootT, PredictionT> {
            public DeeperLevelVisitor() {
                super(LevelVisitor.this.levelIndex, LevelVisitor.this.thisVisitorLevel + 1, null);
            }

            @Override
            public void visitLevel(@NotNull Level<Map<TierInstance<?>, DescribedTierData>, Map<TierInstance<?>, DescribedTierData>> level, @NotNull SessionTree<RootT, Level<Map<TierInstance<?>, DescribedTierData>, Map<TierInstance<?>, DescribedTierData>>, PredictionT> levelRoot) {
                Intrinsics.checkNotNullParameter(level, (String)"level");
                Intrinsics.checkNotNullParameter(levelRoot, (String)"levelRoot");
                LevelVisitor.this.visitLevel(level, levelRoot);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004R\u0014\u0010\u0005\u001a\u0004\u0018\u00018\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/ml/impl/session/SessionTree$PredictionContainer;", "RootT", "LevelT", "PredictionT", "Lcom/intellij/platform/ml/impl/session/SessionTree;", "prediction", "getPrediction", "()Ljava/lang/Object;", "Lcom/intellij/platform/ml/impl/session/SessionTree$Leaf;", "Lcom/intellij/platform/ml/impl/session/SessionTree$SolitaryLeaf;", "intellij.platform.ml.impl"})
    public static interface PredictionContainer<RootT, LevelT, PredictionT>
    extends SessionTree<RootT, LevelT, PredictionT> {
        @Nullable
        public PredictionT getPrediction();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004R\u0012\u0010\u0005\u001a\u00028\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/ml/impl/session/SessionTree$RootContainer;", "RootT", "LevelT", "PredictionT", "Lcom/intellij/platform/ml/impl/session/SessionTree;", "root", "getRoot", "()Ljava/lang/Object;", "Lcom/intellij/platform/ml/impl/session/SessionTree$ComplexRoot;", "Lcom/intellij/platform/ml/impl/session/SessionTree$SolitaryLeaf;", "intellij.platform.ml.impl"})
    public static interface RootContainer<RootT, LevelT, PredictionT>
    extends SessionTree<RootT, LevelT, PredictionT> {
        public RootT getRoot();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005B\u001f\u0012\u0006\u0010\u0006\u001a\u00028\u0003\u0012\u0006\u0010\u0007\u001a\u00028\u0004\u0012\b\u0010\b\u001a\u0004\u0018\u00018\u0005\u00a2\u0006\u0002\u0010\tJ3\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0006\u0010\u00102\u001e\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u0002H\u00100\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00028\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0015\u001a\u00028\u0004H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0016\u001a\u0004\u0018\u00018\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ@\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00002\b\b\u0002\u0010\u0006\u001a\u00028\u00032\b\b\u0002\u0010\u0007\u001a\u00028\u00042\n\b\u0002\u0010\b\u001a\u0004\u0018\u00018\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0016\u0010\u0007\u001a\u00028\u0004X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\b\u001a\u0004\u0018\u00018\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\r\u0010\u000bR\u0016\u0010\u0006\u001a\u00028\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/intellij/platform/ml/impl/session/SessionTree$SolitaryLeaf;", "RootT", "LevelT", "PredictionT", "Lcom/intellij/platform/ml/impl/session/SessionTree$RootContainer;", "Lcom/intellij/platform/ml/impl/session/SessionTree$PredictionContainer;", "root", "level", "prediction", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "getLevel", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getPrediction", "getRoot", "accept", "T", "visitor", "Lcom/intellij/platform/ml/impl/session/SessionTree$Visitor;", "(Lcom/intellij/platform/ml/impl/session/SessionTree$Visitor;)Ljava/lang/Object;", "component1", "component2", "component3", "copy", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Lcom/intellij/platform/ml/impl/session/SessionTree$SolitaryLeaf;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.ml.impl"})
    public static final class SolitaryLeaf<RootT, LevelT, PredictionT>
    implements RootContainer<RootT, LevelT, PredictionT>,
    PredictionContainer<RootT, LevelT, PredictionT> {
        private final RootT root;
        private final LevelT level;
        @Nullable
        private final PredictionT prediction;

        public SolitaryLeaf(RootT root, LevelT level, @Nullable PredictionT prediction) {
            this.root = root;
            this.level = level;
            this.prediction = prediction;
        }

        @Override
        public RootT getRoot() {
            return this.root;
        }

        @Override
        public LevelT getLevel() {
            return this.level;
        }

        @Override
        @Nullable
        public PredictionT getPrediction() {
            return this.prediction;
        }

        @Override
        public <T> T accept(@NotNull Visitor<RootT, LevelT, PredictionT, ? extends T> visitor2) {
            Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
            return visitor2.acceptSolitaryLeaf(this);
        }

        public final RootT component1() {
            return this.root;
        }

        public final LevelT component2() {
            return this.level;
        }

        @Nullable
        public final PredictionT component3() {
            return this.prediction;
        }

        @NotNull
        public final SolitaryLeaf<RootT, LevelT, PredictionT> copy(RootT root, LevelT level, @Nullable PredictionT prediction) {
            return new SolitaryLeaf<RootT, LevelT, PredictionT>(root, level, prediction);
        }

        public static /* synthetic */ SolitaryLeaf copy$default(SolitaryLeaf solitaryLeaf, Object object, Object object2, Object object3, int n, Object object4) {
            if ((n & 1) != 0) {
                object = solitaryLeaf.root;
            }
            if ((n & 2) != 0) {
                object2 = solitaryLeaf.level;
            }
            if ((n & 4) != 0) {
                object3 = solitaryLeaf.prediction;
            }
            return solitaryLeaf.copy(object, object2, object3);
        }

        @NotNull
        public String toString() {
            return "SolitaryLeaf(root=" + this.root + ", level=" + this.level + ", prediction=" + this.prediction + ")";
        }

        public int hashCode() {
            int result2 = this.root == null ? 0 : this.root.hashCode();
            result2 = result2 * 31 + (this.level == null ? 0 : this.level.hashCode());
            result2 = result2 * 31 + (this.prediction == null ? 0 : this.prediction.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SolitaryLeaf)) {
                return false;
            }
            SolitaryLeaf solitaryLeaf = (SolitaryLeaf)other;
            if (!Intrinsics.areEqual(this.root, solitaryLeaf.root)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.level, solitaryLeaf.level)) {
                return false;
            }
            return Intrinsics.areEqual(this.prediction, solitaryLeaf.prediction);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0003\u0010\u0001*\u0004\b\u0004\u0010\u0002*\u0004\b\u0005\u0010\u0003*\u0006\b\u0006\u0010\u0004 \u00012\u00020\u0005J'\u0010\u0006\u001a\u00028\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\bH&\u00a2\u0006\u0002\u0010\tJ'\u0010\n\u001a\u00028\u00062\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\fH&\u00a2\u0006\u0002\u0010\rJ'\u0010\u000e\u001a\u00028\u00062\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0010H&\u00a2\u0006\u0002\u0010\u0011J'\u0010\u0012\u001a\u00028\u00062\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0014H&\u00a2\u0006\u0002\u0010\u0015\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/ml/impl/session/SessionTree$Visitor;", "RootT", "LevelT", "PredictionT", "T", "", "acceptBranching", "branching", "Lcom/intellij/platform/ml/impl/session/SessionTree$Branching;", "(Lcom/intellij/platform/ml/impl/session/SessionTree$Branching;)Ljava/lang/Object;", "acceptLeaf", "leaf", "Lcom/intellij/platform/ml/impl/session/SessionTree$Leaf;", "(Lcom/intellij/platform/ml/impl/session/SessionTree$Leaf;)Ljava/lang/Object;", "acceptRoot", "root", "Lcom/intellij/platform/ml/impl/session/SessionTree$ComplexRoot;", "(Lcom/intellij/platform/ml/impl/session/SessionTree$ComplexRoot;)Ljava/lang/Object;", "acceptSolitaryLeaf", "solitaryLeaf", "Lcom/intellij/platform/ml/impl/session/SessionTree$SolitaryLeaf;", "(Lcom/intellij/platform/ml/impl/session/SessionTree$SolitaryLeaf;)Ljava/lang/Object;", "intellij.platform.ml.impl"})
    public static interface Visitor<RootT, LevelT, PredictionT, T> {
        public T acceptBranching(@NotNull Branching<RootT, LevelT, PredictionT> var1);

        public T acceptLeaf(@NotNull Leaf<RootT, LevelT, PredictionT> var1);

        public T acceptRoot(@NotNull ComplexRoot<RootT, LevelT, PredictionT> var1);

        public T acceptSolitaryLeaf(@NotNull SolitaryLeaf<RootT, LevelT, PredictionT> var1);
    }
}

