/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.operations;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.revertion.DifferenceReverter;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.history.integration.revertion.SelectionReverter;
import com.intellij.history.integration.ui.models.SelectionCalculator;
import com.intellij.openapi.project.Project;
import com.intellij.platform.lvcs.impl.ActivityScope;
import com.intellij.platform.lvcs.impl.ChangeSetActivityItem;
import com.intellij.platform.lvcs.impl.ChangeSetSelection;
import com.intellij.platform.lvcs.impl.ChangeSetSelectionKt;
import com.intellij.platform.lvcs.impl.LocalHistoryActivityDataKt;
import com.intellij.platform.lvcs.impl.RevisionId;
import com.intellij.platform.lvcs.impl.diff.DiffUtilsKt;
import com.intellij.util.text.DateFormatUtil;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a!\u0010\u0000\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a6\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\u0012"}, d2={"getRevertCommandName", "", "Lorg/jetbrains/annotations/Nls;", "item", "Lcom/intellij/platform/lvcs/impl/ChangeSetActivityItem;", "isOldContentUsed", "", "createReverter", "Lcom/intellij/history/integration/revertion/Reverter;", "Lcom/intellij/history/core/LocalHistoryFacade;", "project", "Lcom/intellij/openapi/project/Project;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "scope", "Lcom/intellij/platform/lvcs/impl/ActivityScope;", "selection", "Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;", "intellij.platform.lvcs.impl"})
public final class RevertKt {
    @Nullable
    public static final Reverter createReverter(@NotNull LocalHistoryFacade $this$createReverter, @NotNull Project project2, @NotNull IdeaGateway gateway, @NotNull ActivityScope scope2, @NotNull ChangeSetSelection selection, boolean isOldContentUsed) {
        Intrinsics.checkNotNullParameter((Object)$this$createReverter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        RevisionId targetRevisionId = ChangeSetSelectionKt.getLeftRevision(selection);
        if (Intrinsics.areEqual((Object)targetRevisionId, (Object)RevisionId.Current.INSTANCE)) {
            return null;
        }
        Supplier<String> commandNameSupplier = () -> RevertKt.createReverter$lambda$0(selection, isOldContentUsed);
        if (scope2 instanceof ActivityScope.Selection) {
            SelectionCalculator calculator = LocalHistoryActivityDataKt.getSelectionCalculator(selection.getData(), $this$createReverter, gateway, (ActivityScope.Selection)scope2, isOldContentUsed);
            return new SelectionReverter(project2, $this$createReverter, gateway, calculator, targetRevisionId, DiffUtilsKt.getEntryPath(gateway, scope2), ((ActivityScope.Selection)scope2).getFrom(), ((ActivityScope.Selection)scope2).getTo(), commandNameSupplier);
        }
        RootEntry rootEntry = LocalHistoryActivityDataKt.getRootEntry(selection.getData(), gateway);
        String entryPath = DiffUtilsKt.getEntryPath(gateway, scope2);
        List<Difference> diff = DiffUtilsKt.getDiff($this$createReverter, rootEntry, selection, entryPath, isOldContentUsed);
        return new DifferenceReverter(project2, $this$createReverter, gateway, diff, commandNameSupplier);
    }

    private static final String getRevertCommandName(ChangeSetActivityItem item2, boolean isOldContentUsed) {
        if (item2 == null) {
            return LocalHistoryBundle.message("system.label.revert", new Object[0]);
        }
        String name = item2.getName();
        String string2 = DateFormatUtil.formatDateTime((long)item2.getTimestamp());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatDateTime(...)");
        String date = string2;
        if (isOldContentUsed) {
            if (name != null) {
                Object[] objectArray = new Object[]{name, date};
                return LocalHistoryBundle.message("system.label.revert.change.date", objectArray);
            }
            Object[] objectArray = new Object[]{date};
            return LocalHistoryBundle.message("system.label.revert.date", objectArray);
        }
        if (name != null) {
            Object[] objectArray = new Object[]{name, date};
            return LocalHistoryBundle.message("system.label.revert.to.change.date", objectArray);
        }
        Object[] objectArray = new Object[]{date};
        return LocalHistoryBundle.message("system.label.revert.to.date", objectArray);
    }

    private static final String createReverter$lambda$0(ChangeSetSelection $selection, boolean $isOldContentUsed) {
        Intrinsics.checkNotNullParameter((Object)$selection, (String)"$selection");
        return RevertKt.getRevertCommandName($selection.getLeftItem(), $isOldContentUsed);
    }
}

