/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class BackgroundableActionLock {
    @NotNull
    private final Project myProject;
    private final Object @NotNull [] myKeys;

    BackgroundableActionLock(@NotNull Project project2, Object @NotNull [] keys) {
        if (project2 == null) {
            BackgroundableActionLock.$$$reportNull$$$0(0);
        }
        if (keys == null) {
            BackgroundableActionLock.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myKeys = keys;
    }

    public boolean isLocked() {
        return BackgroundableActionLock.isLocked(this.myProject, this.myKeys);
    }

    @RequiresEdt
    public void lock() {
        ThreadingAssertions.assertEventDispatchThread();
        BackgroundableActionLock.lock(this.myProject, this.myKeys);
    }

    @RequiresEdt
    public void unlock() {
        ThreadingAssertions.assertEventDispatchThread();
        BackgroundableActionLock.unlock(this.myProject, this.myKeys);
    }

    @NotNull
    public static BackgroundableActionLock getLock(@NotNull Project project2, Object ... keys) {
        if (project2 == null) {
            BackgroundableActionLock.$$$reportNull$$$0(2);
        }
        if (keys == null) {
            BackgroundableActionLock.$$$reportNull$$$0(3);
        }
        return new BackgroundableActionLock(project2, keys);
    }

    public static boolean isLocked(@NotNull Project project2, Object ... keys) {
        if (project2 == null) {
            BackgroundableActionLock.$$$reportNull$$$0(4);
        }
        if (keys == null) {
            BackgroundableActionLock.$$$reportNull$$$0(5);
        }
        return BackgroundableActionLock.getManager(project2).isBackgroundTaskRunning(keys);
    }

    @RequiresEdt
    public static void lock(@NotNull Project project2, Object ... keys) {
        if (project2 == null) {
            BackgroundableActionLock.$$$reportNull$$$0(6);
        }
        if (keys == null) {
            BackgroundableActionLock.$$$reportNull$$$0(7);
        }
        ThreadingAssertions.assertEventDispatchThread();
        BackgroundableActionLock.getManager(project2).startBackgroundTask(keys);
    }

    @RequiresEdt
    public static void unlock(@NotNull Project project2, Object ... keys) {
        if (project2 == null) {
            BackgroundableActionLock.$$$reportNull$$$0(8);
        }
        if (keys == null) {
            BackgroundableActionLock.$$$reportNull$$$0(9);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (project2.isDisposed()) {
            return;
        }
        BackgroundableActionLock.getManager(project2).stopBackgroundTask(keys);
    }

    @NotNull
    private static ProjectLevelVcsManagerImpl getManager(@NotNull Project project2) {
        if (project2 == null) {
            BackgroundableActionLock.$$$reportNull$$$0(10);
        }
        ProjectLevelVcsManagerImpl projectLevelVcsManagerImpl = ProjectLevelVcsManagerImpl.getInstanceImpl(project2);
        if (projectLevelVcsManagerImpl == null) {
            BackgroundableActionLock.$$$reportNull$$$0(11);
        }
        return projectLevelVcsManagerImpl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackgroundableActionLock lock = (BackgroundableActionLock)o;
        return this.myProject.equals(lock.myProject) && Arrays.equals(this.myKeys, lock.myKeys);
    }

    public int hashCode() {
        int result2 = Objects.hash(this.myProject);
        result2 = 31 * result2 + Arrays.hashCode(this.myKeys);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/BackgroundableActionLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/BackgroundableActionLock";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLock";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isLocked";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lock";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "unlock";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getManager";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 11 -> new IllegalStateException(string2);
        };
    }
}

