/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CommitCheck;
import com.intellij.openapi.vcs.checkin.CommitInfo;
import com.intellij.openapi.vcs.checkin.CommitProblem;
import com.intellij.openapi.vcs.checkin.MergeConflictsCommitProblem;
import com.intellij.openapi.vcs.checkin.UnresolvedMergeCheckFactoryKt;
import com.intellij.openapi.vcs.checkin.UnresolvedMergeCheckProvider;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/checkin/UnresolvedMergeCheckHandler;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "Lcom/intellij/openapi/vcs/checkin/CommitCheck;", "Lcom/intellij/openapi/project/DumbAware;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "(Lcom/intellij/openapi/vcs/CheckinProjectPanel;Lcom/intellij/openapi/vcs/changes/CommitContext;)V", "createProblemFor", "Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "providerResult", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "getExecutionOrder", "Lcom/intellij/openapi/vcs/checkin/CommitCheck$ExecutionOrder;", "isEnabled", "", "runCheck", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "(Lcom/intellij/openapi/vcs/checkin/CommitInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nUnresolvedMergeCheckFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnresolvedMergeCheckFactory.kt\ncom/intellij/openapi/vcs/checkin/UnresolvedMergeCheckHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1747#2,3:66\n*S KotlinDebug\n*F\n+ 1 UnresolvedMergeCheckFactory.kt\ncom/intellij/openapi/vcs/checkin/UnresolvedMergeCheckHandler\n*L\n39#1:66,3\n*E\n"})
final class UnresolvedMergeCheckHandler
extends CheckinHandler
implements CommitCheck,
DumbAware {
    @NotNull
    private final CheckinProjectPanel panel;
    @NotNull
    private final CommitContext commitContext;

    public UnresolvedMergeCheckHandler(@NotNull CheckinProjectPanel panel2, @NotNull CommitContext commitContext) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)((Object)commitContext), (String)"commitContext");
        this.panel = panel2;
        this.commitContext = commitContext;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    @NotNull
    public CommitCheck.ExecutionOrder getExecutionOrder() {
        return CommitCheck.ExecutionOrder.EARLY;
    }

    @Override
    @Nullable
    public Object runCheck(@NotNull CommitInfo commitInfo, @NotNull Continuation<? super CommitProblem> $completion) {
        boolean hasUnresolvedConflicts;
        block5: {
            CheckinHandler.ReturnResult providerResult2;
            CheckinHandler.ReturnResult returnResult = providerResult2 = (CheckinHandler.ReturnResult)((Object)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])UnresolvedMergeCheckProvider.EP_NAME.getExtensions()), (Function1)((Function1)new Function1<UnresolvedMergeCheckProvider, CheckinHandler.ReturnResult>(this, commitInfo){
                final /* synthetic */ UnresolvedMergeCheckHandler this$0;
                final /* synthetic */ CommitInfo $commitInfo;
                {
                    this.this$0 = $receiver;
                    this.$commitInfo = $commitInfo;
                    super(1);
                }

                @Nullable
                public final CheckinHandler.ReturnResult invoke(UnresolvedMergeCheckProvider it) {
                    return it.checkUnresolvedConflicts(UnresolvedMergeCheckHandler.access$getPanel$p(this.this$0), UnresolvedMergeCheckHandler.access$getCommitContext$p(this.this$0), this.$commitInfo);
                }
            }))));
            if (returnResult != null) {
                return this.createProblemFor(returnResult);
            }
            Iterable $this$any$iv = commitInfo.getCommittedChanges();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Change it = (Change)element$iv;
                    boolean bl = false;
                    if (!UnresolvedMergeCheckFactoryKt.access$getMERGE_STATUSES$p().contains(it.getFileStatus())) continue;
                    v1 = true;
                    break block5;
                }
                v1 = hasUnresolvedConflicts = false;
            }
        }
        if (!hasUnresolvedConflicts) {
            return null;
        }
        int answer = Messages.showYesNoDialog((Component)this.panel.getComponent(), (String)VcsBundle.message("checkin.unresolved.merge.are.you.sure.you.want.to.commit.changes.with.unresolved.conflicts", new Object[0]), (String)VcsBundle.message("checkin.unresolved.merge.unresolved.conflicts", new Object[0]), (Icon)Messages.getWarningIcon());
        CheckinHandler.ReturnResult result2 = answer != 0 ? CheckinHandler.ReturnResult.CANCEL : CheckinHandler.ReturnResult.COMMIT;
        return this.createProblemFor(result2);
    }

    private final CommitProblem createProblemFor(CheckinHandler.ReturnResult providerResult2) {
        if (providerResult2 == CheckinHandler.ReturnResult.COMMIT) {
            return null;
        }
        return new MergeConflictsCommitProblem(providerResult2);
    }

    public static final /* synthetic */ CheckinProjectPanel access$getPanel$p(UnresolvedMergeCheckHandler $this) {
        return $this.panel;
    }

    public static final /* synthetic */ CommitContext access$getCommitContext$p(UnresolvedMergeCheckHandler $this) {
        return $this.commitContext;
    }
}

