/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserModuleNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsImplUtil;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0014\u0015B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0014R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ModuleChangesGroupingPolicy;", "Lcom/intellij/openapi/vcs/changes/ui/SimpleChangesGroupingPolicy;", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/tree/DefaultTreeModel;)V", "myIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createGroupRootNode", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "value", "getGroupRootValueFor", "nodePath", "Lcom/intellij/openapi/vcs/changes/ui/StaticFilePath;", "node", "Companion", "Factory", "intellij.platform.vcs.impl"})
public final class ModuleChangesGroupingPolicy
extends SimpleChangesGroupingPolicy<Module> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ProjectFileIndex myIndex;
    private static final boolean HIDE_EXCLUDED_FILES = Registry.is((String)"ide.hide.excluded.files");

    public ModuleChangesGroupingPolicy(@NotNull Project project2, @NotNull DefaultTreeModel model2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        super(model2);
        this.project = project2;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        this.myIndex = projectFileIndex;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    protected Module getGroupRootValueFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode<?> node) {
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        VirtualFile virtualFile = VcsImplUtil.findValidParentAccurately(nodePath.getFilePath());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        Module module = this.myIndex.getModuleForFile(file, HIDE_EXCLUDED_FILES);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        if (ModuleType.isInternal((Module)module2)) {
            return null;
        }
        return module2;
    }

    @Override
    @Nullable
    protected ChangesBrowserNode<?> createGroupRootNode(@NotNull Module value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        ChangesBrowserModuleNode changesBrowserModuleNode = ChangesBrowserModuleNode.create(value2);
        if (changesBrowserModuleNode == null) {
            return null;
        }
        ChangesBrowserModuleNode moduleNode = changesBrowserModuleNode;
        moduleNode.markAsHelperNode();
        return moduleNode;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ModuleChangesGroupingPolicy$Companion;", "", "()V", "HIDE_EXCLUDED_FILES", "", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ModuleChangesGroupingPolicy$Factory;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "()V", "createGroupingPolicy", "Lcom/intellij/openapi/vcs/changes/ui/ModuleChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "intellij.platform.vcs.impl"})
    public static final class Factory
    extends ChangesGroupingPolicyFactory {
        @Override
        @NotNull
        public ModuleChangesGroupingPolicy createGroupingPolicy(@NotNull Project project2, @NotNull DefaultTreeModel model2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            return new ModuleChangesGroupingPolicy(project2, model2);
        }
    }
}

