/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.google.common.collect.Lists;
import com.intellij.concurrency.JobScheduler;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.history.ActivityId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.NonLazySchemeProcessor;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsScopeKt;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchFileType;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManagerListener;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vcs.changes.ui.RollbackWorker;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vcs.telemetry.VcsTelemetrySpan;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceUtil;
import com.intellij.project.ProjectKt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.vcs.VcsActivity;
import com.intellij.vcsUtil.FilesProgress;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import io.opentelemetry.api.trace.Tracer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@Service(value={Service.Level.PROJECT})
@com.intellij.openapi.components.State(name="ShelveChangesManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class ShelveChangesManager
implements PersistentStateComponent<Element> {
    public static final String DEFAULT_PROJECT_PRESENTATION_PATH = "<Project>/shelf";
    @Topic.ProjectLevel
    public static final Topic<ShelveChangesManagerListener> SHELF_TOPIC = new Topic("shelf updates", ShelveChangesManagerListener.class);
    private static final Logger LOG = Logger.getInstance(ShelveChangesManager.class);
    @NonNls
    private static final String ELEMENT_CHANGELIST = "changelist";
    @NonNls
    private static final String ELEMENT_RECYCLED_CHANGELIST = "recycled_changelist";
    @NonNls
    private static final String DEFAULT_PATCH_NAME = "shelved";
    private static final String SHELVE_MANAGER_DIR_PATH = "shelf";
    private static final Element EMPTY_ELEMENT = new Element("state");
    @NotNull
    private final PathMacroManager myPathMacroSubstitutor;
    private final ReadWriteLock SHELVED_FILES_LOCK;
    private final Tracer myTracer;
    private final Project myProject;
    private State myState;
    @NotNull
    private SchemeManager<ShelvedChangeList> schemeManager;
    private ScheduledFuture<?> myCleaningFuture;
    @Nullable
    private Set<VirtualFile> myShelvingFiles;

    public ShelveChangesManager(@NotNull Project project2) {
        if (project2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(0);
        }
        this.SHELVED_FILES_LOCK = new ReentrantReadWriteLock(true);
        this.myTracer = TelemetryManager.getInstance().getTracer(VcsScopeKt.VcsScope);
        this.myState = new State();
        this.myPathMacroSubstitutor = PathMacroManager.getInstance((ComponentManager)project2);
        this.myProject = project2;
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance(project2);
        this.schemeManager = this.createShelveSchemeManager(project2, vcsConfiguration.USE_CUSTOM_SHELF_PATH ? vcsConfiguration.CUSTOM_SHELF_PATH : null);
        this.myCleaningFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.cleanDeletedOlderOneWeek(), 1L, 1L, TimeUnit.DAYS);
        Disposer.register((Disposable)project2, (Disposable)new Disposable(){

            public void dispose() {
                ShelveChangesManager.this.stopCleanScheduler();
            }
        });
    }

    @NotNull
    public Element getState() {
        Element element = (Element)ObjectUtils.chooseNotNull((Object)XmlSerializer.serialize((Object)this.myState), (Object)EMPTY_ELEMENT);
        if (element == null) {
            ShelveChangesManager.$$$reportNull$$$0(1);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ShelveChangesManager.$$$reportNull$$$0(2);
        }
        this.myState = (State)XmlSerializer.deserialize((Element)state, State.class);
        try {
            this.migrateOldShelfInfo(state, false);
            this.migrateOldShelfInfo(state, true);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void stopCleanScheduler() {
        if (this.myCleaningFuture != null) {
            this.myCleaningFuture.cancel(false);
            this.myCleaningFuture = null;
        }
    }

    @NotNull
    private SchemeManager<ShelvedChangeList> createShelveSchemeManager(@NotNull Project project2, @Nullable String customPath) {
        if (project2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(3);
        }
        FilePath customShelfFilePath = customPath != null ? VcsUtil.getFilePath(this.myPathMacroSubstitutor.expandPath(customPath)) : null;
        final boolean shouldCollapsePath = !VcsConfiguration.getInstance((Project)this.myProject).USE_CUSTOM_SHELF_PATH;
        SchemeManager schemeManager = SchemeManagerFactory.getInstance((Project)project2).create(customShelfFilePath != null ? customShelfFilePath.getName() : SHELVE_MANAGER_DIR_PATH, (SchemeProcessor)new NonLazySchemeProcessor<ShelvedChangeList, ShelvedChangeList>(){

            @NotNull
            public ShelvedChangeList readScheme(@NotNull Element element, boolean duringLoad) throws InvalidDataException {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                ShelvedChangeList shelvedChangeList = ShelveChangesManager.this.readOneShelvedChangeList(element);
                if (shelvedChangeList == null) {
                    2.$$$reportNull$$$0(1);
                }
                return shelvedChangeList;
            }

            @NotNull
            public Parent writeScheme(@NotNull ShelvedChangeList scheme) throws WriteExternalException {
                if (scheme == null) {
                    2.$$$reportNull$$$0(2);
                }
                Element child = new Element(ShelveChangesManager.ELEMENT_CHANGELIST);
                scheme.writeExternal(child);
                if (shouldCollapsePath) {
                    ShelveChangesManager.this.myPathMacroSubstitutor.collapsePaths(child);
                }
                Element element = child;
                if (element == null) {
                    2.$$$reportNull$$$0(3);
                }
                return element;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "readScheme";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "writeScheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "readScheme";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "writeScheme";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1, 3 -> new IllegalStateException(string2);
                };
            }
        }, null, customPath != null ? Paths.get(customPath, new String[0]) : null);
        if (schemeManager == null) {
            ShelveChangesManager.$$$reportNull$$$0(4);
        }
        return schemeManager;
    }

    void projectOpened() {
        try {
            this.schemeManager.loadSchemes();
            this.filterNonValidShelvedChangeLists();
            this.markDeletedSystemUnshelved();
            this.cleanDeletedOlderOneWeek();
            this.notifyStateChanged();
        }
        catch (Exception e) {
            LOG.error("Couldn't read shelf information", (Throwable)e);
        }
    }

    private void filterNonValidShelvedChangeLists() {
        ArrayList allSchemes = new ArrayList(this.schemeManager.getAllSchemes());
        int size = allSchemes.size();
        for (int i = 0; i < size; ++i) {
            ShelvedChangeList t = (ShelvedChangeList)allSchemes.get(i);
            if (t.isValid()) continue;
            this.schemeManager.removeScheme((Object)t);
        }
    }

    public void checkAndMigrateUnderProgress(final @NotNull File fromFile, final @NotNull File toFile, final boolean wasCustom) {
        if (fromFile == null) {
            ShelveChangesManager.$$$reportNull$$$0(5);
        }
        if (toFile == null) {
            ShelveChangesManager.$$$reportNull$$$0(6);
        }
        final SchemeManager<ShelvedChangeList> newSchemeManager = this.createShelveSchemeManager(this.myProject, VcsUtil.getFilePath(toFile).getPath());
        newSchemeManager.loadSchemes();
        if (VcsConfiguration.getInstance((Project)this.myProject).MOVE_SHELVES && fromFile.exists()) {
            new Task.Modal(this.myProject, VcsBundle.message("shelve.copying.shelves.to.progress", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    for (ShelvedChangeList list2 : ShelveChangesManager.this.schemeManager.getAllSchemes()) {
                        if (!list2.isValid()) continue;
                        try {
                            Path newTargetDirectory = ShelveChangesManager.suggestPatchName(this.myProject, list2.DESCRIPTION, toFile, "").toPath();
                            ShelvedChangeList migratedList = ShelveChangesManager.this.createChangelistCopyWithChanges(list2, newTargetDirectory);
                            newSchemeManager.addScheme((Object)migratedList, false);
                            indicator.checkCanceled();
                        }
                        catch (IOException e) {
                            LOG.error("Can't copy patch file: " + list2.path);
                        }
                    }
                    ShelveChangesManager.this.clearShelvedLists(ShelveChangesManager.this.schemeManager.getAllSchemes(), false);
                }

                public void onSuccess() {
                    super.onSuccess();
                    ShelveChangesManager.this.updateShelveSchemaManager((SchemeManager<ShelvedChangeList>)newSchemeManager);
                }

                public void onCancel() {
                    super.onCancel();
                    this.suggestToCancelMigrationOrRevertPathToPrevious();
                }

                private void suggestToCancelMigrationOrRevertPathToPrevious() {
                    if (Messages.showOkCancelDialog((Project)this.myProject, (String)VcsBundle.message("shelve.moving.failed.prompt", new Object[0]), (String)VcsBundle.message("shelve.error.title", new Object[0]), (String)VcsBundle.message("shelve.use.new.directory.button", new Object[0]), (String)VcsBundle.message("shelve.revert.moving.button", new Object[0]), (Icon)UIUtil.getWarningIcon()) == 0) {
                        ShelveChangesManager.this.updateShelveSchemaManager((SchemeManager<ShelvedChangeList>)newSchemeManager);
                    } else {
                        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance(this.myProject);
                        vcsConfiguration.USE_CUSTOM_SHELF_PATH = wasCustom;
                        if (wasCustom) {
                            vcsConfiguration.CUSTOM_SHELF_PATH = FileUtil.toSystemIndependentName((String)fromFile.getPath());
                        }
                    }
                }

                public void onThrowable(@NotNull Throwable error) {
                    if (error == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    super.onThrowable(error);
                    this.suggestToCancelMigrationOrRevertPathToPrevious();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "error";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onThrowable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.queue();
        } else {
            this.updateShelveSchemaManager(newSchemeManager);
        }
    }

    private void updateShelveSchemaManager(SchemeManager<ShelvedChangeList> newSchemeManager) {
        this.myProject.save();
        ApplicationManager.getApplication().saveSettings();
        SchemeManagerFactory.getInstance((Project)this.myProject).dispose(this.schemeManager);
        this.schemeManager = newSchemeManager;
        this.notifyStateChanged();
    }

    @NotNull
    public File getShelfResourcesDirectory() {
        File file = this.schemeManager.getRootDirectory();
        if (file == null) {
            ShelveChangesManager.$$$reportNull$$$0(7);
        }
        return file;
    }

    @NotNull
    private ShelvedChangeList readOneShelvedChangeList(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ShelveChangesManager.$$$reportNull$$$0(8);
        }
        ShelvedChangeList data2 = new ShelvedChangeList();
        this.myPathMacroSubstitutor.expandPaths(element);
        data2.readExternal(element);
        ShelvedChangeList shelvedChangeList = data2;
        if (shelvedChangeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(9);
        }
        return shelvedChangeList;
    }

    private void migrateOldShelfInfo(@NotNull Element element, boolean recycled) throws InvalidDataException, IOException {
        Element changeSetElement;
        ShelvedChangeList list2;
        if (element == null) {
            ShelveChangesManager.$$$reportNull$$$0(10);
        }
        Iterator iterator = element.getChildren(recycled ? ELEMENT_RECYCLED_CHANGELIST : ELEMENT_CHANGELIST).iterator();
        while (iterator.hasNext() && (list2 = this.readOneShelvedChangeList(changeSetElement = (Element)iterator.next())).isValid()) {
            Path uniqueDir = this.generateUniqueSchemePatchDir(list2.DESCRIPTION, false);
            list2.setName(uniqueDir.getFileName().toString());
            list2.setRecycled(recycled);
            this.schemeManager.addScheme((Object)list2, false);
        }
    }

    @NotNull
    public @Unmodifiable List<ShelvedChangeList> getShelvedChangeLists() {
        return this.getRecycled(false);
    }

    private @Unmodifiable @NotNull List<ShelvedChangeList> getRecycled(boolean recycled) {
        List collection = this.schemeManager.getAllSchemes();
        if (collection.isEmpty()) {
            List<ShelvedChangeList> list2 = Collections.emptyList();
            if (list2 == null) {
                ShelveChangesManager.$$$reportNull$$$0(11);
            }
            return list2;
        }
        ArrayList<ShelvedChangeList> result2 = new ArrayList<ShelvedChangeList>();
        for (ShelvedChangeList t : collection) {
            if (recycled != t.isRecycled() || t.isDeleted()) continue;
            result2.add(t);
        }
        List<ShelvedChangeList> list3 = List.copyOf(result2);
        if (list3 == null) {
            ShelveChangesManager.$$$reportNull$$$0(12);
        }
        return list3;
    }

    @NotNull
    public @Unmodifiable List<ShelvedChangeList> getAllLists() {
        List<ShelvedChangeList> list2 = List.copyOf(this.schemeManager.getAllSchemes());
        if (list2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(13);
        }
        return list2;
    }

    public ShelvedChangeList shelveChanges(Collection<? extends Change> changes2, String commitMessage, boolean rollback) throws IOException, VcsException {
        return this.shelveChanges(changes2, commitMessage, rollback, false);
    }

    public ShelvedChangeList shelveChanges(Collection<? extends Change> changes2, String commitMessage, boolean rollback, boolean markToBeDeleted) throws IOException, VcsException {
        return this.shelveChanges(changes2, commitMessage, rollback, markToBeDeleted, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelvedChangeList shelveChanges(Collection<? extends Change> changes2, String commitMessage, boolean rollback, boolean markToBeDeleted, boolean honorExcludedFromCommit) throws IOException, VcsException {
        ShelvedChangeList shelveList;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText(VcsBundle.message("shelve.changes.progress.text", new Object[0]));
        }
        try {
            this.SHELVED_FILES_LOCK.writeLock().lock();
            this.rememberShelvingFiles(changes2);
            shelveList = this.createShelfFromChanges(changes2, commitMessage, markToBeDeleted, honorExcludedFromCommit);
        }
        finally {
            this.cleanShelvingFiles();
            this.SHELVED_FILES_LOCK.writeLock().unlock();
            this.notifyStateChanged();
        }
        if (rollback) {
            this.rollbackChangesAfterShelve(changes2, honorExcludedFromCommit);
        }
        return shelveList;
    }

    @NotNull
    private ShelvedChangeList createShelfFromChanges(@NotNull Collection<? extends Change> changes2, String commitMessage, boolean markToBeDeleted, boolean honorExcludedFromCommit) throws VcsException, IOException {
        ShelvedChangeList shelvedChangeList;
        if (changes2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(14);
        }
        if (changes2.isEmpty()) {
            LOG.warn("Creating an empty shelved list", new Throwable());
        }
        LOG.debug("Shelving of " + changes2.size() + " changes...");
        try {
            shelvedChangeList = (ShelvedChangeList)TraceUtil.computeWithSpanThrows((Tracer)this.myTracer, (String)VcsTelemetrySpan.Shelve.TotalShelving.getName(), span -> {
                span.setAttribute("changesSize", (long)changes2.size());
                Path schemePatchDir = this.generateUniqueSchemePatchDir(commitMessage, true);
                ArrayList<Change> textChanges = new ArrayList<Change>();
                ArrayList<ShelvedBinaryFile> binaryFiles = new ArrayList<ShelvedBinaryFile>();
                for (Change change : changes2) {
                    if (ChangesUtil.getFilePath(change).getIOFile().isDirectory()) continue;
                    if (IdeaTextPatchBuilder.isBinaryRevision(change.getBeforeRevision()) || IdeaTextPatchBuilder.isBinaryRevision(change.getAfterRevision())) {
                        binaryFiles.add(this.shelveBinaryFile(schemePatchDir, change));
                        continue;
                    }
                    textChanges.add(change);
                }
                if (textChanges.isEmpty() && binaryFiles.isEmpty()) {
                    LOG.warn("Created an empty shelved list, ignored changes: " + changes2);
                }
                Path patchFile = ShelveChangesManager.getPatchFileInConfigDir(schemePatchDir);
                ArrayList<FilePatch> patches = new ArrayList<FilePatch>(this.buildAndSavePatchInBatches(patchFile, textChanges, honorExcludedFromCommit));
                ShelvedChangeList changeList = new ShelvedChangeList(patchFile, commitMessage.replace('\n', ' '), binaryFiles, ShelvedChangeList.createShelvedChangesFromFilePatches(this.myProject, patchFile, patches));
                changeList.markToDelete(markToBeDeleted);
                changeList.setName(schemePatchDir.getFileName().toString());
                ProgressManager.checkCanceled();
                this.schemeManager.addScheme((Object)changeList, false);
                return changeList;
            });
        }
        catch (VcsException | IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (shelvedChangeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(15);
        }
        return shelvedChangeList;
    }

    private List<FilePatch> buildAndSavePatchInBatches(@NotNull Path patchFile, @NotNull List<Change> textChanges, boolean honorExcludedFromCommit) throws IOException, VcsException {
        if (patchFile == null) {
            ShelveChangesManager.$$$reportNull$$$0(16);
        }
        if (textChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(17);
        }
        ArrayList<FilePatch> patches = new ArrayList<FilePatch>();
        if (textChanges.isEmpty()) {
            ShelveChangesManager.savePatchFile(this.myProject, patchFile, patches, null, new CommitContext());
            return patches;
        }
        int batchIndex = 0;
        int baseContentsPreloadSize = Registry.intValue((String)"git.shelve.load.base.in.batches", (int)-1);
        int partitionSize = baseContentsPreloadSize > 0 ? baseContentsPreloadSize : textChanges.size();
        List partition = Lists.partition(textChanges, (int)partitionSize);
        for (List list2 : partition) {
            int finalBatchIndex = ++batchIndex;
            try {
                TraceUtil.runWithSpanThrows((Tracer)this.myTracer, (String)VcsTelemetrySpan.Shelve.BatchShelving.getName(), span -> {
                    span.setAttribute("batch", (long)finalBatchIndex);
                    try {
                        if (baseContentsPreloadSize > 0) {
                            TraceKt.runWithSpan((Tracer)this.myTracer, (String)VcsTelemetrySpan.Shelve.PreloadingBaseRevisions.getName(), preloadSpan -> {
                                preloadSpan.setAttribute("changesSize", (long)list2.size());
                                this.preloadBaseRevisions(list2);
                            });
                        }
                        ProgressManager.checkCanceled();
                        TraceUtil.runWithSpanThrows((Tracer)this.myTracer, (String)VcsTelemetrySpan.Shelve.BuildingPatches.getName(), __ -> patches.addAll(IdeaTextPatchBuilder.buildPatch(this.myProject, list2, ProjectKt.getStateStore((Project)this.myProject).getProjectBasePath(), false, honorExcludedFromCommit)));
                        ProgressManager.checkCanceled();
                        CommitContext commitContext = (CommitContext)((Object)((Object)TraceKt.computeWithSpan((Tracer)this.myTracer, (String)VcsTelemetrySpan.Shelve.StoringBaseRevision.getName(), __ -> {
                            CommitContext context = new CommitContext();
                            this.baseRevisionsOfDvcsIntoContext(list2, context);
                            return context;
                        })));
                        TraceUtil.runWithSpanThrows((Tracer)this.myTracer, (String)VcsTelemetrySpan.Shelve.StoringPathFile.getName(), __ -> ShelveChangesManager.savePatchFile(this.myProject, patchFile, patches, null, commitContext));
                    }
                    finally {
                        ProjectLevelVcsManager.getInstance(this.myProject).getContentRevisionCache().clearConstantCache();
                    }
                });
            }
            catch (VcsException | IOException | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return patches;
    }

    private void preloadBaseRevisions(@NotNull List<? extends Change> textChanges) {
        if (textChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(18);
        }
        MultiMap changesGroupedByRoot = MultiMap.create();
        for (Change change : textChanges) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (beforeRevision == null) continue;
            FilePath file = beforeRevision.getFile();
            VcsRoot vcsRoot = ProjectLevelVcsManager.getInstance(this.myProject).getVcsRootObjectFor(file);
            if (vcsRoot == null || vcsRoot.getVcs() == null) {
                LOG.error(file + " is not under VCS");
                continue;
            }
            changesGroupedByRoot.putValue((Object)vcsRoot, (Object)change);
        }
        for (VcsRoot vcsRoot : changesGroupedByRoot.keySet()) {
            AbstractVcs vcs = Objects.requireNonNull(vcsRoot.getVcs());
            if (vcs.getDiffProvider() == null) continue;
            vcs.getDiffProvider().preloadBaseRevisions(Objects.requireNonNull(vcsRoot.getPath()), changesGroupedByRoot.get((Object)vcsRoot));
        }
    }

    private void rollbackChangesAfterShelve(@NotNull Collection<? extends Change> changes2, boolean honorExcludedFromCommit) {
        if (changes2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(19);
        }
        String operationName = UIUtil.removeMnemonic((String)RollbackChangesDialog.operationNameByChanges(this.myProject, changes2));
        boolean modalContext = ApplicationManager.getApplication().isDispatchThread() && LaterInvocator.isInModalContext();
        TraceKt.runWithSpan((Tracer)this.myTracer, (String)VcsTelemetrySpan.Shelve.RollbackAfterShelve.getName(), __ -> new RollbackWorker(this.myProject, operationName, modalContext).doRollback(changes2, true, null, VcsBundle.message("activity.name.shelve", new Object[0]), VcsActivity.Shelve, honorExcludedFromCommit));
    }

    private void baseRevisionsOfDvcsIntoContext(List<? extends Change> textChanges, CommitContext commitContext) {
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance(this.myProject);
        if (this.dvcsUsedInProject() && VcsConfiguration.getInstance((Project)this.myProject).INCLUDE_TEXT_INTO_SHELF) {
            HashMap<FilePath, ContentRevision> toKeep = new HashMap<FilePath, ContentRevision>();
            for (Change change : textChanges) {
                FilePath filePath;
                AbstractVcs vcs;
                if (change.getBeforeRevision() == null || change.getAfterRevision() == null || ShelveChangesManager.isBig(change) || (vcs = vcsManager2.getVcsFor(filePath = change.getBeforeRevision().getFile())) == null || !VcsType.distributed.equals((Object)vcs.getType())) continue;
                toKeep.put(filePath, change.getBeforeRevision());
            }
            commitContext.putUserData(BaseRevisionTextPatchEP.ourBaseRevisions, toKeep);
        }
    }

    private boolean dvcsUsedInProject() {
        return ContainerUtil.exists((Object[])ProjectLevelVcsManager.getInstance(this.myProject).getAllActiveVcss(), vcs -> VcsType.distributed.equals((Object)vcs.getType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ShelvedChangeList importFilePatches(String fileName, List<? extends FilePatch> patches, List<? extends PatchEP> patchTransitExtensions) throws IOException {
        Path schemePatchDir = this.generateUniqueSchemePatchDir(fileName, true);
        Path patchFile = ShelveChangesManager.getPatchFileInConfigDir(schemePatchDir);
        ShelveChangesManager.savePatchFile(this.myProject, patchFile, patches, patchTransitExtensions, new CommitContext());
        ShelvedChangeList changeList = new ShelvedChangeList(patchFile, fileName.replace('\n', ' '), (List<ShelvedBinaryFile>)new SmartList(), ShelvedChangeList.createShelvedChangesFromFilePatches(this.myProject, patchFile, patches));
        changeList.setName(schemePatchDir.getFileName().toString());
        this.schemeManager.addScheme((Object)changeList, false);
        ShelvedChangeList shelvedChangeList = changeList;
        ShelvedChangeList shelvedChangeList2 = shelvedChangeList;
        if (shelvedChangeList2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(20);
        }
        return shelvedChangeList2;
        finally {
            this.notifyStateChanged();
        }
    }

    public List<VirtualFile> gatherPatchFiles(Collection<? extends VirtualFile> files2) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        LinkedList<? extends VirtualFile> filesQueue = new LinkedList<VirtualFile>(files2);
        while (!filesQueue.isEmpty()) {
            ProgressManager.checkCanceled();
            VirtualFile file = filesQueue.removeFirst();
            if (file.isDirectory()) {
                filesQueue.addAll(Arrays.asList(file.getChildren()));
                continue;
            }
            if (!PatchFileType.isPatchFile(file)) continue;
            result2.add(file);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    public List<ShelvedChangeList> importChangeLists(@NotNull Collection<? extends VirtualFile> files2, @NotNull Consumer<? super VcsException> exceptionConsumer) {
        if (files2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(21);
        }
        if (exceptionConsumer == null) {
            ShelveChangesManager.$$$reportNull$$$0(22);
        }
        ThreadingAssertions.assertBackgroundThread();
        ArrayList<ShelvedChangeList> result2 = new ArrayList<ShelvedChangeList>(files2.size());
        try {
            FilesProgress filesProgress = new FilesProgress(files2.size(), VcsBundle.message("shelve.import.to.progress", new Object[0]));
            for (VirtualFile virtualFile : files2) {
                filesProgress.updateIndicator(virtualFile);
                String description2 = virtualFile.getNameWithoutExtension().replace('_', ' ');
                try {
                    Path schemeNameDir = this.generateUniqueSchemePatchDir(description2, true);
                    Path patchFile = ShelveChangesManager.getPatchFileInConfigDir(schemeNameDir);
                    List<? extends FilePatch> filePatches = ShelveChangesManager.loadPatchesWithoutContent(this.myProject, virtualFile.toNioPath(), new CommitContext());
                    if (filePatches.isEmpty()) continue;
                    Files.copy(virtualFile.toNioPath(), patchFile, new CopyOption[0]);
                    ShelvedChangeList list2 = new ShelvedChangeList(patchFile, description2, (List<ShelvedBinaryFile>)new SmartList(), ShelvedChangeList.createShelvedChangesFromFilePatches(this.myProject, patchFile, filePatches), virtualFile.getTimeStamp());
                    list2.setName(schemeNameDir.getFileName().toString());
                    this.schemeManager.addScheme((Object)list2, false);
                    result2.add(list2);
                }
                catch (Exception e) {
                    exceptionConsumer.accept(new VcsException(e));
                }
            }
        }
        finally {
            this.notifyStateChanged();
        }
        return result2;
    }

    private ShelvedBinaryFile shelveBinaryFile(@NotNull Path schemePatchDir, Change change) throws IOException {
        if (schemePatchDir == null) {
            ShelveChangesManager.$$$reportNull$$$0(23);
        }
        ContentRevision beforeRevision = change.getBeforeRevision();
        ContentRevision afterRevision = change.getAfterRevision();
        File beforeFile = beforeRevision == null ? null : beforeRevision.getFile().getIOFile();
        File afterFile = afterRevision == null ? null : afterRevision.getFile().getIOFile();
        String shelvedPath = null;
        if (afterFile != null) {
            String shelvedFileName = afterFile.getName();
            String name = FileUtilRt.getNameWithoutExtension((String)shelvedFileName);
            String extension = FileUtilRt.getExtension((String)shelvedFileName);
            File shelvedFile = FileUtil.findSequentNonexistentFile((File)schemePatchDir.toFile(), (String)name, (String)extension);
            FileUtil.copy((File)afterRevision.getFile().getIOFile(), (File)shelvedFile);
            shelvedPath = shelvedFile.getPath();
        }
        String beforePath = ChangesUtil.getProjectRelativePath(this.myProject, beforeFile);
        String afterPath = ChangesUtil.getProjectRelativePath(this.myProject, afterFile);
        return new ShelvedBinaryFile(beforePath, afterPath, shelvedPath);
    }

    private void notifyStateChanged() {
        if (!this.myProject.isDisposed()) {
            ((ShelveChangesManagerListener)this.myProject.getMessageBus().syncPublisher(SHELF_TOPIC)).shelvedListsChanged();
        }
    }

    @NotNull
    private Path generateUniqueSchemePatchDir(@Nullable String defaultName, boolean createResourceDirectory) throws IOException {
        File shelfResourcesDirectory = this.getShelfResourcesDirectory();
        Path dir = ShelveChangesManager.suggestPatchName(this.myProject, defaultName, shelfResourcesDirectory, "").toPath();
        if (createResourceDirectory) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        Path path2 = dir;
        if (path2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(24);
        }
        return path2;
    }

    public void unshelveChangeList(ShelvedChangeList changeList, @Nullable List<ShelvedChange> changes2, @Nullable List<ShelvedBinaryFile> binaryFiles, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification) {
        this.unshelveChangeList(changeList, changes2, binaryFiles, targetChangeList, showSuccessNotification, this.isRemoveFilesFromShelf());
    }

    private ApplyPatchStatus unshelveChangeList(ShelvedChangeList changeList, @Nullable List<ShelvedChange> changes2, @Nullable List<ShelvedBinaryFile> binaryFiles, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification, boolean removeFilesFromShelf) {
        return this.unshelveChangeList(changeList, changes2, binaryFiles, targetChangeList, showSuccessNotification, false, false, null, null, removeFilesFromShelf);
    }

    public ApplyPatchStatus unshelveChangeList(ShelvedChangeList changeList, @Nullable List<ShelvedChange> changes2, @Nullable List<ShelvedBinaryFile> binaryFiles, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification, boolean systemOperation, boolean reverse, @NlsContexts.Label String leftConflictTitle, @NlsContexts.Label String rightConflictTitle, boolean removeFilesFromShelf) {
        return this.unshelveChangeList(changeList, changes2, binaryFiles, targetChangeList, showSuccessNotification, systemOperation, reverse, leftConflictTitle, rightConflictTitle, removeFilesFromShelf, true);
    }

    public ApplyPatchStatus unshelveChangeList(ShelvedChangeList changeList, @Nullable List<ShelvedChange> changes2, @Nullable List<ShelvedBinaryFile> binaryFiles, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification, boolean systemOperation, boolean reverse, @NlsContexts.Label String leftConflictTitle, @NlsContexts.Label String rightConflictTitle, boolean removeFilesFromShelf, boolean reportLocalHistoryActivity) {
        List<TextFilePatch> textFilePatches;
        ArrayList<FilePatch> remainingPatches = new ArrayList<FilePatch>();
        CommitContext commitContext = new CommitContext();
        commitContext.putUserData(BaseRevisionTextPatchEP.ourProvideStoredBaseRevisionTextKey, true);
        try {
            textFilePatches = ShelveChangesManager.loadTextPatches(this.myProject, changeList, changes2, remainingPatches, commitContext);
        }
        catch (PatchSyntaxException | IOException e) {
            LOG.info((Throwable)e);
            PatchApplier.showError(this.myProject, VcsBundle.message("unshelve.loading.patch.error", e.getMessage()));
            return ApplyPatchStatus.FAILURE;
        }
        ArrayList<TextFilePatch> patches = new ArrayList<TextFilePatch>(textFilePatches);
        ArrayList remainingBinaries = new ArrayList();
        List<ShelvedBinaryFile> binaryFilesToUnshelve = ShelveChangesManager.getBinaryFilesToUnshelve(changeList, binaryFiles, remainingBinaries);
        for (ShelvedBinaryFile shelvedBinaryFile : binaryFilesToUnshelve) {
            patches.add((TextFilePatch)((Object)new ShelvedBinaryFilePatch(shelvedBinaryFile)));
        }
        VirtualFile baseDir2 = LocalFileSystem.getInstance().findFileByNioFile(ProjectKt.getStateStore((Project)this.myProject).getProjectBasePath());
        ActivityId activityId = reportLocalHistoryActivity ? VcsActivity.Unshelve : null;
        PatchApplier patchApplier = new PatchApplier(this.myProject, baseDir2, patches, targetChangeList, commitContext, reverse, leftConflictTitle, rightConflictTitle, VcsBundle.message("activity.name.unshelve", new Object[0]), activityId);
        ApplyPatchStatus status = patchApplier.execute(showSuccessNotification, systemOperation);
        if (removeFilesFromShelf) {
            remainingPatches.addAll(patchApplier.getRemainingPatches());
            remainingPatches.addAll(patchApplier.getFailedPatches());
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.nonModal(), (Condition)this.myProject.getDisposed(), () -> this.updateListAfterUnshelve(changeList, remainingPatches, remainingBinaries, commitContext));
        }
        return status;
    }

    @NotNull
    @RequiresEdt
    Map<ShelvedChangeList, Date> deleteShelves(@NotNull List<ShelvedChangeList> shelvedListsToDelete, @NotNull List<ShelvedChangeList> shelvedListsFromChanges, @NotNull List<ShelvedChange> changesToDelete, @NotNull List<ShelvedBinaryFile> binariesToDelete) {
        Date originalDate;
        if (shelvedListsToDelete == null) {
            ShelveChangesManager.$$$reportNull$$$0(25);
        }
        if (shelvedListsFromChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(26);
        }
        if (changesToDelete == null) {
            ShelveChangesManager.$$$reportNull$$$0(27);
        }
        if (binariesToDelete == null) {
            ShelveChangesManager.$$$reportNull$$$0(28);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ArrayList<ShelvedChangeList> shelvedListsFromChangesToDelete = new ArrayList<ShelvedChangeList>(shelvedListsFromChanges);
        shelvedListsFromChangesToDelete.removeAll(shelvedListsToDelete);
        if (shelvedListsFromChangesToDelete.size() + binariesToDelete.size() == 0 && shelvedListsToDelete.isEmpty()) {
            Map<ShelvedChangeList, Date> map2 = Collections.emptyMap();
            if (map2 == null) {
                ShelveChangesManager.$$$reportNull$$$0(29);
            }
            return map2;
        }
        HashMap<ShelvedChangeList, Date> deletedListsWithOriginalDate = new HashMap<ShelvedChangeList, Date>();
        for (ShelvedChangeList changeList : shelvedListsToDelete) {
            originalDate = changeList.DATE;
            if (changeList.isDeleted()) {
                this.deleteChangeListCompletely(changeList);
                continue;
            }
            this.markChangeListAsDeleted(changeList);
            deletedListsWithOriginalDate.put(changeList, originalDate);
        }
        for (ShelvedChangeList list2 : shelvedListsFromChangesToDelete) {
            ShelvedChangeList shelvedChangeList;
            originalDate = list2.DATE;
            boolean wasDeleted = list2.isDeleted();
            ShelvedChangeList newListWithDeletedChanges = this.removeChangesFromChangeList(list2, changesToDelete, binariesToDelete);
            if (newListWithDeletedChanges != null) {
                deletedListsWithOriginalDate.put(newListWithDeletedChanges, originalDate);
                continue;
            }
            if (wasDeleted || (shelvedChangeList = (ShelvedChangeList)this.schemeManager.findSchemeByName(list2.getName())) == null || !shelvedChangeList.isDeleted()) continue;
            deletedListsWithOriginalDate.put(shelvedChangeList, originalDate);
        }
        HashMap<ShelvedChangeList, Date> hashMap = deletedListsWithOriginalDate;
        if (hashMap == null) {
            ShelveChangesManager.$$$reportNull$$$0(30);
        }
        return hashMap;
    }

    @RequiresEdt
    @Nullable
    private ShelvedChangeList removeChangesFromChangeList(@NotNull ShelvedChangeList list2, @NotNull List<ShelvedChange> changes2, @NotNull List<ShelvedBinaryFile> binaryFiles) {
        if (list2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(31);
        }
        if (changes2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(32);
        }
        if (binaryFiles == null) {
            ShelveChangesManager.$$$reportNull$$$0(33);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ArrayList<ShelvedBinaryFile> remainingBinaries = new ArrayList<ShelvedBinaryFile>(list2.getBinaryFiles());
        remainingBinaries.removeAll(binaryFiles);
        CommitContext commitContext = new CommitContext();
        commitContext.putUserData(BaseRevisionTextPatchEP.ourProvideStoredBaseRevisionTextKey, true);
        ArrayList remainingPatches = new ArrayList();
        try {
            ShelveChangesManager.loadTextPatches(this.myProject, list2, changes2, remainingPatches, commitContext);
        }
        catch (PatchSyntaxException | IOException e) {
            LOG.info((Throwable)e);
            VcsImplUtil.showErrorMessage(this.myProject, e.getMessage(), VcsBundle.message("shelve.delete.files.from.changelist.error", list2.DESCRIPTION));
            return null;
        }
        return this.saveRemainingPatchesIfNeeded(list2, remainingPatches, remainingBinaries, commitContext, true);
    }

    public boolean isRemoveFilesFromShelf() {
        return this.myState.myRemoveFilesFromShelf;
    }

    public void setRemoveFilesFromShelf(boolean removeFilesFromShelf) {
        this.myState.myRemoveFilesFromShelf = removeFilesFromShelf;
    }

    private void markDeletedSystemUnshelved() {
        List systemUnshelved = ContainerUtil.filter((Collection)this.schemeManager.getAllSchemes(), list2 -> list2.isRecycled() && list2.isMarkedToDelete());
        for (ShelvedChangeList list3 : systemUnshelved) {
            list3.setDeleted(true);
            list3.markToDelete(false);
        }
    }

    private void cleanDeletedOlderOneWeek() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -7);
        this.clean((Condition<? super ShelvedChangeList>)((Condition)list2 -> list2.isDeleted() && list2.DATE.before(new Date(cal.getTimeInMillis()))));
    }

    public void cleanUnshelved(long timeBefore) {
        Date limitDate = new Date(timeBefore);
        this.clean((Condition<? super ShelvedChangeList>)((Condition)l -> l.isRecycled() && l.DATE.before(limitDate)));
    }

    private void clean(@NotNull Condition<? super ShelvedChangeList> condition) {
        if (condition == null) {
            ShelveChangesManager.$$$reportNull$$$0(34);
        }
        List toDelete = ContainerUtil.filter((Collection)this.schemeManager.getAllSchemes(), condition);
        this.clearShelvedLists(toDelete, true);
    }

    @RequiresEdt
    public void shelveSilentlyUnderProgress(final @NotNull List<? extends Change> changes2, final boolean rollbackChanges) {
        if (changes2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(35);
        }
        ThreadingAssertions.assertEventDispatchThread();
        final ArrayList result2 = new ArrayList();
        new Task.Backgroundable(this.myProject, VcsBundle.message("shelve.changes.progress.title", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                result2.addAll(ShelveChangesManager.this.shelveChangesInSeparatedLists(changes2, rollbackChanges));
            }

            public void onSuccess() {
                VcsNotifier.getInstance(this.myProject).notifySuccess("vcs.shelve.successful", "", VcsBundle.message("shelve.successful.message", new Object[0]));
                if (result2.size() == 1 && ShelveChangesManager.this.isShelfContentActive()) {
                    ShelvedChangesViewManager.getInstance(this.myProject).startEditing((ShelvedChangeList)result2.get(0));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$4", "run"));
            }
        }.queue();
    }

    private void rememberShelvingFiles(@NotNull Collection<? extends Change> changes2) {
        if (changes2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(36);
        }
        this.myShelvingFiles = new HashSet<VirtualFile>(ContainerUtil.map2SetNotNull(changes2, Change::getVirtualFile));
    }

    private void cleanShelvingFiles() {
        this.myShelvingFiles = null;
    }

    private boolean isShelfContentActive() {
        ToolWindow window = ChangesViewContentManager.getToolWindowFor(this.myProject, "Shelf");
        return window != null && window.isVisible() && ((ChangesViewContentManager)ChangesViewContentManager.getInstance(this.myProject)).isContentSelected("Shelf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<ShelvedChangeList> shelveChangesInSeparatedLists(@NotNull Collection<? extends Change> changes2, boolean rollbackChanges) {
        if (changes2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(37);
        }
        ArrayList<String> failedChangeLists = new ArrayList<String>();
        ArrayList<ShelvedChangeList> result2 = new ArrayList<ShelvedChangeList>();
        ArrayList shelvedChanges = new ArrayList();
        try {
            ChangeListManager changeListManager = ChangeListManager.getInstance(this.myProject);
            if (!changeListManager.areChangeListsEnabled()) {
                LOG.warn("Changelists are disabled", new Throwable());
            }
            this.SHELVED_FILES_LOCK.writeLock().lock();
            this.rememberShelvingFiles(changes2);
            List<LocalChangeList> changeLists = changeListManager.getChangeLists();
            for (LocalChangeList list2 : changeLists) {
                HashSet<Change> changeSet = new HashSet<Change>(list2.getChanges());
                ArrayList<Change> changesForChangelist = new ArrayList<Change>();
                for (Change change : changes2) {
                    boolean inChangelist = change instanceof ChangeListChange ? ((ChangeListChange)change).getChangeListId().equals(list2.getId()) : changeSet.contains(change);
                    if (!inChangelist) continue;
                    changesForChangelist.add(change);
                }
                if (changesForChangelist.isEmpty()) continue;
                try {
                    result2.add(this.createShelfFromChanges(changesForChangelist, list2.getName(), false, false));
                    shelvedChanges.addAll(changesForChangelist);
                }
                catch (Exception e) {
                    ProgressManager.checkCanceled();
                    LOG.warn((Throwable)e);
                    failedChangeLists.add(list2.getName());
                }
            }
        }
        finally {
            this.cleanShelvingFiles();
            this.SHELVED_FILES_LOCK.writeLock().unlock();
            this.notifyStateChanged();
        }
        if (rollbackChanges) {
            this.rollbackChangesAfterShelve(shelvedChanges, false);
        }
        if (!failedChangeLists.isEmpty()) {
            VcsNotifier.getInstance(this.myProject).notifyError("vcs.shelve.failed", VcsBundle.message("shelve.failed.title", new Object[0]), VcsBundle.message("shelve.failed.message", failedChangeLists.size(), StringUtil.join(failedChangeLists, (String)",")));
        }
        ArrayList<ShelvedChangeList> arrayList = result2;
        if (arrayList == null) {
            ShelveChangesManager.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    public void unshelveSilentlyAsynchronously(@NotNull Project project2, @NotNull List<ShelvedChangeList> selectedChangeLists, @NotNull List<ShelvedChange> selectedChanges, @NotNull List<ShelvedBinaryFile> selectedBinaryChanges, @Nullable LocalChangeList forcePredefinedOneChangelist) {
        if (project2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(39);
        }
        if (selectedChangeLists == null) {
            ShelveChangesManager.$$$reportNull$$$0(40);
        }
        if (selectedChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(41);
        }
        if (selectedBinaryChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(42);
        }
        this.unshelveSilentlyAsynchronously(project2, selectedChangeLists, selectedChanges, selectedBinaryChanges, forcePredefinedOneChangelist, this.isRemoveFilesFromShelf());
    }

    public void unshelveSilentlyAsynchronously(@NotNull Project project2, final @NotNull List<ShelvedChangeList> selectedChangeLists, final @NotNull List<ShelvedChange> selectedChanges, final @NotNull List<ShelvedBinaryFile> selectedBinaryChanges, final @Nullable LocalChangeList forcePredefinedOneChangelist, final boolean removeFilesFromShelf) {
        if (project2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(43);
        }
        if (selectedChangeLists == null) {
            ShelveChangesManager.$$$reportNull$$$0(44);
        }
        if (selectedChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(45);
        }
        if (selectedBinaryChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(46);
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, VcsBundle.message("unshelve.changes.progress.title", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                for (ShelvedChangeList changeList : selectedChangeLists) {
                    ArrayList<ShelvedChange> changesForChangelist = new ArrayList<ShelvedChange>(ContainerUtil.intersection((Collection)Objects.requireNonNull(changeList.getChanges()), (Collection)selectedChanges));
                    ArrayList<ShelvedBinaryFile> binariesForChangelist = new ArrayList<ShelvedBinaryFile>(ContainerUtil.intersection(changeList.getBinaryFiles(), (Collection)selectedBinaryChanges));
                    boolean shouldUnshelveAllList = changesForChangelist.isEmpty() && binariesForChangelist.isEmpty();
                    ApplyPatchStatus status = ShelveChangesManager.this.unshelveChangeList(changeList, shouldUnshelveAllList ? null : changesForChangelist, shouldUnshelveAllList ? null : binariesForChangelist, forcePredefinedOneChangelist != null ? forcePredefinedOneChangelist : ShelveChangesManager.this.getChangeListUnshelveTo(changeList), true, removeFilesFromShelf);
                    ChangeListManagerEx.getInstanceEx(this.myProject).waitForUpdate();
                    if (status != ApplyPatchStatus.ABORT) continue;
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$5", "run"));
            }
        });
    }

    @Nullable
    private LocalChangeList getChangeListUnshelveTo(@NotNull ShelvedChangeList list2) {
        ChangeListManager manager;
        if (list2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(47);
        }
        if (!(manager = ChangeListManager.getInstance(this.myProject)).areChangeListsEnabled()) {
            return null;
        }
        if (!VcsApplicationSettings.getInstance().CREATE_CHANGELISTS_AUTOMATICALLY) {
            return null;
        }
        LocalChangeList localChangeList = ChangeListUtil.getPredefinedChangeList(list2, manager);
        return localChangeList != null ? localChangeList : manager.addChangeList(ChangeListUtil.getChangeListNameForUnshelve(list2), "");
    }

    @RequiresEdt
    public void updateListAfterUnshelve(@NotNull ShelvedChangeList listToUpdate, @NotNull List<? extends FilePatch> patches, @NotNull List<ShelvedBinaryFile> binaries, @NotNull CommitContext commitContext) {
        if (listToUpdate == null) {
            ShelveChangesManager.$$$reportNull$$$0(48);
        }
        if (patches == null) {
            ShelveChangesManager.$$$reportNull$$$0(49);
        }
        if (binaries == null) {
            ShelveChangesManager.$$$reportNull$$$0(50);
        }
        if (commitContext == null) {
            ShelveChangesManager.$$$reportNull$$$0(51);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.saveRemainingPatchesIfNeeded(listToUpdate, patches, binaries, commitContext, false);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @Nullable
    private ShelvedChangeList saveRemainingPatchesIfNeeded(ShelvedChangeList shelvedChangeList, List<? extends FilePatch> list2, List<ShelvedBinaryFile> list3, CommitContext commitContext, boolean bl) {
        void changeList;
        void delete;
        void remainingBinaries;
        void remainingPatches;
        ThreadingAssertions.assertEventDispatchThread();
        if (remainingPatches.isEmpty() && remainingBinaries.isEmpty()) {
            if (delete == false) {
                this.recycleChangeList((ShelvedChangeList)changeList);
            } else if (changeList.isDeleted()) {
                this.deleteChangeListCompletely((ShelvedChangeList)changeList);
            } else {
                this.markChangeListAsDeleted((ShelvedChangeList)changeList);
            }
            return null;
        }
        if (delete == false && changeList.isRecycled()) {
            return null;
        }
        ShelvedChangeList newlyCreatedList = null;
        if (delete != false && changeList.isDeleted()) {
            this.saveRemainingChangesInList((ShelvedChangeList)changeList, (List<? extends FilePatch>)remainingPatches, (List<ShelvedBinaryFile>)remainingBinaries, (CommitContext)commitContext);
        } else {
            newlyCreatedList = this.saveRemainingAndRecycleOthers((ShelvedChangeList)changeList, (List<? extends FilePatch>)remainingPatches, (List<ShelvedBinaryFile>)remainingBinaries, (CommitContext)commitContext, (boolean)delete);
        }
        this.notifyStateChanged();
        return newlyCreatedList;
    }

    @RequiresEdt
    @Nullable
    private ShelvedChangeList saveRemainingAndRecycleOthers(@NotNull ShelvedChangeList changeList, List<? extends FilePatch> remainingPatches, List<ShelvedBinaryFile> remainingBinaries, CommitContext commitContext, boolean delete) {
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(52);
        }
        ThreadingAssertions.assertEventDispatchThread();
        try {
            ShelvedChangeList listCopy = this.createChangelistCopyWithChanges(changeList, this.generateUniqueSchemePatchDir(changeList.DESCRIPTION, true));
            listCopy.updateDate();
            this.saveRemainingChangesInList(changeList, remainingPatches, remainingBinaries, commitContext);
            this.removeFromListWithChanges(listCopy, Objects.requireNonNull(changeList.getChanges()), changeList.getBinaryFiles(), commitContext);
            if (delete) {
                this.markChangeListAsDeleted(listCopy);
            } else {
                this.recycleChangeList(listCopy);
            }
            this.saveListAsScheme(listCopy);
            return listCopy;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void saveRemainingChangesInList(@NotNull ShelvedChangeList changeList, List<? extends FilePatch> remainingPatches, List<ShelvedBinaryFile> remainingBinaries, CommitContext commitContext) {
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(53);
        }
        ShelveChangesManager.writePatchesToFile(this.myProject, changeList.path, remainingPatches, commitContext);
        changeList.getBinaryFiles().retainAll(remainingBinaries);
        changeList.setChanges(ShelvedChangeList.createShelvedChangesFromFilePatches(this.myProject, changeList.path, remainingPatches));
    }

    void saveListAsScheme(@NotNull ShelvedChangeList list2) {
        if (list2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(54);
        }
        if (!list2.getBinaryFiles().isEmpty() || !ContainerUtil.isEmpty(list2.getChanges())) {
            this.schemeManager.addScheme((Object)list2, false);
        }
    }

    @NotNull
    ShelvedChangeList createChangelistCopyWithChanges(@NotNull ShelvedChangeList changeList, @NotNull Path targetDir) throws IOException {
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(55);
        }
        if (targetDir == null) {
            ShelveChangesManager.$$$reportNull$$$0(56);
        }
        Path newPath = ShelveChangesManager.getPatchFileInConfigDir(targetDir);
        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
        Files.copy(changeList.path, newPath, new CopyOption[0]);
        changeList.loadChangesIfNeeded(this.myProject);
        ShelvedChangeList listCopy = new ShelvedChangeList(newPath, changeList.DESCRIPTION, ShelveChangesManager.copyBinaryFiles(changeList, targetDir), ShelveChangesManager.copyTextFiles(this.myProject, changeList, newPath), changeList.DATE.getTime());
        listCopy.markToDelete(changeList.isMarkedToDelete());
        listCopy.setRecycled(changeList.isRecycled());
        listCopy.setDeleted(changeList.isDeleted());
        listCopy.setName(targetDir.getFileName().toString());
        ShelvedChangeList shelvedChangeList = listCopy;
        if (shelvedChangeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(57);
        }
        return shelvedChangeList;
    }

    public void restoreList(@NotNull ShelvedChangeList shelvedChangeList, @NotNull Date restoreDate) {
        ShelvedChangeList list2;
        if (shelvedChangeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(58);
        }
        if (restoreDate == null) {
            ShelveChangesManager.$$$reportNull$$$0(59);
        }
        if ((list2 = (ShelvedChangeList)this.schemeManager.findSchemeByName(shelvedChangeList.getName())) == null) {
            return;
        }
        list2.setDeleted(false);
        list2.DATE = restoreDate;
        this.notifyStateChanged();
    }

    @NotNull
    public @Unmodifiable List<ShelvedChangeList> getRecycledShelvedChangeLists() {
        return this.getRecycled(true);
    }

    public @Unmodifiable List<ShelvedChangeList> getDeletedLists() {
        return List.copyOf(ContainerUtil.filter((Collection)this.schemeManager.getAllSchemes(), ShelvedChangeList::isDeleted));
    }

    void clearShelvedLists(@NotNull List<ShelvedChangeList> shelvedLists, boolean updateView) {
        if (shelvedLists == null) {
            ShelveChangesManager.$$$reportNull$$$0(60);
        }
        if (shelvedLists.isEmpty()) {
            return;
        }
        for (ShelvedChangeList list2 : shelvedLists) {
            this.deleteResources(list2);
            this.schemeManager.removeScheme((Object)list2);
        }
        if (updateView) {
            this.notifyStateChanged();
        }
    }

    @NotNull
    public Collection<VirtualFile> getShelvingFiles() {
        return new HashSet<VirtualFile>(ContainerUtil.notNullize(this.myShelvingFiles));
    }

    private void removeFromListWithChanges(@NotNull ShelvedChangeList listCopy, @NotNull List<ShelvedChange> shelvedChanges, @NotNull List<ShelvedBinaryFile> shelvedBinaryChanges, @NotNull CommitContext commitContext) {
        if (listCopy == null) {
            ShelveChangesManager.$$$reportNull$$$0(61);
        }
        if (shelvedChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(62);
        }
        if (shelvedBinaryChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(63);
        }
        if (commitContext == null) {
            ShelveChangesManager.$$$reportNull$$$0(64);
        }
        ShelveChangesManager.removeBinaries(listCopy, shelvedBinaryChanges);
        ShelveChangesManager.removeChanges(listCopy, shelvedChanges);
        try {
            ArrayList<FilePatch> patches = new ArrayList<FilePatch>();
            List<TextFilePatch> filePatches = ShelveChangesManager.loadPatches(this.myProject, listCopy.path, commitContext);
            for (ShelvedChange change : Objects.requireNonNull(listCopy.getChanges())) {
                patches.add((FilePatch)ContainerUtil.find(filePatches, patch -> change.getBeforePath().equals(patch.getBeforeName())));
            }
            ShelveChangesManager.writePatchesToFile(this.myProject, listCopy.path, patches, commitContext);
        }
        catch (PatchSyntaxException | IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private void recycleChangeList(@NotNull ShelvedChangeList changeList) {
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(65);
        }
        changeList.setRecycled(true);
        changeList.updateDate();
        if (changeList.isMarkedToDelete()) {
            changeList.markToDelete(false);
            changeList.setDeleted(true);
        }
        this.notifyStateChanged();
    }

    private void deleteChangeListCompletely(@NotNull ShelvedChangeList changeList) {
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(66);
        }
        this.deleteResources(changeList);
        this.schemeManager.removeScheme((Object)changeList);
        this.notifyStateChanged();
    }

    void markChangeListAsDeleted(@NotNull ShelvedChangeList changeList) {
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(67);
        }
        changeList.setDeleted(true);
        changeList.updateDate();
        this.notifyStateChanged();
    }

    private void deleteResources(@NotNull ShelvedChangeList changeList) {
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(68);
        }
        try {
            Files.deleteIfExists(changeList.path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (ShelvedBinaryFile binaryFile : changeList.getBinaryFiles()) {
            String path2 = binaryFile.SHELVED_PATH;
            if (path2 == null) continue;
            FileUtil.delete((File)new File(path2));
        }
        File schemaDir = new File(this.getShelfResourcesDirectory(), changeList.getName());
        if (schemaDir.exists() && ArrayUtil.isEmpty((Object[])schemaDir.list())) {
            FileUtil.delete((File)schemaDir);
        }
    }

    public void renameChangeList(ShelvedChangeList changeList, String newName) {
        changeList.DESCRIPTION = newName;
        this.notifyStateChanged();
    }

    public boolean isShowRecycled() {
        return this.myState.myShowRecycled;
    }

    public void setShowRecycled(boolean showRecycled) {
        this.myState.myShowRecycled = showRecycled;
    }

    @NotNull
    public Collection<String> getGrouping() {
        TreeSet<String> treeSet = this.myState.groupingKeys;
        if (treeSet == null) {
            ShelveChangesManager.$$$reportNull$$$0(69);
        }
        return treeSet;
    }

    public void setGrouping(@NotNull Collection<String> grouping) {
        if (grouping == null) {
            ShelveChangesManager.$$$reportNull$$$0(70);
        }
        this.myState.groupingKeys.clear();
        this.myState.groupingKeys.addAll(grouping);
    }

    public static ShelveChangesManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(71);
        }
        return (ShelveChangesManager)project2.getService(ShelveChangesManager.class);
    }

    @NotNull
    public static Path getDefaultShelfPath(@NotNull Project project2) {
        if (project2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(72);
        }
        IProjectStore store = ProjectKt.getStateStore((Project)project2);
        Path path2 = store.getProjectFilePath().getParent().resolve(ProjectKt.isDirectoryBased((Project)project2) ? SHELVE_MANAGER_DIR_PATH : ".shelf");
        if (path2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(73);
        }
        return path2;
    }

    @NotNull
    public static String getShelfPath(@NotNull Project project2) {
        if (project2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(74);
        }
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance(project2);
        if (vcsConfiguration.USE_CUSTOM_SHELF_PATH) {
            String string2 = Objects.requireNonNull(vcsConfiguration.CUSTOM_SHELF_PATH);
            if (string2 == null) {
                ShelveChangesManager.$$$reportNull$$$0(75);
            }
            return string2;
        }
        String string3 = ShelveChangesManager.getDefaultShelfPath(project2).toString().replace(File.separatorChar, '/');
        if (string3 == null) {
            ShelveChangesManager.$$$reportNull$$$0(76);
        }
        return string3;
    }

    @NotNull
    private static List<ShelvedChange> copyTextFiles(@NotNull Project project2, @NotNull ShelvedChangeList changeList, @NotNull Path newPatchPath) {
        if (project2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(77);
        }
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(78);
        }
        if (newPatchPath == null) {
            ShelveChangesManager.$$$reportNull$$$0(79);
        }
        ArrayList<ShelvedChange> copied = new ArrayList<ShelvedChange>();
        for (ShelvedChange change : changeList.getChanges()) {
            copied.add(ShelvedChange.copyToNewPatch(project2, newPatchPath, change));
        }
        ArrayList<ShelvedChange> arrayList = copied;
        if (arrayList == null) {
            ShelveChangesManager.$$$reportNull$$$0(80);
        }
        return arrayList;
    }

    @NotNull
    private static List<ShelvedBinaryFile> copyBinaryFiles(@NotNull ShelvedChangeList list2, @NotNull Path targetDirectory) throws IOException {
        if (list2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(81);
        }
        if (targetDirectory == null) {
            ShelveChangesManager.$$$reportNull$$$0(82);
        }
        Files.createDirectories(targetDirectory, new FileAttribute[0]);
        ArrayList<ShelvedBinaryFile> copied = new ArrayList<ShelvedBinaryFile>();
        for (ShelvedBinaryFile file : list2.getBinaryFiles()) {
            if (file.SHELVED_PATH == null) continue;
            Path shelvedFile = Paths.get(file.SHELVED_PATH, new String[0]);
            if (StringUtil.isEmptyOrSpaces((String)file.AFTER_PATH) || !Files.exists(shelvedFile, new LinkOption[0])) continue;
            Path newShelvedFile = targetDirectory.resolve(PathUtil.getFileName((String)file.AFTER_PATH));
            try {
                Files.copy(shelvedFile, newShelvedFile, new CopyOption[0]);
                copied.add(new ShelvedBinaryFile(file.BEFORE_PATH, file.AFTER_PATH, FileUtil.toSystemIndependentName((String)newShelvedFile.toString())));
            }
            catch (IOException e) {
                LOG.warn("Can't copy binary file: " + list2.path, (Throwable)e);
            }
        }
        ArrayList<ShelvedBinaryFile> arrayList = copied;
        if (arrayList == null) {
            ShelveChangesManager.$$$reportNull$$$0(83);
        }
        return arrayList;
    }

    @NotNull
    private static Path getPatchFileInConfigDir(@NotNull Path schemePatchDir) {
        if (schemePatchDir == null) {
            ShelveChangesManager.$$$reportNull$$$0(84);
        }
        Path path2 = schemePatchDir.resolve("shelved.patch");
        if (path2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(85);
        }
        return path2;
    }

    private static boolean isBig(@NotNull Change change) {
        VirtualFile vf;
        if (change == null) {
            ShelveChangesManager.$$$reportNull$$$0(86);
        }
        if ((vf = change.getVirtualFile()) != null) {
            return ShelveChangesManager.isBig(vf.getLength());
        }
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (beforeRevision != null) {
            try {
                String content = beforeRevision.getContent();
                if (content != null && ShelveChangesManager.isBig(content.length())) {
                    return true;
                }
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        }
        return false;
    }

    private static boolean isBig(long contentLength) {
        return contentLength > 500000L;
    }

    @NotNull
    public static File suggestPatchName(@NotNull Project project2, @Nullable String commitMessage, File file, String extension) {
        File nonexistentFile;
        if (project2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(87);
        }
        @NonNls String defaultPath = ShelveChangesManager.shortenAndSanitize(commitMessage);
        while ((nonexistentFile = FileUtil.findSequentNonexistentFile((File)file, (String)defaultPath, (String)(extension == null ? VcsConfiguration.getInstance(project2).getPatchFileExtension() : extension))).getName().length() >= 100) {
            defaultPath = defaultPath.substring(0, defaultPath.length() - 1);
        }
        File file2 = nonexistentFile;
        if (file2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(88);
        }
        return file2;
    }

    @NotNull
    private static String shortenAndSanitize(@Nullable String commitMessage) {
        @NonNls String defaultPath = PathUtil.suggestFileName((String)StringUtil.notNullize((String)commitMessage));
        if (defaultPath.isEmpty()) {
            defaultPath = "unnamed";
        }
        if (defaultPath.length() > 90) {
            defaultPath = defaultPath.substring(0, 90);
        }
        String string2 = defaultPath;
        if (string2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(89);
        }
        return string2;
    }

    private static List<TextFilePatch> loadTextPatches(@NotNull Project project2, ShelvedChangeList changeList, List<ShelvedChange> changes2, List<? super FilePatch> remainingPatches, CommitContext commitContext) throws IOException, PatchSyntaxException {
        if (project2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(90);
        }
        List textFilePatches = ShelveChangesManager.loadPatches(project2, changeList.path, commitContext);
        if (changes2 != null) {
            textFilePatches = ContainerUtil.filter(textFilePatches, patch -> {
                if (ShelveChangesManager.needUnshelve(patch, changes2)) {
                    return true;
                }
                remainingPatches.add((FilePatch)patch);
                return false;
            });
        }
        return textFilePatches;
    }

    @RequiresEdt
    public static void unshelveSilentlyWithDnd(@NotNull Project project2, @NotNull ShelvedChangeListDragBean shelvedChangeListDragBean, @Nullable LocalChangeList targetChangeList, boolean removeFilesFromShelf) {
        if (project2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(91);
        }
        if (shelvedChangeListDragBean == null) {
            ShelveChangesManager.$$$reportNull$$$0(92);
        }
        ThreadingAssertions.assertEventDispatchThread();
        FileDocumentManager.getInstance().saveAllDocuments();
        ShelveChangesManager.getInstance(project2).unshelveSilentlyAsynchronously(project2, shelvedChangeListDragBean.getShelvedChangelists(), shelvedChangeListDragBean.getChanges(), shelvedChangeListDragBean.getBinaryFiles(), targetChangeList, removeFilesFromShelf);
    }

    private static List<ShelvedBinaryFile> getBinaryFilesToUnshelve(ShelvedChangeList changeList, List<ShelvedBinaryFile> binaryFiles, List<? super ShelvedBinaryFile> remainingBinaries) {
        if (binaryFiles == null) {
            return new ArrayList<ShelvedBinaryFile>(changeList.getBinaryFiles());
        }
        ArrayList<ShelvedBinaryFile> result2 = new ArrayList<ShelvedBinaryFile>();
        for (ShelvedBinaryFile file : changeList.getBinaryFiles()) {
            if (binaryFiles.contains(file)) {
                result2.add(file);
                continue;
            }
            remainingBinaries.add(file);
        }
        return result2;
    }

    private static boolean needUnshelve(FilePatch patch, List<ShelvedChange> changes2) {
        for (ShelvedChange change : changes2) {
            if (!Objects.equals(patch.getBeforeName(), change.getBeforePath())) continue;
            return true;
        }
        return false;
    }

    private static void writePatchesToFile(@Nullable Project project2, @NotNull Path path2, @NotNull List<? extends FilePatch> remainingPatches, @Nullable CommitContext commitContext) {
        if (path2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(93);
        }
        if (remainingPatches == null) {
            ShelveChangesManager.$$$reportNull$$$0(94);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path2, new OpenOption[0]);){
            UnifiedDiffWriter.write(project2, remainingPatches, writer, "\n", commitContext);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void removeChanges(@NotNull ShelvedChangeList list2, @NotNull List<ShelvedChange> shelvedChanges) {
        if (list2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(95);
        }
        if (shelvedChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(96);
        }
        Iterator<ShelvedChange> iterator = Objects.requireNonNull(list2.getChanges()).iterator();
        while (iterator.hasNext()) {
            ShelvedChange change = iterator.next();
            boolean toRemove = ContainerUtil.exists(shelvedChanges, newChange -> Objects.equals(change.getBeforePath(), newChange.getBeforePath()) && Objects.equals(change.getAfterPath(), newChange.getAfterPath()));
            if (!toRemove) continue;
            iterator.remove();
        }
    }

    private static void removeBinaries(@NotNull ShelvedChangeList list2, @NotNull List<ShelvedBinaryFile> binaryFiles) {
        if (list2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(97);
        }
        if (binaryFiles == null) {
            ShelveChangesManager.$$$reportNull$$$0(98);
        }
        Iterator<ShelvedBinaryFile> shelvedChangeListIterator = list2.getBinaryFiles().iterator();
        while (shelvedChangeListIterator.hasNext()) {
            ShelvedBinaryFile binaryFile = shelvedChangeListIterator.next();
            for (ShelvedBinaryFile newBinary : binaryFiles) {
                if (!Objects.equals(newBinary.BEFORE_PATH, binaryFile.BEFORE_PATH) || !Objects.equals(newBinary.AFTER_PATH, binaryFile.AFTER_PATH)) continue;
                shelvedChangeListIterator.remove();
            }
        }
    }

    @NotNull
    public static List<TextFilePatch> loadPatches(Project project2, @NotNull Path patchPath, @Nullable CommitContext commitContext) throws IOException, PatchSyntaxException {
        if (patchPath == null) {
            ShelveChangesManager.$$$reportNull$$$0(99);
        }
        List<TextFilePatch> list2 = ShelveChangesManager.loadPatches(project2, patchPath, commitContext, true);
        if (list2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(100);
        }
        return list2;
    }

    @NotNull
    static List<? extends FilePatch> loadPatchesWithoutContent(@NotNull Project project2, @NotNull Path patchPath, @Nullable CommitContext commitContext) throws IOException, PatchSyntaxException {
        if (project2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(101);
        }
        if (patchPath == null) {
            ShelveChangesManager.$$$reportNull$$$0(102);
        }
        List<TextFilePatch> list2 = ShelveChangesManager.loadPatches(project2, patchPath, commitContext, false);
        if (list2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(103);
        }
        return list2;
    }

    private static List<TextFilePatch> loadPatches(@NotNull Project project2, @NotNull Path patchPath, @Nullable CommitContext commitContext, boolean loadContent) throws IOException, PatchSyntaxException {
        char[] text2;
        if (project2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(104);
        }
        if (patchPath == null) {
            ShelveChangesManager.$$$reportNull$$$0(105);
        }
        try (Object reader = new InputStreamReader(Files.newInputStream(patchPath, new OpenOption[0]), StandardCharsets.UTF_8);){
            text2 = FileUtilRt.loadText((Reader)reader, (int)((int)Files.size(patchPath)));
        }
        reader = new PatchReader((CharSequence)new CharArrayCharSequence(text2), loadContent);
        List<TextFilePatch> textFilePatches = ((PatchReader)reader).readTextPatches();
        ApplyPatchDefaultExecutor.applyAdditionalInfoBefore(project2, ((PatchReader)reader).getAdditionalInfo(null), commitContext);
        return textFilePatches;
    }

    private static void savePatchFile(@NotNull Project project2, @NotNull Path patchFile, @NotNull List<? extends FilePatch> patches, @Nullable List<? extends PatchEP> extensions2, @NotNull CommitContext context) throws IOException {
        if (project2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(106);
        }
        if (patchFile == null) {
            ShelveChangesManager.$$$reportNull$$$0(107);
        }
        if (patches == null) {
            ShelveChangesManager.$$$reportNull$$$0(108);
        }
        if (context == null) {
            ShelveChangesManager.$$$reportNull$$$0(109);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(patchFile, new OpenOption[0]);){
            UnifiedDiffWriter.write(project2, ProjectKt.getStateStore((Project)project2).getProjectBasePath(), patches, writer, "\n", context, extensions2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 7, 9, 11, 12, 13, 15, 20, 24, 29, 30, 38, 57, 69, 73, 75, 76, 80, 83, 85, 88, 89, 100, 103 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 24: 
            case 29: 
            case 30: 
            case 38: 
            case 57: 
            case 69: 
            case 73: 
            case 75: 
            case 76: 
            case 80: 
            case 83: 
            case 85: 
            case 88: 
            case 89: 
            case 100: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFile";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: 
            case 19: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 16: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textChanges";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionConsumer";
                break;
            }
            case 23: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemePatchDir";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedListsToDelete";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedListsFromChanges";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesToDelete";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binariesToDelete";
                break;
            }
            case 31: 
            case 47: 
            case 54: 
            case 81: 
            case 95: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 33: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFiles";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedChangeLists";
                break;
            }
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedChanges";
                break;
            }
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedBinaryChanges";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listToUpdate";
                break;
            }
            case 49: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patches";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaries";
                break;
            }
            case 51: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
            case 52: 
            case 53: 
            case 55: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChangeList";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restoreDate";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedLists";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listCopy";
                break;
            }
            case 62: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChanges";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedBinaryChanges";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouping";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPatchPath";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChangeListDragBean";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remainingPatches";
                break;
            }
            case 99: 
            case 102: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchPath";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createShelveSchemeManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShelfResourcesDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readOneShelvedChangeList";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecycled";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLists";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createShelfFromChanges";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "importFilePatches";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUniqueSchemePatchDir";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteShelves";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "shelveChangesInSeparatedLists";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createChangelistCopyWithChanges";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrouping";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultShelfPath";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getShelfPath";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTextFiles";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "copyBinaryFiles";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchFileInConfigDir";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestPatchName";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenAndSanitize";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPatches";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPatchesWithoutContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 24: 
            case 29: 
            case 30: 
            case 38: 
            case 57: 
            case 69: 
            case 73: 
            case 75: 
            case 76: 
            case 80: 
            case 83: 
            case 85: 
            case 88: 
            case 89: 
            case 100: 
            case 103: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createShelveSchemeManager";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkAndMigrateUnderProgress";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readOneShelvedChangeList";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "migrateOldShelfInfo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createShelfFromChanges";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildAndSavePatchInBatches";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "preloadBaseRevisions";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "rollbackChangesAfterShelve";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "importChangeLists";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "shelveBinaryFile";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "deleteShelves";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "removeChangesFromChangeList";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "clean";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "shelveSilentlyUnderProgress";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "rememberShelvingFiles";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "shelveChangesInSeparatedLists";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "unshelveSilentlyAsynchronously";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getChangeListUnshelveTo";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "updateListAfterUnshelve";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "saveRemainingAndRecycleOthers";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "saveRemainingChangesInList";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "saveListAsScheme";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createChangelistCopyWithChanges";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "restoreList";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "clearShelvedLists";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "removeFromListWithChanges";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "recycleChangeList";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "deleteChangeListCompletely";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "markChangeListAsDeleted";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "deleteResources";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "setGrouping";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultShelfPath";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getShelfPath";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "copyTextFiles";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "copyBinaryFiles";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getPatchFileInConfigDir";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isBig";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "suggestPatchName";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "loadTextPatches";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "unshelveSilentlyWithDnd";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "writePatchesToFile";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "removeChanges";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "removeBinaries";
                break;
            }
            case 99: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "loadPatches";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "loadPatchesWithoutContent";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "savePatchFile";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 4, 7, 9, 11, 12, 13, 15, 20, 24, 29, 30, 38, 57, 69, 73, 75, 76, 80, 83, 85, 88, 89, 100, 103 -> new IllegalStateException(string2);
        };
    }

    public static final class State {
        @OptionTag(value="remove_strategy")
        public boolean myRemoveFilesFromShelf;
        @Attribute(value="show_recycled")
        public boolean myShowRecycled;
        @XCollection
        public TreeSet<String> groupingKeys = new TreeSet();
    }
}

