/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.DiffContext;
import com.intellij.diff.EditorDiffViewer;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.OnesideContentPanel;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.LineNumberConverterAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.patch.tool.PatchChangeBuilder;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001)B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0010H\u0003J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u000b\u0010 \u001a\u00070!\u00a2\u0006\u0002\b\"H\u0016J\u0010\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$0\u0010H\u0016J\b\u0010%\u001a\u00020\u001dH\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchDiffViewer;", "Lcom/intellij/diff/FrameDiffTool$DiffViewer;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/diff/EditorDiffViewer;", "diffContext", "Lcom/intellij/diff/DiffContext;", "diffRequest", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchDiffRequest;", "(Lcom/intellij/diff/DiffContext;Lcom/intellij/openapi/vcs/changes/patch/tool/PatchDiffRequest;)V", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "editorHolder", "Lcom/intellij/diff/tools/holders/EditorHolder;", "editorSettingsAction", "Lcom/intellij/diff/actions/impl/SetEditorSettingsAction;", "hunks", "", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk;", "panel", "Lcom/intellij/diff/tools/util/SimpleDiffPanel;", "prevNextDifferenceIterable", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchDiffViewer$MyPrevNextDifferenceIterable;", "project", "Lcom/intellij/openapi/project/Project;", "createToolbarActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "dispose", "", "getComponent", "Ljavax/swing/JComponent;", "getData", "", "dataId", "", "Lorg/jetbrains/annotations/NonNls;", "getEditors", "Lcom/intellij/openapi/editor/Editor;", "getPreferredFocusedComponent", "init", "Lcom/intellij/diff/FrameDiffTool$ToolbarComponents;", "onInit", "MyPrevNextDifferenceIterable", "intellij.platform.vcs.impl"})
public final class PatchDiffViewer
implements FrameDiffTool.DiffViewer,
DataProvider,
EditorDiffViewer {
    @NotNull
    private final DiffContext diffContext;
    @NotNull
    private final PatchDiffRequest diffRequest;
    @Nullable
    private final Project project;
    @NotNull
    private final SimpleDiffPanel panel;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final EditorHolder editorHolder;
    @NotNull
    private final MyPrevNextDifferenceIterable prevNextDifferenceIterable;
    @NotNull
    private final SetEditorSettingsAction editorSettingsAction;
    @NotNull
    private List<? extends PatchChangeBuilder.Hunk> hunks;

    public PatchDiffViewer(@NotNull DiffContext diffContext, @NotNull PatchDiffRequest diffRequest) {
        Intrinsics.checkNotNullParameter((Object)diffContext, (String)"diffContext");
        Intrinsics.checkNotNullParameter((Object)((Object)diffRequest), (String)"diffRequest");
        this.diffContext = diffContext;
        this.diffRequest = diffRequest;
        this.project = this.diffContext.getProject();
        this.hunks = new ArrayList();
        Document document2 = EditorFactory.getInstance().createDocument((CharSequence)"");
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"createDocument(...)");
        Document document3 = document2;
        EditorEx editorEx = DiffUtil.createEditor((Document)document3, (Project)this.project, (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
        this.editor = editorEx;
        DiffUtil.setEditorCodeStyle((Project)this.project, (EditorEx)this.editor, null);
        this.editorHolder = (EditorHolder)new TextEditorHolder(this.project, this.editor);
        Object[] objectArray = new String[]{this.diffRequest.getContentTitle1(), this.diffRequest.getContentTitle2()};
        List list2 = DiffUtil.createPatchTextTitles((FrameDiffTool.DiffViewer)this, (DiffRequest)this.diffRequest, (List)CollectionsKt.listOf((Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createPatchTextTitles(...)");
        List titles = CollectionsKt.filterNotNull((Iterable)list2);
        JComponent titlePanel2 = !((Collection)titles).isEmpty() ? DiffUtil.createStackedComponents((List)titles, (JBValue)DiffUtil.TITLE_GAP) : null;
        OnesideContentPanel onesideContentPanel = OnesideContentPanel.createFromHolder((EditorHolder)this.editorHolder);
        Intrinsics.checkNotNullExpressionValue((Object)onesideContentPanel, (String)"createFromHolder(...)");
        OnesideContentPanel contentPanel = onesideContentPanel;
        contentPanel.setTitle(titlePanel2);
        this.panel = new SimpleDiffPanel((JComponent)contentPanel, (DataProvider)this, this.diffContext);
        this.prevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = TextDiffViewerUtil.getTextSettings((DiffContext)this.diffContext);
        Intrinsics.checkNotNullExpressionValue((Object)textDiffSettings, (String)"getTextSettings(...)");
        this.editorSettingsAction = new SetEditorSettingsAction(textDiffSettings, this.getEditors());
        this.editorSettingsAction.applyDefaults();
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.panel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        return jComponent;
    }

    @NotNull
    public List<Editor> getEditors() {
        return CollectionsKt.listOf((Object)this.editor);
    }

    @NotNull
    public FrameDiffTool.ToolbarComponents init() {
        this.panel.setPersistentNotifications(DiffUtil.createCustomNotifications((FrameDiffTool.DiffViewer)this, (UserDataHolder)((UserDataHolder)this.diffContext), (UserDataHolder)((UserDataHolder)this.diffRequest)));
        this.onInit();
        FrameDiffTool.ToolbarComponents toolbarComponents = new FrameDiffTool.ToolbarComponents();
        toolbarComponents.toolbarActions = this.createToolbarActions();
        return toolbarComponents;
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.editorHolder));
    }

    private final void onInit() {
        PatchChangeBuilder patchChangeBuilder = new PatchChangeBuilder();
        List<PatchHunk> list2 = this.diffRequest.getPatch().getHunks();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getHunks(...)");
        PatchChangeBuilder.PatchState state = patchChangeBuilder.build(list2);
        this.hunks = state.getHunks();
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        Document patchDocument = (Document)documentEx;
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(patchDocument, state){
            final /* synthetic */ Document $patchDocument;
            final /* synthetic */ PatchChangeBuilder.PatchState $state;
            {
                this.$patchDocument = $patchDocument;
                this.$state = $state;
                super(0);
            }

            public final void invoke() {
                this.$patchDocument.setText((CharSequence)((Object)this.$state.getPatchContent()).toString());
            }
        }));
        this.editor.getGutter().setLineNumberConverter((LineNumberConverter)new LineNumberConverterAdapter(state.getLineConvertor1().createConvertor()), (LineNumberConverter)new LineNumberConverterAdapter(state.getLineConvertor2().createConvertor()));
        state.getSeparatorLines().forEach(arg_0 -> PatchDiffViewer.onInit$lambda$0(patchDocument, this, arg_0));
        for (PatchChangeBuilder.Hunk hunk : this.hunks) {
            List<DiffFragment> innerFragments = PatchChangeBuilder.Companion.computeInnerDifferences(patchDocument, hunk);
            DiffDrawUtil.createUnifiedChunkHighlighters((Editor)((Editor)this.editor), (LineRange)hunk.getPatchDeletionRange(), (LineRange)hunk.getPatchInsertionRange(), innerFragments);
        }
        this.editor.getGutterComponentEx().revalidateMarkup();
    }

    @RequiresEdt
    private final List<AnAction> createToolbarActions() {
        List group2 = new ArrayList();
        group2.add(this.editorSettingsAction);
        Separator separator = Separator.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)separator, (String)"getInstance(...)");
        group2.add(separator);
        AnAction anAction = ActionManager.getInstance().getAction("Diff.ViewerToolbar");
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getAction(...)");
        group2.add(anAction);
        return group2;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.project;
        }
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.prevNextDifferenceIterable;
        }
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.editor;
        }
        if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId)) {
            return this.prevNextDifferenceIterable.getCurrentLineRange();
        }
        return null;
    }

    private static final void onInit$lambda$0(Document $patchDocument, PatchDiffViewer this$0, int line) {
        Intrinsics.checkNotNullParameter((Object)$patchDocument, (String)"$patchDocument");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int offset = $patchDocument.getLineStartOffset(line);
        DiffDrawUtil.createLineSeparatorHighlighter((Editor)((Editor)this$0.editor), (int)offset, (int)offset);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchDiffViewer$MyPrevNextDifferenceIterable;", "Lcom/intellij/diff/tools/util/PrevNextDifferenceIterableBase;", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk;", "(Lcom/intellij/openapi/vcs/changes/patch/tool/PatchDiffViewer;)V", "getChanges", "", "getEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getEndLine", "", "change", "getStartLine", "intellij.platform.vcs.impl"})
    private final class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<PatchChangeBuilder.Hunk> {
        @NotNull
        protected List<PatchChangeBuilder.Hunk> getChanges() {
            return PatchDiffViewer.this.hunks;
        }

        @NotNull
        protected EditorEx getEditor() {
            return PatchDiffViewer.this.editor;
        }

        protected int getStartLine(@NotNull PatchChangeBuilder.Hunk change) {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            return change.getPatchDeletionRange().start;
        }

        protected int getEndLine(@NotNull PatchChangeBuilder.Hunk change) {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            return change.getPatchInsertionRange().end;
        }
    }
}

