/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.ChangeListGroupingStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.DateChangeListGroupingStrategy;
import com.intellij.openapi.vcs.changes.committed.LabeledComboBoxAction;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SelectGroupingAction
extends LabeledComboBoxAction
implements DumbAware {
    @NotNull
    private final Project myProject;
    @NotNull
    private final CommittedChangesTreeBrowser myBrowser;

    public SelectGroupingAction(@NotNull Project project2, @NotNull CommittedChangesTreeBrowser browser) {
        if (project2 == null) {
            SelectGroupingAction.$$$reportNull$$$0(0);
        }
        if (browser == null) {
            SelectGroupingAction.$$$reportNull$$$0(1);
        }
        super(VcsBundle.message("committed.changes.group.title", new Object[0]));
        this.myProject = project2;
        this.myBrowser = browser;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            SelectGroupingAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SelectGroupingAction.$$$reportNull$$$0(3);
        }
        e.getPresentation().setText(this.myBrowser.getGroupingStrategy().toString());
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button, @NotNull DataContext context) {
        if (button == null) {
            SelectGroupingAction.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SelectGroupingAction.$$$reportNull$$$0(5);
        }
        return new DefaultActionGroup(ContainerUtil.map(this.collectStrategies(), (Function)((NotNullFunction)strategy -> new SetGroupingAction((ChangeListGroupingStrategy)strategy))));
    }

    @NotNull
    protected Condition<AnAction> getPreselectCondition() {
        Condition condition = action2 -> ((SetGroupingAction)action2).myStrategy.equals(this.myBrowser.getGroupingStrategy());
        if (condition == null) {
            SelectGroupingAction.$$$reportNull$$$0(6);
        }
        return condition;
    }

    @NotNull
    private List<ChangeListGroupingStrategy> collectStrategies() {
        ArrayList<ChangeListGroupingStrategy> result2 = new ArrayList<ChangeListGroupingStrategy>();
        result2.add(new DateChangeListGroupingStrategy());
        result2.add(ChangeListGroupingStrategy.USER);
        for (AbstractVcs vcs : ProjectLevelVcsManager.getInstance(this.myProject).getAllActiveVcss()) {
            CommittedChangesProvider<CommittedChangeList, ?> provider2 = vcs.getCommittedChangesProvider();
            if (provider2 == null) continue;
            for (ChangeListColumn column : provider2.getColumns()) {
                if (!ChangeListColumn.isCustom(column) || column.getComparator() == null) continue;
                result2.add(new CustomChangeListColumnGroupingStrategy(column));
            }
        }
        ArrayList<ChangeListGroupingStrategy> arrayList = result2;
        if (arrayList == null) {
            SelectGroupingAction.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/SelectGroupingAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/SelectGroupingAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreselectCondition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectStrategies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 6, 7 -> new IllegalStateException(string2);
        };
    }

    private static final class CustomChangeListColumnGroupingStrategy
    implements ChangeListGroupingStrategy {
        @NotNull
        private final ChangeListColumn<CommittedChangeList> myColumn;

        private CustomChangeListColumnGroupingStrategy(@NotNull ChangeListColumn column) {
            if (column == null) {
                CustomChangeListColumnGroupingStrategy.$$$reportNull$$$0(0);
            }
            this.myColumn = column;
        }

        @Override
        public void beforeStart() {
        }

        @Override
        public boolean changedSinceApply() {
            return false;
        }

        @Override
        public String getGroupName(@NotNull CommittedChangeList changeList) {
            Object value2;
            if (changeList == null) {
                CustomChangeListColumnGroupingStrategy.$$$reportNull$$$0(1);
            }
            return (value2 = this.myColumn.getValue(changeList)) != null ? value2.toString() : null;
        }

        @Override
        public Comparator<CommittedChangeList> getComparator() {
            return this.myColumn.getComparator();
        }

        @Override
        public String toString() {
            return this.myColumn.getTitle();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeList";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/SelectGroupingAction$CustomChangeListColumnGroupingStrategy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getGroupName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class SetGroupingAction
    extends DumbAwareAction {
        @NotNull
        private final ChangeListGroupingStrategy myStrategy;

        private SetGroupingAction(ChangeListGroupingStrategy strategy) {
            if (strategy == null) {
                SetGroupingAction.$$$reportNull$$$0(0);
            }
            super(strategy.toString());
            this.myStrategy = strategy;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SetGroupingAction.$$$reportNull$$$0(1);
            }
            SelectGroupingAction.this.myBrowser.setGroupingStrategy(this.myStrategy);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strategy";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/SelectGroupingAction$SetGroupingAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

