/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.editor.DiffEditorViewerFileEditor;
import com.intellij.diff.editor.DiffVirtualFile;
import com.intellij.diff.editor.DiffVirtualFileWithTabName;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.ide.actions.SplitAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.changes.DiffPreviewProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreviewDiffVirtualFile
extends DiffVirtualFile
implements DiffVirtualFileWithTabName {
    @NotNull
    private final DiffPreviewProvider myProvider;

    public PreviewDiffVirtualFile(@NotNull DiffPreviewProvider provider2) {
        if (provider2 == null) {
            PreviewDiffVirtualFile.$$$reportNull$$$0(0);
        }
        super("DiffPreview");
        this.myProvider = provider2;
        this.putUserData(SplitAction.FORBID_TAB_SPLIT, true);
    }

    public boolean isValid() {
        Object owner = this.myProvider.getOwner();
        if (!(owner instanceof Disposable)) {
            return true;
        }
        return !Disposer.isDisposed((Disposable)((Disposable)owner));
    }

    @NotNull
    public DiffRequestProcessor createProcessor(@NotNull Project project2) {
        if (project2 == null) {
            PreviewDiffVirtualFile.$$$reportNull$$$0(1);
        }
        DiffRequestProcessor diffRequestProcessor = this.myProvider.createDiffRequestProcessor();
        if (diffRequestProcessor == null) {
            PreviewDiffVirtualFile.$$$reportNull$$$0(2);
        }
        return diffRequestProcessor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PreviewDiffVirtualFile file = (PreviewDiffVirtualFile)((Object)o);
        return this.myProvider.getOwner().equals(file.myProvider.getOwner());
    }

    public int hashCode() {
        return Objects.hash(this.myProvider.getOwner());
    }

    @NotNull
    public String toString() {
        String string2 = super.toString() + ":" + this.myProvider;
        if (string2 == null) {
            PreviewDiffVirtualFile.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    public DiffPreviewProvider getProvider() {
        DiffPreviewProvider diffPreviewProvider = this.myProvider;
        if (diffPreviewProvider == null) {
            PreviewDiffVirtualFile.$$$reportNull$$$0(4);
        }
        return diffPreviewProvider;
    }

    @Nullable
    @NlsContexts.TabTitle
    public String getEditorTabName(@NotNull Project project2, @NotNull List<? extends FileEditor> editors) {
        DiffEditorViewerFileEditor editor;
        if (project2 == null) {
            PreviewDiffVirtualFile.$$$reportNull$$$0(5);
        }
        if (editors == null) {
            PreviewDiffVirtualFile.$$$reportNull$$$0(6);
        }
        DiffRequestProcessor processor2 = (editor = (DiffEditorViewerFileEditor)ContainerUtil.findInstance(editors, DiffEditorViewerFileEditor.class)) != null ? (DiffRequestProcessor)ObjectUtils.tryCast((Object)editor.getEditorViewer(), DiffRequestProcessor.class) : null;
        return this.myProvider.getEditorTabName(processor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/PreviewDiffVirtualFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/PreviewDiffVirtualFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createProcessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTabName";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4 -> new IllegalStateException(string2);
        };
    }
}

