/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.view.focusview;

import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBuilderFactory;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.builder.components.CustomGraphBuilderWheelListener;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.BaseGraphViewControllerMode;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.GraphBuilderDisplay;
import com.intellij.openapi.graph.view.GraphViewControllerBuilder;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.ModelViewManager;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.focusview.GraphFocusViewProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseGraphFocusView<N, E>
implements GraphFocusViewProvider<N, E> {
    private GraphBuilder<N, E> myModelBuilder;
    private GraphBuilder<N, E> myFocusViewBuilder;
    private ModelViewManager myModelViewManager;
    private FocusViewGraphBuilderUpdater myGraphBuilderUpdater;
    private SimpleModificationTracker myModTrackerOfViewUpdates;

    @NotNull
    protected abstract Graph2D createFocusGraph(@NotNull GraphBuilder<N, E> var1);

    protected abstract void customizeViewSettings(@NotNull Graph2DView var1, @NotNull EditMode var2, @NotNull GraphSettings var3, @NotNull GraphBuilder<N, E> var4);

    @Override
    public void setupAndEnableFocusViewFor(@NotNull GraphBuilder<N, E> modelBuilder) {
        if (modelBuilder == null) {
            BaseGraphFocusView.$$$reportNull$$$0(0);
        }
        this.myModelBuilder = modelBuilder;
        this.myModelViewManager = ModelViewManager.Statics.getInstance(modelBuilder.getGraph());
        Graph2D focusViewGraph = this.createFocusGraph(modelBuilder);
        Graph2DView focusView = this.createFocusView(modelBuilder, focusViewGraph);
        EditMode editModeForFocusView = this.createEditModeForFocusView(modelBuilder);
        this.myModTrackerOfViewUpdates = new SimpleModificationTracker();
        this.myFocusViewBuilder = this.createAndSetupFocusViewBuilder(modelBuilder, focusViewGraph, focusView, editModeForFocusView);
        this.setupViewControllers(editModeForFocusView);
        this.updateColors(focusView, modelBuilder.getView());
        this.updateFocusViewGraph(Collections.emptyList());
        GraphLayoutService.getInstance().queryLayout(this.myFocusViewBuilder).runAsync().thenRunAsync(() -> this.getGraphViewDisplay(modelBuilder).orElseThrow().setCurrentViewBuilder(this.myFocusViewBuilder), Futures.inEdt());
    }

    @Override
    public void dropCurrentFocusView() {
        if (this.myModelBuilder == null || GraphFocusViewProvider.getActiveFocusViewProviderFor(this.myModelBuilder) != this) {
            return;
        }
        Graph2D focusGraph = this.getFocusViewBuilder().getGraph();
        this.getFocusViewManager().removeViewGraph(this.getFocusViewBuilder().getGraph());
        focusGraph.clear();
        this.myModelBuilder.removeCustomUpdater(this.myGraphBuilderUpdater);
        this.getGraphViewDisplay(this.myModelBuilder).orElseThrow().setCurrentViewBuilder(this.myModelBuilder);
        this.myModelBuilder.putUserData(ACTIVE_FOCUS_VIEW_PROVIDER_KEY, null);
        this.myModelBuilder = null;
        this.myModelViewManager = null;
        Disposer.dispose(this.myFocusViewBuilder);
        this.myFocusViewBuilder = null;
        this.myGraphBuilderUpdater = null;
        this.myModTrackerOfViewUpdates = null;
    }

    public void dispose() {
        this.dropCurrentFocusView();
    }

    @NotNull
    protected Optional<GraphBuilderDisplay> getGraphViewDisplay(@NotNull GraphBuilder<N, E> modelBuilder) {
        if (modelBuilder == null) {
            BaseGraphFocusView.$$$reportNull$$$0(1);
        }
        Optional<GraphBuilderDisplay> optional = Optional.ofNullable((BasicGraphPresentationModel)ObjectUtils.tryCast(modelBuilder.getGraphPresentationModel(), BasicGraphPresentationModel.class)).map(it -> it.getGraphViewDisplay());
        if (optional == null) {
            BaseGraphFocusView.$$$reportNull$$$0(2);
        }
        return optional;
    }

    @NotNull
    protected GraphBuilder<N, E> createAndSetupFocusViewBuilder(@NotNull GraphBuilder<N, E> modelBuilder, @NotNull Graph2D focusViewGraph, @NotNull Graph2DView focusView, @NotNull EditMode editModeForFocusView) {
        if (modelBuilder == null) {
            BaseGraphFocusView.$$$reportNull$$$0(3);
        }
        if (focusViewGraph == null) {
            BaseGraphFocusView.$$$reportNull$$$0(4);
        }
        if (focusView == null) {
            BaseGraphFocusView.$$$reportNull$$$0(5);
        }
        if (editModeForFocusView == null) {
            BaseGraphFocusView.$$$reportNull$$$0(6);
        }
        FocusViewGraphDataModel dataModel = new FocusViewGraphDataModel(focusViewGraph);
        FocusViewGraphPresentationModel presentationModel = new FocusViewGraphPresentationModel(focusViewGraph);
        GraphBuilder focusViewBuilder = GraphBuilderFactory.getInstance(modelBuilder.getProject()).createGraphBuilder(focusViewGraph, focusView, dataModel, presentationModel, editModeForFocusView);
        presentationModel.setGraphBuilder(focusViewBuilder);
        focusViewBuilder.putUserData((Key)GraphDataKeys.MODEL_GRAPH_BUILDER, this.getModelBuilder());
        this.getModelBuilder().putUserData(ACTIVE_FOCUS_VIEW_PROVIDER_KEY, this);
        focusViewBuilder.initialize();
        this.setupFocusViewModelUpdate(modelBuilder, focusViewBuilder);
        GraphBuilder graphBuilder = focusViewBuilder;
        if (graphBuilder == null) {
            BaseGraphFocusView.$$$reportNull$$$0(7);
        }
        return graphBuilder;
    }

    protected void setupBackgroundRenderer(@NotNull Graph2DView view) {
        if (view == null) {
            BaseGraphFocusView.$$$reportNull$$$0(8);
        }
        DefaultBackgroundRenderer renderer2 = GraphManager.getGraphManager().createDefaultBackgroundRenderer(view);
        renderer2.setColor(UIUtil.getListBackground());
        view.setBackgroundRenderer(renderer2);
    }

    @NotNull
    protected Graph2DView createFocusView(@NotNull GraphBuilder<N, E> modelBuilder, @NotNull Graph2D focusViewGraph) {
        if (modelBuilder == null) {
            BaseGraphFocusView.$$$reportNull$$$0(9);
        }
        if (focusViewGraph == null) {
            BaseGraphFocusView.$$$reportNull$$$0(10);
        }
        Graph2DView view = GraphManager.getGraphManager().createGraph2DView(focusViewGraph);
        this.setupBackgroundRenderer(view);
        view.setFitContentOnResize(false);
        view.setScrollBarPolicy(20, 30);
        Graph2DView graph2DView = view;
        if (graph2DView == null) {
            BaseGraphFocusView.$$$reportNull$$$0(11);
        }
        return graph2DView;
    }

    protected void updateColors(@NotNull Graph2DView focusView, @NotNull Graph2DView modelView) {
        if (focusView == null) {
            BaseGraphFocusView.$$$reportNull$$$0(12);
        }
        if (modelView == null) {
            BaseGraphFocusView.$$$reportNull$$$0(13);
        }
        focusView.setGridColor(modelView.getGridColor());
        focusView.setCoarseGridColor(modelView.getCoarseGridColor());
        BaseGraphFocusView.copyClientProperty(modelView.getJComponent(), focusView.getJComponent(), "selectionbox.fillcolor");
        BaseGraphFocusView.copyClientProperty(modelView.getJComponent(), focusView.getJComponent(), "selectionbox.linecolor");
        BaseGraphFocusView.copyClientProperty(modelView.getJComponent(), focusView.getJComponent(), "magnifier.linecolor");
    }

    @NotNull
    protected EditMode createEditModeForFocusView(@NotNull GraphBuilder<N, E> modelBuilder) {
        if (modelBuilder == null) {
            BaseGraphFocusView.$$$reportNull$$$0(14);
        }
        EditMode editMode = GraphEditModeFactory.getInstance(modelBuilder.getProject()).createEditMode(modelBuilder);
        editMode.allowNodeCreation(false);
        editMode.allowEdgeCreation(false);
        editMode.allowBendCreation(false);
        editMode.allowNodeEditing(true);
        editMode.allowResizeNodes(true);
        editMode.allowMoveLabels(false);
        editMode.allowMovePorts(true);
        editMode.allowLabelSelection(true);
        editMode.allowMoveSelection(true);
        editMode.allowMoving(true);
        editMode.allowMovingWithPopup(true);
        editMode.setAdjustScrollBarPolicy(false);
        editMode.showEdgeTips(true);
        editMode.showNodeTips(true);
        EditMode editMode2 = editMode;
        if (editMode2 == null) {
            BaseGraphFocusView.$$$reportNull$$$0(15);
        }
        return editMode2;
    }

    protected void setupFocusViewModelUpdate(@NotNull GraphBuilder<N, E> modelBuilder, @NotNull GraphBuilder<N, E> focusViewBuilder) {
        if (modelBuilder == null) {
            BaseGraphFocusView.$$$reportNull$$$0(16);
        }
        if (focusViewBuilder == null) {
            BaseGraphFocusView.$$$reportNull$$$0(17);
        }
        this.myGraphBuilderUpdater = new FocusViewGraphBuilderUpdater();
        modelBuilder.addCustomUpdater(this.myGraphBuilderUpdater);
        focusViewBuilder.addCustomUpdater(this.myGraphBuilderUpdater);
    }

    @RequiresEdt
    protected void setupViewControllers(@NotNull EditMode editMode) {
        if (editMode == null) {
            BaseGraphFocusView.$$$reportNull$$$0(18);
        }
        ThreadingAssertions.assertEventDispatchThread();
        MagnifierViewMode magnifierViewMode = new MagnifierViewMode();
        magnifierViewMode.setMagnifierRadius(200);
        ((FocusGraphViewControllerBuilder)((FocusGraphViewControllerBuilder)FocusGraphViewControllerBuilder.beginSetupFor(this.myFocusViewBuilder).setEditMode(editMode)).setMagnifierViewMode(magnifierViewMode)).endSetup();
    }

    @NotNull
    public GraphBuilder<N, E> getModelBuilder() {
        GraphBuilder<N, E> graphBuilder = this.myModelBuilder;
        if (graphBuilder == null) {
            BaseGraphFocusView.$$$reportNull$$$0(19);
        }
        return graphBuilder;
    }

    @NotNull
    public GraphBuilder<N, E> getFocusViewBuilder() {
        GraphBuilder<N, E> graphBuilder = this.myFocusViewBuilder;
        if (graphBuilder == null) {
            BaseGraphFocusView.$$$reportNull$$$0(20);
        }
        return graphBuilder;
    }

    @NotNull
    protected Optional<N> getModelGraphNodeObject(@Nullable Node node) {
        Optional<Object> optional = Optional.ofNullable(node).map(it -> this.getFocusViewManager().getModelNode((Node)it)).map(it -> this.getModelBuilder().getNodeObject((Node)it));
        if (optional == null) {
            BaseGraphFocusView.$$$reportNull$$$0(21);
        }
        return optional;
    }

    @NotNull
    protected Optional<E> getModelGraphEdgeObject(@Nullable Edge edge) {
        Optional<Object> optional = Optional.ofNullable(edge).map(it -> this.getFocusViewManager().getModelEdge((Edge)it)).map(it -> this.getModelBuilder().getEdgeObject((Edge)it));
        if (optional == null) {
            BaseGraphFocusView.$$$reportNull$$$0(22);
        }
        return optional;
    }

    @NotNull
    public JComponent getCanvasComponent() {
        JComponent jComponent = this.myFocusViewBuilder.getView().getJComponent();
        if (jComponent == null) {
            BaseGraphFocusView.$$$reportNull$$$0(23);
        }
        return jComponent;
    }

    @NotNull
    public Graph2DView getGraph2DView() {
        Graph2DView graph2DView = this.myFocusViewBuilder.getView();
        if (graph2DView == null) {
            BaseGraphFocusView.$$$reportNull$$$0(24);
        }
        return graph2DView;
    }

    @NotNull
    public ModelViewManager getFocusViewManager() {
        ModelViewManager modelViewManager = this.myModelViewManager;
        if (modelViewManager == null) {
            BaseGraphFocusView.$$$reportNull$$$0(25);
        }
        return modelViewManager;
    }

    protected void updateFocusViewGraph(@NotNull Collection<?> nodesForSizeUpdate) {
        if (nodesForSizeUpdate == null) {
            BaseGraphFocusView.$$$reportNull$$$0(26);
        }
        this.myModelViewManager.synchronizeModelToViewGraph(this.myFocusViewBuilder.getGraph());
        Map<Object, Node> modelNode2Node = Arrays.stream(this.myFocusViewBuilder.getGraph().getNodeArray()).map(it -> Pair.create(this.getModelGraphNodeObject((Node)it).orElseThrow(), (Object)it)).collect(Collectors.toMap(it -> it.first, it -> (Node)it.second));
        Map<Object, Edge> modelEdge2Edge = Arrays.stream(this.myFocusViewBuilder.getGraph().getEdgeArray()).map(it -> Pair.create(this.getModelGraphEdgeObject((Edge)it).orElseThrow(), (Object)it)).collect(Collectors.toMap(it -> it.first, it -> (Edge)it.second));
        this.myFocusViewBuilder.updateDataModelWithCustomMapping(modelNode2Node::get, modelEdge2Edge::get);
        this.myFocusViewBuilder.queryGraphUpdate().withNodeSizeUpdate(nodesForSizeUpdate.toArray()).run();
    }

    private static void copyClientProperty(@NotNull JComponent source2, @NotNull JComponent target, @NotNull String key2) {
        if (source2 == null) {
            BaseGraphFocusView.$$$reportNull$$$0(27);
        }
        if (target == null) {
            BaseGraphFocusView.$$$reportNull$$$0(28);
        }
        if (key2 == null) {
            BaseGraphFocusView.$$$reportNull$$$0(29);
        }
        target.putClientProperty(key2, source2.getClientProperty(key2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 11, 15, 19, 20, 21, 22, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelBuilder";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusViewGraph";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusView";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editModeForFocusView";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelView";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusViewBuilder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editMode";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesForSizeUpdate";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphViewDisplay";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndSetupFocusViewBuilder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFocusView";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditModeForFocusView";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelBuilder";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusViewBuilder";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelGraphNodeObject";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelGraphEdgeObject";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanvasComponent";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph2DView";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusViewManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupAndEnableFocusViewFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getGraphViewDisplay";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAndSetupFocusViewBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupBackgroundRenderer";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFocusView";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateColors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createEditModeForFocusView";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setupFocusViewModelUpdate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setupViewControllers";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updateFocusViewGraph";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "copyClientProperty";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 7, 11, 15, 19, 20, 21, 22, 23, 24, 25 -> new IllegalStateException(string2);
        };
    }

    protected final class FocusViewGraphBuilderUpdater
    extends CustomGraphUpdater {
        private boolean myRecursionGuardCheck = false;

        protected FocusViewGraphBuilderUpdater() {
        }

        @Override
        public void update(@NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull Collection<?> nodesForSizeUpdate) {
            if (graph == null) {
                FocusViewGraphBuilderUpdater.$$$reportNull$$$0(0);
            }
            if (view == null) {
                FocusViewGraphBuilderUpdater.$$$reportNull$$$0(1);
            }
            if (nodesForSizeUpdate == null) {
                FocusViewGraphBuilderUpdater.$$$reportNull$$$0(2);
            }
            if (!this.myRecursionGuardCheck) {
                this.myRecursionGuardCheck = true;
                BaseGraphFocusView.this.myModTrackerOfViewUpdates.incModificationCount();
                BaseGraphFocusView.this.updateFocusViewGraph(nodesForSizeUpdate);
            }
            this.myRecursionGuardCheck = false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "graph";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "view";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "nodesForSizeUpdate";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView$FocusViewGraphBuilderUpdater";
            objectArray[2] = "update";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class FocusViewGraphDataModel
    extends GraphDataModel<N, E> {
        @NotNull
        private final Graph2D myFocusViewGraph;

        public FocusViewGraphDataModel(Graph2D graph) {
            if (graph == null) {
                FocusViewGraphDataModel.$$$reportNull$$$0(0);
            }
            this.myFocusViewGraph = graph;
        }

        @Override
        @NotNull
        public Collection<N> getNodes() {
            List list2 = ContainerUtil.mapNotNull((Object[])this.myFocusViewGraph.getNodeArray(), it -> BaseGraphFocusView.this.getModelGraphNodeObject((Node)it).orElse(null));
            if (list2 == null) {
                FocusViewGraphDataModel.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Override
        @NotNull
        public Collection<E> getEdges() {
            List list2 = ContainerUtil.mapNotNull((Object[])this.myFocusViewGraph.getEdgeArray(), it -> BaseGraphFocusView.this.getModelGraphEdgeObject((Edge)it).orElse(null));
            if (list2 == null) {
                FocusViewGraphDataModel.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        @NotNull
        public N getSourceNode(E edge) {
            Object n = BaseGraphFocusView.this.getModelBuilder().getGraphDataModel().getSourceNode(edge);
            if (n == null) {
                FocusViewGraphDataModel.$$$reportNull$$$0(3);
            }
            return n;
        }

        @Override
        @NotNull
        public N getTargetNode(E edge) {
            Object n = BaseGraphFocusView.this.getModelBuilder().getGraphDataModel().getTargetNode(edge);
            if (n == null) {
                FocusViewGraphDataModel.$$$reportNull$$$0(4);
            }
            return n;
        }

        @Override
        @NotNull
        public String getNodeName(N node) {
            String string2 = BaseGraphFocusView.this.getModelBuilder().getGraphDataModel().getNodeName(node);
            if (string2 == null) {
                FocusViewGraphDataModel.$$$reportNull$$$0(5);
            }
            return string2;
        }

        @Override
        @NotNull
        public String getEdgeName(E edge) {
            String string2 = BaseGraphFocusView.this.getModelBuilder().getGraphDataModel().getEdgeName(edge);
            if (string2 == null) {
                FocusViewGraphDataModel.$$$reportNull$$$0(6);
            }
            return string2;
        }

        @Override
        @Nullable
        public E createEdge(@NotNull N from, @NotNull N to) {
            if (from == null) {
                FocusViewGraphDataModel.$$$reportNull$$$0(7);
            }
            if (to == null) {
                FocusViewGraphDataModel.$$$reportNull$$$0(8);
            }
            return null;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graph";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView$FocusViewGraphDataModel";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView$FocusViewGraphDataModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdges";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetNode";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdgeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createEdge";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string2);
            };
        }
    }

    protected final class FocusViewGraphPresentationModel
    extends BasicGraphPresentationModel<N, E> {
        public FocusViewGraphPresentationModel(Graph graph) {
            if (graph == null) {
                FocusViewGraphPresentationModel.$$$reportNull$$$0(0);
            }
            super(graph);
        }

        @Override
        @NotNull
        public NodeRealizer getNodeRealizer(@Nullable N node) {
            NodeRealizer nodeRealizer = BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().getNodeRealizer(this.getGraphBuilder(), node);
            if (nodeRealizer == null) {
                FocusViewGraphPresentationModel.$$$reportNull$$$0(1);
            }
            return nodeRealizer;
        }

        @Override
        @NotNull
        public EdgeRealizer getEdgeRealizer(@Nullable E edge) {
            EdgeRealizer edgeRealizer = BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().getEdgeRealizer(this.getSettings().getCurrentEdgeRealizerProvider(), edge);
            if (edgeRealizer == null) {
                FocusViewGraphPresentationModel.$$$reportNull$$$0(2);
            }
            return edgeRealizer;
        }

        @Override
        @Nullable
        public String getNodeTooltip(@Nullable N node) {
            return BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().getNodeTooltip(node);
        }

        @Override
        @Nullable
        public String getEdgeTooltip(@Nullable E edge) {
            return BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().getEdgeTooltip(edge);
        }

        @Override
        @NotNull
        protected DefaultActionGroup getCommonActionGroup() {
            DefaultActionGroup defaultActionGroup = BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().getPaperActionGroup();
            if (defaultActionGroup == null) {
                FocusViewGraphPresentationModel.$$$reportNull$$$0(3);
            }
            return defaultActionGroup;
        }

        @Override
        public EdgeLabel @NotNull [] getEdgeLabels(@Nullable E edge, @NotNull String edgeName) {
            if (edgeName == null) {
                FocusViewGraphPresentationModel.$$$reportNull$$$0(4);
            }
            EdgeLabel[] edgeLabelArray = BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().getEdgeLabels(edge, edgeName);
            if (edgeLabelArray == null) {
                FocusViewGraphPresentationModel.$$$reportNull$$$0(5);
            }
            return edgeLabelArray;
        }

        @Override
        public void customizeSettings(@NotNull Graph2DView view, @NotNull EditMode editMode) {
            if (view == null) {
                FocusViewGraphPresentationModel.$$$reportNull$$$0(6);
            }
            if (editMode == null) {
                FocusViewGraphPresentationModel.$$$reportNull$$$0(7);
            }
            BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().customizeSettings(view, editMode);
            this.getSettings().setFrom(BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().getSettings());
            BaseGraphFocusView.this.customizeViewSettings(view, editMode, this.getSettings(), BaseGraphFocusView.this.getModelBuilder());
        }

        @Override
        public void customizeSettings(@NotNull GraphBuilder<N, E> builder2) {
            if (builder2 == null) {
                FocusViewGraphPresentationModel.$$$reportNull$$$0(8);
            }
            BaseGraphFocusView.this.getModelBuilder().getGraphPresentationModel().customizeSettings(builder2);
            BaseGraphFocusView.this.customizeViewSettings(builder2.getView(), builder2.getEditMode(), this.getSettings(), BaseGraphFocusView.this.getModelBuilder());
        }

        @Override
        public void dispose() {
        }

        @Override
        @NotNull
        public ModificationTracker getModificationTrackerOfViewUpdates() {
            SimpleModificationTracker simpleModificationTracker = BaseGraphFocusView.this.myModTrackerOfViewUpdates;
            if (simpleModificationTracker == null) {
                FocusViewGraphPresentationModel.$$$reportNull$$$0(9);
            }
            return simpleModificationTracker;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 5, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graph";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView$FocusViewGraphPresentationModel";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edgeName";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editMode";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView$FocusViewGraphPresentationModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeRealizer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdgeRealizer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommonActionGroup";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdgeLabels";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModificationTrackerOfViewUpdates";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 9: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getEdgeLabels";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeSettings";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 2, 3, 5, 9 -> new IllegalStateException(string2);
            };
        }
    }

    protected static final class FocusGraphViewControllerBuilder<N, E>
    extends GraphViewControllerBuilder<FocusGraphViewControllerBuilder<N, E>> {
        private FocusGraphViewControllerBuilder(@NotNull GraphBuilder<N, E> focusViewBuilder, @NotNull EventDispatcher<GraphBuilderListener> dispatcher) {
            if (focusViewBuilder == null) {
                FocusGraphViewControllerBuilder.$$$reportNull$$$0(0);
            }
            if (dispatcher == null) {
                FocusGraphViewControllerBuilder.$$$reportNull$$$0(1);
            }
            super(focusViewBuilder, dispatcher);
        }

        @NotNull
        public static <N, E> FocusGraphViewControllerBuilder<N, E> beginSetupFor(@NotNull GraphBuilder<N, E> graphBuilder) {
            if (graphBuilder == null) {
                FocusGraphViewControllerBuilder.$$$reportNull$$$0(2);
            }
            return new FocusGraphViewControllerBuilder<N, E>(graphBuilder, GraphBuilderFactory.getInstance(graphBuilder.getProject()).getGraphBuilderDispatcher(graphBuilder));
        }

        @Override
        @NotNull
        protected FocusGraphViewControllerBuilder<N, E> self() {
            FocusGraphViewControllerBuilder focusGraphViewControllerBuilder = this;
            if (focusGraphViewControllerBuilder == null) {
                FocusGraphViewControllerBuilder.$$$reportNull$$$0(3);
            }
            return focusGraphViewControllerBuilder;
        }

        @Override
        public void endSetup() {
            this.setEditModeConstituents(this.getEditMode());
            Graph2DView view = this.getBuilder().getView();
            JComponent canvas = view.getCanvasComponent();
            BaseGraphViewControllerMode controllerMode = new BaseGraphViewControllerMode(this.getBuilder(), this.getDispatcher(), this.getEditMode(), this.getNavigationMode(), this.getMagnifierViewMode());
            view.addViewMode(controllerMode);
            controllerMode.setupKeyBindingsTo(canvas);
            canvas.addFocusListener(controllerMode);
            canvas.addMouseWheelListener(new CustomGraphBuilderWheelListener(this.getBuilder()));
            controllerMode.initialize();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focusViewBuilder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dispatcher";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graphBuilder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView$FocusGraphViewControllerBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/view/focusview/BaseGraphFocusView$FocusGraphViewControllerBuilder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "self";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "beginSetupFor";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }
}

