/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.services;

import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.view.Graph2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.jcip.annotations.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphSelectionService {
    @NotNull
    private static final GraphSelectionService INSTANCE = new GraphSelectionService();
    @GuardedBy(value="this")
    @NotNull
    private final Map<GraphBuilder<?, ?>, List<Consumer<? super Rectangle>>> myOneTimeSelectionCallbacks = new HashMap();
    @NotNull
    private final Set<GraphBuilder<?, ?>> myGraphBuilderWithSuppressedSelection = Collections.synchronizedSet(new HashSet());

    @NotNull
    public static GraphSelectionService getInstance() {
        GraphSelectionService graphSelectionService = INSTANCE;
        if (graphSelectionService == null) {
            GraphSelectionService.$$$reportNull$$$0(0);
        }
        return graphSelectionService;
    }

    private GraphSelectionService() {
    }

    public boolean anyNodeOrEdgeSelected(@NotNull Graph2D graph) {
        if (graph == null) {
            GraphSelectionService.$$$reportNull$$$0(1);
        }
        return this.hasSelectedNodes(graph) || this.hasSelectedEdges(graph);
    }

    public boolean hasSelectedNodes(@NotNull Graph2D graph) {
        if (graph == null) {
            GraphSelectionService.$$$reportNull$$$0(2);
        }
        return graph.selectedNodes().ok();
    }

    public void forEachSelectedNode(@NotNull Graph2D graph, @NotNull Consumer<? super Node> consumer) {
        if (graph == null) {
            GraphSelectionService.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            GraphSelectionService.$$$reportNull$$$0(4);
        }
        NodeCursor cursor = graph.selectedNodes();
        while (cursor.ok()) {
            consumer.accept(cursor.node());
            cursor.next();
        }
    }

    public <N> void forEachSelectedModelNode(@NotNull GraphBuilder<N, ?> builder2, @NotNull Consumer<? super N> consumer) {
        if (builder2 == null) {
            GraphSelectionService.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            GraphSelectionService.$$$reportNull$$$0(6);
        }
        NodeCursor cursor = builder2.getGraph().selectedNodes();
        while (cursor.ok()) {
            N modelNode = builder2.getNodeObject(cursor.node());
            if (modelNode != null) {
                consumer.accept(modelNode);
            }
            cursor.next();
        }
    }

    @NotNull
    public List<Node> getSelectedNodes(@NotNull Graph2D graph) {
        if (graph == null) {
            GraphSelectionService.$$$reportNull$$$0(7);
        }
        ArrayList<Node> result2 = new ArrayList<Node>();
        NodeCursor cursor = graph.selectedNodes();
        while (cursor.ok()) {
            result2.add(cursor.node());
            cursor.next();
        }
        ArrayList<Node> arrayList = result2;
        if (arrayList == null) {
            GraphSelectionService.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public <N> List<N> getSelectedModelNodes(@NotNull GraphBuilder<N, ?> builder2) {
        if (builder2 == null) {
            GraphSelectionService.$$$reportNull$$$0(9);
        }
        ArrayList<N> result2 = new ArrayList<N>();
        NodeCursor cursor = builder2.getGraph().selectedNodes();
        while (cursor.ok()) {
            N modelNode = builder2.getNodeObject(cursor.node());
            if (modelNode != null) {
                result2.add(modelNode);
            }
            cursor.next();
        }
        ArrayList<N> arrayList = result2;
        if (arrayList == null) {
            GraphSelectionService.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Nullable
    public Node getSingleSelectedNode(@NotNull Graph2D graph) {
        NodeCursor cursor;
        if (graph == null) {
            GraphSelectionService.$$$reportNull$$$0(11);
        }
        if ((cursor = graph.selectedNodes()).ok()) {
            Node node = cursor.node();
            cursor.next();
            if (!cursor.ok()) {
                return node;
            }
        }
        return null;
    }

    @Nullable
    public <N> N getSingleSelectedModelNode(@NotNull GraphBuilder<N, ?> builder2) {
        if (builder2 == null) {
            GraphSelectionService.$$$reportNull$$$0(12);
        }
        return builder2.getNodeObject(this.getSingleSelectedNode(builder2.getGraph()));
    }

    public void selectAllNodes(@NotNull Graph2D graph, @NotNull Collection<Node> nodes, boolean state) {
        if (graph == null) {
            GraphSelectionService.$$$reportNull$$$0(13);
        }
        if (nodes == null) {
            GraphSelectionService.$$$reportNull$$$0(14);
        }
        for (Node node : nodes) {
            graph.setSelected(node, state);
        }
    }

    public <N> void selectAllModelNodes(@NotNull GraphBuilder<N, ?> builder2, @NotNull Collection<N> nodes, boolean state) {
        if (builder2 == null) {
            GraphSelectionService.$$$reportNull$$$0(15);
        }
        if (nodes == null) {
            GraphSelectionService.$$$reportNull$$$0(16);
        }
        Graph2D graph = builder2.getGraph();
        for (N modelNode : nodes) {
            Node node = builder2.getNode(modelNode);
            if (node == null) continue;
            graph.setSelected(node, state);
        }
    }

    public boolean hasSelectedEdges(@NotNull Graph2D graph) {
        if (graph == null) {
            GraphSelectionService.$$$reportNull$$$0(17);
        }
        return graph.selectedEdges().ok();
    }

    public void forEachSelectedEdge(@NotNull Graph2D graph, @NotNull Consumer<? super Edge> consumer) {
        if (graph == null) {
            GraphSelectionService.$$$reportNull$$$0(18);
        }
        if (consumer == null) {
            GraphSelectionService.$$$reportNull$$$0(19);
        }
        EdgeCursor cursor = graph.selectedEdges();
        while (cursor.ok()) {
            consumer.accept(cursor.edge());
            cursor.next();
        }
    }

    @NotNull
    public List<Edge> getSelectedEdges(@NotNull Graph2D graph) {
        if (graph == null) {
            GraphSelectionService.$$$reportNull$$$0(20);
        }
        ArrayList<Edge> result2 = new ArrayList<Edge>();
        EdgeCursor cursor = graph.selectedEdges();
        while (cursor.ok()) {
            result2.add(cursor.edge());
            cursor.next();
        }
        ArrayList<Edge> arrayList = result2;
        if (arrayList == null) {
            GraphSelectionService.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @Nullable
    public Edge getSingleSelectedEdge(@NotNull Graph2D graph) {
        EdgeCursor cursor;
        if (graph == null) {
            GraphSelectionService.$$$reportNull$$$0(22);
        }
        if ((cursor = graph.selectedEdges()).ok()) {
            Edge edge = cursor.edge();
            cursor.next();
            if (!cursor.ok()) {
                return edge;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOneTimeSelectionCallback(@NotNull GraphBuilder<?, ?> builder2, @NotNull Consumer<? super Rectangle> callback2) {
        if (builder2 == null) {
            GraphSelectionService.$$$reportNull$$$0(23);
        }
        if (callback2 == null) {
            GraphSelectionService.$$$reportNull$$$0(24);
        }
        Map<GraphBuilder<?, ?>, List<Consumer<? super Rectangle>>> map2 = this.myOneTimeSelectionCallbacks;
        synchronized (map2) {
            if (this.myOneTimeSelectionCallbacks.containsKey(builder2)) {
                this.myOneTimeSelectionCallbacks.get(builder2).add(callback2);
            } else {
                ArrayList<Consumer<? super Rectangle>> bean = new ArrayList<Consumer<? super Rectangle>>();
                bean.add(callback2);
                this.myOneTimeSelectionCallbacks.put(builder2, bean);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAllOneTimeSelectionCallbacks(@NotNull GraphBuilder<?, ?> builder2, @NotNull Consumer<? super Consumer<? super Rectangle>> processor2) {
        if (builder2 == null) {
            GraphSelectionService.$$$reportNull$$$0(25);
        }
        if (processor2 == null) {
            GraphSelectionService.$$$reportNull$$$0(26);
        }
        Map<GraphBuilder<?, ?>, List<Consumer<? super Rectangle>>> map2 = this.myOneTimeSelectionCallbacks;
        synchronized (map2) {
            List<Consumer<? super Rectangle>> bean = this.myOneTimeSelectionCallbacks.get(builder2);
            if (bean != null) {
                for (Consumer<? super Rectangle> callback2 : bean) {
                    processor2.accept(callback2);
                }
                bean.clear();
            }
        }
    }

    public void suppressSelection(@NotNull GraphBuilder<?, ?> builder2) {
        if (builder2 == null) {
            GraphSelectionService.$$$reportNull$$$0(27);
        }
        this.myGraphBuilderWithSuppressedSelection.add(builder2);
    }

    public void enableSelection(@NotNull GraphBuilder<?, ?> builder2) {
        if (builder2 == null) {
            GraphSelectionService.$$$reportNull$$$0(28);
        }
        this.myGraphBuilderWithSuppressedSelection.remove(builder2);
    }

    public boolean isSelectionSuppressedFor(@NotNull GraphBuilder<?, ?> builder2) {
        if (builder2 == null) {
            GraphSelectionService.$$$reportNull$$$0(29);
        }
        return this.myGraphBuilderWithSuppressedSelection.contains(builder2);
    }

    public void onGraphBuilderDispose(@NotNull GraphBuilder<?, ?> builder2) {
        if (builder2 == null) {
            GraphSelectionService.$$$reportNull$$$0(30);
        }
        this.myGraphBuilderWithSuppressedSelection.remove(builder2);
        this.myOneTimeSelectionCallbacks.remove(builder2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/services/GraphSelectionService";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 4: 
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 15: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/services/GraphSelectionService";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModelNodes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEdges";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "anyNodeOrEdgeSelected";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasSelectedNodes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forEachSelectedNode";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forEachSelectedModelNode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedNodes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedModelNodes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSingleSelectedNode";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSingleSelectedModelNode";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "selectAllNodes";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "selectAllModelNodes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasSelectedEdges";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "forEachSelectedEdge";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEdges";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSingleSelectedEdge";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "registerOneTimeSelectionCallback";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processAllOneTimeSelectionCallbacks";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "suppressSelection";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "enableSelection";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionSuppressedFor";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "onGraphBuilderDispose";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30 -> new IllegalArgumentException(string2);
        };
    }
}

