/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.renderer;

import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.services.GraphNodeRealizerService;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasicNodeCellRenderer
implements NodeCellRenderer {
    @NotNull
    private static final Key<MyRealizerComponents> MY_COMPONENTS_KEY = Key.create((String)"com.intellij.openapi.graph.builder.renderer.BasicNodeCellRenderer.MY_COMPONENTS_KEY");
    @Nullable
    private final ModificationTracker myCacheModificationTracker;

    protected BasicNodeCellRenderer(@Nullable ModificationTracker modificationTracker) {
        this.myCacheModificationTracker = modificationTracker;
    }

    @Override
    @NotNull
    public JComponent getNodeCellRendererComponent(@NotNull Graph2DView view, @NotNull NodeRealizer nodeRealizer, @Nullable Object object, boolean isSelected) {
        if (view == null) {
            BasicNodeCellRenderer.$$$reportNull$$$0(0);
        }
        if (nodeRealizer == null) {
            BasicNodeCellRenderer.$$$reportNull$$$0(1);
        }
        if (GraphExportService.getInstance().isPrintMode()) {
            JComponent component2 = this.createNodeRealizerComponent(view, nodeRealizer, object, isSelected);
            UIUtil.uiTraverser((Component)component2).forEach(it -> it.setBackground((Color)JBColor.white));
            JComponent jComponent = component2;
            if (jComponent == null) {
                BasicNodeCellRenderer.$$$reportNull$$$0(2);
            }
            return jComponent;
        }
        MyRealizerComponents existingComponents = GraphNodeRealizerService.getInstance().getUserData(nodeRealizer, MY_COMPONENTS_KEY);
        if (existingComponents == null) {
            existingComponents = new MyRealizerComponents();
            GraphNodeRealizerService.getInstance().putUserData(nodeRealizer, MY_COMPONENTS_KEY, existingComponents);
        }
        JComponent component3 = existingComponents.getOrCompute(this.myCacheModificationTracker, view, nodeRealizer, object, isSelected);
        this.beforeShown(component3, view, nodeRealizer, object, isSelected);
        JComponent jComponent = component3;
        if (jComponent == null) {
            BasicNodeCellRenderer.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @NotNull
    protected Object createNodeRealizerComponentKey(@NotNull Graph2DView view, @NotNull NodeRealizer nodeRealizer, @Nullable Object object, boolean isSelected) {
        if (view == null) {
            BasicNodeCellRenderer.$$$reportNull$$$0(4);
        }
        if (nodeRealizer == null) {
            BasicNodeCellRenderer.$$$reportNull$$$0(5);
        }
        Boolean bl = isSelected;
        if (bl == null) {
            BasicNodeCellRenderer.$$$reportNull$$$0(6);
        }
        return bl;
    }

    @NotNull
    protected abstract JComponent createNodeRealizerComponent(@NotNull Graph2DView var1, @NotNull NodeRealizer var2, @Nullable Object var3, boolean var4);

    protected void beforeShown(@NotNull JComponent component2, @NotNull Graph2DView view, @NotNull NodeRealizer nodeRealizer, @Nullable Object object, boolean isSelected) {
        if (component2 == null) {
            BasicNodeCellRenderer.$$$reportNull$$$0(7);
        }
        if (view == null) {
            BasicNodeCellRenderer.$$$reportNull$$$0(8);
        }
        if (nodeRealizer == null) {
            BasicNodeCellRenderer.$$$reportNull$$$0(9);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeRealizer";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/renderer/BasicNodeCellRenderer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/renderer/BasicNodeCellRenderer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeCellRendererComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeRealizerComponentKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNodeCellRendererComponent";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNodeRealizerComponentKey";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "beforeShown";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 6 -> new IllegalStateException(string2);
        };
    }

    private final class MyRealizerComponents {
        @NotNull
        private final Map<Object, JComponent> myComponents = new HashMap<Object, JComponent>(2);
        private long myModificationCount = 0L;

        private MyRealizerComponents() {
        }

        @NotNull
        public JComponent getOrCompute(@Nullable ModificationTracker modificationTracker, @NotNull Graph2DView view, @NotNull NodeRealizer nodeRealizer, @Nullable Object object, boolean isSelected) {
            long currModCount;
            if (view == null) {
                MyRealizerComponents.$$$reportNull$$$0(0);
            }
            if (nodeRealizer == null) {
                MyRealizerComponents.$$$reportNull$$$0(1);
            }
            long l = currModCount = modificationTracker != null ? modificationTracker.getModificationCount() : 0L;
            if (currModCount != this.myModificationCount) {
                this.myModificationCount = currModCount;
                this.myComponents.clear();
            }
            JComponent jComponent = this.myComponents.computeIfAbsent(BasicNodeCellRenderer.this.createNodeRealizerComponentKey(view, nodeRealizer, object, isSelected), __ -> BasicNodeCellRenderer.this.createNodeRealizerComponent(view, nodeRealizer, object, isSelected));
            if (jComponent == null) {
                MyRealizerComponents.$$$reportNull$$$0(2);
            }
            return jComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeRealizer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/builder/renderer/BasicNodeCellRenderer$MyRealizerComponents";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/builder/renderer/BasicNodeCellRenderer$MyRealizerComponents";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCompute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCompute";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

