/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.printing;

import com.intellij.ide.actions.PrintActionHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBundle;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.printing.DarculaAwareGraph2DPrinter;
import com.intellij.openapi.graph.builder.actions.printing.PrintOptionsDialog;
import com.intellij.openapi.graph.builder.actions.printing.PrintUtil;
import com.intellij.openapi.graph.option.OptionHandler;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.view.BackgroundRenderer;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.PrintPreviewPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterJob;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramPrintHandler
extends PrintActionHandler {
    private static final Logger LOG = Logger.getInstance(DiagramPrintHandler.class);

    public boolean canPrint(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DiagramPrintHandler.$$$reportNull$$$0(0);
        }
        return GraphDataKeys.GRAPH_BUILDER.getData(dataContext) != null;
    }

    public void print(@NotNull DataContext dataContext) {
        GraphBuilder builder2;
        if (dataContext == null) {
            DiagramPrintHandler.$$$reportNull$$$0(1);
        }
        if ((builder2 = (GraphBuilder)((Object)GraphDataKeys.GRAPH_BUILDER.getData(dataContext))) == null) {
            return;
        }
        final PrinterJob printJob = PrinterJob.getPrinterJob();
        final Project project2 = builder2.getProject();
        final Graph2D graph2D = builder2.getGraph();
        Graph2DView view = AbstractGraphAction.getGraph2DView(graph2D);
        final BackgroundRenderer renderer2 = view.getBackgroundRenderer();
        final DarculaAwareGraph2DPrinter gp = new DarculaAwareGraph2DPrinter(view);
        final PrintPreviewPanel panel2 = GraphManager.getGraphManager().createPrintPreviewPanel(printJob, gp, gp.getPosterColumns(), gp.getPosterColumns() * gp.getPosterRows(), printJob.defaultPage());
        panel2.setThreadingEnabled(false);
        final OptionHandler options = PrintUtil.createPrintOptions();
        AbstractAction optionAction = new AbstractAction(GraphBundle.message("button.text.print.options", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PrintOptionsDialog dialog = new PrintOptionsDialog(project2, options);
                if (!dialog.showAndGet()) {
                    return;
                }
                PrintUtil.initGraph2DPrinter(gp, options);
                panel2.setPages(0, gp.getPosterColumns(), gp.getPosterColumns() * gp.getPosterRows());
            }
        };
        panel2.addControlComponent(new JButton(optionAction));
        final JPanel panelComponent = panel2.getJPanel();
        UIUtil.uiTraverser((Component)panelComponent).filter(JButton.class).filter(o -> o.getText().startsWith("Print")).consumeEach(o -> o.setVisible(false));
        new DialogWrapper(project2){
            {
                super(arg0);
                this.setTitle(GraphBundle.message("dialog.title.print.preview", new Object[0]));
                this.init();
                this.getOKAction().putValue("Name", GraphBundle.message("button.print", new Object[0]));
            }

            protected String getDimensionServiceKey() {
                return "Diagram.Print.Preview.Dialog";
            }

            protected JComponent createCenterPanel() {
                DiagramPrintHandler.setupBackgroundBeforePrint(graph2D, renderer2, builder2);
                ApplicationManager.getApplication().invokeLater(() -> DiagramPrintHandler.rollbackBackgroundAfterPrint(renderer2, builder2));
                return panelComponent;
            }

            protected void doOKAction() {
                super.doOKAction();
                printJob.setPrintable(gp, panel2.getPageFormat());
                DiagramPrintHandler.doPrint(graph2D, renderer2, builder2, printJob);
            }
        }.show();
    }

    private static void setupBackgroundBeforePrint(@NotNull Graph2D graph2D, @Nullable BackgroundRenderer renderer2, @Nullable GraphBuilder builder2) {
        if (graph2D == null) {
            DiagramPrintHandler.$$$reportNull$$$0(2);
        }
        if (!StartupUiUtil.isUnderDarcula()) {
            return;
        }
        if (renderer2 instanceof DefaultBackgroundRenderer) {
            ((DefaultBackgroundRenderer)renderer2).setColor(Color.white);
        }
        JBColor.setDark((boolean)false);
        GraphExportService.getInstance().setPrintMode(true);
        graph2D.getCurrentView().updateView();
        if (builder2 != null) {
            builder2.queryGraphUpdate().withDataReload().withRelayout().run();
            builder2.getGraph().updateViews();
        }
    }

    private static void rollbackBackgroundAfterPrint(@Nullable BackgroundRenderer renderer2, @Nullable GraphBuilder builder2) {
        if (!StartupUiUtil.isUnderDarcula()) {
            return;
        }
        GraphExportService.getInstance().setPrintMode(false);
        JBColor.setDark((boolean)StartupUiUtil.isUnderDarcula());
        if (renderer2 instanceof DefaultBackgroundRenderer) {
            ((DefaultBackgroundRenderer)renderer2).setColor(JBColor.background());
        }
        if (builder2 != null) {
            builder2.queryGraphUpdate().withDataReload().withRelayout().run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doPrint(@NotNull Graph2D graph2D, BackgroundRenderer renderer2, GraphBuilder builder2, PrinterJob printJob) {
        if (graph2D == null) {
            DiagramPrintHandler.$$$reportNull$$$0(3);
        }
        if (printJob.printDialog()) {
            try {
                DiagramPrintHandler.setupBackgroundBeforePrint(graph2D, renderer2, builder2);
                printJob.print();
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
            finally {
                DiagramPrintHandler.rollbackBackgroundAfterPrint(renderer2, builder2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph2D";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/graph/builder/actions/printing/DiagramPrintHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canPrint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "print";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setupBackgroundBeforePrint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doPrint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

