/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.layout;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBundle;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.layout.GraphLayout;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.partial.PartialLayouter;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.services.GraphUndoService;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyCurrentLayoutAction
extends AbstractGraphAction {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Graph2D graph) {
        GraphBuilder<?, ?> builder2;
        if (e == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(0);
        }
        if (graph == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(1);
        }
        if ((builder2 = this.getBuilder(e)) == null) {
            return;
        }
        Layouter layouter = this.getLayouter(builder2);
        if (layouter == null) {
            return;
        }
        GraphLayoutService.GraphLayoutQueryParams basicQuery = GraphLayoutService.getInstance().queryLayout(builder2).animated().withLayouter(layouter);
        GraphLayoutService.GraphLayoutQueryParams adjustedQuery = ApplyCurrentLayoutAction.setupLayoutOfSelectionOnlyIfNeeded(builder2, basicQuery);
        GraphLayoutService.getInstance().calcLayoutAsync(builder2, Objects.requireNonNull(adjustedQuery.getLayouter())).thenAcceptAsync(layout -> GraphUndoService.getInstance().performPositionsOnlyChangingAction(builder2, this.getActionName(), () -> adjustedQuery.withCustomLayout((GraphLayout)layout).run()), Futures.inEdt());
    }

    @Override
    public void update(@NotNull AnActionEvent e, @NotNull Graph2D graph) {
        if (e == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(2);
        }
        if (graph == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(3);
        }
        Project project2 = ApplyCurrentLayoutAction.getProject(e);
        Presentation presentation2 = e.getPresentation();
        presentation2.setEnabled(project2 != null && graph.nodeCount() > 0 && this.canLayout(this.getBuilder(e)));
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(4);
        }
        return actionUpdateThread;
    }

    @Nls
    protected String getActionName() {
        return GraphBundle.message("action.Graph.ApplyCurrentLayout.text", new Object[0]);
    }

    @Nullable
    protected Layouter getLayouter(@NotNull GraphBuilder<?, ?> builder2) {
        if (builder2 == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(5);
        }
        return builder2.getGraphPresentationModel().getSettings().getCurrentLayouter();
    }

    protected boolean canLayout(@Nullable GraphBuilder<?, ?> builder2) {
        if (builder2 == null) {
            return false;
        }
        try {
            Layouter layouter = this.getLayouter(builder2);
            return layouter != null && GraphLayoutService.getInstance().canLayout(builder2, layouter);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @NotNull
    private static GraphLayoutService.GraphLayoutQueryParams setupLayoutOfSelectionOnlyIfNeeded(@NotNull GraphBuilder<?, ?> builder2, @NotNull GraphLayoutService.GraphLayoutQueryParams layoutParams) {
        if (builder2 == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(6);
        }
        if (layoutParams == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(7);
        }
        Layouter layouter = Objects.requireNonNull(layoutParams.getLayouter());
        if (GraphSelectionService.getInstance().anyNodeOrEdgeSelected(builder2.getGraph()) && !(layouter instanceof PartialLayouter)) {
            if (GraphLayoutService.getInstance().isEdgeRouter(layouter)) {
                GraphLayoutService.getInstance().setupDataProvidersForEdgeRouterBasedOnCurrentSelection(layouter, builder2);
                GraphLayoutService.GraphLayoutQueryParams graphLayoutQueryParams = layoutParams.withFitContent(GraphLayoutService.GraphLayoutQueryParams.FitContentOption.NEVER);
                if (graphLayoutQueryParams == null) {
                    ApplyCurrentLayoutAction.$$$reportNull$$$0(8);
                }
                return graphLayoutQueryParams;
            }
            List<Node> nodesToLayout = GraphSelectionService.getInstance().getSelectedNodes(builder2.getGraph());
            List<Edge> edgesToLayout = GraphSelectionService.getInstance().getSelectedEdges(builder2.getGraph());
            Layouter partialLayouter = GraphLayoutService.getInstance().getPartialLayouter(layouter, true);
            GraphLayoutService.getInstance().markElementsForPartialLayout(builder2.getGraph(), nodesToLayout, edgesToLayout);
            GraphLayoutService.GraphLayoutQueryParams graphLayoutQueryParams = layoutParams.withLayouter(partialLayouter).withFitContent(GraphLayoutService.GraphLayoutQueryParams.FitContentOption.NEVER);
            if (graphLayoutQueryParams == null) {
                ApplyCurrentLayoutAction.$$$reportNull$$$0(9);
            }
            return graphLayoutQueryParams;
        }
        GraphLayoutService.GraphLayoutQueryParams graphLayoutQueryParams = layoutParams;
        if (graphLayoutQueryParams == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(10);
        }
        return graphLayoutQueryParams;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/actions/layout/ApplyCurrentLayoutAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/actions/layout/ApplyCurrentLayoutAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setupLayoutOfSelectionOnlyIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLayouter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupLayoutOfSelectionOnlyIfNeeded";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 8, 9, 10 -> new IllegalStateException(string2);
        };
    }
}

