/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.tree;

import com.intellij.history.core.Content;
import com.intellij.history.core.DataStreamUtil;
import com.intellij.history.core.Paths;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.DirectoryEntry;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.SmartList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Entry {
    private int myNameId;
    private int myNameHash;
    private DirectoryEntry myParent;
    private static final int NULL_NAME_ID = -1;
    private static final int EMPTY_NAME_ID = 0;

    public Entry(@NonNls String name) {
        this(Entry.toNameId(name), Entry.calcNameHash(name));
    }

    public Entry(int nameId) {
        this(nameId, Entry.calcNameHash(Entry.fromNameId(nameId)));
    }

    private Entry(int nameId, int nameHash) {
        this.myNameId = nameId;
        this.myNameHash = nameHash;
    }

    protected static int toNameId(@NonNls String name) {
        if (name == null) {
            return -1;
        }
        if (name.isEmpty()) {
            return 0;
        }
        return FSRecords.getInstance().getNameId(name);
    }

    private static CharSequence fromNameId(int nameId) {
        if (nameId == -1) {
            return null;
        }
        if (nameId == 0) {
            return "";
        }
        return FSRecords.getInstance().getNameByNameId(nameId);
    }

    public Entry(DataInput in) throws IOException {
        String name = DataStreamUtil.readString(in);
        this.myNameId = Entry.toNameId(name);
        this.myNameHash = Entry.calcNameHash(name);
    }

    public void write(DataOutput out) throws IOException {
        DataStreamUtil.writeString(out, this.getName());
    }

    @NlsSafe
    public String getName() {
        CharSequence sequence = Entry.fromNameId(this.myNameId);
        if (sequence != null && !(sequence instanceof String)) {
            return sequence.toString();
        }
        return (String)sequence;
    }

    @NlsSafe
    public CharSequence getNameSequence() {
        return Entry.fromNameId(this.myNameId);
    }

    public int getNameId() {
        return this.myNameId;
    }

    public int getNameHash() {
        return this.myNameHash;
    }

    @NlsSafe
    public String getPath() {
        StringBuilder builder2 = new StringBuilder();
        Entry.buildPath(this, builder2);
        return builder2.toString();
    }

    private static void buildPath(Entry e, StringBuilder builder2) {
        String pName;
        if (e == null) {
            return;
        }
        Entry parent = e.getParent();
        Entry.buildPath(parent, builder2);
        String string2 = pName = parent == null ? "" : parent.getName();
        if (!(builder2.isEmpty() || pName.length() == 1 && pName.charAt(0) == '/')) {
            builder2.append('/');
        }
        builder2.append(e.getNameSequence());
    }

    public boolean nameEquals(@NonNls String name) {
        return Paths.equals(this.getName(), name);
    }

    public boolean pathEquals(@NonNls String path2) {
        return Paths.equals(this.getPath(), path2);
    }

    public abstract long getTimestamp();

    public boolean isReadOnly() {
        throw new UnsupportedOperationException(this.formatPath());
    }

    public void setReadOnly(boolean isReadOnly) {
        throw new UnsupportedOperationException(this.formatPath());
    }

    public boolean isOutdated(long timestamp) {
        return this.getTimestamp() != timestamp;
    }

    public Content getContent() {
        throw new UnsupportedOperationException(this.formatPath());
    }

    public boolean hasUnavailableContent() {
        return this.hasUnavailableContent(new ArrayList());
    }

    public boolean hasUnavailableContent(List<? super Entry> entriesWithUnavailableContent) {
        return false;
    }

    public Entry getParent() {
        return this.myParent;
    }

    protected void setParent(DirectoryEntry parent) {
        this.myParent = parent;
    }

    public boolean isDirectory() {
        return false;
    }

    public void addChild(Entry child) {
        throw new UnsupportedOperationException(this.formatAddRemove(child));
    }

    public void addChildren(Collection<? extends Entry> children) {
        throw new UnsupportedOperationException();
    }

    public void removeChild(Entry child) {
        throw new UnsupportedOperationException(this.formatAddRemove(child));
    }

    @NonNls
    private String formatAddRemove(Entry child) {
        return "add/remove " + child.formatPath() + " to " + this.formatPath();
    }

    public List<Entry> getChildren() {
        return Collections.emptyList();
    }

    public Entry findChild(@NonNls String name) {
        int nameHash = Entry.calcNameHash(name);
        for (Entry e : this.getChildren()) {
            if (nameHash != e.getNameHash() || !e.nameEquals(name)) continue;
            return e;
        }
        return null;
    }

    protected static int calcNameHash(@Nullable @NonNls CharSequence name) {
        return name == null ? -1 : StringUtil.stringHashCodeInsensitive((CharSequence)name);
    }

    public boolean hasEntry(@NonNls String path2) {
        return this.findEntry(path2) != null;
    }

    @NotNull
    public Entry getEntry(@NonNls String path2) {
        Entry result2 = this.findEntry(path2);
        if (result2 == null) {
            throw new RuntimeException(String.format("entry '%s' not found", path2));
        }
        Entry entry2 = result2;
        if (entry2 == null) {
            Entry.$$$reportNull$$$0(0);
        }
        return entry2;
    }

    @Nullable
    public Entry findEntry(@NonNls String relativePath) {
        Iterable<String> parts = Paths.split(relativePath);
        Entry result2 = this;
        for (String each : parts) {
            if ((result2 = result2.findChild(each)) != null) continue;
            return null;
        }
        return result2;
    }

    @NotNull
    public abstract Entry copy();

    public void setName(@NonNls String newName) {
        if (this.myParent != null) {
            this.myParent.checkDoesNotExist(this, newName);
        }
        this.myNameId = Entry.toNameId(newName);
        this.myNameHash = Entry.calcNameHash(newName);
    }

    public void setContent(Content newContent, long timestamp) {
        throw new UnsupportedOperationException(this.formatPath());
    }

    public static List<Difference> getDifferencesBetween(@Nullable Entry left, @Nullable Entry right) {
        return Entry.getDifferencesBetween(left, right, false);
    }

    @NotNull
    public static List<Difference> getDifferencesBetween(@Nullable Entry left, @Nullable Entry right, boolean isRightContentCurrent) {
        SmartList result2 = new SmartList();
        BiConsumer<Entry, Entry> consumer = (arg_0, arg_1) -> Entry.lambda$getDifferencesBetween$0((List)result2, isRightContentCurrent, arg_0, arg_1);
        if (left != null && right != null) {
            left.collectDifferencesWith(right, consumer);
        } else if (right != null) {
            right.collectCreatedDifferences(consumer);
        } else if (left != null) {
            left.collectDeletedDifferences(consumer);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            Entry.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    protected abstract void collectDifferencesWith(@NotNull Entry var1, @NotNull BiConsumer<Entry, Entry> var2);

    protected abstract void collectCreatedDifferences(@NotNull BiConsumer<Entry, Entry> var1);

    protected abstract void collectDeletedDifferences(@NotNull BiConsumer<Entry, Entry> var1);

    public String toString() {
        return this.getName();
    }

    @NonNls
    private String formatPath() {
        String type2 = this.isDirectory() ? "dir: " : "file: ";
        return type2 + this.getPath();
    }

    private static /* synthetic */ void lambda$getDifferencesBetween$0(List result2, boolean isRightContentCurrent, Entry leftEntry, Entry rightEntry) {
        result2.add(new Difference(leftEntry, rightEntry, isRightContentCurrent));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/history/core/tree/Entry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDifferencesBetween";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

