/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.resultUI.BasicTreeNode;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesModel;
import com.intellij.dupLocator.resultUI.DuplicatesRoot;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class GroupNode
extends BasicTreeNode {
    private CodeNode[] myChildren;
    private final int myCost;
    private final DupInfo myDuplicates;
    private final int myIndex;

    public GroupNode(DuplicatesRoot duplicatesRoot, DupInfo duplicates, int index) {
        super(true, duplicatesRoot);
        this.myDuplicates = duplicates;
        this.myIndex = index;
        this.myCost = duplicates.getPatternCost(index);
    }

    protected CodeNode[] getChildren() {
        if (this.myChildren == null) {
            UsageInfo[] usageInfos = this.myDuplicates.getUsageOccurences(this.myIndex);
            PsiFragment[] fragments = this.myDuplicates.getFragmentOccurences(this.myIndex);
            CodeNode[] children = new CodeNode[usageInfos.length];
            for (int i = 0; i < children.length; ++i) {
                children[i] = new CodeNode(this, fragments[i], usageInfos[i], i + 1);
            }
            this.myChildren = children;
        }
        return this.myChildren;
    }

    @Override
    public CodeNode getChildAt(int childIndex) {
        return (CodeNode)super.getChildAt(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.myDuplicates.getPatternDensity(this.myIndex);
    }

    @Override
    public DuplicatesRoot getParent() {
        return (DuplicatesRoot)super.getParent();
    }

    @Override
    public boolean isLeaf() {
        return this.myDuplicates.getPatternDensity(this.myIndex) == 0;
    }

    public CellAppearanceEx getTitle(boolean sel) {
        int filesCount;
        int duplicatesCount = this.getChildCount();
        if (this.myChildren != null) {
            for (CodeNode child : this.myChildren) {
                if (child.isValid()) continue;
                return CompositeAppearance.single((String)DupLocatorBundle.message("duplicates.partially.valid.group.node", duplicatesCount), (SimpleTextAttributes)BasicTreeNode.getTextAttributes(sel));
            }
        }
        if ((filesCount = this.myDuplicates.getFileCount(this.myIndex)) == 1) {
            CompositeAppearance.DequeEnd ending = new CompositeAppearance().getEnding();
            ending.addText(DupLocatorBundle.message("duplicates.single.file.group.node", duplicatesCount, this.myCost, this.myDuplicates.getTitle(this.myIndex)), BasicTreeNode.getTextAttributes(sel));
            ending.addComment(this.myDuplicates.getComment(this.myIndex), BasicTreeNode.getCommentAttributes(sel));
            return ending.getAppearance();
        }
        return CompositeAppearance.single((String)DupLocatorBundle.message("duplicates.multiple.files.group.node", duplicatesCount, this.myCost, filesCount), (SimpleTextAttributes)BasicTreeNode.getTextAttributes(sel));
    }

    @Override
    public DuplicatesModel getModel() {
        return this.getParent().getModel();
    }

    public int getIndexOf(CodeNode codeNode) {
        for (int i = 0; i < this.myChildren.length; ++i) {
            CodeNode child = this.myChildren[i];
            if (!Comparing.equal((Object)child, (Object)codeNode)) continue;
            return i;
        }
        return -1;
    }

    public Set<VirtualFile> getAffectedFiles() {
        PsiFragment[] occurrences;
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        for (PsiFragment fragment2 : occurrences = this.myDuplicates.getFragmentOccurences(this.myIndex)) {
            PsiFile file = fragment2.getFile();
            if (file == null) continue;
            result2.add(file.getVirtualFile());
        }
        return result2;
    }

    @Nullable
    public DuplicatesPresentation getPresentation() {
        return DuplicatesPresentation.Service.findPresentationForDuplicate(this.myDuplicates, this.myIndex);
    }
}

