/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesRoot;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.Nullable;

public class DuplicatesModel {
    private final TreeSelectionModel mySelectionModel = new DefaultTreeSelectionModel();
    private final MyTreeModel myTreeModel;
    private final EventDispatcher<Listener> myListeners = EventDispatcher.create(Listener.class);
    private final Project myProject;
    private GroupNode myCurrentGroup;
    private final int[] myDiffIndices = new int[]{-1, -1};

    public DuplicatesModel(DupInfo duplicates, Project project2) {
        this.myProject = project2;
        DuplicatesRoot root = new DuplicatesRoot(duplicates, this);
        this.myTreeModel = new MyTreeModel(root);
        this.mySelectionModel.setSelectionMode(1);
        this.mySelectionModel.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DuplicatesModel.this.onSelectionChanged();
            }
        });
        this.mySelectionModel.setSelectionPath(new TreePath(new Object[]{root, root.getChildAt(0)}));
    }

    @Nullable
    public CodeNode getRight() {
        if (this.myCurrentGroup == null) {
            return null;
        }
        return this.myCurrentGroup.getChildAt(this.myDiffIndices[1]);
    }

    @Nullable
    public CodeNode getLeft() {
        if (this.myCurrentGroup == null) {
            return null;
        }
        return this.myCurrentGroup.getChildAt(this.myDiffIndices[0]);
    }

    @Nullable
    private TreeNode getSelectedNode() {
        TreePath path2 = this.mySelectionModel.getSelectionPath();
        if (path2 == null) {
            return null;
        }
        return (TreeNode)path2.getLastPathComponent();
    }

    private void onSelectionChanged() {
        TreeNode node = this.getSelectedNode();
        GroupNode selectedGroup = null;
        if (node != null) {
            if (node instanceof GroupNode) {
                selectedGroup = (GroupNode)node;
            } else {
                TreeNode parent = node.getParent();
                if (parent instanceof GroupNode) {
                    selectedGroup = (GroupNode)parent;
                }
            }
        }
        this.setCurrentGroup(selectedGroup);
    }

    private void setCurrentGroup(GroupNode groupNode) {
        if (Comparing.equal((Object)this.myCurrentGroup, (Object)groupNode)) {
            return;
        }
        if (groupNode != null) {
            this.setCurrentGroup(groupNode, 0, 1);
        } else {
            this.setCurrentGroup(null, -1, -1);
        }
    }

    public TreeSelectionModel getSelectionModel() {
        return this.mySelectionModel;
    }

    public void addListener(Listener listener2) {
        this.myListeners.addListener((EventListener)listener2);
    }

    public void removeListener(Listener listener2) {
        this.myListeners.removeListener((EventListener)listener2);
    }

    public TreeModel getTreeModel() {
        return this.myTreeModel;
    }

    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public CodeNode getSelectedCodeNode() {
        TreeNode node = this.getSelectedNode();
        return node instanceof CodeNode ? (CodeNode)node : null;
    }

    public DuplicatesRoot getRoot() {
        return this.myTreeModel.getRoot();
    }

    public void setDiff(int diffIndex, CodeNode codeNode) {
        GroupNode parent = codeNode.getParent();
        int childIndex = parent.getIndexOf(codeNode);
        if (Comparing.equal((Object)parent, (Object)this.myCurrentGroup)) {
            if (childIndex == this.myDiffIndices[diffIndex]) {
                return;
            }
            this.myDiffIndices[diffIndex] = childIndex;
            ((Listener)this.myListeners.getMulticaster()).onSelectionChanged();
        } else if (diffIndex == 0) {
            this.setCurrentGroup(parent, childIndex, 1);
        } else {
            this.setCurrentGroup(parent, 0, childIndex);
        }
    }

    private void setCurrentGroup(GroupNode groupNode, int leftIndex, int rightIndex) {
        if (Comparing.equal((Object)this.myCurrentGroup, (Object)groupNode) && leftIndex == this.myDiffIndices[0] && rightIndex == this.myDiffIndices[1]) {
            return;
        }
        this.myCurrentGroup = groupNode;
        this.myDiffIndices[0] = leftIndex;
        this.myDiffIndices[1] = rightIndex;
        ((Listener)this.myListeners.getMulticaster()).onSelectionChanged();
    }

    public static interface Listener
    extends EventListener {
        public void onSelectionChanged();
    }

    private static class MyTreeModel
    extends DefaultTreeModel {
        MyTreeModel(DuplicatesRoot root) {
            super(root);
        }

        @Override
        public DuplicatesRoot getRoot() {
            return (DuplicatesRoot)super.getRoot();
        }
    }
}

