/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.resultUI.BasicTreeNode;
import com.intellij.dupLocator.resultUI.CodeFragmentType;
import com.intellij.dupLocator.resultUI.DuplicatesModel;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.dupLocator.resultUI.UsagesEditSourceDescriptor;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeNode
extends BasicTreeNode {
    private RangeMarker myRangeMarker;
    private VirtualFile myVirtualFile;
    private final int myIndex;
    private final DuplicatesPresentation myPresentation;
    private final PsiFragment myFragment;

    public CodeNode(GroupNode parent, @NotNull PsiFragment fragment2, @Nullable UsageInfo info, int index) {
        PsiElement element;
        if (fragment2 == null) {
            CodeNode.$$$reportNull$$$0(0);
        }
        super(false, parent);
        this.myFragment = fragment2;
        this.myPresentation = parent.getPresentation();
        this.myIndex = index;
        if (info != null && (element = info.getElement()) != null) {
            PsiElement elementAfterWhitespaces;
            TextRange textRange = element.getTextRange().cutOut((TextRange)info.getRangeInElement());
            this.myVirtualFile = element.getContainingFile().getVirtualFile();
            Document document2 = FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
            int startOffset = textRange.getStartOffset();
            int fragmentStartLine = document2.getLineNumber(startOffset);
            int lineStartOffset = document2.getLineStartOffset(fragmentStartLine);
            PsiElement elementAtLineStart = element.getContainingFile().findElementAt(lineStartOffset);
            if (elementAtLineStart instanceof PsiWhiteSpace && (elementAfterWhitespaces = PsiTreeUtil.skipWhitespacesForward((PsiElement)elementAtLineStart)) != null && elementAfterWhitespaces.getTextRange().getStartOffset() == startOffset) {
                startOffset = lineStartOffset;
            }
            this.myRangeMarker = document2.createRangeMarker(startOffset, textRange.getEndOffset(), true);
        }
    }

    public PsiFragment getFragment() {
        return this.myFragment;
    }

    @Nullable
    public DuplicatesPresentation getPresentation() {
        return this.myPresentation;
    }

    @Override
    protected TreeNode[] getChildren() {
        return new TreeNode[0];
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public GroupNode getParent() {
        return (GroupNode)super.getParent();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Nullable
    public DocumentContent getDiffContentIfValid() {
        try {
            RangeMarker marker = this.getRangeMarker();
            Document document2 = marker.getDocument();
            TextRange textRange = marker.getTextRange();
            return DiffContentFactory.getInstance().createFragment(this.getProject(), document2, textRange);
        }
        catch (InvalidatedException e) {
            return null;
        }
    }

    public CellAppearanceEx getTitle(boolean selected) {
        CompositeAppearance title2 = null;
        try {
            CodeFragmentType type2;
            DuplicatesPresentation presentation2 = this.getPresentation();
            if (presentation2 != null && (type2 = presentation2.getType(this)) != null) {
                title2 = type2.getTitle(selected);
            }
        }
        catch (InvalidatedException invalidatedException) {
            // empty catch block
        }
        if (title2 == null) {
            title2 = CodeNode.invalidTitle();
        }
        title2.getBeginning().addText("#" + this.myIndex + " ", SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
        return title2;
    }

    public VirtualFile getVirtualFile() throws InvalidatedException {
        if (this.myVirtualFile == null || !this.myVirtualFile.isValid()) {
            throw new InvalidatedException();
        }
        return this.myVirtualFile;
    }

    public boolean isValid() {
        return this.myRangeMarker != null && this.myRangeMarker.isValid();
    }

    public boolean isRightInDiff() {
        return Comparing.equal((Object)this.getModel().getRight(), (Object)this);
    }

    public boolean isLeftInDiff() {
        return Comparing.equal((Object)this.getModel().getLeft(), (Object)this);
    }

    @Override
    public DuplicatesModel getModel() {
        return this.getParent().getModel();
    }

    @Nullable
    public OpenFileDescriptor getOpenFileDescriptorIfValid() {
        try {
            return new UsagesEditSourceDescriptor(this.getProject(), this.getVirtualFile(), this.getTextRange(), false);
        }
        catch (InvalidatedException e) {
            return null;
        }
    }

    public RangeMarker getRangeMarker() throws InvalidatedException {
        if (this.myRangeMarker == null || !this.myRangeMarker.isValid()) {
            throw new InvalidatedException();
        }
        return this.myRangeMarker;
    }

    public TextRange getTextRange() throws InvalidatedException {
        RangeMarker rangeMarker = this.getRangeMarker();
        return rangeMarker.getTextRange();
    }

    public static CompositeAppearance invalidTitle() {
        return CompositeAppearance.single((String)DupLocatorBundle.message("duplicate.location.invalid", new Object[0]), (SimpleTextAttributes)SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    public int getIndex() {
        return this.myIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/dupLocator/resultUI/CodeNode", "<init>"));
    }
}

