/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.application.options.HtmlSettings;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.HtmlInTextCompletionEnabler;
import com.intellij.codeInsight.completion.HtmlInTextCompletionPopupExtension;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.StartOnlyMatcher;
import com.intellij.codeInsight.completion.TagNameReferenceCompletionProvider;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.html.impl.util.MicrodataUtil;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.documentation.MimeTypeDictionary;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlCompletionContributor
extends CompletionContributor
implements DumbAware {
    public static final String[] TARGET = new String[]{"_blank", "_top", "_self", "_parent"};
    public static final String[] ENCTYPE = new String[]{"multipart/form-data", "application/x-www-form-urlencoded"};
    public static final String[] REL_LINK = new String[]{"alternate", "canonical", "author", "dns-prefetch", "help", "icon", "manifest", "modulepreload", "license", "next", "pingback", "preconnect", "prefetch", "preload", "prerender", "prev", "stylesheet", "apple-touch-icon", "apple-touch-icon-precomposed", "apple-touch-startup-image"};
    public static final String[] REL_A_AREA = new String[]{"bookmark", "external", "help", "license", "next", "nofollow", "noopener", "noreferrer", "opener", "prev", "search", "tag", "sponsored", "ugc"};
    public static final String[] REL_FORM = new String[]{"external", "help", "license", "next", "nofollow", "noopener", "noreferrer", "opener", "prev", "search"};
    public static final String[] MEDIA = new String[]{"all", "braille", "embossed", "handheld", "print", "projection", "screen", "speech", "tty", "tv"};
    public static final String[] LANGUAGE = new String[]{"JavaScript", "VBScript", "JScript", "JavaScript1.2", "JavaScript1.3", "JavaScript1.4", "JavaScript1.5"};
    public static final String[] TYPE = new String[]{"text/css", "text/html", "text/plain", "text/xml"};
    public static final String[] SANDBOX = new String[]{"allow-downloads", "allow-forms", "allow-modals", "allow-orientation-lock", "allow-pointer-lock", "allow-popups", "allow-popups-to-escape-sandbox", "allow-presentation", "allow-same-origin", "allow-scripts", "allow-top-navigation", "allow-top-navigation-by-user-activation", "allow-top-navigation-to-custom-protocols"};
    public static final String[] LANG = new String[]{"aa", "ab", "ae", "af", "ak", "am", "an", "ar", "as", "av", "ay", "az", "ba", "be", "bg", "bh", "bi", "bm", "bn", "bo", "br", "bs", "ca", "ce", "ch", "co", "cr", "cs", "cu", "cv", "cy", "da", "de", "dv", "dz", "ee", "el", "en", "eo", "es", "et", "eu", "fa", "ff", "fi", "fj", "fo", "fr", "fy", "ga", "gd", "gl", "gn", "gu", "gv", "ha", "he", "hi", "ho", "hr", "ht", "hu", "hy", "hz", "ia", "id", "ie", "ig", "ii", "ik", "io", "is", "it", "iu", "ja", "jv", "ka", "kg", "ki", "kj", "kk", "kl", "km", "kn", "ko", "kr", "ks", "ku", "kv", "kw", "ky", "la", "lb", "lg", "li", "ln", "lo", "lt", "lu", "lv", "mg", "mh", "mi", "mk", "ml", "mn", "mr", "ms", "mt", "my", "na", "nb", "nd", "ne", "ng", "nl", "nn", "no", "nr", "nv", "ny", "oc", "oj", "om", "or", "os", "pa", "pi", "pl", "ps", "pt", "qu", "rm", "rn", "ro", "ru", "rw", "sa", "sc", "sd", "se", "sg", "si", "sk", "sl", "sm", "sn", "so", "sq", "sr", "ss", "st", "su", "sv", "sw", "ta", "te", "tg", "th", "ti", "tk", "tl", "tn", "to", "tr", "ts", "tt", "tw", "ty", "ug", "uk", "ur", "uz", "ve", "vi", "vo", "wa", "wo", "xh", "yi", "yo", "za", "zh", "zu"};

    public HtmlCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlAttributeValue()), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
                PsiElement position;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!HtmlCompletionContributor.hasHtmlAttributesCompletion(position = parameters.getPosition())) {
                    return;
                }
                XmlAttributeValue attributeValue2 = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)position, XmlAttributeValue.class, (boolean)false);
                if (attributeValue2 != null && attributeValue2.getParent() instanceof XmlAttribute) {
                    for (String element : HtmlCompletionContributor.addSpecificCompletions((XmlAttribute)attributeValue2.getParent())) {
                        result2.addElement((LookupElement)LookupElementBuilder.create((String)element));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/HtmlCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, HtmlCompletionContributor.getHtmlElementInTextPattern(), new HtmlElementInTextCompletionProvider());
    }

    public static boolean hasHtmlAttributesCompletion(PsiElement position) {
        if (PsiTreeUtil.getParentOfType((PsiElement)position, HtmlTag.class, (boolean)false) != null) {
            return true;
        }
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)position, XmlTag.class, (boolean)false);
        return xmlTag != null && xmlTag.getLanguage() == XHTMLLanguage.INSTANCE;
    }

    public static @NonNls String @NotNull [] addSpecificCompletions(XmlAttribute attribute) {
        String namespace;
        @NonNls String name = attribute.getName();
        XmlTag tag = attribute.getParent();
        if (tag == null) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                HtmlCompletionContributor.$$$reportNull$$$0(0);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        @NonNls String tagName = tag.getName();
        if (tag.getDescriptor() instanceof HtmlElementDescriptorImpl) {
            name = StringUtil.toLowerCase((String)name);
            tagName = StringUtil.toLowerCase((String)tagName);
        }
        if ("http://www.w3.org/1999/xhtml".equals(namespace = tag.getNamespace()) || "http://www.w3.org/1999/html".equals(namespace)) {
            if ("target".equals(name) || "formtarget".equals(name)) {
                if (TARGET == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(1);
                }
                return TARGET;
            }
            if (("lang".equals(name) || "xml:lang".equals(name)) && tagName.equalsIgnoreCase("html") || "hreflang".equals(name)) {
                if (LANG == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(2);
                }
                return LANG;
            }
            if ("enctype".equals(name)) {
                XmlAttributeDescriptor descriptor = attribute.getDescriptor();
                String[] stringArray = descriptor == null || descriptor.isEnumerated() ? ArrayUtilRt.EMPTY_STRING_ARRAY : ENCTYPE;
                if (stringArray == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(3);
                }
                return stringArray;
            }
            if ("rel".equals(name) && tagName.equalsIgnoreCase("link")) {
                if (REL_LINK == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(4);
                }
                return REL_LINK;
            }
            if (("rel".equals(name) || "rev".equals(name)) && (tagName.equalsIgnoreCase("a") || tagName.equalsIgnoreCase("area"))) {
                if (REL_A_AREA == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(5);
                }
                return REL_A_AREA;
            }
            if ("rel".equals(name) && tagName.equalsIgnoreCase("form")) {
                if (REL_FORM == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(6);
                }
                return REL_FORM;
            }
            if ("media".equals(name)) {
                if (MEDIA == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(7);
                }
                return MEDIA;
            }
            if ("language".equals(name)) {
                if (LANGUAGE == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(8);
                }
                return LANGUAGE;
            }
            if ("sandbox".equals(name)) {
                if (SANDBOX == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(9);
                }
                return SANDBOX;
            }
            if ("type".equals(name) && "link".equals(tagName)) {
                if (TYPE == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(10);
                }
                return TYPE;
            }
            if ("http-equiv".equals(name) && "meta".equals(tagName)) {
                if (HtmlUtil.RFC2616_HEADERS == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(11);
                }
                return HtmlUtil.RFC2616_HEADERS;
            }
            if ("content".equals(name) && "meta".equals(tagName) && tag.getAttribute("name") == null) {
                if (MimeTypeDictionary.HTML_CONTENT_TYPES == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(12);
                }
                return MimeTypeDictionary.HTML_CONTENT_TYPES;
            }
            if ("accept".equals(name) && "input".equals(tagName)) {
                if (MimeTypeDictionary.HTML_CONTENT_TYPES == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(13);
                }
                return MimeTypeDictionary.HTML_CONTENT_TYPES;
            }
            if ("accept-charset".equals(name) || "charset".equals(name)) {
                Charset[] charSets = CharsetToolkit.getAvailableCharsets();
                String[] names = new String[charSets.length];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = charSets[i].toString();
                }
                if (names == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(14);
                }
                return names;
            }
            if ("itemprop".equals(name) && !DumbService.isDumb((Project)attribute.getProject())) {
                XmlTag scopeTag = MicrodataUtil.findScopeTag(tag);
                String[] stringArray = scopeTag != null ? HtmlCompletionContributor.findItemProperties(scopeTag) : ArrayUtilRt.EMPTY_STRING_ARRAY;
                if (stringArray == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(15);
                }
                return stringArray;
            }
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(16);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    private static String[] findItemProperties(@NotNull XmlTag tag) {
        XmlAttribute typeAttribute;
        if (tag == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(17);
        }
        if ((typeAttribute = tag.getAttribute("itemtype")) != null) {
            XmlAttributeValue valueElement = typeAttribute.getValueElement();
            PsiReference[] references = valueElement != null ? valueElement.getReferences() : PsiReference.EMPTY_ARRAY;
            ArrayList<String> result2 = new ArrayList<String>();
            for (PsiReference reference : references) {
                PsiElement target;
                PsiElement psiElement = target = reference != null ? reference.resolve() : null;
                if (!(target instanceof PsiFile)) continue;
                result2.addAll(MicrodataUtil.extractProperties((PsiFile)target, StringUtil.unquoteString((String)reference.getCanonicalText())));
            }
            return ArrayUtilRt.toStringArray(result2);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Contract(value="null->false")
    public static boolean shouldTryDeselectingFirstPopupItem(@Nullable PsiElement element) {
        PsiFile file = (PsiFile)ObjectUtils.doIfNotNull((Object)element, PsiElement::getContainingFile);
        if (file == null || !HtmlCompletionContributor.isHtmlElementInTextCompletionEnabledForFile(file)) {
            return false;
        }
        if (HtmlCompletionContributor.isDeselectingFirstPopupItemDisabled(element)) {
            return false;
        }
        IElementType elementType = element.getNode().getElementType();
        if ((elementType == XmlTokenType.XML_DATA_CHARACTERS || element.getNode().getElementType() == XmlTokenType.XML_WHITE_SPACE) && (element.getParent() instanceof XmlText || element.getParent() instanceof XmlDocument)) {
            return !element.getText().endsWith("<");
        }
        if (elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
            return element.getText().contains("&");
        }
        return false;
    }

    @ApiStatus.Internal
    public static ElementPattern<PsiElement> getHtmlElementInTextPattern() {
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)XmlTokenType.XML_DATA_CHARACTERS).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(XmlText.class), PlatformPatterns.psiElement(XmlDocument.class)}))).inFile((ElementPattern)PlatformPatterns.psiFile(HtmlFileImpl.class));
    }

    @ApiStatus.Internal
    public static CompletionResultSet patchResultSetForHtmlElementInTextCompletion(@NotNull CompletionResultSet result2, @NotNull CompletionParameters parameters) {
        if (result2 == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(18);
        }
        if (parameters == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(19);
        }
        result2 = result2.withRelevanceSorter(HtmlCompletionContributor.withoutLiveTemplatesWeigher(null, parameters, result2.getPrefixMatcher()));
        if (parameters.getInvocationCount() == 0) {
            result2 = result2.withPrefixMatcher((PrefixMatcher)new StartOnlyMatcher(result2.getPrefixMatcher()));
        }
        return result2;
    }

    @ApiStatus.Internal
    public static boolean canProvideHtmlElementInTextCompletion(@NotNull CompletionParameters parameters) {
        List psiFiles;
        if (parameters == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(20);
        }
        return ContainerUtil.exists((Iterable)(psiFiles = parameters.getOriginalFile().getViewProvider().getAllFiles()), f -> f instanceof HtmlFileImpl) && ContainerUtil.and((Iterable)psiFiles, f -> HtmlCompletionContributor.isHtmlElementInTextCompletionEnabledForFile(f));
    }

    static boolean isHtmlElementInTextCompletionEnabledForFile(@NotNull PsiFile file) {
        if (file == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(21);
        }
        return ContainerUtil.exists((Iterable)HtmlInTextCompletionEnabler.EP_NAME.getExtensionList(), enabler -> enabler.isEnabledInFile(file));
    }

    static boolean isHtmlElementInTextCompletionAutoPopupEnabledForFile(@NotNull PsiFile file) {
        if (file == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(22);
        }
        return HtmlSettings.getInstance().AUTO_POPUP_TAG_CODE_COMPLETION_ON_TYPING_IN_TEXT && HtmlCompletionContributor.isHtmlElementInTextCompletionEnabledForFile(file);
    }

    private static boolean isDeselectingFirstPopupItemDisabled(@NotNull PsiElement element) {
        if (element == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(23);
        }
        return ContainerUtil.exists((Iterable)HtmlInTextCompletionPopupExtension.EP_NAME.getExtensionList(), ext -> ext.isDeselectingFirstItemDisabled(element));
    }

    private static CompletionSorter withoutLiveTemplatesWeigher(@Nullable CompletionSorter sorter, @NotNull CompletionParameters parameters, @NotNull PrefixMatcher prefixMatcher) {
        if (parameters == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(24);
        }
        if (prefixMatcher == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(25);
        }
        if (sorter == null) {
            sorter = CompletionService.getCompletionService().defaultSorter(parameters, prefixMatcher);
        }
        return ((CompletionSorterImpl)sorter).withoutClassifiers(f -> "templates".equals(f.getId()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 17, 18, 19, 20, 21, 22, 23, 24, 25 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/HtmlCompletionContributor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "addSpecificCompletions";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/HtmlCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findItemProperties";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "patchResultSetForHtmlElementInTextCompletion";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "canProvideHtmlElementInTextCompletion";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isHtmlElementInTextCompletionEnabledForFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isHtmlElementInTextCompletionAutoPopupEnabledForFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDeselectingFirstPopupItemDisabled";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "withoutLiveTemplatesWeigher";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 17, 18, 19, 20, 21, 22, 23, 24, 25 -> new IllegalArgumentException(string2);
        };
    }

    private static class HtmlElementInTextCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private HtmlElementInTextCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
            if (parameters == null) {
                HtmlElementInTextCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                HtmlElementInTextCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                HtmlElementInTextCompletionProvider.$$$reportNull$$$0(2);
            }
            if (!HtmlCompletionContributor.canProvideHtmlElementInTextCompletion(parameters)) {
                return;
            }
            if (parameters.getPosition().getContainingFile().isPhysical()) {
                return;
            }
            PsiFile completionFile = parameters.getPosition().getContainingFile();
            int offset = parameters.getOffset();
            OffsetsInFile offsets = new OffsetsInFile(completionFile);
            offsets.getOffsets().addOffset(CompletionInitializationContext.START_OFFSET, offset);
            offsets = offsets.copyWithReplacement(offset, offset, "<");
            PsiElement tag = (PsiElement)ObjectUtils.doIfNotNull((Object)offsets.getFile().findElementAt(offset + 1), PsiElement::getParent);
            if (tag instanceof XmlTag) {
                CompletionResultSet patchedResultSet = HtmlCompletionContributor.patchResultSetForHtmlElementInTextCompletion(result2, parameters);
                for (LookupElement variant : TagNameReferenceCompletionProvider.getTagNameVariants((XmlTag)tag, "")) {
                    LookupElementDecorator<LookupElement> decorated = new LookupElementDecorator<LookupElement>(variant){

                        @NotNull
                        public String getLookupString() {
                            String string2 = "<" + super.getLookupString();
                            if (string2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return string2;
                        }

                        public void renderElement(@NotNull LookupElementPresentation presentation2) {
                            if (presentation2 == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            super.renderElement(presentation2);
                            presentation2.setItemText("<" + presentation2.getItemText());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[switch (n) {
                                default -> 2;
                                case 1 -> 3;
                            }];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/codeInsight/completion/HtmlCompletionContributor$HtmlElementInTextCompletionProvider$1";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "presentation";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getLookupString";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/codeInsight/completion/HtmlCompletionContributor$HtmlElementInTextCompletionProvider$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray;
                                    objectArray[2] = "renderElement";
                                    break;
                                }
                            }
                            String string2 = String.format(v0, objectArray);
                            throw switch (n) {
                                default -> new IllegalStateException(string2);
                                case 1 -> new IllegalArgumentException(string2);
                            };
                        }
                    };
                    if (variant instanceof PrioritizedLookupElement) {
                        decorated = PrioritizedLookupElement.withGrouping((LookupElement)PrioritizedLookupElement.withExplicitProximity((LookupElement)PrioritizedLookupElement.withPriority((LookupElement)decorated, (double)((PrioritizedLookupElement)variant).getPriority()), (int)((PrioritizedLookupElement)variant).getExplicitProximity()), (int)((PrioritizedLookupElement)variant).getGrouping());
                    }
                    patchedResultSet.consume((LookupElement)decorated);
                }
                patchedResultSet.runRemainingContributors(parameters, r -> patchedResultSet.withPrefixMatcher(r.getPrefixMatcher()).withRelevanceSorter(HtmlCompletionContributor.withoutLiveTemplatesWeigher(r.getSorter(), parameters, r.getPrefixMatcher())).addElement(r.getLookupElement()));
            }
            if (result2.getPrefixMatcher().getPrefix().length() < 2) {
                result2.restartCompletionOnAnyPrefixChange();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/completion/HtmlCompletionContributor$HtmlElementInTextCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class HtmlElementInTextLookupManagerListener
    implements LookupManagerListener {
        public void activeLookupChanged(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
            if (newLookup instanceof LookupImpl) {
                final LookupImpl lookup = (LookupImpl)newLookup;
                if (HtmlCompletionContributor.shouldTryDeselectingFirstPopupItem(newLookup.getPsiElement())) {
                    lookup.setPrefixChangeListener(new PrefixChangeListener(){

                        public void afterAppend(char c) {
                            if (lookup.getCurrentItemOrEmpty() == null && HtmlElementInTextLookupManagerListener.hasTwoCharsAfterAmp(lookup)) {
                                lookup.setSelectedIndex(0);
                            }
                        }
                    });
                    lookup.addLookupListener(new LookupListener(){

                        public void uiRefreshed() {
                            CompletionProcess currentCompletion = CompletionService.getCompletionService().getCurrentCompletion();
                            if (currentCompletion != null && currentCompletion.isAutopopupCompletion() && !lookup.isSelectionTouched() && !HtmlElementInTextLookupManagerListener.hasTwoCharsAfterAmp(lookup)) {
                                lookup.getList().setSelectedValue(null, false);
                                ListSelectionModel selectionModel = lookup.getList().getSelectionModel();
                                selectionModel.setAnchorSelectionIndex(-1);
                                selectionModel.setLeadSelectionIndex(-1);
                            }
                        }
                    });
                }
            }
        }

        private static boolean hasTwoCharsAfterAmp(LookupImpl lookup) {
            int start2 = Math.max(lookup.getLookupStart() - 1, 0);
            int end = lookup.getEditor().getCaretModel().getOffset();
            if (end - start2 < 3) {
                return false;
            }
            Document doc2 = lookup.getEditor().getDocument();
            return doc2.getTextLength() > start2 && doc2.getCharsSequence().charAt(start2) == '&';
        }
    }
}

