/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.patterns;

import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.text.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J \u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/grazie/nlp/patterns/AhoCorasickPattern;", "Lai/grazie/nlp/patterns/Pattern;", "words", "", "", "(Ljava/util/List;)V", "trie", "Lai/grazie/nlp/patterns/AhoCorasickPattern$TrieNode;", "find", "Lai/grazie/text/TextRange;", "text", "", "findWideChar", "Lai/grazie/nlp/patterns/AhoCorasickPattern$WideChar;", "offset", "", "retreat", "last", "depth", "transition", "nodeIdx", "c", "", "AhoCorasickBuilder", "TrieNode", "WideChar", "nlp-patterns"})
public class AhoCorasickPattern
implements Pattern {
    @NotNull
    private final List<TrieNode> trie;

    public AhoCorasickPattern(@NotNull List<String> words2) {
        Intrinsics.checkNotNullParameter(words2, (String)"words");
        AhoCorasickBuilder builder2 = new AhoCorasickBuilder();
        for (String word : CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)words2))) {
            builder2.addWord(word);
        }
        this.trie = builder2.build();
    }

    @Override
    @NotNull
    public List<TextRange> find(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        ArrayList<TextRange> matches = new ArrayList<TextRange>();
        int nodeIdx = 0;
        int idx = 0;
        boolean hadWide = false;
        while (idx < text2.length()) {
            int nextStart;
            char c;
            WideChar wide;
            WideChar wideChar = wide = this.findWideChar(text2, idx);
            char c2 = c = wideChar != null ? wideChar.getMain() : text2.charAt(idx);
            if (wide != null) {
                hadWide = true;
            }
            nodeIdx = this.transition(nodeIdx, c);
            TrieNode node = this.trie.get(nodeIdx);
            WideChar wideChar2 = wide;
            int n = nextStart = wideChar2 != null ? wideChar2.getEndExclusive() : idx + 1;
            if (node.isLeaf()) {
                int length = node.getDepth();
                matches.add(new TextRange(hadWide ? this.retreat(text2, idx, length) : idx - length + 1, nextStart));
            }
            int possibleLeafIdx = node.getSuffixLinkToLeaf();
            while (possibleLeafIdx != 0) {
                int length = this.trie.get(possibleLeafIdx).getDepth();
                matches.add(new TextRange(hadWide ? this.retreat(text2, idx, length) : idx - length + 1, nextStart));
                possibleLeafIdx = this.trie.get(possibleLeafIdx).getSuffixLinkToLeaf();
            }
            idx = nextStart;
        }
        return matches;
    }

    @Nullable
    protected WideChar findWideChar(@NotNull CharSequence text2, int offset) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return null;
    }

    private final int retreat(CharSequence text2, int last, int depth) {
        int start2 = last;
        int i = 2;
        if (i <= depth) {
            while (true) {
                WideChar wide;
                WideChar wideChar = wide = this.findWideChar(text2, start2 - 1);
                int n = start2 = wideChar != null ? wideChar.getStart() : start2 - 1;
                if (i == depth) break;
                ++i;
            }
        }
        return start2;
    }

    private final int transition(int nodeIdx, char c) {
        Character c2;
        if (nodeIdx == 0) {
            c2 = Character.valueOf(c);
            if (!this.trie.get(nodeIdx).getNext().containsKey(c2)) {
                return 0;
            }
        }
        c2 = Character.valueOf(c);
        if (this.trie.get(nodeIdx).getNext().containsKey(c2)) {
            Integer n = this.trie.get(nodeIdx).getNext().get(Character.valueOf(c));
            Intrinsics.checkNotNull((Object)n);
            return ((Number)n).intValue();
        }
        return this.transition(this.trie.get(nodeIdx).getSuffixLink(), c);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lai/grazie/nlp/patterns/AhoCorasickPattern$AhoCorasickBuilder;", "", "()V", "automata", "Ljava/util/ArrayList;", "Lai/grazie/nlp/patterns/AhoCorasickPattern$AhoCorasickBuilder$AutomataBuilderNode;", "Lkotlin/collections/ArrayList;", "addWord", "", "word", "", "build", "", "Lai/grazie/nlp/patterns/AhoCorasickPattern$TrieNode;", "getSuffixLink", "", "nodeIdx", "getSuffixLinkToLeaf", "performTransition", "transitionChar", "", "AutomataBuilderNode", "nlp-patterns"})
    @SourceDebugExtension(value={"SMAP\nAhoCorasickPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AhoCorasickPattern.kt\nai/grazie/nlp/patterns/AhoCorasickPattern$AhoCorasickBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n1559#2:204\n1590#2,4:205\n*S KotlinDebug\n*F\n+ 1 AhoCorasickPattern.kt\nai/grazie/nlp/patterns/AhoCorasickPattern$AhoCorasickBuilder\n*L\n146#1:204\n146#1:205,4\n*E\n"})
    public static final class AhoCorasickBuilder {
        @NotNull
        private final ArrayList<AutomataBuilderNode> automata;

        public AhoCorasickBuilder() {
            Object[] objectArray = new AutomataBuilderNode[1];
            boolean bl = false;
            objectArray[0] = new AutomataBuilderNode(new HashMap<Character, Integer>(), 0, false, 0, (char)(bl ? 1 : 0), 0, new HashMap<Character, Integer>());
            this.automata = CollectionsKt.arrayListOf((Object[])objectArray);
        }

        public final void addWord(@NotNull String word) {
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            int nodeIdx = 0;
            int n = word.length();
            for (int charIdx = 0; charIdx < n; ++charIdx) {
                char c = word.charAt(charIdx);
                Character c2 = Character.valueOf(c);
                if (!((Map)this.automata.get(nodeIdx).getNext()).containsKey(c2)) {
                    int newNodeIdx = this.automata.size();
                    Character c3 = Character.valueOf(c);
                    Integer n2 = newNodeIdx;
                    ((Map)this.automata.get(nodeIdx).getNext()).put(c3, n2);
                    this.automata.add(new AutomataBuilderNode(new HashMap<Character, Integer>(), this.automata.get(nodeIdx).getDepth() + 1, charIdx == word.length() - 1, nodeIdx, c, -1, new HashMap<Character, Integer>()));
                }
                Integer n3 = this.automata.get(nodeIdx).getNext().get(Character.valueOf(c));
                Intrinsics.checkNotNull((Object)n3);
                nodeIdx = ((Number)n3).intValue();
                if (charIdx != word.length() - 1) continue;
                this.automata.get(nodeIdx).setLeaf(true);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<TrieNode> build() {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = this.automata;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void idx;
                void node;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                AutomataBuilderNode automataBuilderNode = (AutomataBuilderNode)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Map<Character, Integer> next = node.getNext().isEmpty() ? MapsKt.emptyMap() : ai.grazie.utils.CollectionsKt.toSmallMemoryFootprintIntValueMap((Map)node.getNext());
                collection.add(new TrieNode(next, node.getDepth(), node.isLeaf(), this.getSuffixLink((int)idx), this.getSuffixLinkToLeaf((int)idx)));
            }
            return (List)destination$iv$iv;
        }

        private final int getSuffixLinkToLeaf(int nodeIdx) {
            int suffixIdx = this.getSuffixLink(nodeIdx);
            while (suffixIdx != 0) {
                if (this.automata.get(suffixIdx).isLeaf()) {
                    return suffixIdx;
                }
                suffixIdx = this.getSuffixLink(suffixIdx);
            }
            return 0;
        }

        private final int getSuffixLink(int nodeIdx) {
            if (this.automata.get(nodeIdx).getSuffixLink() == -1) {
                if (nodeIdx == 0 || this.automata.get(nodeIdx).getParentIdx() == 0) {
                    this.automata.get(nodeIdx).setSuffixLink(0);
                } else {
                    this.automata.get(nodeIdx).setSuffixLink(this.performTransition(this.getSuffixLink(this.automata.get(nodeIdx).getParentIdx()), this.automata.get(nodeIdx).getParentEdgeChar()));
                }
            }
            return this.automata.get(nodeIdx).getSuffixLink();
        }

        private final int performTransition(int nodeIdx, char transitionChar) {
            Character c = Character.valueOf(transitionChar);
            if (!((Map)this.automata.get(nodeIdx).getAutomataTransitions()).containsKey(c)) {
                Integer n;
                Map map2 = this.automata.get(nodeIdx).getAutomataTransitions();
                c = Character.valueOf(transitionChar);
                Character c2 = Character.valueOf(transitionChar);
                if (((Map)this.automata.get(nodeIdx).getNext()).containsKey(c2)) {
                    Integer n2 = this.automata.get(nodeIdx).getNext().get(Character.valueOf(transitionChar));
                    Intrinsics.checkNotNull((Object)n2);
                    n = n2;
                } else {
                    n = nodeIdx == 0 ? 0 : this.performTransition(this.getSuffixLink(nodeIdx), transitionChar);
                }
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"if (transitionChar in au\u2026ar)\n                    }");
                Integer n3 = n;
                map2.put(c, n3);
            }
            Integer n = this.automata.get(nodeIdx).getAutomataTransitions().get(Character.valueOf(transitionChar));
            Intrinsics.checkNotNull((Object)n);
            return ((Number)n).intValue();
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001f\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001Bu\u0012\"\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\"\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\tH\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J%\u0010#\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006H\u00c6\u0003J\u0087\u0001\u0010$\u001a\u00020\u00002$\b\u0002\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u00052$\b\u0002\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006H\u00c6\u0001J\u0013\u0010%\u001a\u00020\t2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020\u0005H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R-\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0013\"\u0004\b\u0014\u0010\u0015R-\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0012\"\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lai/grazie/nlp/patterns/AhoCorasickPattern$AhoCorasickBuilder$AutomataBuilderNode;", "", "next", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "depth", "isLeaf", "", "parentIdx", "parentEdgeChar", "suffixLink", "automataTransitions", "(Ljava/util/HashMap;IZICILjava/util/HashMap;)V", "getAutomataTransitions", "()Ljava/util/HashMap;", "getDepth", "()I", "()Z", "setLeaf", "(Z)V", "getNext", "getParentEdgeChar", "()C", "getParentIdx", "getSuffixLink", "setSuffixLink", "(I)V", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "", "nlp-patterns"})
        public static final class AutomataBuilderNode {
            @NotNull
            private final HashMap<Character, Integer> next;
            private final int depth;
            private boolean isLeaf;
            private final int parentIdx;
            private final char parentEdgeChar;
            private int suffixLink;
            @NotNull
            private final HashMap<Character, Integer> automataTransitions;

            public AutomataBuilderNode(@NotNull HashMap<Character, Integer> next, int depth, boolean isLeaf, int parentIdx, char parentEdgeChar, int suffixLink, @NotNull HashMap<Character, Integer> automataTransitions) {
                Intrinsics.checkNotNullParameter(next, (String)"next");
                Intrinsics.checkNotNullParameter(automataTransitions, (String)"automataTransitions");
                this.next = next;
                this.depth = depth;
                this.isLeaf = isLeaf;
                this.parentIdx = parentIdx;
                this.parentEdgeChar = parentEdgeChar;
                this.suffixLink = suffixLink;
                this.automataTransitions = automataTransitions;
            }

            @NotNull
            public final HashMap<Character, Integer> getNext() {
                return this.next;
            }

            public final int getDepth() {
                return this.depth;
            }

            public final boolean isLeaf() {
                return this.isLeaf;
            }

            public final void setLeaf(boolean bl) {
                this.isLeaf = bl;
            }

            public final int getParentIdx() {
                return this.parentIdx;
            }

            public final char getParentEdgeChar() {
                return this.parentEdgeChar;
            }

            public final int getSuffixLink() {
                return this.suffixLink;
            }

            public final void setSuffixLink(int n) {
                this.suffixLink = n;
            }

            @NotNull
            public final HashMap<Character, Integer> getAutomataTransitions() {
                return this.automataTransitions;
            }

            @NotNull
            public final HashMap<Character, Integer> component1() {
                return this.next;
            }

            public final int component2() {
                return this.depth;
            }

            public final boolean component3() {
                return this.isLeaf;
            }

            public final int component4() {
                return this.parentIdx;
            }

            public final char component5() {
                return this.parentEdgeChar;
            }

            public final int component6() {
                return this.suffixLink;
            }

            @NotNull
            public final HashMap<Character, Integer> component7() {
                return this.automataTransitions;
            }

            @NotNull
            public final AutomataBuilderNode copy(@NotNull HashMap<Character, Integer> next, int depth, boolean isLeaf, int parentIdx, char parentEdgeChar, int suffixLink, @NotNull HashMap<Character, Integer> automataTransitions) {
                Intrinsics.checkNotNullParameter(next, (String)"next");
                Intrinsics.checkNotNullParameter(automataTransitions, (String)"automataTransitions");
                return new AutomataBuilderNode(next, depth, isLeaf, parentIdx, parentEdgeChar, suffixLink, automataTransitions);
            }

            public static /* synthetic */ AutomataBuilderNode copy$default(AutomataBuilderNode automataBuilderNode, HashMap hashMap, int n, boolean bl, int n2, char c, int n3, HashMap hashMap2, int n4, Object object) {
                if ((n4 & 1) != 0) {
                    hashMap = automataBuilderNode.next;
                }
                if ((n4 & 2) != 0) {
                    n = automataBuilderNode.depth;
                }
                if ((n4 & 4) != 0) {
                    bl = automataBuilderNode.isLeaf;
                }
                if ((n4 & 8) != 0) {
                    n2 = automataBuilderNode.parentIdx;
                }
                if ((n4 & 0x10) != 0) {
                    c = automataBuilderNode.parentEdgeChar;
                }
                if ((n4 & 0x20) != 0) {
                    n3 = automataBuilderNode.suffixLink;
                }
                if ((n4 & 0x40) != 0) {
                    hashMap2 = automataBuilderNode.automataTransitions;
                }
                return automataBuilderNode.copy(hashMap, n, bl, n2, c, n3, hashMap2);
            }

            @NotNull
            public String toString() {
                return "AutomataBuilderNode(next=" + this.next + ", depth=" + this.depth + ", isLeaf=" + this.isLeaf + ", parentIdx=" + this.parentIdx + ", parentEdgeChar=" + this.parentEdgeChar + ", suffixLink=" + this.suffixLink + ", automataTransitions=" + this.automataTransitions + ")";
            }

            public int hashCode() {
                int result2 = this.next.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.depth);
                int n = this.isLeaf ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                result2 = result2 * 31 + n;
                result2 = result2 * 31 + Integer.hashCode(this.parentIdx);
                result2 = result2 * 31 + Character.hashCode(this.parentEdgeChar);
                result2 = result2 * 31 + Integer.hashCode(this.suffixLink);
                result2 = result2 * 31 + this.automataTransitions.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AutomataBuilderNode)) {
                    return false;
                }
                AutomataBuilderNode automataBuilderNode = (AutomataBuilderNode)other;
                if (!Intrinsics.areEqual(this.next, automataBuilderNode.next)) {
                    return false;
                }
                if (this.depth != automataBuilderNode.depth) {
                    return false;
                }
                if (this.isLeaf != automataBuilderNode.isLeaf) {
                    return false;
                }
                if (this.parentIdx != automataBuilderNode.parentIdx) {
                    return false;
                }
                if (this.parentEdgeChar != automataBuilderNode.parentEdgeChar) {
                    return false;
                }
                if (this.suffixLink != automataBuilderNode.suffixLink) {
                    return false;
                }
                return Intrinsics.areEqual(this.automataTransitions, automataBuilderNode.automataTransitions);
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003JG\u0010\u0018\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000eR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006\u001e"}, d2={"Lai/grazie/nlp/patterns/AhoCorasickPattern$TrieNode;", "", "next", "", "", "", "depth", "isLeaf", "", "suffixLink", "suffixLinkToLeaf", "(Ljava/util/Map;IZII)V", "getDepth", "()I", "()Z", "getNext", "()Ljava/util/Map;", "getSuffixLink", "getSuffixLinkToLeaf", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "", "nlp-patterns"})
    public static final class TrieNode {
        @NotNull
        private final Map<Character, Integer> next;
        private final int depth;
        private final boolean isLeaf;
        private final int suffixLink;
        private final int suffixLinkToLeaf;

        public TrieNode(@NotNull Map<Character, Integer> next, int depth, boolean isLeaf, int suffixLink, int suffixLinkToLeaf) {
            Intrinsics.checkNotNullParameter(next, (String)"next");
            this.next = next;
            this.depth = depth;
            this.isLeaf = isLeaf;
            this.suffixLink = suffixLink;
            this.suffixLinkToLeaf = suffixLinkToLeaf;
        }

        @NotNull
        public final Map<Character, Integer> getNext() {
            return this.next;
        }

        public final int getDepth() {
            return this.depth;
        }

        public final boolean isLeaf() {
            return this.isLeaf;
        }

        public final int getSuffixLink() {
            return this.suffixLink;
        }

        public final int getSuffixLinkToLeaf() {
            return this.suffixLinkToLeaf;
        }

        @NotNull
        public final Map<Character, Integer> component1() {
            return this.next;
        }

        public final int component2() {
            return this.depth;
        }

        public final boolean component3() {
            return this.isLeaf;
        }

        public final int component4() {
            return this.suffixLink;
        }

        public final int component5() {
            return this.suffixLinkToLeaf;
        }

        @NotNull
        public final TrieNode copy(@NotNull Map<Character, Integer> next, int depth, boolean isLeaf, int suffixLink, int suffixLinkToLeaf) {
            Intrinsics.checkNotNullParameter(next, (String)"next");
            return new TrieNode(next, depth, isLeaf, suffixLink, suffixLinkToLeaf);
        }

        public static /* synthetic */ TrieNode copy$default(TrieNode trieNode, Map map2, int n, boolean bl, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                map2 = trieNode.next;
            }
            if ((n4 & 2) != 0) {
                n = trieNode.depth;
            }
            if ((n4 & 4) != 0) {
                bl = trieNode.isLeaf;
            }
            if ((n4 & 8) != 0) {
                n2 = trieNode.suffixLink;
            }
            if ((n4 & 0x10) != 0) {
                n3 = trieNode.suffixLinkToLeaf;
            }
            return trieNode.copy(map2, n, bl, n2, n3);
        }

        @NotNull
        public String toString() {
            return "TrieNode(next=" + this.next + ", depth=" + this.depth + ", isLeaf=" + this.isLeaf + ", suffixLink=" + this.suffixLink + ", suffixLinkToLeaf=" + this.suffixLinkToLeaf + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.next).hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.depth);
            int n = this.isLeaf ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            result2 = result2 * 31 + Integer.hashCode(this.suffixLink);
            result2 = result2 * 31 + Integer.hashCode(this.suffixLinkToLeaf);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TrieNode)) {
                return false;
            }
            TrieNode trieNode = (TrieNode)other;
            if (!Intrinsics.areEqual(this.next, trieNode.next)) {
                return false;
            }
            if (this.depth != trieNode.depth) {
                return false;
            }
            if (this.isLeaf != trieNode.isLeaf) {
                return false;
            }
            if (this.suffixLink != trieNode.suffixLink) {
                return false;
            }
            return this.suffixLinkToLeaf == trieNode.suffixLinkToLeaf;
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lai/grazie/nlp/patterns/AhoCorasickPattern$WideChar;", "", "start", "", "endExclusive", "main", "", "(IIC)V", "getEndExclusive", "()I", "getMain", "()C", "getStart", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "nlp-patterns"})
    protected static final class WideChar {
        private final int start;
        private final int endExclusive;
        private final char main;

        public WideChar(int start2, int endExclusive, char main2) {
            this.start = start2;
            this.endExclusive = endExclusive;
            this.main = main2;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEndExclusive() {
            return this.endExclusive;
        }

        public final char getMain() {
            return this.main;
        }

        public final int component1() {
            return this.start;
        }

        public final int component2() {
            return this.endExclusive;
        }

        public final char component3() {
            return this.main;
        }

        @NotNull
        public final WideChar copy(int start2, int endExclusive, char main2) {
            return new WideChar(start2, endExclusive, main2);
        }

        public static /* synthetic */ WideChar copy$default(WideChar wideChar, int n, int n2, char c, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = wideChar.start;
            }
            if ((n3 & 2) != 0) {
                n2 = wideChar.endExclusive;
            }
            if ((n3 & 4) != 0) {
                c = wideChar.main;
            }
            return wideChar.copy(n, n2, c);
        }

        @NotNull
        public String toString() {
            return "WideChar(start=" + this.start + ", endExclusive=" + this.endExclusive + ", main=" + this.main + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.start);
            result2 = result2 * 31 + Integer.hashCode(this.endExclusive);
            result2 = result2 * 31 + Character.hashCode(this.main);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WideChar)) {
                return false;
            }
            WideChar wideChar = (WideChar)other;
            if (this.start != wideChar.start) {
                return false;
            }
            if (this.endExclusive != wideChar.endExclusive) {
                return false;
            }
            return this.main == wideChar.main;
        }
    }
}

