/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ijent.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.platform.ijent.IjentBundle;
import com.intellij.platform.ijent.IjentExecFileProvider;
import com.intellij.platform.ijent.IjentExecFileProviderKt;
import com.intellij.platform.ijent.impl.ProductionIjentExecFileProvider;
import com.intellij.platform.ijent.impl.ProductionIjentExecFileProviderKt;
import com.intellij.util.system.CpuArch;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000E\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000*\u0001\u0019\u001a \u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0002\u001a\u001c\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0081@\u00a2\u0006\u0002\u0010\u0012\u001a\u0016\u0010\u0013\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0001\u001a\u001e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0081@\u00a2\u0006\u0002\u0010\u0017\u001a\u0017\u0010\u0018\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u00a2\u0006\u0002\u0010\u001a\u001a\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u0003*\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\f\u0010\u001c\u001a\u00020\u001d*\u00020\u0016H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0002\u001a\u0004\u0018\u00010\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "repositoryRoot", "Ljava/nio/file/Path;", "getRepositoryRoot", "()Ljava/nio/file/Path;", "repositoryRoot$delegate", "Lkotlin/Lazy;", "askAboutPlugin", "", "mayShowDialog", "Lkotlin/reflect/KMutableProperty0;", "dialogMessage", "", "reportAboutProblemsWhenRunningFromSources", "", "localBinaries", "", "(Ljava/util/Collection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "theOnlyLocalBinary", "tryGetIjentBinariesFromStaticDirectory", "targetPlatform", "Lcom/intellij/platform/ijent/IjentExecFileProvider$SupportedPlatform;", "(Lcom/intellij/platform/ijent/IjentExecFileProvider$SupportedPlatform;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doNotAskOption", "com/intellij/platform/ijent/impl/ProductionIjentExecFileProviderKt$doNotAskOption$1", "(Lkotlin/reflect/KMutableProperty0;)Lcom/intellij/platform/ijent/impl/ProductionIjentExecFileProviderKt$doNotAskOption$1;", "getBinaryFromPluginRoot", "getHostingPlugin", "Lcom/intellij/openapi/extensions/PluginId;", "intellij.platform.ijent.impl"})
@SourceDebugExtension(value={"SMAP\nProductionIjentExecFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProductionIjentExecFileProvider.kt\ncom/intellij/platform/ijent/impl/ProductionIjentExecFileProviderKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,278:1\n11#2:279\n*S KotlinDebug\n*F\n+ 1 ProductionIjentExecFileProvider.kt\ncom/intellij/platform/ijent/impl/ProductionIjentExecFileProviderKt\n*L\n278#1:279\n*E\n"})
public final class ProductionIjentExecFileProviderKt {
    @NotNull
    private static final Lazy repositoryRoot$delegate = LazyKt.lazy((Function0)repositoryRoot.2.INSTANCE);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final PluginId getHostingPlugin(@NotNull IjentExecFileProvider.SupportedPlatform $this$getHostingPlugin) {
        PluginId pluginId;
        Intrinsics.checkNotNullParameter((Object)$this$getHostingPlugin, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$getHostingPlugin.ordinal()]) {
            case 1: 
            case 2: {
                PluginId pluginId2 = PluginId.getId((String)"intellij.platform.ijent.impl");
                pluginId = pluginId2;
                Intrinsics.checkNotNullExpressionValue((Object)pluginId2, (String)"getId(...)");
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                PluginId pluginId3 = PluginId.getId((String)"ijent.binariesPlugin");
                pluginId = pluginId3;
                Intrinsics.checkNotNullExpressionValue((Object)pluginId3, (String)"getId(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pluginId;
    }

    @VisibleForTesting
    @Nullable
    public static final Object tryGetIjentBinariesFromStaticDirectory(@NotNull IjentExecFileProvider.SupportedPlatform targetPlatform, @NotNull Continuation<? super Collection<? extends Path>> $completion) {
        Path path = ProductionIjentExecFileProviderKt.getRepositoryRoot();
        if (path == null) {
            return null;
        }
        Path repositoryRoot2 = path;
        LOG.debug("Looking if there are locally built IJent binaries");
        String explicitTargetSubdir = switch (WhenMappings.$EnumSwitchMapping$0[targetPlatform.ordinal()]) {
            case 3 -> "aarch64-apple-darwin";
            case 1 -> "aarch64-unknown-linux-musl";
            case 4 -> "x86_64-apple-darwin";
            case 2 -> "x86_64-unknown-linux-musl";
            case 5 -> "x86_64-pc-windows-gnu";
            default -> throw new NoWhenBranchMatchedException();
        };
        Path localBinariesHomePath = repositoryRoot2.resolve("fleet/native/target");
        String extension = switch (WhenMappings.$EnumSwitchMapping$0[targetPlatform.ordinal()]) {
            case 1, 2, 3, 4 -> "";
            case 5 -> ".exe";
            default -> throw new NoWhenBranchMatchedException();
        };
        boolean sameSystem = switch (WhenMappings.$EnumSwitchMapping$0[targetPlatform.ordinal()]) {
            case 3 -> {
                if (SystemInfoRt.isMac && CpuArch.isArm64()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (SystemInfoRt.isLinux && CpuArch.isArm64()) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (SystemInfoRt.isMac && CpuArch.isIntel64()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (SystemInfoRt.isLinux && CpuArch.isIntel64()) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (SystemInfoRt.isWindows && CpuArch.isIntel64()) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        Object[] objectArray = new String[]{"debug", "release"};
        return SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Function1)((Function1)new Function1<String, Sequence<? extends Path>>(localBinariesHomePath, explicitTargetSubdir, extension, sameSystem){
            final /* synthetic */ Path $localBinariesHomePath;
            final /* synthetic */ String $explicitTargetSubdir;
            final /* synthetic */ String $extension;
            final /* synthetic */ boolean $sameSystem;
            {
                this.$localBinariesHomePath = $localBinariesHomePath;
                this.$explicitTargetSubdir = $explicitTargetSubdir;
                this.$extension = $extension;
                this.$sameSystem = $sameSystem;
                super(1);
            }

            @NotNull
            public final Sequence<Path> invoke(@NotNull String subdir) {
                Intrinsics.checkNotNullParameter((Object)subdir, (String)"subdir");
                return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Path>, Continuation<? super Unit>, Object>(this.$localBinariesHomePath, this.$explicitTargetSubdir, subdir, this.$extension, this.$sameSystem, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ Path $localBinariesHomePath;
                    final /* synthetic */ String $explicitTargetSubdir;
                    final /* synthetic */ String $subdir;
                    final /* synthetic */ String $extension;
                    final /* synthetic */ boolean $sameSystem;
                    {
                        this.$localBinariesHomePath = $localBinariesHomePath;
                        this.$explicitTargetSubdir = $explicitTargetSubdir;
                        this.$subdir = $subdir;
                        this.$extension = $extension;
                        this.$sameSystem = $sameSystem;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$sequence = (SequenceScope)this.L$0;
                                this.L$0 = $this$sequence;
                                this.label = 1;
                                v0 = $this$sequence.yield((Object)this.$localBinariesHomePath.resolve(this.$explicitTargetSubdir + "/" + this.$subdir + "/ijent" + this.$extension), (Continuation)this);
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl16
                            }
                            case 1: {
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl16:
                                // 2 sources

                                if (this.$sameSystem) {
                                    this.L$0 = null;
                                    this.label = 2;
                                    v1 = $this$sequence.yield((Object)this.$localBinariesHomePath.resolve(this.$subdir + "/ijent" + this.$extension), (Continuation)this);
                                    if (v1 == var3_2) {
                                        return var3_2;
                                    }
                                }
                                ** GOTO lbl26
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl26:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    @Nullable
                    public final Object invoke(@NotNull SequenceScope<? super Path> p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
        })), (Function1)tryGetIjentBinariesFromStaticDirectory.3.INSTANCE));
    }

    @VisibleForTesting
    @NotNull
    public static final Path theOnlyLocalBinary(@NotNull Collection<? extends Path> localBinaries) {
        Intrinsics.checkNotNullParameter(localBinaries, (String)"localBinaries");
        Path theBinary = (Path)CollectionsKt.first((Iterable)localBinaries);
        LOG.warn("Reminder: the following IJent is used instead of the bundled one. In case if it is undesired, delete the binary. " + theBinary);
        return theBinary;
    }

    @VisibleForTesting
    @Nullable
    public static final Object reportAboutProblemsWhenRunningFromSources(@NotNull Collection<? extends Path> localBinaries, @NotNull Continuation<? super Unit> $completion) {
        String message = CollectionsKt.joinToString$default((Iterable)localBinaries, (CharSequence)"\n\n", (CharSequence)"Ambiguity in paths to locally built IJents. Don't know what to choose between the files below. Keep only the right file, delete the others.\n\n", null, (int)0, null, null, (int)60, null);
        Application application = ApplicationManager.getApplication();
        boolean bl = application != null ? !application.isUnitTestMode() : false;
        if (bl) {
            CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
            ModalityState modalityState = ModalityState.any();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
            Object object = BuildersKt.withContext((CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(message, null){
                int label;
                final /* synthetic */ String $message;
                {
                    this.$message = $message;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Messages.showErrorDialog((String)this.$message, (String)"IJent in internal mode");
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        throw new IllegalStateException(message.toString());
    }

    private static final Path getBinaryFromPluginRoot(Path $this$getBinaryFromPluginRoot, IjentExecFileProvider.SupportedPlatform targetPlatform) {
        Path path;
        Path result = $this$getBinaryFromPluginRoot.resolve(IjentExecFileProviderKt.getExecutableName((IjentExecFileProvider.SupportedPlatform)targetPlatform));
        Intrinsics.checkNotNull((Object)result);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(result, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LOG.warn(result + " isn't a regular file. It seems that the plugin " + $this$getBinaryFromPluginRoot + " is corrupted.");
            path = null;
        } else {
            path = result;
        }
        return path;
    }

    private static final Path getRepositoryRoot() {
        Lazy lazy = repositoryRoot$delegate;
        return (Path)lazy.getValue();
    }

    private static final boolean askAboutPlugin(KMutableProperty0<Boolean> mayShowDialog, @NlsContexts.DialogMessage String dialogMessage) {
        return (Boolean)mayShowDialog.get() != false && ((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(IjentBundle.INSTANCE.message("dialog.title.ijent.binary.plugin", new Object[0]), dialogMessage).doNotAsk((DoNotAskOption)ProductionIjentExecFileProviderKt.doNotAskOption(mayShowDialog))).ask(null);
    }

    private static final doNotAskOption.1 doNotAskOption(KMutableProperty0<Boolean> $this$doNotAskOption) {
        return new DoNotAskOption.Adapter($this$doNotAskOption){
            final /* synthetic */ KMutableProperty0<Boolean> $this_doNotAskOption;
            {
                this.$this_doNotAskOption = $receiver;
            }

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (exitCode == 0) {
                    this.$this_doNotAskOption.set((Object)(!isSelected ? 1 : 0));
                }
            }
        };
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Path access$getBinaryFromPluginRoot(Path $receiver, IjentExecFileProvider.SupportedPlatform targetPlatform) {
        return ProductionIjentExecFileProviderKt.getBinaryFromPluginRoot($receiver, targetPlatform);
    }

    public static final /* synthetic */ boolean access$askAboutPlugin(KMutableProperty0 mayShowDialog, String dialogMessage) {
        return ProductionIjentExecFileProviderKt.askAboutPlugin((KMutableProperty0<Boolean>)mayShowDialog, dialogMessage);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProductionIjentExecFileProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IjentExecFileProvider.SupportedPlatform.values().length];
            try {
                nArray[IjentExecFileProvider.SupportedPlatform.AARCH64__LINUX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IjentExecFileProvider.SupportedPlatform.X86_64__LINUX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IjentExecFileProvider.SupportedPlatform.AARCH64__DARWIN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IjentExecFileProvider.SupportedPlatform.X86_64__DARWIN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IjentExecFileProvider.SupportedPlatform.X86_64__WINDOWS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

