/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.profiler;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bH\u00c6\u0003JU\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\"\u001a\u00020\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001J\u001c\u0010&\u001a\u00020'2\n\u0010(\u001a\u00060)j\u0002`*2\b\b\u0002\u0010+\u001a\u00020$J\f\u0010,\u001a\u00020\u0003*\u00020\u0005H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006-"}, d2={"Lio/kinference/profiler/ProfileAnalysisEntry;", "", "name", "", "avg", "", "max", "min", "p50", "p90", "children", "", "(Ljava/lang/String;DDDDDLjava/util/List;)V", "getAvg", "()D", "getChildren", "()Ljava/util/List;", "getMax", "getMin", "getName", "()Ljava/lang/String;", "getP50", "getP90", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "getInfo", "hashCode", "", "toString", "writeToStringBuilder", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "toRoundString", "model-profiler"})
public final class ProfileAnalysisEntry {
    @NotNull
    private final String name;
    private final double avg;
    private final double max;
    private final double min;
    private final double p50;
    private final double p90;
    @NotNull
    private final List<ProfileAnalysisEntry> children;

    public ProfileAnalysisEntry(@NotNull String name, double avg, double max2, double min2, double p50, double p90, @NotNull List<ProfileAnalysisEntry> children2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(children2, (String)"children");
        this.name = name;
        this.avg = avg;
        this.max = max2;
        this.min = min2;
        this.p50 = p50;
        this.p90 = p90;
        this.children = children2;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final double getAvg() {
        return this.avg;
    }

    public final double getMax() {
        return this.max;
    }

    public final double getMin() {
        return this.min;
    }

    public final double getP50() {
        return this.p50;
    }

    public final double getP90() {
        return this.p90;
    }

    @NotNull
    public final List<ProfileAnalysisEntry> getChildren() {
        return this.children;
    }

    private final String toRoundString(double $this$toRoundString) {
        int rounded = (int)$this$toRoundString;
        return StringsKt.padStart$default((String)(rounded + "." + StringsKt.padStart((String)String.valueOf(MathKt.roundToInt((double)(($this$toRoundString - (double)rounded) * 100.0))), (int)2, (char)'0')), (int)7, (char)'\u0000', (int)2, null);
    }

    public final void writeToStringBuilder(@NotNull StringBuilder builder2, int indent) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        builder2.append("\n" + StringsKt.padEnd$default((String)(StringsKt.repeat((CharSequence)"  ", (int)indent) + this.name), (int)40, (char)'\u0000', (int)2, null) + " AVG: " + this.toRoundString(this.avg) + " ms | MAX: " + this.toRoundString(this.max) + " ms | MIN: " + this.toRoundString(this.min) + " ms | Percentile 50: " + this.toRoundString(this.p50) + " ms | Percentile 90: " + this.toRoundString(this.p90) + " ms");
        for (ProfileAnalysisEntry entry2 : this.children) {
            entry2.writeToStringBuilder(builder2, indent + 1);
        }
    }

    public static /* synthetic */ void writeToStringBuilder$default(ProfileAnalysisEntry profileAnalysisEntry, StringBuilder stringBuilder, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        profileAnalysisEntry.writeToStringBuilder(stringBuilder, n);
    }

    @NotNull
    public final String getInfo() {
        StringBuilder stringBuilder;
        StringBuilder $this$getInfo_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        ProfileAnalysisEntry.writeToStringBuilder$default(this, $this$getInfo_u24lambda_u240, 0, 2, null);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final double component2() {
        return this.avg;
    }

    public final double component3() {
        return this.max;
    }

    public final double component4() {
        return this.min;
    }

    public final double component5() {
        return this.p50;
    }

    public final double component6() {
        return this.p90;
    }

    @NotNull
    public final List<ProfileAnalysisEntry> component7() {
        return this.children;
    }

    @NotNull
    public final ProfileAnalysisEntry copy(@NotNull String name, double avg, double max2, double min2, double p50, double p90, @NotNull List<ProfileAnalysisEntry> children2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(children2, (String)"children");
        return new ProfileAnalysisEntry(name, avg, max2, min2, p50, p90, children2);
    }

    public static /* synthetic */ ProfileAnalysisEntry copy$default(ProfileAnalysisEntry profileAnalysisEntry, String string, double d, double d2, double d3, double d4, double d5, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = profileAnalysisEntry.name;
        }
        if ((n & 2) != 0) {
            d = profileAnalysisEntry.avg;
        }
        if ((n & 4) != 0) {
            d2 = profileAnalysisEntry.max;
        }
        if ((n & 8) != 0) {
            d3 = profileAnalysisEntry.min;
        }
        if ((n & 0x10) != 0) {
            d4 = profileAnalysisEntry.p50;
        }
        if ((n & 0x20) != 0) {
            d5 = profileAnalysisEntry.p90;
        }
        if ((n & 0x40) != 0) {
            list = profileAnalysisEntry.children;
        }
        return profileAnalysisEntry.copy(string, d, d2, d3, d4, d5, list);
    }

    @NotNull
    public String toString() {
        return "ProfileAnalysisEntry(name=" + this.name + ", avg=" + this.avg + ", max=" + this.max + ", min=" + this.min + ", p50=" + this.p50 + ", p90=" + this.p90 + ", children=" + this.children + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + Double.hashCode(this.avg);
        result2 = result2 * 31 + Double.hashCode(this.max);
        result2 = result2 * 31 + Double.hashCode(this.min);
        result2 = result2 * 31 + Double.hashCode(this.p50);
        result2 = result2 * 31 + Double.hashCode(this.p90);
        result2 = result2 * 31 + ((Object)this.children).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProfileAnalysisEntry)) {
            return false;
        }
        ProfileAnalysisEntry profileAnalysisEntry = (ProfileAnalysisEntry)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)profileAnalysisEntry.name)) {
            return false;
        }
        if (Double.compare(this.avg, profileAnalysisEntry.avg) != 0) {
            return false;
        }
        if (Double.compare(this.max, profileAnalysisEntry.max) != 0) {
            return false;
        }
        if (Double.compare(this.min, profileAnalysisEntry.min) != 0) {
            return false;
        }
        if (Double.compare(this.p50, profileAnalysisEntry.p50) != 0) {
            return false;
        }
        if (Double.compare(this.p90, profileAnalysisEntry.p90) != 0) {
            return false;
        }
        return Intrinsics.areEqual(this.children, profileAnalysisEntry.children);
    }
}

