/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.tiled;

import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.Strides;
import io.kinference.ndarray.arrays.pointers.PrimitivePointer;
import io.kinference.ndarray.arrays.pointers.PrimitivePointerKt;
import io.kinference.primitives.types.PrimitiveArray;
import io.kinference.primitives.types.PrimitiveType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0015\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ,\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0019\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u0003J\u0006\u0010\u001c\u001a\u00020\u0000J\u0016\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J\"\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\f2\b\b\u0002\u0010\"\u001a\u00020\u00032\b\b\u0002\u0010#\u001a\u00020\u0003J\u0011\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u0003H\u0086\u0002J\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030'2\u0006\u0010%\u001a\u00020\u0003J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0000J\u0010\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020\u0003J\u0019\u0010-\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\fH\u0086\u0002J\u0006\u0010.\u001a\u00020\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000f\u00a8\u00060"}, d2={"Lio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray;", "", "size", "", "blockSize", "(II)V", "blocks", "", "Lio/kinference/primitives/types/PrimitiveArray;", "([Lio/kinference/primitives/types/PrimitiveArray;)V", "init", "Lkotlin/Function1;", "Lio/kinference/primitives/types/PrimitiveType;", "(IILkotlin/jvm/functions/Function1;)V", "getBlockSize", "()I", "getBlocks", "()[Lio/kinference/primitives/types/PrimitiveArray;", "[Lio/kinference/primitives/types/PrimitiveArray;", "blocksNum", "getBlocksNum", "getSize", "copyInto", "", "dest", "destOffset", "srcStart", "srcEnd", "copyOf", "copyOfRange", "fromIndex", "toIndex", "fill", "value", "from", "to", "get", "i", "indexFor", "Lkotlin/Pair;", "plus", "other", "pointer", "Lio/kinference/ndarray/arrays/pointers/PrimitivePointer;", "startIndex", "set", "toArray", "Companion", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nPrimitiveTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrimitiveTiledArray.kt\nio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 PrimitivePointer.kt\nio/kinference/ndarray/arrays/pointers/PrimitivePointerKt\n*L\n1#1,186:1\n1#2:187\n1#2:189\n1#2:221\n259#3:188\n261#3,30:190\n259#3:220\n261#3,30:222\n*S KotlinDebug\n*F\n+ 1 PrimitiveTiledArray.kt\nio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray\n*L\n145#1:189\n152#1:221\n145#1:188\n145#1:190,30\n152#1:220\n152#1:222,30\n*E\n"})
public final class PrimitiveTiledArray {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int size;
    private final int blockSize;
    private final int blocksNum;
    @NotNull
    private final PrimitiveArray[] blocks;

    public final int getSize() {
        return this.size;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final int getBlocksNum() {
        return this.blocksNum;
    }

    @NotNull
    public final PrimitiveArray[] getBlocks() {
        return this.blocks;
    }

    public PrimitiveTiledArray(int size2, int blockSize) {
        if (blockSize != 0 && !(size2 % blockSize == 0)) {
            boolean bl = false;
            String string = "Size must divide blockSize";
            throw new IllegalArgumentException(string.toString());
        }
        this.blocksNum = blockSize == 0 ? 0 : size2 / blockSize;
        int n = 0;
        int n2 = this.blocksNum;
        PrimitiveArray[] primitiveArrayArray = new PrimitiveArray[n2];
        PrimitiveTiledArray primitiveTiledArray = this;
        while (n < n2) {
            int n3 = n++;
            primitiveArrayArray[n3] = new PrimitiveArray(blockSize);
        }
        primitiveTiledArray.blocks = primitiveArrayArray;
        this.blockSize = blockSize;
        this.size = size2;
    }

    public PrimitiveTiledArray(@NotNull PrimitiveArray[] blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        this.blocks = blocks;
        this.blockSize = blocks.length == 0 ? 0 : ((PrimitiveArray)ArraysKt.first((Object[])blocks)).getSize();
        this.blocksNum = blocks.length;
        this.size = this.blocksNum * this.blockSize;
    }

    public PrimitiveTiledArray(int size2, int blockSize, @NotNull Function1<? super Integer, ? extends PrimitiveType> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this(size2, blockSize);
        int count = 0;
        for (PrimitiveArray block : this.blocks) {
            for (int idx = 0; idx < blockSize; ++idx) {
                block.set(idx, (PrimitiveType)init.invoke((Object)count++));
            }
        }
    }

    @NotNull
    public final PrimitivePointer pointer(int startIndex) {
        return new PrimitivePointer(this, startIndex);
    }

    public static /* synthetic */ PrimitivePointer pointer$default(PrimitiveTiledArray primitiveTiledArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return primitiveTiledArray.pointer(n);
    }

    @NotNull
    public final PrimitiveArray toArray() {
        if (this.size == 0) {
            return new PrimitiveArray(0);
        }
        PrimitiveArray array = new PrimitiveArray(this.size);
        int offset = 0;
        for (PrimitiveArray block : this.blocks) {
            PrimitiveArray.copyInto$default(block, array, offset, 0, 0, 12, null);
            offset += this.blockSize;
        }
        return array;
    }

    @NotNull
    public final Pair<Integer, Integer> indexFor(int i) {
        int blockIdx = i / this.blockSize;
        int blockOff = i % this.blockSize;
        return TuplesKt.to((Object)blockIdx, (Object)blockOff);
    }

    @NotNull
    public final PrimitiveType get(int i) {
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        return this.blocks[blockIdx].get(blockOff);
    }

    public final void set(int i, @NotNull PrimitiveType value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        this.blocks[blockIdx].set(blockOff, value);
    }

    @NotNull
    public final PrimitiveTiledArray copyOf() {
        PrimitiveTiledArray copyArray = new PrimitiveTiledArray(this.size, this.blockSize);
        int n = this.blocksNum;
        for (int blockNum = 0; blockNum < n; ++blockNum) {
            PrimitiveArray thisBlock = this.blocks[blockNum];
            PrimitiveArray destBlock = copyArray.blocks[blockNum];
            PrimitiveArray.copyInto$default(thisBlock, destBlock, 0, 0, 0, 14, null);
        }
        return copyArray;
    }

    /*
     * WARNING - void declaration
     */
    public final void copyInto(@NotNull PrimitiveTiledArray dest, int destOffset, int srcStart, int srcEnd) {
        void $this$accept$iv;
        PrimitivePointer destPtr;
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (srcStart == srcEnd) {
            return;
        }
        PrimitivePointer thisPtr = new PrimitivePointer(this, srcStart);
        PrimitivePointer primitivePointer = destPtr = new PrimitivePointer(dest, destOffset);
        int count$iv = srcEnd - srcStart;
        boolean $i$f$accept = false;
        if (!PrimitivePointerKt.isCompatibleBySize((PrimitivePointer)$this$accept$iv, thisPtr, count$iv)) {
            boolean $i$a$-require-PrimitivePointerKt$accept$1$iv22 = false;
            String $i$a$-require-PrimitivePointerKt$accept$1$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-PrimitivePointerKt$accept$1$iv22.toString());
        }
        if (PrimitivePointerKt.isCompatibleWith((PrimitivePointer)$this$accept$iv, thisPtr)) {
            int dstOffset$iv;
            PrimitiveArray dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.getSize() - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                PrimitiveArray srcBlock$iv = thisPtr.getCurrentBlock();
                if (dstBlock$iv.getSize() <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    thisPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    thisPtr.setIndexInBlock(thisPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.getSize(), dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void src;
                    dstBlock$iv.get(index$iv);
                    PrimitiveType primitiveType = srcBlock$iv.get(index$iv);
                    int n2 = index$iv++;
                    PrimitiveArray primitiveArray = dstBlock$iv;
                    boolean bl = false;
                    void var20_25 = src;
                    primitiveArray.set(n2, (PrimitiveType)var20_25);
                }
            }
        } else {
            while (end$iv > 0) {
                $this$accept$iv.get();
                PrimitiveType src = thisPtr.getAndIncrement();
                void var18_23 = $this$accept$iv;
                boolean bl = false;
                var18_23.set(src);
                $this$accept$iv.increment();
                --end$iv;
            }
        }
    }

    public static /* synthetic */ void copyInto$default(PrimitiveTiledArray primitiveTiledArray, PrimitiveTiledArray primitiveTiledArray2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = primitiveTiledArray.size;
        }
        primitiveTiledArray.copyInto(primitiveTiledArray2, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PrimitiveTiledArray plus(@NotNull PrimitiveTiledArray other) {
        void $this$accept$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        PrimitivePointer thisPtr = new PrimitivePointer(this, 0, 2, null);
        PrimitivePointer destPtr = new PrimitivePointer(other, 0, 2, null);
        PrimitivePointer primitivePointer = thisPtr;
        int count$iv = this.size;
        boolean $i$f$accept = false;
        if (!PrimitivePointerKt.isCompatibleBySize((PrimitivePointer)$this$accept$iv, destPtr, count$iv)) {
            boolean $i$a$-require-PrimitivePointerKt$accept$1$iv22 = false;
            String $i$a$-require-PrimitivePointerKt$accept$1$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-PrimitivePointerKt$accept$1$iv22.toString());
        }
        if (PrimitivePointerKt.isCompatibleWith((PrimitivePointer)$this$accept$iv, destPtr)) {
            int dstOffset$iv;
            PrimitiveArray dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.getSize() - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                PrimitiveArray srcBlock$iv = destPtr.getCurrentBlock();
                if (dstBlock$iv.getSize() <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    destPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    destPtr.setIndexInBlock(destPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.getSize(), dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void dst;
                    void src;
                    PrimitiveType primitiveType = srcBlock$iv.get(index$iv);
                    PrimitiveType primitiveType2 = dstBlock$iv.get(index$iv);
                    int n2 = index$iv++;
                    PrimitiveArray primitiveArray = dstBlock$iv;
                    boolean bl = false;
                    PrimitiveType primitiveType3 = src.plus((PrimitiveType)dst).toPrimitive();
                    primitiveArray.set(n2, primitiveType3);
                }
            }
        } else {
            while (end$iv > 0) {
                PrimitiveType dst = destPtr.getAndIncrement();
                PrimitiveType src = $this$accept$iv.get();
                void var16_22 = $this$accept$iv;
                boolean bl = false;
                var16_22.set(src.plus(dst).toPrimitive());
                $this$accept$iv.increment();
                --end$iv;
            }
        }
        return this;
    }

    @NotNull
    public final PrimitiveArray copyOfRange(int fromIndex, int toIndex) {
        int n;
        PrimitiveArray array = new PrimitiveArray(toIndex - fromIndex);
        PrimitivePointer pointer = new PrimitivePointer(this, fromIndex);
        IntRange intRange = array.getIndices();
        int i = intRange.getFirst();
        if (i <= (n = intRange.getLast())) {
            while (true) {
                array.set(i, pointer.getAndIncrement());
                if (i == n) break;
                ++i;
            }
        }
        return array;
    }

    public final void fill(@NotNull PrimitiveType value, int from2, int to) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (from2 == to) {
            return;
        }
        PrimitivePointer pointer = new PrimitivePointer(this, from2);
        for (int count = to - from2; count > 0; count -= this.blockSize) {
            PrimitiveArray block = pointer.getCurrentBlock();
            int offset = pointer.getIndexInBlock();
            pointer.blockIncrement();
            block.fill(value, offset, Math.min(this.blockSize, count + offset));
        }
    }

    public static /* synthetic */ void fill$default(PrimitiveTiledArray primitiveTiledArray, PrimitiveType primitiveType, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = primitiveTiledArray.size;
        }
        primitiveTiledArray.fill(primitiveType, n, n2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0086\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0086\u0002J\"\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a8\u0006\u0010"}, d2={"Lio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray$Companion;", "", "()V", "invoke", "Lio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray;", "strides", "Lio/kinference/ndarray/arrays/Strides;", "init", "Lkotlin/Function1;", "", "Lio/kinference/primitives/types/PrimitiveType;", "array", "Lio/kinference/primitives/types/PrimitiveArray;", "shape", "", "matrixLike", "ndarray-core"})
    @SourceDebugExtension(value={"SMAP\nPrimitiveTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrimitiveTiledArray.kt\nio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1#2:187\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PrimitiveTiledArray invoke(@NotNull Strides strides2) {
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            int blockSize = UtilsKt.blockSizeByStrides(strides2);
            return new PrimitiveTiledArray(strides2.getLinearSize(), blockSize);
        }

        @NotNull
        public final PrimitiveTiledArray invoke(@NotNull Strides strides2, @NotNull Function1<? super Integer, ? extends PrimitiveType> init) {
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            int blockSize = UtilsKt.blockSizeByStrides(strides2);
            return new PrimitiveTiledArray(strides2.getLinearSize(), blockSize, init);
        }

        @NotNull
        public final PrimitiveTiledArray invoke(@NotNull int[] shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            return this.invoke(new Strides(shape));
        }

        @NotNull
        public final PrimitiveTiledArray invoke(@NotNull int[] shape, @NotNull Function1<? super Integer, ? extends PrimitiveType> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            return this.invoke(new Strides(shape), init);
        }

        @NotNull
        public final PrimitiveTiledArray invoke(@NotNull Strides strides2, @NotNull PrimitiveArray array) {
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int blockSize = UtilsKt.blockSizeByStrides(strides2);
            int countBlocks = array.getSize() / blockSize;
            int n = 0;
            PrimitiveArray[] primitiveArrayArray = new PrimitiveArray[countBlocks];
            while (n < countBlocks) {
                int n2 = n++;
                primitiveArrayArray[n2] = new PrimitiveArray(blockSize);
            }
            PrimitiveArray[] blocksArray = primitiveArrayArray;
            n = 0;
            while (n < countBlocks) {
                int blockNum = n++;
                boolean bl = false;
                PrimitiveArray.copyInto$default(array, blocksArray[blockNum], 0, blockNum * blockSize, (blockNum + 1) * blockSize, 2, null);
            }
            return new PrimitiveTiledArray(blocksArray);
        }

        @NotNull
        public final PrimitiveTiledArray matrixLike(@NotNull int[] shape, @NotNull Function1<? super Integer, ? extends PrimitiveType> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            if (!(shape.length == 1 || shape.length == 2)) {
                boolean $i$a$-require-PrimitiveTiledArray$Companion$matrixLike$22 = false;
                String $i$a$-require-PrimitiveTiledArray$Companion$matrixLike$22 = "NDArray should be of rank <= 2. Got rank=" + shape.length;
                throw new IllegalArgumentException($i$a$-require-PrimitiveTiledArray$Companion$matrixLike$22.toString());
            }
            int count = 0;
            int blockSize = ArraysKt.last((int[])shape);
            int blocksNum = shape.length == 1 ? 1 : shape[0];
            int n = 0;
            PrimitiveArray[] primitiveArrayArray = new PrimitiveArray[blocksNum];
            while (n < blocksNum) {
                int n2 = n++;
                primitiveArrayArray[n2] = new PrimitiveArray(blockSize);
            }
            PrimitiveArray[] blocks = primitiveArrayArray;
            int n3 = blocks.length;
            for (n = 0; n < n3; ++n) {
                PrimitiveArray block = blocks[n];
                for (int idx = 0; idx < blockSize; ++idx) {
                    block.set(idx, (PrimitiveType)init.invoke((Object)count++));
                }
            }
            return new PrimitiveTiledArray(blocks);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

