/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.tiled;

import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.Strides;
import io.kinference.ndarray.arrays.pointers.FloatPointer;
import io.kinference.ndarray.arrays.pointers.FloatPointerKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 /2\u00020\u0001:\u0001/B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0015\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ,\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0019\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u0003J\u0006\u0010\u001c\u001a\u00020\u0000J\u0016\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J\"\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\f2\b\b\u0002\u0010\"\u001a\u00020\u00032\b\b\u0002\u0010#\u001a\u00020\u0003J\u0011\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u0003H\u0086\u0002J\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030'2\u0006\u0010%\u001a\u00020\u0003J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0000J\u0010\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020\u0003J\u0019\u0010-\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\fH\u0086\u0002J\u0006\u0010.\u001a\u00020\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000f\u00a8\u00060"}, d2={"Lio/kinference/ndarray/arrays/tiled/FloatTiledArray;", "", "size", "", "blockSize", "(II)V", "blocks", "", "", "([[F)V", "init", "Lkotlin/Function1;", "", "(IILkotlin/jvm/functions/Function1;)V", "getBlockSize", "()I", "getBlocks", "()[[F", "[[F", "blocksNum", "getBlocksNum", "getSize", "copyInto", "", "dest", "destOffset", "srcStart", "srcEnd", "copyOf", "copyOfRange", "fromIndex", "toIndex", "fill", "value", "from", "to", "get", "i", "indexFor", "Lkotlin/Pair;", "plus", "other", "pointer", "Lio/kinference/ndarray/arrays/pointers/FloatPointer;", "startIndex", "set", "toArray", "Companion", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nFloatTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatTiledArray.kt\nio/kinference/ndarray/arrays/tiled/FloatTiledArray\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FloatPointer.kt\nio/kinference/ndarray/arrays/pointers/FloatPointerKt\n*L\n1#1,183:1\n1#2:184\n1#2:186\n1#2:218\n1217#3:185\n1219#3,30:187\n1217#3:217\n1219#3,30:219\n*S KotlinDebug\n*F\n+ 1 FloatTiledArray.kt\nio/kinference/ndarray/arrays/tiled/FloatTiledArray\n*L\n142#1:186\n148#1:218\n142#1:185\n142#1:187,30\n148#1:217\n148#1:219,30\n*E\n"})
public final class FloatTiledArray {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int size;
    private final int blockSize;
    private final int blocksNum;
    @NotNull
    private final float[][] blocks;

    public final int getSize() {
        return this.size;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final int getBlocksNum() {
        return this.blocksNum;
    }

    @NotNull
    public final float[][] getBlocks() {
        return this.blocks;
    }

    public FloatTiledArray(int size2, int blockSize) {
        if (blockSize != 0 && !(size2 % blockSize == 0)) {
            boolean bl = false;
            String string = "Size must divide blockSize";
            throw new IllegalArgumentException(string.toString());
        }
        this.blocksNum = blockSize == 0 ? 0 : size2 / blockSize;
        int n = 0;
        int n2 = this.blocksNum;
        float[][] fArrayArray = new float[n2][];
        FloatTiledArray floatTiledArray = this;
        while (n < n2) {
            int n3 = n++;
            fArrayArray[n3] = new float[blockSize];
        }
        floatTiledArray.blocks = fArrayArray;
        this.blockSize = blockSize;
        this.size = size2;
    }

    public FloatTiledArray(@NotNull float[][] blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        this.blocks = blocks;
        this.blockSize = ((Object[])blocks).length == 0 ? 0 : ((float[])ArraysKt.first((Object[])((Object[])blocks))).length;
        this.blocksNum = ((Object[])blocks).length;
        this.size = this.blocksNum * this.blockSize;
    }

    public FloatTiledArray(int size2, int blockSize, @NotNull Function1<? super Integer, Float> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this(size2, blockSize);
        int count = 0;
        float[][] fArray = this.blocks;
        int n = ((Object[])fArray).length;
        for (int i = 0; i < n; ++i) {
            float[] block = fArray[i];
            for (int idx = 0; idx < blockSize; ++idx) {
                block[idx] = ((Number)init.invoke((Object)count++)).floatValue();
            }
        }
    }

    @NotNull
    public final FloatPointer pointer(int startIndex) {
        return new FloatPointer(this, startIndex);
    }

    public static /* synthetic */ FloatPointer pointer$default(FloatTiledArray floatTiledArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return floatTiledArray.pointer(n);
    }

    @NotNull
    public final float[] toArray() {
        if (this.size == 0) {
            return new float[0];
        }
        float[] array = new float[this.size];
        int offset = 0;
        float[][] fArray = this.blocks;
        int n = ((Object[])fArray).length;
        for (int i = 0; i < n; ++i) {
            float[] block = fArray[i];
            ArraysKt.copyInto$default((float[])block, (float[])array, (int)offset, (int)0, (int)0, (int)12, null);
            offset += this.blockSize;
        }
        return array;
    }

    @NotNull
    public final Pair<Integer, Integer> indexFor(int i) {
        int blockIdx = i / this.blockSize;
        int blockOff = i % this.blockSize;
        return TuplesKt.to((Object)blockIdx, (Object)blockOff);
    }

    public final float get(int i) {
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        return this.blocks[blockIdx][blockOff];
    }

    public final void set(int i, float value) {
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        this.blocks[blockIdx][blockOff] = value;
    }

    @NotNull
    public final FloatTiledArray copyOf() {
        FloatTiledArray copyArray = new FloatTiledArray(this.size, this.blockSize);
        int n = this.blocksNum;
        for (int blockNum = 0; blockNum < n; ++blockNum) {
            float[] thisBlock = this.blocks[blockNum];
            float[] destBlock = copyArray.blocks[blockNum];
            ArraysKt.copyInto$default((float[])thisBlock, (float[])destBlock, (int)0, (int)0, (int)0, (int)14, null);
        }
        return copyArray;
    }

    /*
     * WARNING - void declaration
     */
    public final void copyInto(@NotNull FloatTiledArray dest, int destOffset, int srcStart, int srcEnd) {
        void $this$accept$iv;
        FloatPointer destPtr;
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (srcStart == srcEnd) {
            return;
        }
        FloatPointer thisPtr = new FloatPointer(this, srcStart);
        FloatPointer floatPointer = destPtr = new FloatPointer(dest, destOffset);
        int count$iv = srcEnd - srcStart;
        boolean $i$f$accept = false;
        if (!FloatPointerKt.isCompatibleBySize((FloatPointer)$this$accept$iv, thisPtr, count$iv)) {
            boolean $i$a$-require-FloatPointerKt$accept$9$iv22 = false;
            String $i$a$-require-FloatPointerKt$accept$9$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$accept$9$iv22.toString());
        }
        if (FloatPointerKt.isCompatibleWith((FloatPointer)$this$accept$iv, thisPtr)) {
            int dstOffset$iv;
            float[] dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                float[] srcBlock$iv = thisPtr.getCurrentBlock();
                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    thisPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    thisPtr.setIndexInBlock(thisPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void src;
                    float cfr_ignored_0 = dstBlock$iv[index$iv];
                    float f = srcBlock$iv[index$iv];
                    int n2 = index$iv++;
                    float[] fArray = dstBlock$iv;
                    boolean bl = false;
                    void var20_26 = src;
                    fArray[n2] = var20_26;
                }
            }
        } else {
            while (end$iv > 0) {
                $this$accept$iv.get();
                float src = thisPtr.getAndIncrement();
                void var18_23 = $this$accept$iv;
                boolean bl = false;
                float f = src;
                var18_23.set(f);
                $this$accept$iv.increment();
                --end$iv;
            }
        }
    }

    public static /* synthetic */ void copyInto$default(FloatTiledArray floatTiledArray, FloatTiledArray floatTiledArray2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = floatTiledArray.size;
        }
        floatTiledArray.copyInto(floatTiledArray2, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FloatTiledArray plus(@NotNull FloatTiledArray other) {
        void $this$accept$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        FloatPointer thisPtr = new FloatPointer(this, 0, 2, null);
        FloatPointer destPtr = new FloatPointer(other, 0, 2, null);
        FloatPointer floatPointer = thisPtr;
        int count$iv = this.size;
        boolean $i$f$accept = false;
        if (!FloatPointerKt.isCompatibleBySize((FloatPointer)$this$accept$iv, destPtr, count$iv)) {
            boolean $i$a$-require-FloatPointerKt$accept$9$iv22 = false;
            String $i$a$-require-FloatPointerKt$accept$9$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$accept$9$iv22.toString());
        }
        if (FloatPointerKt.isCompatibleWith((FloatPointer)$this$accept$iv, destPtr)) {
            int dstOffset$iv;
            float[] dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                float[] srcBlock$iv = destPtr.getCurrentBlock();
                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    destPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    destPtr.setIndexInBlock(destPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void dst;
                    void src;
                    float f = srcBlock$iv[index$iv];
                    float f2 = dstBlock$iv[index$iv];
                    int n2 = index$iv++;
                    float[] fArray = dstBlock$iv;
                    boolean bl = false;
                    void var18_25 = src + dst;
                    fArray[n2] = var18_25;
                }
            }
        } else {
            while (end$iv > 0) {
                float dst = destPtr.getAndIncrement();
                float src = $this$accept$iv.get();
                void var16_22 = $this$accept$iv;
                boolean bl = false;
                float f = src + dst;
                var16_22.set(f);
                $this$accept$iv.increment();
                --end$iv;
            }
        }
        return this;
    }

    @NotNull
    public final float[] copyOfRange(int fromIndex, int toIndex) {
        float[] array = new float[toIndex - fromIndex];
        FloatPointer pointer = new FloatPointer(this, fromIndex);
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = pointer.getAndIncrement();
        }
        return array;
    }

    public final void fill(float value, int from2, int to) {
        if (from2 == to) {
            return;
        }
        FloatPointer pointer = new FloatPointer(this, from2);
        for (int count = to - from2; count > 0; count -= this.blockSize) {
            float[] block = pointer.getCurrentBlock();
            int offset = pointer.getIndexInBlock();
            pointer.blockIncrement();
            ArraysKt.fill((float[])block, (float)value, (int)offset, (int)Math.min(this.blockSize, count + offset));
        }
    }

    public static /* synthetic */ void fill$default(FloatTiledArray floatTiledArray, float f, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = floatTiledArray.size;
        }
        floatTiledArray.fill(f, n, n2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0086\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0086\u0002J\"\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a8\u0006\u0010"}, d2={"Lio/kinference/ndarray/arrays/tiled/FloatTiledArray$Companion;", "", "()V", "invoke", "Lio/kinference/ndarray/arrays/tiled/FloatTiledArray;", "strides", "Lio/kinference/ndarray/arrays/Strides;", "init", "Lkotlin/Function1;", "", "", "array", "", "shape", "", "matrixLike", "ndarray-core"})
    @SourceDebugExtension(value={"SMAP\nFloatTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatTiledArray.kt\nio/kinference/ndarray/arrays/tiled/FloatTiledArray$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1#2:184\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FloatTiledArray invoke(@NotNull Strides strides2) {
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            int blockSize = UtilsKt.blockSizeByStrides(strides2);
            return new FloatTiledArray(strides2.getLinearSize(), blockSize);
        }

        @NotNull
        public final FloatTiledArray invoke(@NotNull Strides strides2, @NotNull Function1<? super Integer, Float> init) {
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            int blockSize = UtilsKt.blockSizeByStrides(strides2);
            return new FloatTiledArray(strides2.getLinearSize(), blockSize, init);
        }

        @NotNull
        public final FloatTiledArray invoke(@NotNull int[] shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            return this.invoke(new Strides(shape));
        }

        @NotNull
        public final FloatTiledArray invoke(@NotNull int[] shape, @NotNull Function1<? super Integer, Float> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            return this.invoke(new Strides(shape), init);
        }

        @NotNull
        public final FloatTiledArray invoke(@NotNull Strides strides2, @NotNull float[] array) {
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int blockSize = UtilsKt.blockSizeByStrides(strides2);
            int countBlocks = array.length / blockSize;
            int n = 0;
            float[][] fArrayArray = new float[countBlocks][];
            while (n < countBlocks) {
                int n2 = n++;
                fArrayArray[n2] = new float[blockSize];
            }
            float[][] blocksArray = fArrayArray;
            n = 0;
            while (n < countBlocks) {
                int blockNum = n++;
                boolean bl = false;
                ArraysKt.copyInto$default((float[])array, (float[])blocksArray[blockNum], (int)0, (int)(blockNum * blockSize), (int)((blockNum + 1) * blockSize), (int)2, null);
            }
            return new FloatTiledArray(blocksArray);
        }

        @NotNull
        public final FloatTiledArray matrixLike(@NotNull int[] shape, @NotNull Function1<? super Integer, Float> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            if (!(shape.length == 1 || shape.length == 2)) {
                boolean $i$a$-require-FloatTiledArray$Companion$matrixLike$22 = false;
                String $i$a$-require-FloatTiledArray$Companion$matrixLike$22 = "NDArray should be of rank <= 2. Got rank=" + shape.length;
                throw new IllegalArgumentException($i$a$-require-FloatTiledArray$Companion$matrixLike$22.toString());
            }
            int count = 0;
            int blockSize = ArraysKt.last((int[])shape);
            int blocksNum = shape.length == 1 ? 1 : shape[0];
            int n = 0;
            float[][] fArrayArray = new float[blocksNum][];
            while (n < blocksNum) {
                int n2 = n++;
                fArrayArray[n2] = new float[blockSize];
            }
            float[][] blocks = fArrayArray;
            int n3 = ((Object[])blocks).length;
            for (n = 0; n < n3; ++n) {
                float[] block = blocks[n];
                for (int idx = 0; idx < blockSize; ++idx) {
                    block[idx] = ((Number)init.invoke((Object)count++)).floatValue();
                }
            }
            return new FloatTiledArray(blocks);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

