/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.tiled;

import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.Strides;
import io.kinference.ndarray.arrays.pointers.DoublePointer;
import io.kinference.ndarray.arrays.pointers.DoublePointerKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 /2\u00020\u0001:\u0001/B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0015\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ,\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0019\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u0003J\u0006\u0010\u001c\u001a\u00020\u0000J\u0016\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J\"\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\f2\b\b\u0002\u0010\"\u001a\u00020\u00032\b\b\u0002\u0010#\u001a\u00020\u0003J\u0011\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u0003H\u0086\u0002J\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030'2\u0006\u0010%\u001a\u00020\u0003J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0000J\u0010\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020\u0003J\u0019\u0010-\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\fH\u0086\u0002J\u0006\u0010.\u001a\u00020\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000f\u00a8\u00060"}, d2={"Lio/kinference/ndarray/arrays/tiled/DoubleTiledArray;", "", "size", "", "blockSize", "(II)V", "blocks", "", "", "([[D)V", "init", "Lkotlin/Function1;", "", "(IILkotlin/jvm/functions/Function1;)V", "getBlockSize", "()I", "getBlocks", "()[[D", "[[D", "blocksNum", "getBlocksNum", "getSize", "copyInto", "", "dest", "destOffset", "srcStart", "srcEnd", "copyOf", "copyOfRange", "fromIndex", "toIndex", "fill", "value", "from", "to", "get", "i", "indexFor", "Lkotlin/Pair;", "plus", "other", "pointer", "Lio/kinference/ndarray/arrays/pointers/DoublePointer;", "startIndex", "set", "toArray", "Companion", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nDoubleTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DoubleTiledArray.kt\nio/kinference/ndarray/arrays/tiled/DoubleTiledArray\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 DoublePointer.kt\nio/kinference/ndarray/arrays/pointers/DoublePointerKt\n*L\n1#1,183:1\n1#2:184\n1#2:186\n1#2:218\n1250#3:185\n1252#3,30:187\n1250#3:217\n1252#3,30:219\n*S KotlinDebug\n*F\n+ 1 DoubleTiledArray.kt\nio/kinference/ndarray/arrays/tiled/DoubleTiledArray\n*L\n142#1:186\n148#1:218\n142#1:185\n142#1:187,30\n148#1:217\n148#1:219,30\n*E\n"})
public final class DoubleTiledArray {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int size;
    private final int blockSize;
    private final int blocksNum;
    @NotNull
    private final double[][] blocks;

    public final int getSize() {
        return this.size;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final int getBlocksNum() {
        return this.blocksNum;
    }

    @NotNull
    public final double[][] getBlocks() {
        return this.blocks;
    }

    public DoubleTiledArray(int size2, int blockSize) {
        if (blockSize != 0 && !(size2 % blockSize == 0)) {
            boolean bl = false;
            String string = "Size must divide blockSize";
            throw new IllegalArgumentException(string.toString());
        }
        this.blocksNum = blockSize == 0 ? 0 : size2 / blockSize;
        int n = 0;
        int n2 = this.blocksNum;
        double[][] dArrayArray = new double[n2][];
        DoubleTiledArray doubleTiledArray = this;
        while (n < n2) {
            int n3 = n++;
            dArrayArray[n3] = new double[blockSize];
        }
        doubleTiledArray.blocks = dArrayArray;
        this.blockSize = blockSize;
        this.size = size2;
    }

    public DoubleTiledArray(@NotNull double[][] blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        this.blocks = blocks;
        this.blockSize = ((Object[])blocks).length == 0 ? 0 : ((double[])ArraysKt.first((Object[])((Object[])blocks))).length;
        this.blocksNum = ((Object[])blocks).length;
        this.size = this.blocksNum * this.blockSize;
    }

    public DoubleTiledArray(int size2, int blockSize, @NotNull Function1<? super Integer, Double> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this(size2, blockSize);
        int count = 0;
        double[][] dArray = this.blocks;
        int n = ((Object[])dArray).length;
        for (int i = 0; i < n; ++i) {
            double[] block = dArray[i];
            for (int idx = 0; idx < blockSize; ++idx) {
                block[idx] = ((Number)init.invoke((Object)count++)).doubleValue();
            }
        }
    }

    @NotNull
    public final DoublePointer pointer(int startIndex) {
        return new DoublePointer(this, startIndex);
    }

    public static /* synthetic */ DoublePointer pointer$default(DoubleTiledArray doubleTiledArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return doubleTiledArray.pointer(n);
    }

    @NotNull
    public final double[] toArray() {
        if (this.size == 0) {
            return new double[0];
        }
        double[] array = new double[this.size];
        int offset = 0;
        double[][] dArray = this.blocks;
        int n = ((Object[])dArray).length;
        for (int i = 0; i < n; ++i) {
            double[] block = dArray[i];
            ArraysKt.copyInto$default((double[])block, (double[])array, (int)offset, (int)0, (int)0, (int)12, null);
            offset += this.blockSize;
        }
        return array;
    }

    @NotNull
    public final Pair<Integer, Integer> indexFor(int i) {
        int blockIdx = i / this.blockSize;
        int blockOff = i % this.blockSize;
        return TuplesKt.to((Object)blockIdx, (Object)blockOff);
    }

    public final double get(int i) {
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        return this.blocks[blockIdx][blockOff];
    }

    public final void set(int i, double value) {
        Pair<Integer, Integer> pair = this.indexFor(i);
        int blockIdx = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        this.blocks[blockIdx][blockOff] = value;
    }

    @NotNull
    public final DoubleTiledArray copyOf() {
        DoubleTiledArray copyArray = new DoubleTiledArray(this.size, this.blockSize);
        int n = this.blocksNum;
        for (int blockNum = 0; blockNum < n; ++blockNum) {
            double[] thisBlock = this.blocks[blockNum];
            double[] destBlock = copyArray.blocks[blockNum];
            ArraysKt.copyInto$default((double[])thisBlock, (double[])destBlock, (int)0, (int)0, (int)0, (int)14, null);
        }
        return copyArray;
    }

    /*
     * WARNING - void declaration
     */
    public final void copyInto(@NotNull DoubleTiledArray dest, int destOffset, int srcStart, int srcEnd) {
        void $this$accept$iv;
        DoublePointer destPtr;
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (srcStart == srcEnd) {
            return;
        }
        DoublePointer thisPtr = new DoublePointer(this, srcStart);
        DoublePointer doublePointer = destPtr = new DoublePointer(dest, destOffset);
        int count$iv = srcEnd - srcStart;
        boolean $i$f$accept = false;
        if (!DoublePointerKt.isCompatibleBySize((DoublePointer)$this$accept$iv, thisPtr, count$iv)) {
            boolean $i$a$-require-DoublePointerKt$accept$10$iv22 = false;
            String $i$a$-require-DoublePointerKt$accept$10$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-DoublePointerKt$accept$10$iv22.toString());
        }
        if (DoublePointerKt.isCompatibleWith((DoublePointer)$this$accept$iv, thisPtr)) {
            int dstOffset$iv;
            double[] dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                double[] srcBlock$iv = thisPtr.getCurrentBlock();
                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    thisPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    thisPtr.setIndexInBlock(thisPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void src;
                    double cfr_ignored_0 = dstBlock$iv[index$iv];
                    double d = srcBlock$iv[index$iv];
                    int n2 = index$iv++;
                    double[] dArray = dstBlock$iv;
                    boolean bl = false;
                    void var22_26 = src;
                    dArray[n2] = var22_26;
                }
            }
        } else {
            while (end$iv > 0) {
                $this$accept$iv.get();
                double src = thisPtr.getAndIncrement();
                void var19_23 = $this$accept$iv;
                boolean bl = false;
                double d = src;
                var19_23.set(d);
                $this$accept$iv.increment();
                --end$iv;
            }
        }
    }

    public static /* synthetic */ void copyInto$default(DoubleTiledArray doubleTiledArray, DoubleTiledArray doubleTiledArray2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = doubleTiledArray.size;
        }
        doubleTiledArray.copyInto(doubleTiledArray2, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DoubleTiledArray plus(@NotNull DoubleTiledArray other) {
        void $this$accept$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        DoublePointer thisPtr = new DoublePointer(this, 0, 2, null);
        DoublePointer destPtr = new DoublePointer(other, 0, 2, null);
        DoublePointer doublePointer = thisPtr;
        int count$iv = this.size;
        boolean $i$f$accept = false;
        if (!DoublePointerKt.isCompatibleBySize((DoublePointer)$this$accept$iv, destPtr, count$iv)) {
            boolean $i$a$-require-DoublePointerKt$accept$10$iv22 = false;
            String $i$a$-require-DoublePointerKt$accept$10$iv22 = "Pointers not compatible by available elements";
            throw new IllegalArgumentException($i$a$-require-DoublePointerKt$accept$10$iv22.toString());
        }
        if (DoublePointerKt.isCompatibleWith((DoublePointer)$this$accept$iv, destPtr)) {
            int dstOffset$iv;
            double[] dstBlock$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                double[] srcBlock$iv = destPtr.getCurrentBlock();
                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                    $this$accept$iv.blockIncrement();
                    destPtr.blockIncrement();
                } else {
                    $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                    destPtr.setIndexInBlock(destPtr.getIndexInBlock() + end$iv);
                }
                int index$iv = dstOffset$iv;
                int n = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                while (index$iv < n) {
                    void dst;
                    void src;
                    double d = srcBlock$iv[index$iv];
                    double d2 = dstBlock$iv[index$iv];
                    int n2 = index$iv++;
                    double[] dArray = dstBlock$iv;
                    boolean bl = false;
                    void var21_25 = src + dst;
                    dArray[n2] = var21_25;
                }
            }
        } else {
            while (end$iv > 0) {
                double dst = destPtr.getAndIncrement();
                double src = $this$accept$iv.get();
                void var18_22 = $this$accept$iv;
                boolean bl = false;
                double d = src + dst;
                var18_22.set(d);
                $this$accept$iv.increment();
                --end$iv;
            }
        }
        return this;
    }

    @NotNull
    public final double[] copyOfRange(int fromIndex, int toIndex) {
        double[] array = new double[toIndex - fromIndex];
        DoublePointer pointer = new DoublePointer(this, fromIndex);
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = pointer.getAndIncrement();
        }
        return array;
    }

    public final void fill(double value, int from2, int to) {
        if (from2 == to) {
            return;
        }
        DoublePointer pointer = new DoublePointer(this, from2);
        for (int count = to - from2; count > 0; count -= this.blockSize) {
            double[] block = pointer.getCurrentBlock();
            int offset = pointer.getIndexInBlock();
            pointer.blockIncrement();
            ArraysKt.fill((double[])block, (double)value, (int)offset, (int)Math.min(this.blockSize, count + offset));
        }
    }

    public static /* synthetic */ void fill$default(DoubleTiledArray doubleTiledArray, double d, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = doubleTiledArray.size;
        }
        doubleTiledArray.fill(d, n, n2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0086\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0086\u0002J\"\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a8\u0006\u0010"}, d2={"Lio/kinference/ndarray/arrays/tiled/DoubleTiledArray$Companion;", "", "()V", "invoke", "Lio/kinference/ndarray/arrays/tiled/DoubleTiledArray;", "strides", "Lio/kinference/ndarray/arrays/Strides;", "init", "Lkotlin/Function1;", "", "", "array", "", "shape", "", "matrixLike", "ndarray-core"})
    @SourceDebugExtension(value={"SMAP\nDoubleTiledArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DoubleTiledArray.kt\nio/kinference/ndarray/arrays/tiled/DoubleTiledArray$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1#2:184\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DoubleTiledArray invoke(@NotNull Strides strides2) {
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            int blockSize = UtilsKt.blockSizeByStrides(strides2);
            return new DoubleTiledArray(strides2.getLinearSize(), blockSize);
        }

        @NotNull
        public final DoubleTiledArray invoke(@NotNull Strides strides2, @NotNull Function1<? super Integer, Double> init) {
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            int blockSize = UtilsKt.blockSizeByStrides(strides2);
            return new DoubleTiledArray(strides2.getLinearSize(), blockSize, init);
        }

        @NotNull
        public final DoubleTiledArray invoke(@NotNull int[] shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            return this.invoke(new Strides(shape));
        }

        @NotNull
        public final DoubleTiledArray invoke(@NotNull int[] shape, @NotNull Function1<? super Integer, Double> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            return this.invoke(new Strides(shape), init);
        }

        @NotNull
        public final DoubleTiledArray invoke(@NotNull Strides strides2, @NotNull double[] array) {
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int blockSize = UtilsKt.blockSizeByStrides(strides2);
            int countBlocks = array.length / blockSize;
            int n = 0;
            double[][] dArrayArray = new double[countBlocks][];
            while (n < countBlocks) {
                int n2 = n++;
                dArrayArray[n2] = new double[blockSize];
            }
            double[][] blocksArray = dArrayArray;
            n = 0;
            while (n < countBlocks) {
                int blockNum = n++;
                boolean bl = false;
                ArraysKt.copyInto$default((double[])array, (double[])blocksArray[blockNum], (int)0, (int)(blockNum * blockSize), (int)((blockNum + 1) * blockSize), (int)2, null);
            }
            return new DoubleTiledArray(blocksArray);
        }

        @NotNull
        public final DoubleTiledArray matrixLike(@NotNull int[] shape, @NotNull Function1<? super Integer, Double> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            if (!(shape.length == 1 || shape.length == 2)) {
                boolean $i$a$-require-DoubleTiledArray$Companion$matrixLike$22 = false;
                String $i$a$-require-DoubleTiledArray$Companion$matrixLike$22 = "NDArray should be of rank <= 2. Got rank=" + shape.length;
                throw new IllegalArgumentException($i$a$-require-DoubleTiledArray$Companion$matrixLike$22.toString());
            }
            int count = 0;
            int blockSize = ArraysKt.last((int[])shape);
            int blocksNum = shape.length == 1 ? 1 : shape[0];
            int n = 0;
            double[][] dArrayArray = new double[blocksNum][];
            while (n < blocksNum) {
                int n2 = n++;
                dArrayArray[n2] = new double[blockSize];
            }
            double[][] blocks = dArrayArray;
            int n3 = ((Object[])blocks).length;
            for (n = 0; n < n3; ++n) {
                double[] block = blocks[n];
                for (int idx = 0; idx < blockSize; ++idx) {
                    block[idx] = ((Number)init.invoke((Object)count++)).doubleValue();
                }
            }
            return new DoubleTiledArray(blocks);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

