/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.pointers;

import io.kinference.ndarray.arrays.tiled.UIntTiledArray;
import kotlin.Metadata;
import kotlin.UIntArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u0006\u0010!\u001a\u00020\u001fJ\u0013\u0010\"\u001a\u00020#\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b$\u0010\rJ\u0013\u0010%\u001a\u00020#\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b&\u0010\rJ\u0006\u0010'\u001a\u00020\u001fJ\u0013\u0010(\u001a\u00020#\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b)\u0010\rJ\u0006\u0010*\u001a\u00020+J\u0018\u0010,\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020#\u00f8\u0001\u0000\u00a2\u0006\u0004\b-\u0010\u000fJ\u0018\u0010.\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020#\u00f8\u0001\u0000\u00a2\u0006\u0004\b/\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000fR$\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\r\"\u0004\b\u001d\u0010\u000f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00060"}, d2={"Lio/kinference/ndarray/arrays/pointers/UIntPointer;", "", "array", "Lio/kinference/ndarray/arrays/tiled/UIntTiledArray;", "startIndex", "", "(Lio/kinference/ndarray/arrays/tiled/UIntTiledArray;I)V", "other", "(Lio/kinference/ndarray/arrays/pointers/UIntPointer;)V", "getArray", "()Lio/kinference/ndarray/arrays/tiled/UIntTiledArray;", "blockNum", "getBlockNum", "()I", "setBlockNum", "(I)V", "currentBlock", "Lkotlin/UIntArray;", "getCurrentBlock--hP7Qyg", "()[I", "setCurrentBlock--ajY-9A", "([I)V", "[I", "indexInBlock", "getIndexInBlock", "setIndexInBlock", "value", "linearIndex", "getLinearIndex", "setLinearIndex", "blockDecrement", "", "blockIncrement", "decrement", "get", "Lkotlin/UInt;", "get-pVg5ArA", "getAndIncrement", "getAndIncrement-pVg5ArA", "increment", "incrementAndGet", "incrementAndGet-pVg5ArA", "isValid", "", "set", "set-WZ4Q5Ns", "setAndIncrement", "setAndIncrement-WZ4Q5Ns", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nUIntPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UIntPointer.kt\nio/kinference/ndarray/arrays/pointers/UIntPointer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,3128:1\n1#2:3129\n*E\n"})
public final class UIntPointer {
    @NotNull
    private final UIntTiledArray array;
    private int blockNum;
    private int indexInBlock;
    @NotNull
    private int[] currentBlock;

    @NotNull
    public final UIntTiledArray getArray() {
        return this.array;
    }

    public final int getBlockNum() {
        return this.blockNum;
    }

    public final void setBlockNum(int n) {
        this.blockNum = n;
    }

    public final int getIndexInBlock() {
        return this.indexInBlock;
    }

    public final void setIndexInBlock(int n) {
        this.indexInBlock = n;
    }

    @NotNull
    public final int[] getCurrentBlock--hP7Qyg() {
        return this.currentBlock;
    }

    public final void setCurrentBlock--ajY-9A(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.currentBlock = nArray;
    }

    public UIntPointer(@NotNull UIntTiledArray array, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (!(startIndex >= 0 && startIndex < array.getSize())) {
            boolean bl = false;
            String string = "Start index of Iterator must be >= 0 and < array size";
            throw new IllegalArgumentException(string.toString());
        }
        this.array = array;
        this.blockNum = startIndex / array.getBlockSize();
        this.indexInBlock = startIndex % array.getBlockSize();
        this.currentBlock = array.getBlocks()[this.blockNum].unbox-impl();
    }

    public /* synthetic */ UIntPointer(UIntTiledArray uIntTiledArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(uIntTiledArray, n);
    }

    public UIntPointer(@NotNull UIntPointer other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.array = other.array;
        this.blockNum = other.blockNum;
        this.indexInBlock = other.indexInBlock;
        this.currentBlock = other.currentBlock;
    }

    public final int getLinearIndex() {
        return this.blockNum * this.array.getBlockSize() + this.indexInBlock;
    }

    public final void setLinearIndex(int value) {
        if (!(value >= 0 && value < this.array.getSize())) {
            boolean bl = false;
            String string = "Linear index of Iterator must be >= 0 and < array size";
            throw new IllegalArgumentException(string.toString());
        }
        this.blockNum = value / this.array.getBlockSize();
        this.indexInBlock = value % this.array.getBlockSize();
        this.currentBlock = this.array.getBlocks()[this.blockNum].unbox-impl();
    }

    public final void set-WZ4Q5Ns(int value) {
        UIntArray.set-VXSXFK8((int[])this.currentBlock, (int)this.indexInBlock, (int)value);
    }

    public final int get-pVg5ArA() {
        return UIntArray.get-pVg5ArA((int[])this.currentBlock, (int)this.indexInBlock);
    }

    public final void blockIncrement() {
        if (this.blockNum < this.array.getBlocksNum() - 1) {
            int n = this.blockNum;
            this.blockNum = n + 1;
            this.indexInBlock = 0;
            this.currentBlock = this.array.getBlocks()[this.blockNum].unbox-impl();
        } else {
            this.indexInBlock = this.array.getBlockSize();
        }
    }

    public final void increment() {
        if (this.indexInBlock < this.array.getBlockSize() - 1) {
            int n = this.indexInBlock;
            this.indexInBlock = n + 1;
        } else {
            this.blockIncrement();
        }
    }

    public final void blockDecrement() {
        if (this.blockNum > 0) {
            int n = this.blockNum;
            this.blockNum = n + -1;
            this.indexInBlock = this.array.getBlockSize() - 1;
            this.currentBlock = this.array.getBlocks()[this.blockNum].unbox-impl();
        } else {
            this.indexInBlock = -1;
        }
    }

    public final void decrement() {
        if (this.indexInBlock > 0) {
            int n = this.indexInBlock;
            this.indexInBlock = n + -1;
        } else {
            this.blockDecrement();
        }
    }

    public final int incrementAndGet-pVg5ArA() {
        this.increment();
        return UIntArray.get-pVg5ArA((int[])this.currentBlock, (int)this.indexInBlock);
    }

    public final int getAndIncrement-pVg5ArA() {
        int value = UIntArray.get-pVg5ArA((int[])this.currentBlock, (int)this.indexInBlock);
        this.increment();
        return value;
    }

    public final void setAndIncrement-WZ4Q5Ns(int value) {
        UIntArray.set-VXSXFK8((int[])this.currentBlock, (int)this.indexInBlock, (int)value);
        this.increment();
    }

    public final boolean isValid() {
        return this.indexInBlock < this.array.getBlockSize() && this.indexInBlock > -1;
    }
}

