/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.inprocess;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.InternalChannelz;
import io.grpc.InternalInstrumented;
import io.grpc.ServerStreamTracer;
import io.grpc.inprocess.AnonymousInProcessSocketAddress;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.inprocess.InProcessSocketAddress;
import io.grpc.inprocess.InProcessTransport;
import io.grpc.internal.InternalServer;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServerListener;
import io.grpc.internal.ServerTransport;
import io.grpc.internal.ServerTransportListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class InProcessServer
implements InternalServer {
    private static final ConcurrentMap<String, InProcessServer> registry = new ConcurrentHashMap<String, InProcessServer>();
    private final SocketAddress listenAddress;
    private final int maxInboundMetadataSize;
    private final List<ServerStreamTracer.Factory> streamTracerFactories;
    private ServerListener listener;
    private boolean shutdown;
    private final ObjectPool<ScheduledExecutorService> schedulerPool;
    private ScheduledExecutorService scheduler;

    static InProcessServer findServer(SocketAddress addr) {
        if (addr instanceof AnonymousInProcessSocketAddress) {
            return ((AnonymousInProcessSocketAddress)addr).getServer();
        }
        if (addr instanceof InProcessSocketAddress) {
            return (InProcessServer)registry.get(((InProcessSocketAddress)addr).getName());
        }
        return null;
    }

    InProcessServer(InProcessServerBuilder builder2, List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
        this.listenAddress = builder2.listenAddress;
        this.schedulerPool = builder2.schedulerPool;
        this.maxInboundMetadataSize = builder2.maxInboundMetadataSize;
        this.streamTracerFactories = Collections.unmodifiableList((List)Preconditions.checkNotNull(streamTracerFactories, (Object)"streamTracerFactories"));
    }

    public void start(ServerListener serverListener) throws IOException {
        this.listener = serverListener;
        this.scheduler = (ScheduledExecutorService)this.schedulerPool.getObject();
        this.registerInstance();
    }

    private void registerInstance() throws IOException {
        if (this.listenAddress instanceof AnonymousInProcessSocketAddress) {
            ((AnonymousInProcessSocketAddress)this.listenAddress).setServer(this);
        } else if (this.listenAddress instanceof InProcessSocketAddress) {
            String name = ((InProcessSocketAddress)this.listenAddress).getName();
            if (registry.putIfAbsent(name, this) != null) {
                throw new IOException("name already registered: " + name);
            }
        } else {
            throw new AssertionError();
        }
    }

    public SocketAddress getListenSocketAddress() {
        return this.listenAddress;
    }

    public List<? extends SocketAddress> getListenSocketAddresses() {
        return Collections.singletonList(this.getListenSocketAddress());
    }

    public InternalInstrumented<InternalChannelz.SocketStats> getListenSocketStats() {
        return null;
    }

    public List<InternalInstrumented<InternalChannelz.SocketStats>> getListenSocketStatsList() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.unregisterInstance();
        this.scheduler = (ScheduledExecutorService)this.schedulerPool.returnObject((Object)this.scheduler);
        InProcessServer inProcessServer = this;
        synchronized (inProcessServer) {
            this.shutdown = true;
            this.listener.serverShutdown();
        }
    }

    private void unregisterInstance() {
        if (this.listenAddress instanceof AnonymousInProcessSocketAddress) {
            ((AnonymousInProcessSocketAddress)this.listenAddress).clearServer(this);
        } else if (this.listenAddress instanceof InProcessSocketAddress) {
            String name = ((InProcessSocketAddress)this.listenAddress).getName();
            if (!registry.remove(name, this)) {
                throw new AssertionError();
            }
        } else {
            throw new AssertionError();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("listenAddress", (Object)this.listenAddress).toString();
    }

    synchronized ServerTransportListener register(InProcessTransport transport) {
        if (this.shutdown) {
            return null;
        }
        return this.listener.transportCreated((ServerTransport)transport);
    }

    ObjectPool<ScheduledExecutorService> getScheduledExecutorServicePool() {
        return this.schedulerPool;
    }

    int getMaxInboundMetadataSize() {
        return this.maxInboundMetadataSize;
    }

    List<ServerStreamTracer.Factory> getStreamTracerFactories() {
        return this.streamTracerFactories;
    }
}

