/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.inprocess;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.DoNotCall;
import io.grpc.ChannelCredentials;
import io.grpc.ChannelLogger;
import io.grpc.ExperimentalApi;
import io.grpc.ForwardingChannelBuilder2;
import io.grpc.Internal;
import io.grpc.ManagedChannelBuilder;
import io.grpc.inprocess.AnonymousInProcessSocketAddress;
import io.grpc.inprocess.InProcessSocketAddress;
import io.grpc.inprocess.InProcessTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ManagedChannelImplBuilder;
import io.grpc.internal.SharedResourceHolder;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1783")
public final class InProcessChannelBuilder
extends ForwardingChannelBuilder2<InProcessChannelBuilder> {
    private final ManagedChannelImplBuilder managedChannelImplBuilder;
    private ScheduledExecutorService scheduledExecutorService;
    private int maxInboundMetadataSize = Integer.MAX_VALUE;
    private boolean transportIncludeStatusCause = false;

    public static InProcessChannelBuilder forName(String name) {
        return InProcessChannelBuilder.forAddress(new InProcessSocketAddress((String)Preconditions.checkNotNull((Object)name, (Object)"name")));
    }

    public static InProcessChannelBuilder forTarget(String target) {
        return new InProcessChannelBuilder(null, (String)Preconditions.checkNotNull((Object)target, (Object)"target"));
    }

    public static InProcessChannelBuilder forAddress(SocketAddress address) {
        return new InProcessChannelBuilder((SocketAddress)Preconditions.checkNotNull((Object)address, (Object)"address"), null);
    }

    @DoNotCall(value="Unsupported. Use forName() instead")
    public static InProcessChannelBuilder forAddress(String name, int port) {
        throw new UnsupportedOperationException("call forName() instead");
    }

    private InProcessChannelBuilder(@Nullable SocketAddress directAddress, @Nullable String target) {
        final class InProcessChannelTransportFactoryBuilder
        implements ManagedChannelImplBuilder.ClientTransportFactoryBuilder {
            InProcessChannelTransportFactoryBuilder() {
            }

            public ClientTransportFactory buildClientTransportFactory() {
                return InProcessChannelBuilder.this.buildTransportFactory();
            }
        }
        this.managedChannelImplBuilder = directAddress != null ? new ManagedChannelImplBuilder(directAddress, "localhost", (ManagedChannelImplBuilder.ClientTransportFactoryBuilder)new InProcessChannelTransportFactoryBuilder(), null) : new ManagedChannelImplBuilder(target, (ManagedChannelImplBuilder.ClientTransportFactoryBuilder)new InProcessChannelTransportFactoryBuilder(), null);
        this.managedChannelImplBuilder.setStatsRecordStartedRpcs(false);
        this.managedChannelImplBuilder.setStatsRecordFinishedRpcs(false);
        this.managedChannelImplBuilder.setStatsRecordRetryMetrics(false);
        this.managedChannelImplBuilder.disableRetry();
    }

    @Internal
    protected ManagedChannelBuilder<?> delegate() {
        return this.managedChannelImplBuilder;
    }

    public InProcessChannelBuilder maxInboundMessageSize(int max2) {
        return (InProcessChannelBuilder)super.maxInboundMessageSize(max2);
    }

    public InProcessChannelBuilder useTransportSecurity() {
        return this;
    }

    public InProcessChannelBuilder usePlaintext() {
        return this;
    }

    public InProcessChannelBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        return this;
    }

    public InProcessChannelBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        return this;
    }

    public InProcessChannelBuilder keepAliveWithoutCalls(boolean enable) {
        return this;
    }

    public InProcessChannelBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"scheduledExecutorService");
        return this;
    }

    public InProcessChannelBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument((bytes > 0 ? 1 : 0) != 0, (Object)"maxInboundMetadataSize must be > 0");
        this.maxInboundMetadataSize = bytes;
        return this;
    }

    public InProcessChannelBuilder propagateCauseWithStatus(boolean enable) {
        this.transportIncludeStatusCause = enable;
        return this;
    }

    ClientTransportFactory buildTransportFactory() {
        return new InProcessClientTransportFactory(this.scheduledExecutorService, this.maxInboundMetadataSize, this.transportIncludeStatusCause);
    }

    void setStatsEnabled(boolean value) {
        this.managedChannelImplBuilder.setStatsEnabled(value);
    }

    static final class InProcessClientTransportFactory
    implements ClientTransportFactory {
        private final ScheduledExecutorService timerService;
        private final boolean useSharedTimer;
        private final int maxInboundMetadataSize;
        private boolean closed;
        private final boolean includeCauseWithStatus;

        private InProcessClientTransportFactory(@Nullable ScheduledExecutorService scheduledExecutorService, int maxInboundMetadataSize, boolean includeCauseWithStatus) {
            this.useSharedTimer = scheduledExecutorService == null;
            this.timerService = this.useSharedTimer ? (ScheduledExecutorService)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE) : scheduledExecutorService;
            this.maxInboundMetadataSize = maxInboundMetadataSize;
            this.includeCauseWithStatus = includeCauseWithStatus;
        }

        public ConnectionClientTransport newClientTransport(SocketAddress addr, ClientTransportFactory.ClientTransportOptions options, ChannelLogger channelLogger) {
            if (this.closed) {
                throw new IllegalStateException("The transport factory is closed.");
            }
            return new InProcessTransport(addr, this.maxInboundMetadataSize, options.getAuthority(), options.getUserAgent(), options.getEagAttributes(), this.includeCauseWithStatus);
        }

        public ScheduledExecutorService getScheduledExecutorService() {
            return this.timerService;
        }

        public ClientTransportFactory.SwapChannelCredentialsResult swapChannelCredentials(ChannelCredentials channelCreds) {
            return null;
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.useSharedTimer) {
                SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE, (Object)this.timerService);
            }
        }

        public Collection<Class<? extends SocketAddress>> getSupportedSocketAddressTypes() {
            return Arrays.asList(InProcessSocketAddress.class, AnonymousInProcessSocketAddress.class);
        }
    }
}

