/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.treetable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaterfallSupport<T> {
    private final Map<T, T> myWaterfall;
    private final Traverser<T> myTraverser;
    private final Predicate<? super T> myFilter;
    private final T rootsParent;
    private final Consumer<T> empty;

    public WaterfallSupport(@NotNull Traverser<T> traverser, @NotNull Predicate<? super T> filter2, @Nullable T root) {
        if (traverser == null) {
            WaterfallSupport.$$$reportNull$$$0(0);
        }
        if (filter2 == null) {
            WaterfallSupport.$$$reportNull$$$0(1);
        }
        this.myWaterfall = new HashMap<T, T>();
        this.empty = v -> {};
        this.myTraverser = traverser;
        this.myFilter = filter2;
        this.rootsParent = root == null ? null : this.myTraverser.getParent(root);
        Object v0 = this.rootsParent;
        if (root != null) {
            this.myWaterfall.put(root, root);
        }
    }

    public WaterfallSupport(@NotNull Traverser<T> traverser, @NotNull Predicate<? super T> filter2) {
        if (traverser == null) {
            WaterfallSupport.$$$reportNull$$$0(2);
        }
        if (filter2 == null) {
            WaterfallSupport.$$$reportNull$$$0(3);
        }
        this(traverser, filter2, null);
    }

    public T forward(T element2) {
        T forwardValue = this.myWaterfall.get(element2);
        if (forwardValue == null) {
            T waterfallValue = this.waterfall(element2);
            if (waterfallValue != element2) {
                if (this.backward(element2) == element2) {
                    this.myWaterfall.put(element2, waterfallValue);
                }
                return waterfallValue;
            }
            forwardValue = element2;
        }
        return forwardValue;
    }

    public T backward(T element2) {
        return this.backward(element2, this.empty);
    }

    public T backward(T element2, Consumer<? super T> consumer) {
        for (Map.Entry entry2 : this.myWaterfall.entrySet()) {
            if (entry2.getValue() != element2) continue;
            return this.backward(entry2.getValue(), v -> v != entry2.getKey(), consumer);
        }
        LinkedList parents = new LinkedList();
        Object backward = this.backward(element2, v -> !this.myWaterfall.containsKey(v), v -> parents.add(v));
        if (!parents.contains(this.myWaterfall.get(backward))) {
            parents.forEach(consumer);
            return (T)backward;
        }
        return element2;
    }

    private T backward(T element2, Predicate<? super T> canContinue, Consumer<? super T> consumer) {
        T backwardValue = element2;
        while (canContinue.test(backwardValue)) {
            consumer.accept(backwardValue);
            if ((backwardValue = this.myTraverser.getParent(backwardValue)) != this.rootsParent) continue;
            consumer.accept(this.rootsParent);
            return element2;
        }
        consumer.accept(backwardValue);
        return backwardValue;
    }

    public List<T> fold(T start2, T end2) {
        T current = end2;
        ArrayList<T> nodes2 = new ArrayList<T>();
        T waterfall2 = this.waterfall(start2);
        while (current != start2 && current != this.rootsParent) {
            nodes2.add(0, current);
            if (waterfall2 == current && current != end2) {
                throw new IllegalArgumentException(start2 + " and " + end2 + " cannot be folded");
            }
            current = this.myTraverser.getParent(current);
        }
        if (current != start2) {
            throw new IllegalArgumentException(start2 + " isn't parent of " + end2 + " in this chain: ");
        }
        T oldValue = this.myWaterfall.get(current);
        if (oldValue != null && oldValue != current) {
            throw new IllegalArgumentException(current + " isn't equal to removed value " + oldValue);
        }
        this.myWaterfall.keySet().removeAll(nodes2);
        if (this.myWaterfall.put(current, end2) != oldValue) {
            throw new IllegalStateException("Data changed while processing fold");
        }
        nodes2.add(0, oldValue);
        return nodes2;
    }

    public List<T> unfold(T start2, T end2) {
        HashSet parents = new HashSet();
        Object left = this.backward(start2, v -> !this.myWaterfall.containsKey(v), parents::add);
        if (!this.contains(left) || parents.contains(this.myWaterfall.get(left))) {
            return Collections.emptyList();
        }
        Object right = this.waterfall(left);
        ArrayList<T> folded = new ArrayList<T>(10);
        T current = end2;
        T startParent = this.myTraverser.getParent(start2);
        while (current != startParent) {
            this.myWaterfall.put(current, current);
            folded.add(0, current);
            current = this.myTraverser.getParent(current);
        }
        this.myWaterfall.put(end2, right);
        this.myWaterfall.put(left, start2);
        return folded;
    }

    public boolean contains(T element2) {
        return this.myWaterfall.containsKey(element2);
    }

    public void clear() {
        this.myWaterfall.clear();
    }

    private T waterfall(T element2) {
        List<T> children2;
        if (!this.myFilter.test(element2) || this.myTraverser.getParent(element2) == this.rootsParent) {
            return element2;
        }
        T current = element2;
        while ((children2 = this.myTraverser.getChildren(current)).size() == 1 && this.myFilter.test(children2.get(0))) {
            current = children2.get(0);
        }
        return current;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "traverser";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "filter";
                break;
            }
        }
        objectArray[1] = "com/intellij/profiler/ui/treetable/WaterfallSupport";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Traverser<T> {
        public T getParent(T var1);

        public List<T> getChildren(T var1);
    }
}

