/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.callusage;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.api.ValueMetricPrinter;
import com.intellij.profiler.api.ValueMetricPrinterWithOptionalUnits;
import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.profiler.ui.callusage.DiffFactor;
import com.intellij.profiler.ui.callusage.Percentage;
import com.intellij.profiler.ui.callusage.SignedLong;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UpdateScaleHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0002'(B$\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0015\b\u0002\u0010\u0005\u001a\u000f\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0003J:\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0019H\u0003J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u000f\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTableCellRenderer;", "Lcom/intellij/ui/components/JBLabel;", "Ljavax/swing/table/TableCellRenderer;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "undefined", "Lkotlin/Function0;", "", "Lorg/jetbrains/annotations/Nls;", "(Lcom/intellij/profiler/api/ValueMetric;Lkotlin/jvm/functions/Function0;)V", "SPARK_LINE_COLOR", "Lcom/intellij/ui/JBColor;", "metricPrinter", "Lcom/intellij/profiler/api/ValueMetricPrinter;", "percentage", "Lcom/intellij/profiler/ui/callusage/CallUsageTableCellRenderer$PercentageState;", "updateScaleHelper", "Lcom/intellij/util/ui/UpdateScaleHelper;", "formatValue", "value", "", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "", "isSelected", "", "hasFocus", "row", "", "column", "isOpaque", "nlsSafe", "any", "paintComponent", "", "g", "Ljava/awt/Graphics;", "Companion", "PercentageState", "intellij.profiler.common"})
public final class CallUsageTableCellRenderer
extends JBLabel
implements TableCellRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ValueMetric metric;
    @Nullable
    private final Function0<String> undefined;
    @NotNull
    private final JBColor SPARK_LINE_COLOR;
    @NotNull
    private final PercentageState percentage;
    @NotNull
    private final ValueMetricPrinter metricPrinter;
    @NotNull
    private final UpdateScaleHelper updateScaleHelper;
    public static final int SPACING_SIZE = 8;

    public CallUsageTableCellRenderer(@NotNull ValueMetric metric, @Nullable Function0<String> undefined) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.metric = metric;
        this.undefined = undefined;
        this.SPARK_LINE_COLOR = new JBColor(12769014, 4543843);
        this.percentage = new PercentageState();
        this.metricPrinter = new ValueMetricPrinterWithOptionalUnits(ValueMetricPrinter.Default.INSTANCE);
        this.updateScaleHelper = new UpdateScaleHelper(false, null, 3, null);
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
        this.setHorizontalAlignment(4);
    }

    public /* synthetic */ CallUsageTableCellRenderer(ValueMetric valueMetric, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = null;
        }
        this(valueMetric, (Function0<String>)function0);
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String string;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.intellij.ui.components.JBLabel");
        JBLabel comp2 = this;
        int width = table.getColumnModel().getColumn(column).getWidth();
        this.updateScaleHelper.saveScaleAndUpdateUIIfChanged((JComponent)comp2);
        this.setBackground(RenderingUtil.getBackground((JTable)table, (boolean)isSelected));
        this.setForeground(RenderingUtil.getForeground((JTable)table, (boolean)isSelected));
        this.percentage.clear();
        Object object = value;
        if (object instanceof Percentage) {
            this.percentage.setWidth(MathKt.roundToInt((double)((double)width * ((Percentage)value).getValue())));
            this.percentage.setX(0);
            this.percentage.setColor(isSelected ? ColorUtil.mix((Color)this.getBackground(), (Color)this.getForeground(), (double)0.2) : (Color)this.SPARK_LINE_COLOR);
            Number number = ((Percentage)value).getNatureValue();
            string = number instanceof Long ? this.metricPrinter.print(this.metric, number.longValue()) : this.formatValue(number);
        } else if (object instanceof Long) {
            string = this.metricPrinter.print(this.metric, ((Number)value).longValue());
        } else if (object instanceof SignedLong) {
            long longValue = ((SignedLong)value).unbox-impl();
            Object res2 = this.metricPrinter.print(this.metric, longValue);
            if (longValue > 0L) {
                res2 = "+" + (String)res2;
            }
            string = res2;
        } else if (object instanceof DiffFactor) {
            double factor = ((DiffFactor)value).unbox-impl();
            string = Double.isInfinite(factor) ? CommonProfilerBundleKt.profilerMessage("ui.flamechart.tooltip.added", new Object[0]) : ProfilerUIUtilsKt.fractionToString$default(factor, 0.0, true, false, 10, null);
        } else {
            if (!isSelected) {
                this.setForeground(UIUtil.getLabelDisabledForeground());
            }
            Object object2 = value;
            if (object2 != null) {
                string = this.nlsSafe(object2);
            } else {
                Function0<String> function0 = this.undefined;
                string = function0 != null ? (String)function0.invoke() : null;
            }
        }
        comp2.setText(string);
        return (Component)((Object)this);
    }

    @NlsSafe
    private final String formatValue(Number value) {
        Object object = value;
        object = (object instanceof Integer ? true : object instanceof Long) ? "%,d" : ((object instanceof Float ? true : object instanceof Double) ? "%.2f" : "%s");
        Object[] objectArray = new Object[]{value};
        String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NlsSafe
    private final String nlsSafe(Object any) {
        return any.toString();
    }

    public boolean isOpaque() {
        return false;
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.percentage.getColor());
        int pad = JBUI.scale((int)1);
        g.fillRect(this.percentage.getX(), pad, Math.max(this.percentage.getWidth(), 1), this.getHeight() - pad * 2);
        super.paintComponent(g);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTableCellRenderer$Companion;", "", "()V", "SPACING_SIZE", "", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTableCellRenderer$PercentageState;", "", "()V", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "width", "", "getWidth", "()I", "setWidth", "(I)V", "x", "getX", "setX", "clear", "", "updateState", "intellij.profiler.common"})
    private static final class PercentageState {
        private int x;
        private int width;
        @Nullable
        private Color color;

        public final int getX() {
            return this.x;
        }

        public final void setX(int n) {
            this.x = n;
        }

        public final int getWidth() {
            return this.width;
        }

        public final void setWidth(int n) {
            this.width = n;
        }

        @Nullable
        public final Color getColor() {
            return this.color;
        }

        public final void setColor(@Nullable Color color2) {
            this.color = color2;
        }

        public final void updateState(int x, int width, @Nullable Color color2) {
            this.x = x;
            this.width = width;
            this.color = color2;
        }

        public final void clear() {
            this.updateState(0, 0, null);
        }
    }
}

